/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.util.List;
import org.apache.tools.ant.Target;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.TogglePresentationAction;
import org.eclipse.ant.internal.ui.editor.outline.AntOutlineMessages;
import org.eclipse.ant.internal.ui.editor.outline.FilterImportedElementsAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterInternalTargetsAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterPropertiesAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterTopLevelAction;
import org.eclipse.ant.internal.ui.editor.outline.ToggleLinkWithEditorAction;
import org.eclipse.ant.internal.ui.editor.outline.ToggleSortAntOutlineAction;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntImportNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelChangeEvent;
import org.eclipse.ant.internal.ui.model.AntModelContentProvider;
import org.eclipse.ant.internal.ui.model.AntModelCore;
import org.eclipse.ant.internal.ui.model.AntModelLabelProvider;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.IAntModelListener;
import org.eclipse.ant.internal.ui.views.actions.AntOpenWithMenu;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AntEditorContentOutlinePage
extends ContentOutlinePage
implements IShowInSource,
IAdaptable {
    private static final int EXPAND_TO_LEVEL = 2;
    private Menu fMenu;
    private AntOpenWithMenu fOpenWithMenu;
    private IAntModelListener fListener;
    private IAntModel fModel;
    private AntModelCore fCore;
    private ListenerList fPostSelectionChangedListeners = new ListenerList();
    private boolean fIsModelEmpty = true;
    private boolean fFilterInternalTargets;
    private boolean fFilterImportedElements;
    private boolean fFilterProperties;
    private boolean fFilterTopLevel;
    private boolean fSort;
    private ViewerSorter fSorter;
    private AntEditor fEditor;
    private TogglePresentationAction fTogglePresentation;
    static /* synthetic */ Class class$0;

    protected void setFilterInternalTargets(boolean filter) {
        this.fFilterInternalTargets = filter;
        this.setFilter(filter, "anteditor.filterInternalTargets");
    }

    protected void setFilterImportedElements(boolean filter) {
        this.fFilterImportedElements = filter;
        this.setFilter(filter, "anteditor.filterImportedElements");
    }

    private void setFilter(boolean filter, String name) {
        if (name != null) {
            AntUIPlugin.getDefault().getPreferenceStore().setValue(name, filter);
        }
        this.getTreeViewer().refresh();
    }

    protected void setFilterProperties(boolean filter) {
        this.fFilterProperties = filter;
        this.setFilter(filter, "anteditor.filterProperties");
    }

    protected void setFilterTopLevel(boolean filter) {
        this.fFilterTopLevel = filter;
        this.setFilter(filter, "anteditor.filterTopLevel");
    }

    protected boolean filterInternalTargets() {
        return this.fFilterInternalTargets;
    }

    protected boolean filterImportedElements() {
        return this.fFilterImportedElements;
    }

    protected boolean filterProperties() {
        return this.fFilterProperties;
    }

    protected boolean filterTopLevel() {
        return this.fFilterTopLevel;
    }

    protected void setSort(boolean sort) {
        this.fSort = sort;
        if (sort) {
            if (this.fSorter == null) {
                this.fSorter = new AntOutlineSorter();
            }
            this.getTreeViewer().setSorter(this.fSorter);
        } else {
            this.getTreeViewer().setSorter(null);
        }
        AntUIPlugin.getDefault().getPreferenceStore().setValue("anteditor.sort", sort);
    }

    protected boolean isSort() {
        return this.fSort;
    }

    public AntEditorContentOutlinePage(AntModelCore core, AntEditor editor) {
        this.fCore = core;
        this.fFilterInternalTargets = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterInternalTargets");
        this.fFilterImportedElements = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterImportedElements");
        this.fFilterProperties = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterProperties");
        this.fFilterTopLevel = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterTopLevel");
        this.fSort = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.sort");
        this.fEditor = editor;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        if (this.fOpenWithMenu != null) {
            this.fOpenWithMenu.dispose();
        }
        if (this.fListener != null) {
            this.fCore.removeAntModelListener(this.fListener);
            this.fListener = null;
        }
        this.fTogglePresentation.setEditor(null);
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new AntModelContentProvider());
        this.setSort(this.fSort);
        viewer.setLabelProvider((IBaseLabelProvider)new AntModelLabelProvider());
        if (this.fModel != null) {
            this.setViewerInput(this.fModel);
        }
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                AntEditorContentOutlinePage.this.contextMenuAboutToShow(menuManager);
            }
        });
        this.fMenu = manager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu("org.eclipse.ant.ui.antEditorOutline", manager, (ISelectionProvider)viewer);
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        tbm.add((IAction)new ToggleSortAntOutlineAction(this));
        tbm.add((IAction)new FilterInternalTargetsAction(this));
        tbm.add((IAction)new FilterPropertiesAction(this));
        tbm.add((IAction)new FilterImportedElementsAction(this));
        tbm.add((IAction)new FilterTopLevelAction(this));
        IMenuManager viewMenu = site.getActionBars().getMenuManager();
        viewMenu.add((IAction)new ToggleLinkWithEditorAction(this.fEditor));
        this.fOpenWithMenu = new AntOpenWithMenu(this.getSite().getPage());
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntEditorContentOutlinePage.this.firePostSelectionChanged(event.getSelection());
            }
        });
        viewer.addFilter((ViewerFilter)new AntOutlineFilter());
        site.getActionBars().setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
    }

    private void setViewerInput(Object newInput) {
        TreeViewer tree = this.getTreeViewer();
        Object oldInput = tree.getInput();
        boolean isAntModel = newInput instanceof AntModel;
        boolean wasAntModel = oldInput instanceof AntModel;
        if (isAntModel && !wasAntModel) {
            if (this.fListener == null) {
                this.fListener = this.createAntModelChangeListener();
            }
            this.fCore.addAntModelListener(this.fListener);
        } else if (!isAntModel && wasAntModel && this.fListener != null) {
            this.fCore.removeAntModelListener(this.fListener);
            this.fListener = null;
        }
        tree.setInput(newInput);
        if (isAntModel) {
            this.updateTreeExpansion();
        }
    }

    public void setPageInput(AntModel xmlModel) {
        this.fModel = xmlModel;
        if (this.getTreeViewer() != null) {
            this.setViewerInput(this.fModel);
        }
    }

    private IAntModelListener createAntModelChangeListener() {
        return new IAntModelListener(){

            public void antModelChanged(AntModelChangeEvent event) {
                if (event.getModel() == AntEditorContentOutlinePage.this.fModel && !AntEditorContentOutlinePage.this.getControl().isDisposed()) {
                    AntEditorContentOutlinePage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Control ctrl = 3.access$0(this.this$1).getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                AntEditorContentOutlinePage.access$7(3.access$0(this.this$1)).refresh();
                                AntEditorContentOutlinePage.access$8(3.access$0(this.this$1));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ AntEditorContentOutlinePage access$0(3 var0) {
                return var0.AntEditorContentOutlinePage.this;
            }
        };
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    private void updateTreeExpansion() {
        boolean wasModelEmpty = this.fIsModelEmpty;
        boolean bl = this.fIsModelEmpty = this.fModel == null || this.fModel.getProjectNode() == null;
        if (wasModelEmpty && !this.fIsModelEmpty) {
            this.getTreeViewer().expandToLevel(2);
        }
    }

    private void firePostSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.fPostSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    private void contextMenuAboutToShow(IMenuManager menuManager) {
        if (this.shouldAddOpenWithMenu()) {
            this.addOpenWithMenu(menuManager);
        }
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void addOpenWithMenu(IMenuManager menuManager) {
        AntElementNode element = this.getSelectedNode();
        IFile file = element.getIFile();
        if (file != null) {
            menuManager.add((IContributionItem)new Separator("group.open"));
            MenuManager submenu = new MenuManager(AntOutlineMessages.AntEditorContentOutlinePage_Open_With_1);
            this.fOpenWithMenu.setNode(element);
            submenu.add((IContributionItem)this.fOpenWithMenu);
            menuManager.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    private boolean shouldAddOpenWithMenu() {
        String path;
        AntElementNode node = this.getSelectedNode();
        if (node instanceof AntImportNode) {
            return true;
        }
        return node != null && node.isExternal() && (path = node.getFilePath()) != null && path.length() > 0;
    }

    private AntElementNode getSelectedNode() {
        Object selected;
        IStructuredSelection selection;
        ISelection iselection = this.getSelection();
        if (iselection instanceof IStructuredSelection && (selection = (IStructuredSelection)iselection).size() == 1 && (selected = selection.getFirstElement()) instanceof AntElementNode) {
            return (AntElementNode)selected;
        }
        return null;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IFile file = null;
        if (this.fModel != null) {
            AntElementNode node = this.getSelectedNode();
            file = node.getIFile();
        }
        if (file != null) {
            StructuredSelection selection = new StructuredSelection((Object)file);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    public void select(AntElementNode node) {
        IStructuredSelection ss;
        List nodes;
        ISelection s;
        if (this.getTreeViewer() != null && (s = this.getTreeViewer().getSelection()) instanceof IStructuredSelection && !(nodes = (ss = (IStructuredSelection)s).toList()).contains(node)) {
            s = node == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)node);
            this.getTreeViewer().setSelection(s, true);
        }
    }

    static /* synthetic */ TreeViewer access$7(AntEditorContentOutlinePage antEditorContentOutlinePage) {
        return antEditorContentOutlinePage.getTreeViewer();
    }

    static /* synthetic */ void access$8(AntEditorContentOutlinePage antEditorContentOutlinePage) {
        antEditorContentOutlinePage.updateTreeExpansion();
    }

    private class AntOutlineFilter
    extends ViewerFilter {
        AntOutlineFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AntElementNode) {
                AntElementNode node = (AntElementNode)element;
                if (AntEditorContentOutlinePage.this.fFilterTopLevel && node instanceof AntTaskNode && parentElement instanceof AntProjectNode) {
                    return false;
                }
                if (AntEditorContentOutlinePage.this.fFilterImportedElements && (node.getImportNode() != null || node.isExternal())) {
                    return node instanceof AntTargetNode && ((AntTargetNode)node).isDefaultTarget();
                }
                if (AntEditorContentOutlinePage.this.fFilterInternalTargets && node instanceof AntTargetNode) {
                    Target target = ((AntTargetNode)node).getTarget();
                    return target.getDescription() != null || ((AntTargetNode)node).isDefaultTarget();
                }
                if (AntEditorContentOutlinePage.this.fFilterProperties && node instanceof AntPropertyNode) {
                    return false;
                }
                if (!node.isStructuralNode()) {
                    return false;
                }
            }
            return true;
        }
    }

    private class AntOutlineSorter
    extends ViewerSorter {
        AntOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof AntElementNode) || !(e2 instanceof AntElementNode)) {
                return super.compare(viewer, e1, e2);
            }
            String name1 = ((AntElementNode)e1).getLabel();
            String name2 = ((AntElementNode)e2).getLabel();
            return this.getCollator().compare(name1, name2);
        }
    }
}

