/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;

public final class JFaceTextUtil {
    private JFaceTextUtil() {
    }

    public static int computeLineHeight(StyledText textWidget, int startLine, int endLine, int lineCount) {
        return JFaceTextUtil.getLinePixel(textWidget, endLine) - JFaceTextUtil.getLinePixel(textWidget, startLine);
    }

    public static int getBottomIndex(StyledText widget) {
        int lastPixel = JFaceTextUtil.computeLastVisiblePixel(widget);
        int bottom = widget.getLineIndex(lastPixel);
        if (bottom == 0) {
            return bottom;
        }
        int pixel = widget.getLinePixel(bottom);
        if (pixel <= 0) {
            return bottom;
        }
        int offset = widget.getOffsetAtLine(bottom);
        int height = widget.getLineHeight(offset);
        if (pixel + height - 1 > lastPixel) {
            return bottom - 1;
        }
        return bottom;
    }

    public static int getPartialTopIndex(StyledText widget) {
        int top = widget.getTopIndex();
        int pixels = widget.getLinePixel(top);
        if (pixels == -widget.getLineHeight(widget.getOffsetAtLine(top))) {
            ++top;
            pixels = 0;
        }
        if (pixels > 0) {
            --top;
        }
        return top;
    }

    public static int getPartialBottomIndex(StyledText widget) {
        int lastPixel = JFaceTextUtil.computeLastVisiblePixel(widget);
        int bottom = widget.getLineIndex(lastPixel);
        return bottom;
    }

    private static int computeLastVisiblePixel(StyledText widget) {
        int caHeight = widget.getClientArea().height;
        int lastPixel = caHeight - 1;
        return lastPixel;
    }

    public static int getPartialTopIndex(ITextViewer viewer) {
        StyledText widget = viewer.getTextWidget();
        int widgetTop = JFaceTextUtil.getPartialTopIndex(widget);
        return JFaceTextUtil.widgetLine2ModelLine(viewer, widgetTop);
    }

    public static int getPartialBottomIndex(ITextViewer viewer) {
        StyledText textWidget = viewer.getTextWidget();
        int widgetBottom = JFaceTextUtil.getPartialBottomIndex(textWidget);
        return JFaceTextUtil.widgetLine2ModelLine(viewer, widgetBottom);
    }

    public static ILineRange getVisibleModelLines(ITextViewer viewer) {
        int top = JFaceTextUtil.getPartialTopIndex(viewer);
        int bottom = JFaceTextUtil.getPartialBottomIndex(viewer);
        if (top == -1 || bottom == -1) {
            return null;
        }
        return new LineRange(top, bottom - top + 1);
    }

    public static int widgetLine2ModelLine(ITextViewer viewer, int widgetLine) {
        int modelLine;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)viewer);
            modelLine = extension.widgetLine2ModelLine(widgetLine);
        } else {
            try {
                IRegion r = viewer.getVisibleRegion();
                IDocument d = viewer.getDocument();
                modelLine = widgetLine + d.getLineOfOffset(r.getOffset());
            }
            catch (BadLocationException badLocationException) {
                modelLine = widgetLine;
            }
        }
        return modelLine;
    }

    public static int modelLineToWidgetLine(ITextViewer viewer, int modelLine) {
        int widgetLine;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)viewer);
            widgetLine = extension.modelLine2WidgetLine(modelLine);
        } else {
            IRegion region = viewer.getVisibleRegion();
            IDocument document = viewer.getDocument();
            try {
                int visibleStartLine = document.getLineOfOffset(region.getOffset());
                int visibleEndLine = document.getLineOfOffset(region.getOffset() + region.getLength());
                widgetLine = modelLine < visibleStartLine || modelLine > visibleEndLine ? -1 : modelLine - visibleStartLine;
            }
            catch (BadLocationException badLocationException) {
                widgetLine = -1;
            }
        }
        return widgetLine;
    }

    public static int getHiddenTopLinePixels(StyledText textWidget) {
        int top = JFaceTextUtil.getPartialTopIndex(textWidget);
        return -textWidget.getLinePixel(top);
    }

    public static int getVisibleLinesInViewport(StyledText textWidget) {
        Rectangle clArea;
        if (textWidget != null && !(clArea = textWidget.getClientArea()).isEmpty()) {
            int firstPixel = 0;
            int lastPixel = clArea.height - 1;
            int first = JFaceTextUtil.getLineIndex(textWidget, firstPixel);
            int last = JFaceTextUtil.getLineIndex(textWidget, lastPixel);
            return last - first;
        }
        return -1;
    }

    public static int getLinePixel(StyledText textWidget, int line) {
        return textWidget.getLinePixel(line);
    }

    public static int getLineIndex(StyledText textWidget, int y) {
        int lineIndex = textWidget.getLineIndex(y);
        return lineIndex;
    }

    public static boolean isShowingEntireContents(StyledText widget) {
        if (widget.getTopPixel() != 0) {
            return true;
        }
        int lastVisiblePixel = JFaceTextUtil.computeLastVisiblePixel(widget);
        int lastPossiblePixel = widget.getLinePixel(widget.getLineCount());
        return lastPossiblePixel > lastVisiblePixel;
    }
}

