/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.internal.text.JFaceTextUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LineNumberRulerColumn
implements IVerticalRulerColumn {
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = LineNumberRulerColumn.this.fRunnableLock;
            synchronized (object) {
                LineNumberRulerColumn.this.fIsRunnablePosted = false;
            }
            LineNumberRulerColumn.this.redraw();
        }
    };
    private MouseHandler fMouseHandler;

    public void setForeground(Color foreground) {
        this.fForeground = foreground;
    }

    protected Color getForeground() {
        return this.fForeground;
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean updateNumberOfDigits() {
        if (this.fCachedTextViewer == null) {
            return false;
        }
        int digits = this.computeNumberOfDigits();
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected int computeNumberOfDigits() {
        IDocument document = this.fCachedTextViewer.getDocument();
        int lines = document == null ? 0 : document.getNumberOfLines();
        int digits = 2;
        while ((double)lines > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        return digits;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)((Object)this.fCachedTextViewer)).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void computeIndentations() {
        if (this.fCanvas == null) {
            return;
        }
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            Float number = new Float(Math.pow(10.0, this.fCachedNumberOfDigits) - 1.0);
            Point p = gc.stringExtent(Integer.toString(number.intValue()));
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                number = new Float(Math.pow(10.0, i) - 1.0);
                p = gc.stringExtent(Integer.toString(number.intValue()));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        gc.dispose();
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 0);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LineNumberRulerColumn.this.fCachedTextViewer != null) {
                    LineNumberRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LineNumberRulerColumn.this.handleDispose();
                LineNumberRulerColumn.this.fCachedTextViewer = null;
                LineNumberRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fMouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doubleBufferPaint(GC dest) {
        GC gc;
        block10: {
            block9: {
                Point size = this.fCanvas.getSize();
                if (size.x <= 0 || size.y <= 0) {
                    return;
                }
                if (this.fBuffer != null) {
                    Rectangle r = this.fBuffer.getBounds();
                    if (r.width != size.x || r.height != size.y) {
                        this.fBuffer.dispose();
                        this.fBuffer = null;
                    }
                }
                if (this.fBuffer == null) {
                    this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
                }
                gc = new GC((Drawable)this.fBuffer);
                gc.setFont(this.fCanvas.getFont());
                if (this.fForeground != null) {
                    gc.setForeground(this.fForeground);
                }
                try {
                    gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
                    gc.fillRectangle(0, 0, size.x, size.y);
                    ILineRange visibleLines = JFaceTextUtil.getVisibleModelLines(this.fCachedTextViewer);
                    if (visibleLines == null) {
                        Object var5_5 = null;
                        break block9;
                    }
                    this.doPaint(gc, visibleLines);
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    gc.dispose();
                    throw throwable;
                }
            }
            gc.dispose();
            return;
        }
        Object var5_7 = null;
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        return JFaceTextUtil.getVisibleLinesInViewport(this.fCachedTextWidget);
    }

    protected final boolean isViewerCompletelyShown() {
        return JFaceTextUtil.isShowingEntireContents(this.fCachedTextWidget);
    }

    void doPaint(GC gc, ILineRange visibleLines) {
        this.fSensitiveToTextChanges = this.isViewerCompletelyShown();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        Display display = this.fCachedTextWidget.getDisplay();
        int y = -JFaceTextUtil.getHiddenTopLinePixels(this.fCachedTextWidget);
        int lastLine = LineNumberRulerColumn.end(visibleLines);
        int line = visibleLines.getStartLine();
        while (line < lastLine) {
            int widgetLine = JFaceTextUtil.modelLineToWidgetLine(this.fCachedTextViewer, line);
            if (widgetLine != -1) {
                int lineHeight = this.fCachedTextWidget.getLineHeight(this.fCachedTextWidget.getOffsetAtLine(widgetLine));
                this.paintLine(line, y, lineHeight, gc, display);
                y += lineHeight;
            }
            ++line;
        }
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    protected String createDisplayString(int line) {
        return Integer.toString(line + 1);
    }

    private int getBaselineBias(GC gc, int widgetLine) {
        int offset = this.fCachedTextWidget.getOffsetAtLine(widgetLine);
        int widgetBaseline = this.fCachedTextWidget.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        int baselineBias = widgetBaseline - fontBaseline;
        return Math.max(0, baselineBias);
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        int widgetLine = JFaceTextUtil.modelLineToWidgetLine(this.fCachedTextViewer, line);
        String s = this.createDisplayString(line);
        int indentation = this.fIndentation[s.length()];
        int baselineBias = this.getBaselineBias(gc, widgetLine);
        gc.drawString(s, indentation, y + baselineBias, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (this.fCachedRedrawState && verticalPosition != LineNumberRulerColumn.this.fScrollPos) {
                LineNumberRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            this.fCachedRedrawState = event.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            if (LineNumberRulerColumn.this.updateNumberOfDigits()) {
                LineNumberRulerColumn.this.computeIndentations();
                LineNumberRulerColumn.this.layout(event.getViewerRedrawState());
                return;
            }
            if (LineNumberRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                LineNumberRulerColumn.this.postRedraw();
            }
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private int fCachedViewportSize;
        private IRegion fStartLine;
        private int fStartLineNumber;
        private int fAutoScrollDirection;
        private boolean fIsListeningForMove = false;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
            }
        }

        public void mouseDown(MouseEvent event) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            if (event.button == 1) {
                this.startSelecting();
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            if (this.fIsListeningForMove && !this.autoScroll(event)) {
                int newLine = LineNumberRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                this.expandSelection(newLine);
            }
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        private void startSelecting() {
            try {
                IDocument document = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                this.fStartLineNumber = LineNumberRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                this.fStartLine = document.getLineInformation(this.fStartLineNumber);
                LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLine.getOffset(), this.fStartLine.getLength());
                this.fCachedViewportSize = LineNumberRulerColumn.this.getVisibleLinesInViewport();
                this.fIsListeningForMove = true;
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopSelecting() {
            this.fIsListeningForMove = false;
        }

        private void expandSelection(int lineNumber) {
            try {
                IDocument document = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int start = Math.min(this.fStartLine.getOffset(), lineInfo.getOffset());
                int end = Math.max(this.fStartLine.getOffset() + this.fStartLine.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                if (lineNumber < this.fStartLineNumber) {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = LineNumberRulerColumn.this.fCanvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.fAutoScrollDirection == direction) {
                return;
            }
            Display display = LineNumberRulerColumn.this.fCanvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(this, display){
                        final /* synthetic */ MouseHandler this$1;
                        private final /* synthetic */ Display val$display;
                        {
                            this.this$1 = mouseHandler;
                            this.val$display = display;
                        }

                        public void run() {
                            int top;
                            if (MouseHandler.access$0(this.this$1) == 128 && (top = MouseHandler.access$1(this.this$1)) > 0) {
                                LineNumberRulerColumn.access$5(MouseHandler.access$4(this.this$1)).setTopIndex(top - 1);
                                MouseHandler.access$2(this.this$1, top - 1);
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(this, display){
                        final /* synthetic */ MouseHandler this$1;
                        private final /* synthetic */ Display val$display;
                        {
                            this.this$1 = mouseHandler;
                            this.val$display = display;
                        }

                        public void run() {
                            if (MouseHandler.access$0(this.this$1) == 1024) {
                                int top = MouseHandler.access$1(this.this$1);
                                LineNumberRulerColumn.access$5(MouseHandler.access$4(this.this$1)).setTopIndex(top + 1);
                                MouseHandler.access$2(this.this$1, top + 1 + MouseHandler.access$3(this.this$1));
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (timer != null) {
                this.fAutoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (LineNumberRulerColumn.this.fCachedTextWidget != null && !LineNumberRulerColumn.this.fCachedTextWidget.isDisposed()) {
                return JFaceTextUtil.getPartialTopIndex(LineNumberRulerColumn.this.fCachedTextViewer);
            }
            return -1;
        }

        static /* synthetic */ int access$0(MouseHandler mouseHandler) {
            return mouseHandler.fAutoScrollDirection;
        }

        static /* synthetic */ int access$1(MouseHandler mouseHandler) {
            return mouseHandler.getInclusiveTopIndex();
        }

        static /* synthetic */ void access$2(MouseHandler mouseHandler, int n) {
            mouseHandler.expandSelection(n);
        }

        static /* synthetic */ int access$3(MouseHandler mouseHandler) {
            return mouseHandler.fCachedViewportSize;
        }

        static /* synthetic */ LineNumberRulerColumn access$4(MouseHandler mouseHandler) {
            return mouseHandler.LineNumberRulerColumn.this;
        }
    }
}

