/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.osgi.framework.Bundle;

public class BundleUtil {
    private static String NL_TAG = "$nl$/";

    public static URL getResourceAsURL(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL localLocation = Platform.find((Bundle)bundle, (IPath)new Path(resource));
        return localLocation;
    }

    public static Bundle getBundleFromConfigurationElement(IConfigurationElement cfg) {
        return Platform.getBundle((String)cfg.getNamespace());
    }

    public static String getResourceLocation(String resource, IConfigurationElement element) {
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(element);
        return BundleUtil.getResolvedResourceLocation(resource, bundle, false);
    }

    public static String getResolvedResourceLocation(String resource, Bundle bundle, boolean forceNLResolve) {
        if (resource == null) {
            return null;
        }
        if (bundle == null || !BundleUtil.bundleHasValidState(bundle)) {
            return resource;
        }
        URL localLocation = null;
        try {
            Path resourcePath;
            String copyResource = resource;
            if (forceNLResolve && !copyResource.startsWith(NL_TAG)) {
                if (copyResource.startsWith("/") || copyResource.startsWith("\\")) {
                    copyResource = resource.substring(1);
                }
                copyResource = String.valueOf(NL_TAG) + copyResource;
            }
            if ((localLocation = Platform.find((Bundle)bundle, (IPath)(resourcePath = new Path(copyResource)))) == null) {
                String msg = "Could not find resource: " + resource + " in " + BundleUtil.getBundleHeader(bundle, "Bundle-Name");
                HelpPlugin.logWarning(msg);
                return resource;
            }
            localLocation = Platform.asLocalURL((URL)localLocation);
            return localLocation.toExternalForm();
        }
        catch (Exception e) {
            String msg = "Failed to load resource: " + resource + " from " + BundleUtil.getBundleHeader(bundle, "Bundle-Name");
            HelpPlugin.logError(msg, e);
            return resource;
        }
    }

    public static boolean bundleHasValidState(Bundle bundle) {
        if (bundle == null || bundle.getState() == 1 || bundle.getState() == 2) {
            if (bundle == null) {
                HelpPlugin.logError("Help  tried accessing a NULL bundle.", null);
            } else {
                String msg = "Help tried accessing Bundle: " + BundleUtil.getBundleHeader(bundle, "Bundle-Name") + " vendor: " + BundleUtil.getBundleHeader(bundle, "Bundle-Vendor") + " bundle state: " + String.valueOf(bundle.getState());
                HelpPlugin.logError(msg, null);
            }
            return false;
        }
        return true;
    }

    public static String getBundleHeader(Bundle bundle, String key) {
        return (String)bundle.getHeaders().get(key);
    }
}

