/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.osgi.framework.Bundle;

public final class RegistryUtils {
    private static IRegistryProvider defaultRegistryProvider;

    public static RegistryStrategy createOSGiStrategy(File storageDir, boolean cacheReadOnly, Object token) {
        return new RegistryStrategyOSGI(storageDir, cacheReadOnly, token);
    }

    public static String getContributorId(Bundle bundle) {
        return RegistryStrategyOSGI.getId(bundle);
    }

    public static IExtensionRegistry getRegistryFromProvider() {
        if (defaultRegistryProvider == null) {
            return null;
        }
        return defaultRegistryProvider.getRegistry();
    }

    public static void setRegistryProvider(IRegistryProvider provider) throws CoreException {
        if (defaultRegistryProvider != null) {
            Status status = new Status(4, "org.eclipse.equinox.registry", 1, RegistryMessages.registry_default_exists, null);
            throw new CoreException((IStatus)status);
        }
        defaultRegistryProvider = provider;
    }
}

