/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.internal.DynamicContentProducer;
import org.eclipse.help.search.XMLSearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XHTMLSearchParticipant
extends XMLSearchParticipant {
    protected void handleStartElement(String name, Attributes attributes, XMLSearchParticipant.IParsedXMLContent data) {
        if (name.equalsIgnoreCase("include")) {
            this.processIncludedContent(attributes.getValue("path"), data);
        }
    }

    protected void handleEndElement(String name, XMLSearchParticipant.IParsedXMLContent data) {
    }

    protected void handleText(String text, XMLSearchParticipant.IParsedXMLContent data) {
        String stackPath = this.getElementStackPath();
        Path path = new Path(stackPath);
        if (path.segment(1).equalsIgnoreCase("body")) {
            data.addText(text);
            data.addToSummary(text);
        } else if (path.segment(1).equalsIgnoreCase("head")) {
            data.setTitle(text);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processIncludedContent(String path, XMLSearchParticipant.IParsedXMLContent data) {
        int sep1 = path.indexOf(47);
        if (sep1 == -1) {
            return;
        }
        String pluginId = path.substring(0, sep1);
        int sep2 = path.lastIndexOf(47);
        if (sep2 == -1) {
            return;
        }
        String href = path.substring(sep1 + 1, sep2);
        String id = path.substring(sep2 + 1);
        InputStream stream = DynamicContentProducer.openStreamFromPlugin((String)pluginId, (String)href, (String)data.getLocale());
        if (stream == null) {
            return;
        }
        try {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                IncludedHandler handler = new IncludedHandler(id, data);
                parser.parse(stream, (DefaultHandler)handler);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        stream.close();
    }

    class IncludedHandler
    extends DefaultHandler {
        private String id;
        private boolean active;
        private Stack stack = new Stack();
        private XMLSearchParticipant.IParsedXMLContent data;

        public IncludedHandler(String id, XMLSearchParticipant.IParsedXMLContent data) {
            this.id = id;
            this.data = data;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String eid = attributes.getValue("id");
            if (eid != null && eid.equals(this.id)) {
                this.stack.push(qName);
                this.active = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.active) {
                this.stack.pop();
                if (this.stack.size() == 0) {
                    this.active = false;
                }
            }
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (!this.active) {
                return;
            }
            if (length == 0) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString().trim();
            if (text.length() > 0) {
                this.data.addText(text);
                this.data.addToSummary(text);
            }
        }
    }
}

