/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractDebugContextActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IActionDelegate2,
IDebugContextListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection = StructuredSelection.EMPTY;
    protected IWorkbenchWindow fWindow;
    private IWorkbenchSiteProgressService fProgressService = null;
    private UpdateEnablementJob fUpdateJob = null;
    private DebugRequestJob fRequestJob = null;
    static /* synthetic */ Class class$0;

    public void dispose() {
        IWorkbenchWindow window = this.getWindow();
        if (this.getWindow() != null) {
            IViewPart view = this.getView();
            if (view != null) {
                String partId = view.getSite().getId();
                DebugContextManager.getDefault().removeDebugContextListener(this, window, partId);
            } else {
                DebugContextManager.getDefault().removeDebugContextListener(this, window);
            }
        }
        this.fSelection = null;
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IDebugContextManager manager = DebugContextManager.getDefault();
        manager.addDebugContextListener(this, window);
        ISelection activeContext = manager.getActiveContext(window);
        if (activeContext != null) {
            this.contextActivated(activeContext, null);
        }
    }

    public synchronized void run(IAction action) {
        IStructuredSelection selection = this.getContext();
        if (selection != null && action.isEnabled()) {
            action.setEnabled(false);
            if (this.fRequestJob == null) {
                this.fRequestJob = new DebugRequestJob();
            }
            this.fRequestJob.setElements(selection.toArray());
            this.schedule(this.fRequestJob);
        }
    }

    public void selectionChanged(IAction action, ISelection s) {
    }

    protected synchronized void update(IAction action, ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            action.setEnabled(this.getEnableStateForContext(ss));
            this.setContext(ss);
        } else {
            action.setEnabled(false);
            this.setContext((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected abstract void doAction(Object var1) throws DebugException;

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public void init(IViewPart view) {
        this.setView(view);
        this.setWindow(view.getSite().getWorkbenchWindow());
        IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fProgressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        DebugContextManager.getDefault().addDebugContextListener(this, this.getWindow(), "org.eclipse.debug.ui.DebugView");
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected IStructuredSelection getContext() {
        return this.fSelection;
    }

    private void setContext(IStructuredSelection context) {
        this.fSelection = context;
    }

    public synchronized void contextActivated(ISelection context, IWorkbenchPart part) {
        this.setContext(null);
        if (this.fUpdateJob == null) {
            this.fUpdateJob = new UpdateEnablementJob();
        }
        this.fUpdateJob.setContext(context);
        this.schedule(this.fUpdateJob);
    }

    public void contextChanged(ISelection context, IWorkbenchPart part) {
        this.contextActivated(context, part);
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setView(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected boolean getEnableStateForContext(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            Object target = this.getTarget(element);
            if (target != null && this.isEnabledFor(target)) continue;
            return false;
        }
        return true;
    }

    protected Object getTarget(Object selectee) {
        return selectee;
    }

    protected boolean isEnabledFor(Object element) {
        return true;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
        this.setAction(action);
    }

    private void schedule(Job job) {
        if (this.fProgressService == null) {
            job.schedule();
        } else {
            this.fProgressService.schedule(job);
        }
    }

    class UpdateEnablementJob
    extends Job {
        ISelection targetSelection = null;

        public UpdateEnablementJob() {
            super(ActionMessages.AbstractDebugActionDelegate_1);
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ISelection context = null;
            UpdateEnablementJob updateEnablementJob = this;
            synchronized (updateEnablementJob) {
                context = this.targetSelection;
                this.targetSelection = null;
            }
            AbstractDebugContextActionDelegate.this.update(AbstractDebugContextActionDelegate.this.getAction(), context);
            return Status.OK_STATUS;
        }

        protected synchronized void setContext(ISelection context) {
            this.targetSelection = context;
        }
    }

    class DebugRequestJob
    extends Job {
        private Object[] fElements = null;

        public DebugRequestJob() {
            super(DebugUIPlugin.removeAccelerators(AbstractDebugContextActionDelegate.this.getAction().getText()));
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, AbstractDebugContextActionDelegate.this.getStatusMessage(), null);
            Object[] targets = null;
            DebugRequestJob debugRequestJob = this;
            synchronized (debugRequestJob) {
                targets = this.fElements;
                this.fElements = null;
            }
            int i = 0;
            while (i < targets.length) {
                Object element = targets[i];
                Object target = AbstractDebugContextActionDelegate.this.getTarget(element);
                try {
                    if (target != null && AbstractDebugContextActionDelegate.this.isEnabledFor(target)) {
                        AbstractDebugContextActionDelegate.this.doAction(target);
                    }
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
                ++i;
            }
            return status;
        }

        protected synchronized void setElements(Object[] elements) {
            this.fElements = elements;
        }
    }
}

