/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextActionDelegate;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ResumeActionDelegate
extends AbstractDebugContextActionDelegate {
    static /* synthetic */ Class class$0;

    protected void doAction(Object object) throws DebugException {
        if (this.isEnabledFor(object)) {
            ISuspendResume resume = (ISuspendResume)object;
            resume.resume();
        } else {
            this.doActionForAllThreads(object);
        }
    }

    protected void doActionForAllThreads(Object object) throws DebugException {
        if (this.isEnabledForAllThreads(object)) {
            IDebugElement debugElement = (IDebugElement)object;
            IThread[] threads = debugElement.getDebugTarget().getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.canResume()) {
                    thread.resume();
                }
                ++i;
            }
        }
    }

    protected boolean isEnabledFor(Object element) {
        return element instanceof ISuspendResume && ((ISuspendResume)element).canResume();
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (this.isEnabledFor(element) || this.isEnabledForAllThreads(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledForAllThreads(Object element) {
        if (element instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            try {
                IThread[] threads = debugElement.getDebugTarget().getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].canResume()) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    protected String getStatusMessage() {
        return ActionMessages.ResumeActionDelegate_Exceptions_occurred_attempting_to_resume__2;
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.ResumeActionDelegate_Resume_failed__1;
    }

    protected Object getTarget(Object selectee) {
        if (selectee instanceof ISuspendResume) {
            return selectee;
        }
        if (selectee instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)selectee;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.ISuspendResume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

