/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ImportBreakpointsOperation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WizardImportBreakpointsPage
extends WizardPage
implements Listener {
    private Button fAutoRemoveDuplicates = null;
    private Button fAutoCreateWorkingSets = null;
    private Text fFileNameField = null;
    private Button fBrowseForFileButton = null;
    private static final String REMOVE_DUPS = "overwrite";
    private static final String CREATE_WORKING_SETS = "createws";
    private static final String SOURCE_FILE_NAME = "filename";

    public WizardImportBreakpointsPage(String pageName) {
        super(pageName, ImportExportMessages.WizardImportBreakpointsPage_0, null);
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fBrowseForFileButton) {
            this.handleBrowseForFileButtonPressed();
        }
        this.setPageComplete(this.detectPageComplete());
    }

    protected void handleBrowseForFileButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.bkpt"});
        String file = dialog.open();
        if (file != null) {
            this.fFileNameField.setText(file);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        this.restoreWidgetState();
        this.setPageComplete(this.detectPageComplete());
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_IMPORT_BREAKPOINTS");
    }

    private boolean detectPageComplete() {
        String fileName = this.fFileNameField.getText().trim();
        if (fileName.equals("")) {
            this.setMessage(ImportExportMessages.WizardImportBreakpointsPage_6);
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            this.setMessage(MessageFormat.format(ImportExportMessages.WizardImportBreakpointsPage_1, fileName), 3);
            return false;
        }
        this.setMessage(ImportExportMessages.WizardImportBreakpointsPage_2);
        return true;
    }

    protected void createOptionsGroup(Composite parent) {
        Font font = parent.getFont();
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(ImportExportMessages.WizardBreakpointsPage_5);
        optionsGroup.setFont(parent.getFont());
        this.fAutoRemoveDuplicates = new Button((Composite)optionsGroup, 16416);
        this.fAutoRemoveDuplicates.setText(ImportExportMessages.WizardImportBreakpointsPage_3);
        this.fAutoRemoveDuplicates.setFont(font);
        this.fAutoCreateWorkingSets = new Button((Composite)optionsGroup, 16416);
        this.fAutoCreateWorkingSets.setText(ImportExportMessages.WizardImportBreakpointsPage_5);
        this.fAutoCreateWorkingSets.setFont(font);
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(ImportExportMessages.WizardImportBreakpointsPage_4);
        destinationLabel.setFont(font);
        this.fFileNameField = new Text(destinationSelectionGroup, 2048);
        this.fFileNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        this.fFileNameField.setLayoutData((Object)data);
        this.fFileNameField.setFont(font);
        this.fBrowseForFileButton = SWTUtil.createPushButton(destinationSelectionGroup, ImportExportMessages.WizardBreakpointsPage_8, null);
        this.fBrowseForFileButton.addListener(13, (Listener)this);
    }

    private void saveWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(REMOVE_DUPS, this.fAutoRemoveDuplicates.getSelection());
            settings.put(CREATE_WORKING_SETS, this.fAutoCreateWorkingSets.getSelection());
            settings.put(SOURCE_FILE_NAME, this.fFileNameField.getText().trim());
        }
    }

    private void restoreWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fAutoRemoveDuplicates.setSelection(Boolean.valueOf(settings.get(REMOVE_DUPS)).booleanValue());
            this.fAutoCreateWorkingSets.setSelection(Boolean.valueOf(settings.get(CREATE_WORKING_SETS)).booleanValue());
            String fileName = settings.get(SOURCE_FILE_NAME);
            if (fileName != null) {
                this.fFileNameField.setText(fileName);
            }
        }
    }

    public boolean finish() {
        try {
            this.saveWidgetState();
            this.getContainer().run(true, true, (IRunnableWithProgress)new ImportBreakpointsOperation(this.fFileNameField.getText().trim(), this.fAutoRemoveDuplicates.getSelection(), this.fAutoCreateWorkingSets.getSelection()));
        }
        catch (InterruptedException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        return true;
    }
}

