/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class CompileErrorProjectPromptStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        ILaunchConfiguration config = null;
        ArrayList projects = new ArrayList();
        if (source instanceof List) {
            List args = (List)source;
            Iterator iterator = args.iterator();
            while (iterator.hasNext()) {
                Object arg = iterator.next();
                if (arg instanceof ILaunchConfiguration) {
                    config = (ILaunchConfiguration)arg;
                    if (!DebugUITools.isPrivate(config)) continue;
                    return Boolean.TRUE;
                }
                if (!(arg instanceof IProject)) continue;
                projects.add(arg);
            }
        }
        Shell shell = DebugUIPlugin.getShell();
        String title = LaunchConfigurationsMessages.CompileErrorPromptStatusHandler_0;
        StringBuffer projectMessage = new StringBuffer();
        int i = 0;
        while (i < projects.size()) {
            if (i > 0) {
                projectMessage.append(", ");
            }
            projectMessage.append(((IProject)projects.get(i)).getName());
            ++i;
        }
        String message = MessageFormat.format(LaunchConfigurationsMessages.CompileErrorPromptStatusHandler_2, projectMessage.toString());
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        String pref = store.getString(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR);
        if (pref != null && pref.equals("always")) {
            return Boolean.TRUE;
        }
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, null, false);
        dialog.setPrefKey(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR);
        dialog.setPrefStore(store);
        dialog.open();
        int returnValue = dialog.getReturnCode();
        if (returnValue == 2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

