/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.ClosedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeletedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.FilterLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationView;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.WorkingSetsFilter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class LaunchConfigurationsDialog
extends TitleAreaDialog
implements ILaunchConfigurationDialog,
IPageChangeProvider,
IPropertyChangeListener {
    private static ILaunchConfigurationDialog fgCurrentlyVisibleLaunchConfigurationDialog;
    private static final int[] DEFAULT_SASH_WEIGHTS;
    protected static final int ID_LAUNCH_BUTTON = 1025;
    protected static final int ID_CLOSE_BUTTON = 1026;
    protected static final int ID_CANCEL_BUTTON = 1027;
    private static final String FOCUS_CONTROL = "focusControl";
    protected static final float MAX_DIALOG_WIDTH_PERCENT = 0.5f;
    protected static final float MAX_DIALOG_HEIGHT_PERCENT = 0.5f;
    protected static final Point DEFAULT_INITIAL_DIALOG_SIZE;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_LAST_LAUNCHED = 2;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_SELECTION = 3;
    public static final int LAUNCH_CONFIGURATION_DIALOG_REUSE_OPEN = 4;
    private SashForm fSashForm;
    private Composite fSelectionArea;
    private LaunchConfigurationView fLaunchConfigurationView;
    private LaunchConfigurationTabGroupViewer fTabViewer;
    private Composite fEditArea;
    private Button fProgressMonitorCancelButton;
    private IStructuredSelection fInitialSelection;
    private IStatus fInitialStatus;
    private ProgressMonitorPart fProgressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private ListenerList changeListeners = new ListenerList();
    private long fActiveRunningOperations = 0L;
    private LaunchGroupExtension fGroup;
    private Image fBannerImage;
    private IAction fDoubleClickAction;
    private Label fFilteringLabel;
    private ClosedProjectFilter fClosedProjectFilter;
    private DeletedProjectFilter fDeletedProjectFilter;
    private LaunchConfigurationTypeFilter fLCTFilter;
    private WorkingSetsFilter fWorkingSetsFilter;
    private int fOpenMode = 2;
    private static final String DIALOG_SASH_WEIGHTS_1;
    private static final String DIALOG_SASH_WEIGHTS_2;
    private static final String DIALOG_WIDTH;

    static {
        DEFAULT_SASH_WEIGHTS = new int[]{11, 30};
        DEFAULT_INITIAL_DIALOG_SIZE = new Point(620, 560);
        DIALOG_SASH_WEIGHTS_1 = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DIALOG_SASH_WEIGHTS_1";
        DIALOG_SASH_WEIGHTS_2 = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DIALOG_SASH_WEIGHTS_2";
        DIALOG_WIDTH = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DIALOG_WIDTH";
    }

    public static ILaunchConfigurationDialog getCurrentlyVisibleLaunchConfigurationDialog() {
        return fgCurrentlyVisibleLaunchConfigurationDialog;
    }

    public static void setCurrentlyVisibleLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        fgCurrentlyVisibleLaunchConfigurationDialog = dialog;
    }

    public LaunchConfigurationsDialog(Shell shell, LaunchGroupExtension group) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setLaunchGroup(group);
    }

    private Object aboutToStart() {
        Map savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.getProgressMonitorCancelButton().setCursor(this.arrowCursor);
            savedState = this.saveUIState();
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            this.getProgressMonitorCancelButton().setEnabled(true);
            this.getProgressMonitorPart().attachToCancelComponent((Control)this.getProgressMonitorCancelButton());
            this.getProgressMonitorPart().getParent().setVisible(true);
            this.getProgressMonitorCancelButton().setFocus();
        }
        return savedState;
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 5;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(LaunchConfigurationsMessages.LaunchConfigurationDialog_Create__manage__and_run_launch_configurations_8);
        this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationDialog_Ready_to_launch_2);
        this.setModeLabelState();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        SashForm sash = new SashForm(topComp, 65536);
        sash.setOrientation(256);
        sash.setLayoutData((Object)gd);
        sash.setFont(dialogComp.getFont());
        sash.setVisible(true);
        this.setSashForm(sash);
        Control launchConfigSelectionArea = this.createLaunchConfigurationSelectionArea((Composite)this.getSashForm());
        gd = new GridData(1040);
        launchConfigSelectionArea.setLayoutData((Object)gd);
        Composite editAreaComp = this.createLaunchConfigurationEditArea((Composite)this.getSashForm());
        this.setEditArea(editAreaComp);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        dialogComp.layout(true);
        LaunchConfigurationsDialog.applyDialogFont((Control)dialogComp);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.changeListeners.add((Object)listener);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleLaunchPressed();
        } else if (buttonId == 1026) {
            this.handleClosePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private int[] calculateNewSashWeights(int widthIncrease) {
        int[] newWeights = new int[2];
        newWeights[0] = this.getSelectionArea().getBounds().width;
        if (newWeights[0] < 180) {
            newWeights[0] = 180;
        }
        newWeights[1] = this.getEditArea().getBounds().width + widthIncrease;
        return newWeights;
    }

    private boolean canDiscardCurrentConfig() {
        if (this.getTabViewer().isDirty()) {
            return this.showUnsavedChangesDialog();
        }
        return true;
    }

    public boolean close() {
        if (!this.isSafeToClose()) {
            return false;
        }
        this.persistSashWeights();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
        this.getBannerImage().dispose();
        this.getTabViewer().dispose();
        if (this.fLaunchConfigurationView != null) {
            this.fLaunchConfigurationView.dispose();
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.getHelpContextId());
    }

    public void create() {
        super.create();
        if (this.getTabViewer().getInput() == null) {
            this.getTabViewer().inputChanged(null);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (this.isHelpAvailable() || TrayDialog.isDialogHelpAvailable()) {
            this.createHelpControl(composite);
        }
        Composite monitorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        monitorComposite.setLayout((Layout)layout);
        monitorComposite.setLayoutData((Object)new GridData(768));
        GridLayout pmLayout = new GridLayout();
        this.setProgressMonitorPart(new ProgressMonitorPart(monitorComposite, (Layout)pmLayout));
        Button cancelButton = this.createButton(monitorComposite, 1027, LaunchConfigurationsMessages.LaunchConfigurationDialog_Cancel_3, true);
        this.setProgressMonitorCancelButton(cancelButton);
        this.getProgressMonitorCancelButton().setFont(font);
        this.getProgressMonitorPart().setLayoutData((Object)new GridData(768));
        this.getProgressMonitorPart().setFont(font);
        monitorComposite.setVisible(false);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setFont(composite.getFont());
        this.createButtonsForButtonBar(buttonComposite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1025, this.getLaunchButtonText(), true);
        button.setEnabled(false);
        this.createButton(parent, 1026, LaunchConfigurationsMessages.LaunchConfigurationDialog_Close_1, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeContent();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        this.addContent(dialogComp);
        return dialogComp;
    }

    protected Composite createLaunchConfigurationEditArea(Composite parent) {
        this.setTabViewer(new LaunchConfigurationTabGroupViewer(parent, this));
        this.getTabViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleTabSelectionChanged();
            }
        });
        return (Composite)this.getTabViewer().getControl();
    }

    protected void createToolbarActions(ToolBarManager tmanager) {
        tmanager.add((IAction)this.getNewAction());
        tmanager.add((IAction)this.getDuplicateAction());
        tmanager.add((IAction)this.getDeleteAction());
        tmanager.add(this.getFilterAction());
        tmanager.update(true);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Control createLaunchConfigurationSelectionArea(Composite parent) {
        Composite comp = new Composite(parent, 0x800000);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        ViewForm viewForm = new ViewForm(comp, 0x800800);
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x800000);
        viewForm.setTopLeft((Control)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.setSelectionArea((Composite)viewForm);
        viewForm.setLayoutData((Object)new GridData(1808));
        Composite viewFormContents = new Composite((Composite)viewForm, 0x800000);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        viewFormContents.setLayout((Layout)gridLayout);
        this.fLaunchConfigurationView = new LaunchConfigurationView(this.getLaunchGroup());
        this.fLaunchConfigurationView.createLaunchDialogControl(viewFormContents);
        this.createToolbarActions(toolBarManager);
        this.fDoubleClickAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)LaunchConfigurationsDialog.this.fLaunchConfigurationView.getViewer().getSelection();
                Object target = selection.getFirstElement();
                if (target instanceof ILaunchConfiguration) {
                    if (LaunchConfigurationsDialog.this.getTabViewer().canLaunch()) {
                        LaunchConfigurationsDialog.this.handleLaunchPressed();
                    }
                } else {
                    LaunchConfigurationsDialog.this.getNewAction().run();
                    LaunchConfigurationsDialog.this.refreshFilteringLabel();
                }
            }
        };
        this.fLaunchConfigurationView.setAction("Double_Click_ActionId", this.fDoubleClickAction);
        Viewer viewer = this.fLaunchConfigurationView.getViewer();
        this.fClosedProjectFilter = new ClosedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED)) {
            ((StructuredViewer)viewer).addFilter((ViewerFilter)this.fClosedProjectFilter);
        }
        this.fDeletedProjectFilter = new DeletedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED)) {
            ((StructuredViewer)viewer).addFilter((ViewerFilter)this.fDeletedProjectFilter);
        }
        this.fLCTFilter = new LaunchConfigurationTypeFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
            ((StructuredViewer)viewer).addFilter((ViewerFilter)this.fLCTFilter);
        }
        this.fWorkingSetsFilter = new WorkingSetsFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS)) {
            ((StructuredViewer)viewer).addFilter((ViewerFilter)this.fWorkingSetsFilter);
        }
        Control control = viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        viewForm.setContent((Control)viewFormContents);
        this.fFilteringLabel = new Label(viewFormContents, 0);
        gd = new GridData(769);
        gd.horizontalIndent = 5;
        gd.heightHint = 15;
        this.fFilteringLabel.setLayoutData((Object)gd);
        this.refreshFilteringLabel();
        AbstractLaunchConfigurationAction.IConfirmationRequestor requestor = new AbstractLaunchConfigurationAction.IConfirmationRequestor(){

            public boolean getConfirmation() {
                return LaunchConfigurationsDialog.this.canDiscardCurrentConfig();
            }
        };
        this.getDuplicateAction().setConfirmationRequestor(requestor);
        this.getNewAction().setConfirmationRequestor(requestor);
        ((StructuredViewer)viewer).addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleLaunchConfigurationSelectionChanged(event);
                LaunchConfigurationsDialog.this.getNewAction().setEnabled(LaunchConfigurationsDialog.this.getNewAction().isEnabled());
                LaunchConfigurationsDialog.this.getDeleteAction().setEnabled(LaunchConfigurationsDialog.this.getDeleteAction().isEnabled());
                LaunchConfigurationsDialog.this.getDuplicateAction().setEnabled(LaunchConfigurationsDialog.this.getDuplicateAction().isEnabled());
            }
        });
        return comp;
    }

    private boolean equalCategories(String c1, String c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.equals(c2);
    }

    public void refreshFilteringLabel() {
        try {
            int total = 0;
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
            int i = 0;
            while (i < configs.length) {
                if (configs[i].supportsMode(this.getMode()) & !configs[i].getAttribute(IDebugUIConstants.ATTR_PRIVATE, false) & this.equalCategories(configs[i].getCategory(), this.getLaunchGroup().getCategory())) {
                    ++total;
                }
                ++i;
            }
            ILaunchConfigurationType[] types = this.getLaunchManager().getLaunchConfigurationTypes();
            int i2 = 0;
            while (i2 < types.length) {
                if (types[i2].supportsMode(this.getMode()) & types[i2].isPublic() & this.equalCategories(types[i2].getCategory(), this.getLaunchGroup().getCategory())) {
                    ++total;
                }
                ++i2;
            }
            TreeViewer viewer = (TreeViewer)this.fLaunchConfigurationView.getViewer();
            IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
            viewer.getTree().selectAll();
            int filtered = ((IStructuredSelection)viewer.getSelection()).size();
            viewer.getTree().deselectAll();
            viewer.setSelection((ISelection)sel);
            this.fFilteringLabel.setText(MessageFormat.format(LaunchConfigurationsMessages.LaunchConfigurationsDialog_6, new Integer(filtered), new Integer(total)));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void doInitialTreeSelection() {
        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)this.getInitialSelection());
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    public String generateName(String name) {
        if (name == null) {
            name = "";
        }
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
    }

    public ILaunchConfigurationTab getActiveTab() {
        return this.getTabViewer().getActiveTab();
    }

    protected Image getBannerImage() {
        ImageDescriptor descriptor;
        if (this.fBannerImage == null && (descriptor = this.getLaunchGroup().getBannerImageDescriptor()) != null) {
            this.fBannerImage = descriptor.createImage();
        }
        return this.fBannerImage;
    }

    protected AbstractLaunchConfigurationAction getDeleteAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION);
    }

    protected IAction getFilterAction() {
        return this.fLaunchConfigurationView.getAction(FilterLaunchConfigurationAction.ID_FILTER_ACTION);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".LAUNCH_CONFIGURATIONS_DIALOG_SECTION";
    }

    protected Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    protected AbstractLaunchConfigurationAction getDuplicateAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION);
    }

    protected Composite getEditArea() {
        return this.fEditArea;
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG;
    }

    private IStructuredSelection getInitialSelection() {
        return this.fInitialSelection;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            settings.getInt(DIALOG_WIDTH);
            return super.getInitialSize();
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_INITIAL_DIALOG_SIZE;
        }
    }

    protected IStatus getInitialStatus() {
        return this.fInitialStatus;
    }

    protected ILaunchConfiguration getLastLaunchedWorkbenchConfiguration() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroup().getIdentifier());
    }

    protected String getLaunchButtonText() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getMode()).getLabel();
    }

    public LaunchGroupExtension getLaunchGroup() {
        return this.fGroup;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public String getMode() {
        return this.getLaunchGroup().getMode();
    }

    protected AbstractLaunchConfigurationAction getNewAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION);
    }

    protected int getOpenMode() {
        return this.fOpenMode;
    }

    private Button getProgressMonitorCancelButton() {
        return this.fProgressMonitorCancelButton;
    }

    private ProgressMonitorPart getProgressMonitorPart() {
        return this.fProgressMonitorPart;
    }

    private SashForm getSashForm() {
        return this.fSashForm;
    }

    public Object getSelectedPage() {
        return this.getActiveTab();
    }

    private Composite getSelectionArea() {
        return this.fSelectionArea;
    }

    protected String getShellTitle() {
        String title = DebugUIPlugin.removeAccelerators(this.getLaunchGroup().getLabel());
        if (title == null) {
            title = LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configurations_18;
        }
        return title;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        if (this.getTabViewer() != null) {
            return this.getTabViewer().getTabGroup();
        }
        return null;
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() == null) {
            return null;
        }
        return this.getTabGroup().getTabs();
    }

    protected LaunchConfigurationTabGroupViewer getTabViewer() {
        return this.fTabViewer;
    }

    protected void handleClosePressed() {
        if (this.canDiscardCurrentConfig()) {
            this.cancelPressed();
        }
    }

    protected void handleLaunchConfigurationSelectionChanged(SelectionChangedEvent event) {
        ILaunchConfiguration original;
        Object input = this.getTabViewer().getInput();
        Object newInput = null;
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Button button = this.getButton(1025);
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                newInput = structuredSelection.getFirstElement();
                button.setEnabled(true);
            } else {
                button.setEnabled(false);
            }
        }
        if ((original = this.getTabViewer().getOriginal()) != null && newInput == null && this.getLaunchManager().getMovedTo(original) != null) {
            return;
        }
        if (!this.isEqual(input, newInput)) {
            ILaunchConfigurationTabGroup newGroup;
            ILaunchConfigurationTabGroup group = this.getTabGroup();
            if (original != null) {
                boolean canReplace;
                boolean deleted = !original.exists();
                boolean renamed = false;
                if (newInput instanceof ILaunchConfiguration) {
                    ILaunchConfiguration lc = (ILaunchConfiguration)newInput;
                    boolean bl = renamed = this.getLaunchManager().getMovedFrom(lc) != null;
                }
                if (this.getTabViewer().isDirty() && !deleted && !renamed && !(canReplace = this.showUnsavedChangesDialog())) {
                    StructuredSelection sel = new StructuredSelection(input);
                    this.fLaunchConfigurationView.getViewer().setSelection((ISelection)sel);
                    return;
                }
            }
            this.getTabViewer().setInput(newInput);
            if (this.getTabViewer().isDirty()) {
                this.getTabViewer().handleApplyPressed();
            }
            if (!this.isEqual(group, newGroup = this.getTabGroup()) && this.isVisible()) {
                this.resize();
            }
        }
    }

    protected void handleLaunchPressed() {
        ILaunchConfiguration config = this.getTabViewer().getOriginal();
        if (this.getTabViewer().isDirty()) {
            this.getTabViewer().handleApplyPressed();
            config = this.getTabViewer().getOriginal();
        }
        String mode = this.getMode();
        this.close();
        if (config != null) {
            DebugUITools.launch(config, mode);
        }
    }

    public void handleStatus(IStatus status) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, (Object)this);
                return;
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
        }
        String title = null;
        switch (status.getSeverity()) {
            case 4: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Error_1;
                break;
            }
            case 2: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Warning_2;
                break;
            }
            default: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Information_3;
            }
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    protected void handleTabSelectionChanged() {
        this.updateMessage();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage()));
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.initializeSashForm();
        this.resize();
    }

    protected void initializeContent() {
        this.doInitialTreeSelection();
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
    }

    private void initializeSashForm() {
        if (this.getSashForm() != null) {
            int[] sashWeights;
            IDialogSettings settings = this.getDialogSettings();
            try {
                int w1 = settings.getInt(DIALOG_SASH_WEIGHTS_1);
                if (w1 < 270) {
                    w1 = 270;
                }
                int w2 = settings.getInt(DIALOG_SASH_WEIGHTS_2);
                sashWeights = new int[]{w1, w2};
            }
            catch (NumberFormatException numberFormatException) {
                sashWeights = DEFAULT_SASH_WEIGHTS;
            }
            this.getSashForm().setWeights(sashWeights);
        }
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected boolean isSafeToClose() {
        return this.fActiveRunningOperations == 0L;
    }

    private boolean isVisible() {
        return this.getShell() != null && this.getShell().isVisible();
    }

    public int open() {
        ILaunchConfiguration lastLaunchedConfig;
        int mode = this.getOpenMode();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(this);
        if (mode == 2 && (lastLaunchedConfig = this.getLastLaunchedWorkbenchConfiguration()) != null) {
            this.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)lastLaunchedConfig));
        }
        return super.open();
    }

    protected void persistSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        SashForm sashForm = this.getSashForm();
        if (sashForm != null) {
            int[] sashWeights = this.getSashForm().getWeights();
            settings.put(DIALOG_SASH_WEIGHTS_1, sashWeights[0]);
            settings.put(DIALOG_SASH_WEIGHTS_2, sashWeights[1]);
        }
    }

    protected void refreshStatus() {
        this.updateMessage();
        this.updateButtons();
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected void resize() {
        PixelConverter pixelConverter = new PixelConverter((Control)this.getEditArea());
        int runningTabWidth = 0;
        ILaunchConfigurationTabGroup group = this.getTabGroup();
        if (group == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = group.getTabs();
        Point contentSize = new Point(0, 0);
        int i = 0;
        while (i < tabs.length) {
            Control control;
            String name = tabs[i].getName();
            Image image = tabs[i].getImage();
            runningTabWidth += pixelConverter.convertWidthInCharsToPixels(name.length() + 5);
            if (image != null) {
                runningTabWidth += image.getBounds().width;
            }
            if ((control = tabs[i].getControl()) != null) {
                Point size = control.computeSize(-1, -1, true);
                if (size.x > contentSize.x) {
                    contentSize.x = size.x;
                }
                if (size.y > contentSize.y) {
                    contentSize.y = size.y;
                }
            }
            ++i;
        }
        if (runningTabWidth > contentSize.x) {
            int otherWidth = this.getSashForm().SASH_WIDTH + this.getSelectionArea().getBounds().width;
            int totalWidth = runningTabWidth + otherWidth;
            int maxAllowedWidth = (int)((float)this.getDisplay().getBounds().width * 0.5f);
            contentSize.x = totalWidth > maxAllowedWidth ? maxAllowedWidth - otherWidth : runningTabWidth;
        }
        int maxAllowedHeight = (int)((float)this.getDisplay().getBounds().height * 0.5f);
        contentSize.y = Math.min(contentSize.y, maxAllowedHeight);
        Rectangle tabFolderBoundingBox = this.getEditArea().computeTrim(0, 0, contentSize.x, contentSize.y);
        contentSize.x = tabFolderBoundingBox.width;
        contentSize.y = tabFolderBoundingBox.height;
        this.getEditArea().layout(true);
        Rectangle rect = this.getTabViewer().getTabFolder().getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        int hdiff = contentSize.x - containerSize.x;
        int vdiff = contentSize.y - containerSize.y;
        if (hdiff > 0 || vdiff > 0) {
            int[] newSashWeights = null;
            if (hdiff > 0) {
                newSashWeights = this.calculateNewSashWeights(hdiff);
            }
            hdiff = Math.max(0, hdiff);
            vdiff = Math.max(0, vdiff);
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
            if (newSashWeights != null) {
                this.getSashForm().setWeights(newSashWeights);
            }
        }
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.getButton(1025), state, "launch");
        this.restoreEnableState((Control)this.getButton(1026), state, "close");
        ControlEnableState treeState = (ControlEnableState)state.get("selectionarea");
        if (treeState != null) {
            treeState.restore();
        }
        ControlEnableState tabState = (ControlEnableState)state.get("editarea");
        tabState.restore();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!this.isVisible()) {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
            return;
        }
        Object state = this.aboutToStart();
        ++this.fActiveRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.fActiveRunningOperations;
            this.stopped(state);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.fActiveRunningOperations;
            this.stopped(state);
            return;
        }
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, w.isEnabled());
            w.setEnabled(enabled);
        }
    }

    private Map saveUIState() {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(4);
        this.saveEnableStateAndSet((Control)this.getButton(1025), savedState, "launch", false);
        this.saveEnableStateAndSet((Control)this.getButton(1026), savedState, "close", false);
        if (this.getSelectionArea() != null) {
            savedState.put("selectionarea", ControlEnableState.disable((Control)this.getSelectionArea()));
        }
        savedState.put("editarea", ControlEnableState.disable((Control)this.getEditArea()));
        return savedState;
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        this.getTabViewer().setActiveTab(tab);
    }

    public void setActiveTab(int index) {
        this.getTabViewer().setActiveTab(index);
    }

    private void setDisplayCursor(Cursor cursor) {
        Shell[] shells = this.getShell().getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(cursor);
            ++i;
        }
    }

    protected void setEditArea(Composite editArea) {
        this.fEditArea = editArea;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.fInitialSelection = selection;
    }

    public void setInitialStatus(IStatus status) {
        this.fInitialStatus = status;
    }

    protected void setLaunchGroup(LaunchGroupExtension group) {
        this.fGroup = group;
    }

    protected void setModeLabelState() {
        this.setTitleImage(this.getBannerImage());
    }

    public void setName(String name) {
        this.getTabViewer().setName(name);
    }

    public void setOpenMode(int mode) {
        this.fOpenMode = mode;
    }

    private void setProgressMonitorCancelButton(Button button) {
        this.fProgressMonitorCancelButton = button;
    }

    private void setProgressMonitorPart(ProgressMonitorPart part) {
        this.fProgressMonitorPart = part;
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    private void setSelectionArea(Composite selectionArea) {
        this.fSelectionArea = selectionArea;
    }

    protected void setShellSize(int width, int height) {
        Rectangle bounds = this.getShell().getDisplay().getBounds();
        this.getShell().setSize(Math.min(width, bounds.width), Math.min(height, bounds.height));
    }

    protected void setTabViewer(LaunchConfigurationTabGroupViewer viewer) {
        this.fTabViewer = viewer;
    }

    private boolean showDiscardChangesDialog() {
        StringBuffer buffer = new StringBuffer(MessageFormat.format(LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___35, this.getTabViewer().getWorkingCopy().getName()));
        buffer.append(this.getTabViewer().getErrorMesssage());
        buffer.append(LaunchConfigurationsMessages.LaunchConfigurationDialog_Do_you_wish_to_discard_changes_37);
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Discard_changes__38, null, buffer.toString(), 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33}, 1);
        return dialog.open() == 0;
    }

    private boolean showSaveChangesDialog() {
        String message = MessageFormat.format(LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___29, this.getTabViewer().getWorkingCopy().getName());
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Save_changes__31, null, message, 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33, LaunchConfigurationsMessages.LaunchConfigurationDialog_Cancel_34}, 0);
        int ret = dialog.open();
        if (ret == 0) {
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(false);
            }
            this.getTabViewer().handleApplyPressed();
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(true);
            }
            return true;
        }
        return ret == 1;
    }

    private boolean showUnsavedChangesDialog() {
        if (this.getTabViewer().canSave()) {
            return this.showSaveChangesDialog();
        }
        return this.showDiscardChangesDialog();
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            this.getProgressMonitorPart().getParent().setVisible(false);
            this.getProgressMonitorPart().removeFromCancelComponent((Control)this.getProgressMonitorCancelButton());
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.setDisplayCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    public void updateButtons() {
        this.getNewAction().setEnabled(this.getNewAction().isEnabled());
        this.getDeleteAction().setEnabled(this.getDeleteAction().isEnabled());
        this.getDuplicateAction().setEnabled(this.getDuplicateAction().isEnabled());
        this.getTabViewer().refresh();
        this.getButton(1025).setEnabled(this.getTabViewer().canLaunch());
    }

    public void updateMessage() {
        this.setErrorMessage(this.getTabViewer().getErrorMesssage());
        this.setMessage(this.getTabViewer().getMessage());
    }

    public void propertyChange(final PropertyChangeEvent event) {
        WorkbenchJob job = new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TreeViewer viewer = LaunchConfigurationsDialog.this.fLaunchConfigurationView.getTreeViewer();
                TreeSelection sel = (TreeSelection)viewer.getSelection();
                TreePath path = null;
                int pidx = -1;
                int cidx = -1;
                if (!sel.isEmpty()) {
                    path = sel.getPaths()[0];
                    pidx = LaunchConfigurationsDialog.this.findIndexOfParent(path.getFirstSegment());
                    cidx = LaunchConfigurationsDialog.this.findIndexOfChild(path.getFirstSegment(), path.getLastSegment());
                }
                boolean newvalue = Boolean.valueOf(event.getNewValue().toString());
                if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fClosedProjectFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fDeletedProjectFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fLCTFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fWorkingSetsFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_TYPE_LIST)) {
                    viewer.removeFilter((ViewerFilter)LaunchConfigurationsDialog.this.fLCTFilter);
                    viewer.addFilter((ViewerFilter)LaunchConfigurationsDialog.this.fLCTFilter);
                }
                viewer.expandAll();
                LaunchConfigurationsDialog.this.refreshFilteringLabel();
                LaunchConfigurationsDialog.this.updateSelection(path, pidx, cidx);
                return null;
            }
        };
        job.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    private void updateFilter(boolean state, ViewerFilter filter) {
        TreeViewer viewer = (TreeViewer)this.fLaunchConfigurationView.getViewer();
        if (state) {
            viewer.addFilter(filter);
        } else {
            viewer.removeFilter(filter);
        }
    }

    private void updateSelection(TreePath path, int pidx, int cidx) {
        TreeViewer viewer = this.fLaunchConfigurationView.getTreeViewer();
        Tree tree = viewer.getTree();
        int pcount = tree.getItemCount();
        if (tree.getItemCount() == 0) {
            this.setErrorMessage(null);
            this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationsDialog_7);
            this.updateButtons();
        } else if (path != null) {
            Object sel = path.getLastSegment();
            int pidex = this.findIndexOfParent(path.getFirstSegment());
            if (path.getSegmentCount() == 1) {
                if (pidex == -1) {
                    if (pidx > pcount) {
                        pidx = pcount - 1;
                    }
                    sel = pidx == 0 ? tree.getItem(pidx).getData() : tree.getItem(pidx - 1).getData();
                } else {
                    sel = tree.getItem(pidex).getData();
                }
            } else if (pidex == -1) {
                if (pidx > pcount) {
                    pidx = pcount - 1;
                }
                sel = pidx == 0 ? tree.getItem(pidx).getData() : tree.getItem(pidx - 1).getData();
            } else {
                int cidex = this.findIndexOfChild(path.getFirstSegment(), path.getLastSegment());
                TreeItem parent = tree.getItem(pidex);
                int ccount = parent.getItemCount();
                if (cidex == -1) {
                    if (parent.getItemCount() == 0) {
                        sel = parent.getData();
                    } else {
                        if (cidx > ccount) {
                            cidx = ccount - 1;
                        }
                        sel = cidx == 0 ? parent.getItem(cidx).getData() : parent.getItem(cidx - 1).getData();
                    }
                } else {
                    sel = parent.getItem(cidex).getData();
                }
            }
            viewer.setSelection((ISelection)new StructuredSelection(sel));
        } else {
            this.setErrorMessage(null);
            this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationDialog_Ready_to_launch_2);
        }
    }

    private int findIndexOfParent(Object parent) {
        Tree tree = this.fLaunchConfigurationView.getTreeViewer().getTree();
        TreeItem[] roots = tree.getItems();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getData().equals(parent)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findIndexOfChild(Object parent, Object child) {
        Tree tree = this.fLaunchConfigurationView.getTreeViewer().getTree();
        int pidx = this.findIndexOfParent(parent);
        if (pidx != -1) {
            TreeItem root = tree.getItem(pidx);
            TreeItem[] children = root.getItems();
            int j = 0;
            while (j < children.length) {
                if (children[j].getData().equals(child)) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }
}

