/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModelViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class AsynchronousTreeNavigationModel
extends LabelProvider {
    private Map fElementsToItems = new HashMap();
    private AsynchronousTreeModelViewer fViewer = null;

    public AsynchronousTreeNavigationModel(AsynchronousTreeModelViewer viewer) {
        this.init(viewer);
    }

    private void init(AsynchronousTreeModelViewer viewer) {
        this.fViewer = viewer;
        TreeItem[] items = viewer.getTree().getItems();
        this.traverse(items);
    }

    private void traverse(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            Object data = item.getData();
            if (data != null) {
                this.fElementsToItems.put(data, item);
                this.traverse(item.getItems());
            }
            ++i;
        }
    }

    public Image getImage(Object element) {
        TreeItem item = this.getItem(element);
        if (item != null) {
            return item.getImage();
        }
        return null;
    }

    public String getText(Object element) {
        TreeItem item = this.getItem(element);
        if (item != null) {
            return item.getText();
        }
        return "";
    }

    TreeItem getItem(Object element) {
        return (TreeItem)this.fElementsToItems.get(element);
    }

    Object[] getElements() {
        return this.fElementsToItems.keySet().toArray();
    }

    AsynchronousTreeModelViewer getViewer() {
        return this.fViewer;
    }

    public void dispose() {
        super.dispose();
        this.fElementsToItems.clear();
        this.fViewer = null;
    }
}

