/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.Iterator;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class ViewManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fPerspectiveViewer;
    private Button fTrackViewsButton;
    private Button fResetViewsButton;
    private boolean fResetPressed = false;
    private PerspectiveLabelProvider fLabelProvider = null;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ViewManagementPreferencePage.this.fResetViewsButton) {
                ViewManagementPreferencePage.this.handleResetPressed();
            } else if (source == ViewManagementPreferencePage.this.fTrackViewsButton) {
                ViewManagementPreferencePage.this.handleTrackViewsToggled();
            }
        }
    };

    public ViewManagementPreferencePage() {
        this.setTitle(DebugPreferencesMessages.ViewManagementPreferencePage_1);
        this.setDescription(DebugPreferencesMessages.ViewManagementPreferencePage_0);
        this.setPreferenceStore(DebugUITools.getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.VIEW_MANAGEMENT_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createPerspectiveViewer(composite);
        this.createViewTrackingOptions(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createViewTrackingOptions(Composite composite) {
        this.fTrackViewsButton = new Button(composite, 32);
        this.fTrackViewsButton.setLayoutData((Object)new GridData(768));
        this.fTrackViewsButton.setText(DebugPreferencesMessages.ViewManagementPreferencePage_3);
        this.fTrackViewsButton.setSelection(DebugUITools.getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS));
        this.fTrackViewsButton.addSelectionListener(this.fSelectionListener);
        Label label = new Label(composite, 64);
        label.setText(DebugPreferencesMessages.ViewManagementPreferencePage_4);
        label.setLayoutData((Object)new GridData(768));
        this.fResetViewsButton = SWTUtil.createPushButton(composite, DebugPreferencesMessages.ViewManagementPreferencePage_5, null);
        ((GridData)this.fResetViewsButton.getLayoutData()).horizontalAlignment = 1;
        this.fResetViewsButton.addSelectionListener(this.fSelectionListener);
        this.updateResetButton();
    }

    private void handleResetPressed() {
        this.fResetPressed = true;
        this.fResetViewsButton.setEnabled(false);
    }

    protected void handleTrackViewsToggled() {
        if (this.fTrackViewsButton.getSelection()) {
            this.updateResetButton();
        } else {
            this.fResetViewsButton.setEnabled(false);
        }
    }

    private void createPerspectiveViewer(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(DebugPreferencesMessages.ViewManagementPreferencePage_2);
        label.setLayoutData((Object)new GridData(768));
        Table table = new Table(parent, 67618);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        this.fPerspectiveViewer = new CheckboxTableViewer(table);
        PerspectiveProvider provider = new PerspectiveProvider();
        this.fPerspectiveViewer.setContentProvider((IContentProvider)provider);
        this.fLabelProvider = new PerspectiveLabelProvider();
        this.fPerspectiveViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fPerspectiveViewer.setInput((Object)this);
        this.checkPerspectives(this.getPreferenceStore().getString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES));
    }

    private void checkPerspectives(String perspectiveList) {
        this.fPerspectiveViewer.setAllChecked(false);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        Iterator perspectiveIds = ViewContextService.parseList(perspectiveList).iterator();
        while (perspectiveIds.hasNext()) {
            IPerspectiveDescriptor descriptor = registry.findPerspectiveWithId((String)perspectiveIds.next());
            if (descriptor == null) continue;
            this.fPerspectiveViewer.setChecked((Object)descriptor, true);
        }
    }

    public boolean performOk() {
        StringBuffer buffer = new StringBuffer();
        Object[] descriptors = this.fPerspectiveViewer.getCheckedElements();
        int i = 0;
        while (i < descriptors.length) {
            buffer.append(((IPerspectiveDescriptor)descriptors[i]).getId()).append(',');
            ++i;
        }
        this.getPreferenceStore().setValue(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES, buffer.toString());
        boolean trackViews = this.fTrackViewsButton.getSelection();
        this.getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_TRACK_VIEWS, trackViews);
        if (this.fResetPressed || !trackViews) {
            this.getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_USER_VIEW_BINDINGS, "");
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.checkPerspectives(this.getPreferenceStore().getDefaultString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES));
        this.fTrackViewsButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS));
        this.fResetPressed = false;
        this.updateResetButton();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private void updateResetButton() {
        boolean enableReset = !"".equals(this.getPreferenceStore().getString(IInternalDebugUIConstants.PREF_USER_VIEW_BINDINGS));
        this.fResetViewsButton.setEnabled(enableReset && !this.fResetPressed && this.fTrackViewsButton.getSelection());
    }

    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }

    private static class PerspectiveProvider
    implements IStructuredContentProvider {
        PerspectiveProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

