/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import java.io.File;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DirectorySourceContainerDialog
extends TitleAreaDialog {
    private static final String LAST_PATH_SETTING = "EXT_FOLDER_LAST_PATH_SETTING";
    private static final String LAST_SUBDIR_SETTING = "EXT_FOLDER_LAST_SUBDIR_SETTING";
    private String fDirectory;
    private boolean fSearchSubfolders = true;
    private Text fDirText;
    private Button fSubfoldersButton;
    private boolean fNewContainer = true;

    public DirectorySourceContainerDialog(Shell shell) {
        this(shell, "", DebugUIPlugin.getDefault().getDialogSettings().getBoolean(LAST_SUBDIR_SETTING));
        this.fNewContainer = true;
    }

    public DirectorySourceContainerDialog(Shell shell, String directory, boolean searchSubfolders) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDirectory = directory;
        this.fSearchSubfolders = searchSubfolders;
        this.fNewContainer = false;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    public boolean isSearchSubfolders() {
        return this.fSearchSubfolders;
    }

    protected Control createDialogArea(Composite parent) {
        Image image = this.fNewContainer ? DebugPluginImages.getImage("IMG_ADD_SRC_DIRECTORY") : DebugPluginImages.getImage("IMG_EDIT_SRC_DIRECTORY");
        this.setTitle(SourceLookupUIMessages.DirectorySourceContainerDialog_2);
        this.setMessage(SourceLookupUIMessages.DirectorySourceContainerDialog_3);
        this.setTitleImage(image);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        Composite dirComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        dirComposite.setLayout((Layout)layout);
        dirComposite.setLayoutData((Object)new GridData(768));
        dirComposite.setFont(font);
        Label label = new Label(dirComposite, 0);
        label.setText(SourceLookupUIMessages.DirectorySourceContainerDialog_4);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.fDirText = new Text(dirComposite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fDirText.setLayoutData((Object)data);
        this.fDirText.setFont(font);
        this.fDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectorySourceContainerDialog.this.validate();
            }
        });
        Button button = new Button(dirComposite, 8);
        button.setText(SourceLookupUIMessages.DirectorySourceContainerDialog_5);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectorySourceContainerDialog.this.browse();
            }
        });
        this.fSubfoldersButton = new Button(composite, 32);
        this.fSubfoldersButton.setText(SourceLookupUIMessages.DirectorySourceContainerDialog_6);
        return parentComposite;
    }

    protected void configureShell(Shell newShell) {
        String title = null;
        title = this.fNewContainer ? SourceLookupUIMessages.DirectorySourceContainerDialog_7 : SourceLookupUIMessages.DirectorySourceContainerDialog_8;
        newShell.setText(title);
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.fDirText.setText(this.fDirectory);
        this.fSubfoldersButton.setSelection(this.fSearchSubfolders);
        this.validate();
        return c;
    }

    protected void okPressed() {
        this.fDirectory = this.fDirText.getText().trim();
        this.fSearchSubfolders = this.fSubfoldersButton.getSelection();
        DebugUIPlugin.getDefault().getDialogSettings().put(LAST_PATH_SETTING, this.fDirectory);
        DebugUIPlugin.getDefault().getDialogSettings().put(LAST_SUBDIR_SETTING, this.fSearchSubfolders);
        super.okPressed();
    }

    private void browse() {
        String last = this.fDirText.getText().trim();
        if (last.length() == 0) {
            last = DebugUIPlugin.getDefault().getDialogSettings().get(LAST_PATH_SETTING);
        }
        if (last == null) {
            last = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4);
        dialog.setText(SourceLookupUIMessages.DirectorySourceContainerDialog_0);
        dialog.setMessage(SourceLookupUIMessages.DirectorySourceContainerDialog_1);
        dialog.setFilterPath(last);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.fDirText.setText(result);
    }

    private void validate() {
        File file = new File(this.fDirText.getText().trim());
        this.getButton(0).setEnabled(file.isDirectory() && file.exists());
    }
}

