/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class AsynchronousRequestMonitor
implements IAsynchronousRequestMonitor {
    private Widget fWidget;
    private AsynchronousViewer fViewer;
    private boolean fCanceled = false;
    private IStatus fStatus = null;
    protected WorkbenchJob fViewerUpdateJob = new WorkbenchJob("AsynchronousRequestMonitor.fViewerUpdateJob"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            AsynchronousRequestMonitor.this.getViewer().updateComplete(AsynchronousRequestMonitor.this);
            if (!AsynchronousRequestMonitor.this.isCanceled() && !AsynchronousRequestMonitor.this.getWidget().isDisposed()) {
                if (AsynchronousRequestMonitor.this.fStatus != null && !AsynchronousRequestMonitor.this.fStatus.isOK()) {
                    AsynchronousRequestMonitor.this.getViewer().handlePresentationFailure(AsynchronousRequestMonitor.this, AsynchronousRequestMonitor.this.fStatus);
                }
                AsynchronousRequestMonitor.this.performUpdate();
            }
            return Status.OK_STATUS;
        }
    };

    AsynchronousRequestMonitor(Widget item, AsynchronousViewer viewer) {
        this.fWidget = item;
        this.fViewer = viewer;
        this.fViewerUpdateJob.setSystem(true);
    }

    protected AsynchronousViewer getViewer() {
        return this.fViewer;
    }

    protected Widget getWidget() {
        return this.fWidget;
    }

    protected boolean contains(Widget widget) {
        if (widget == this.getWidget()) {
            return true;
        }
        Widget parent = this.getViewer().getParent(widget);
        while (parent != null) {
            if (parent.equals(this.getWidget())) {
                return true;
            }
            parent = this.getViewer().getParent(parent);
        }
        return false;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public void beginTask(String name, int totalWork) {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.fCanceled;
    }

    public void setCanceled(boolean value) {
        this.fCanceled = true;
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
    }

    public final void done() {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule();
        }
    }

    protected void scheduleViewerUpdate(long ms) {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule(ms);
        }
    }

    protected abstract void performUpdate();

    protected abstract boolean contains(AsynchronousRequestMonitor var1);
}

