/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewerContentManager;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ChildrenRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.IUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.LabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableEditorImpl;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.update.DefaultTableUpdatePolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

public class AsynchronousTableViewer
extends AsynchronousViewer {
    private Table fTable;
    private AsynchronousTableViewerContentManager fContentManager;
    private TableEditor fTableEditor;
    private TableEditorImpl fTableEditorImpl;
    static /* synthetic */ Class class$0;

    public AsynchronousTableViewer(Composite parent) {
        this(parent, 0x10000000);
    }

    public AsynchronousTableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public AsynchronousTableViewer(Table table) {
        Assert.isTrue(((table.getStyle() & 0x10000000) != 0 ? 1 : 0) != 0);
        this.fTable = table;
        this.fContentManager = this.createContentManager();
        this.hookControl((Control)this.fTable);
        this.fTableEditor = new TableEditor(this.fTable);
        this.fTableEditorImpl = this.createTableEditorImpl();
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AsynchronousTableViewer.this.fTableEditorImpl.handleMouseDown(e);
            }
        });
    }

    public IUpdatePolicy createUpdatePolicy() {
        return new DefaultTableUpdatePolicy();
    }

    public synchronized void dispose() {
        this.fContentManager.dispose();
        this.fTable.dispose();
        this.fTableEditor.dispose();
        super.dispose();
    }

    protected AsynchronousTableViewerContentManager createContentManager() {
        return new AsynchronousTableViewerContentManager(this);
    }

    protected ISelection doAttemptSelectionToWidget(ISelection selection, boolean reveal) {
        if (this.acceptsSelection(selection)) {
            List list = ((IStructuredSelection)selection).toList();
            if (list == null) {
                this.fTable.deselectAll();
                return StructuredSelection.EMPTY;
            }
            int[] indices = new int[list.size()];
            Object[] elements = this.fContentManager.getElements();
            int index = 0;
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (list.contains(element)) {
                    indices[index] = i;
                    ++index;
                }
                ++i;
            }
            this.fTable.setSelection(indices);
            if (reveal && indices.length > 0) {
                TableItem item = this.fTable.getItem(indices[0]);
                this.fTable.showItem(item);
            }
        }
        return StructuredSelection.EMPTY;
    }

    protected boolean acceptsSelection(ISelection selection) {
        return selection instanceof IStructuredSelection;
    }

    protected ISelection getEmptySelection() {
        return StructuredSelection.EMPTY;
    }

    protected Widget getParent(Widget widget) {
        if (widget instanceof TableItem) {
            return this.fTable;
        }
        return null;
    }

    protected Widget doFindInputItem(Object element) {
        if (element.equals(this.getInput())) {
            return this.fTable;
        }
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data != null && this.equals(data, element)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    protected List getSelectionFromWidget() {
        TableItem[] selection = this.fTable.getSelection();
        ArrayList<Object> datas = new ArrayList<Object>(selection.length);
        int i = 0;
        while (i < selection.length) {
            datas.add(selection[i].getData());
            ++i;
        }
        return datas;
    }

    public Control getControl() {
        return this.fTable;
    }

    public Table getTable() {
        return (Table)this.getControl();
    }

    protected void setChildren(Widget widget, List children) {
        Object[] elements = this.filter(children.toArray());
        if (elements.length > 0) {
            ViewerSorter sorter = this.getSorter();
            if (sorter != null) {
                sorter.sort((Viewer)this, elements);
            }
            this.fContentManager.setElements(elements);
        }
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    protected void updateLabel(Object element, Widget item) {
        IAsynchronousLabelAdapter adapter;
        if (item instanceof Item && (adapter = this.getLabelAdapter(element)) != null) {
            LabelRequestMonitor labelUpdate = new LabelRequestMonitor(item, this);
            this.schedule(labelUpdate);
            adapter.retrieveLabel(element, this.getPresentationContext(), labelUpdate);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.map(input, (Widget)this.fTable);
        this.refresh();
    }

    protected void internalRefresh(Object element, Widget widget) {
        IAsynchronousContentAdapter adapter;
        super.internalRefresh(element, widget);
        if (element.equals(this.getRoot()) && (adapter = this.getTableContentAdapter(element)) != null) {
            ChildrenRequestMonitor update = new ChildrenRequestMonitor(widget, this);
            this.schedule(update);
            adapter.retrieveChildren(element, this.getPresentationContext(), update);
        }
    }

    private IAsynchronousContentAdapter getTableContentAdapter(Object element) {
        IAsynchronousContentAdapter adapter = null;
        if (element instanceof IAsynchronousContentAdapter) {
            adapter = (IAsynchronousContentAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousContentAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    public void setLabels(Widget widget, String[] labels, ImageDescriptor[] imageDescriptors) {
        TableItem item = (TableItem)widget;
        item.setText(labels);
        Image[] images = new Image[labels.length];
        if (imageDescriptors != null) {
            int i = 0;
            while (i < images.length) {
                if (i < imageDescriptors.length) {
                    images[i] = this.getImage(imageDescriptors[i]);
                }
                ++i;
            }
        }
        item.setImage(images);
    }

    public void setColors(Widget widget, RGB[] foregrounds, RGB[] backgrounds) {
        TableItem item = (TableItem)widget;
        if (foregrounds == null) {
            foregrounds = new RGB[this.fTable.getColumnCount()];
        }
        if (backgrounds == null) {
            backgrounds = new RGB[this.fTable.getColumnCount()];
        }
        int i = 0;
        while (i < foregrounds.length) {
            Color fg = this.getColor(foregrounds[i]);
            item.setForeground(i, fg);
            ++i;
        }
        i = 0;
        while (i < backgrounds.length) {
            Color bg = this.getColor(backgrounds[i]);
            item.setBackground(i, bg);
            ++i;
        }
    }

    public void setFonts(Widget widget, FontData[] fontDatas) {
        TableItem item = (TableItem)widget;
        if (fontDatas != null) {
            int i = 0;
            while (i < fontDatas.length) {
                Font font = this.getFont(fontDatas[i]);
                item.setFont(i, font);
                ++i;
            }
        }
    }

    public void setColumnHeaders(String[] headers) {
        this.fTableEditorImpl.setColumnProperties(headers);
    }

    public Object[] getColumnProperties() {
        return this.fTableEditorImpl.getColumnProperties();
    }

    public void showColumnHeader(final boolean showHeaders) {
        WorkbenchJob job = new WorkbenchJob("Set Header Visibility"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AsynchronousTableViewer.this.fTable.setHeaderVisible(showHeaders);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public void reveal(Object element) {
        Assert.isNotNull((Object)element);
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fTableEditorImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fTableEditorImpl.setCellModifier(modifier);
    }

    protected TableEditorImpl createTableEditorImpl() {
        return new TableEditorImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return AsynchronousTableViewer.this.getTable().getColumnCount();
            }

            Item[] getSelection() {
                return AsynchronousTableViewer.this.getTable().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                AsynchronousTableViewer.this.fTableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            void setSelection(StructuredSelection selection, boolean b) {
                AsynchronousTableViewer.this.setSelection((ISelection)selection, b);
            }

            void showSelection() {
                AsynchronousTableViewer.this.getTable().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((AsynchronousTableViewer)AsynchronousTableViewer.this).fTableEditor.grabHorizontal = layoutData.grabHorizontal;
                ((AsynchronousTableViewer)AsynchronousTableViewer.this).fTableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((AsynchronousTableViewer)AsynchronousTableViewer.this).fTableEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                AsynchronousTableViewer.this.fireDoubleClick(new DoubleClickEvent((Viewer)viewer, viewer.getSelection()));
                AsynchronousTableViewer.this.fireOpen(new OpenEvent((Viewer)viewer, viewer.getSelection()));
            }
        };
    }

    protected ISelection newSelectionFromWidget() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new StructuredSelection(list);
    }

    public CellEditor[] getCellEditors() {
        return this.fTableEditorImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.fTableEditorImpl.getCellModifier();
    }

    public boolean isCellEditorActive() {
        return this.fTableEditorImpl.isCellEditorActive();
    }

    void clear(int index) {
        TableItem item = this.fTable.getItem(index);
        Object data = item.getData();
        if (item.getData() != null) {
            this.unmap(data, (Widget)item);
        }
        this.fTable.clear(index);
    }

    public void cancelEditing() {
        this.fTableEditorImpl.cancelEditing();
    }

    public void editElement(Object element, int column) {
        this.fTableEditorImpl.editElement(element, column);
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.fTable.getItemCount();
        }
        int count = this.fTable.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.fTable.getItem(mid).getData();
            int compare = sorter.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.fTable.getItem(mid).getData();
                    compare = sorter.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void add(Widget parent, Object element) {
        this.add(element);
    }

    public void add(Object element) {
        if (element != null) {
            this.add(new Object[]{element});
        }
    }

    public void add(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        ViewerSorter sorter = this.getSorter();
        if (sorter != null) {
            this.insert(elements, 0);
            return;
        }
        final Object[] filteredElements = this.filter(elements);
        if (filteredElements.length == 0) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob("AsychronousTableViewer.add"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    AsynchronousTableViewer.this.fContentManager.add(filteredElements);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public void remove(Object element) {
        if (element != null) {
            this.remove(new Object[]{element});
        }
    }

    public void remove(final Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob("AsychronousTableViewer.remove"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    AsynchronousTableViewer.this.fContentManager.remove(elements);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public void insert(Object element, int position) {
        if (element != null) {
            this.insert(new Object[]{element}, position);
        }
    }

    public void insert(Object[] elements, final int position) {
        if (elements == null || elements.length == 0) {
            return;
        }
        final Object[] filteredElements = this.filter(elements);
        WorkbenchJob job = new WorkbenchJob("AsychronousTableViewer.insert"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                ViewerSorter sorter = AsynchronousTableViewer.this.getSorter();
                if (sorter == null) {
                    AsynchronousTableViewer.this.fContentManager.insert(filteredElements, position);
                } else {
                    int i = 0;
                    while (i < filteredElements.length) {
                        Object element = filteredElements[i];
                        int index = AsynchronousTableViewer.this.indexForElement(element);
                        AsynchronousTableViewer.this.fContentManager.insert(new Object[]{element}, index);
                        ++i;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public void replace(final Object element, final Object replacement) {
        if (element == null || replacement == null) {
            throw new IllegalArgumentException("unexpected null parameter");
        }
        Object[] filtered = this.filter(new Object[]{replacement});
        if (filtered.length == 0) {
            this.remove(element);
            return;
        }
        WorkbenchJob job = new WorkbenchJob("AsychronousTableViewer.replace"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                ViewerSorter sorter = AsynchronousTableViewer.this.getSorter();
                if (sorter == null) {
                    AsynchronousTableViewer.this.fContentManager.replace(element, replacement);
                } else {
                    AsynchronousTableViewer.this.fContentManager.remove(new Object[]{element});
                    int position = AsynchronousTableViewer.this.indexForElement(replacement);
                    AsynchronousTableViewer.this.fContentManager.insert(new Object[]{replacement}, position);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public AsynchronousTableViewerContentManager getContentManager() {
        return this.fContentManager;
    }
}

