/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class AsynchronousTreeViewerContentManager {
    private static final Object[] EMPTY = new Object[0];
    private Map fWidgetToChildElements = new HashMap();

    public void clearAll() {
        this.fWidgetToChildElements.clear();
    }

    public Object[] getChildElements(Widget parentWidget) {
        Object[] childElements = (Object[])this.fWidgetToChildElements.get(parentWidget);
        if (childElements == null) {
            childElements = EMPTY;
        }
        return childElements;
    }

    public void addChildElement(Widget parentWidget, Object child) {
        Object[] originalChildren = this.getChildElements(parentWidget);
        Object[] newChildren = new Object[originalChildren.length + 1];
        System.arraycopy(originalChildren, 0, newChildren, 0, originalChildren.length);
        newChildren[originalChildren.length] = child;
        this.fWidgetToChildElements.put(parentWidget, newChildren);
    }

    public int getChildCount(Widget parentWidget) {
        return this.getChildElements(parentWidget).length;
    }

    public void setChildElements(Widget parentWidget, Object[] children) {
        this.fWidgetToChildElements.put(parentWidget, children);
    }

    public Object getChildElement(Widget parentWidget, int index) {
        Object[] childElements = this.getChildElements(parentWidget);
        if (index < childElements.length) {
            return childElements[index];
        }
        return null;
    }

    public void remove(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            this.removeChildren(treeItem);
            Object data = treeItem.getData();
            if (data != null) {
                TreeItem parentWidget = treeItem.getParentItem();
                if (parentWidget == null) {
                    parentWidget = treeItem.getParent();
                }
                this.removeFromParent((Widget)parentWidget, data);
            }
        } else {
            this.fWidgetToChildElements.clear();
        }
    }

    private void removeFromParent(Widget parentWidget, Object data) {
        Object[] childElements = this.getChildElements(parentWidget);
        int i = 0;
        while (i < childElements.length) {
            Object object = childElements[i];
            if (data.equals(object)) {
                Object[] newChildren = new Object[childElements.length - 1];
                System.arraycopy(childElements, 0, newChildren, 0, i);
                System.arraycopy(childElements, i + 1, newChildren, i, newChildren.length - i);
                this.fWidgetToChildElements.put(parentWidget, newChildren);
                return;
            }
            ++i;
        }
    }

    private void removeChildren(TreeItem item) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.removeChildren(items[i]);
            ++i;
        }
        this.fWidgetToChildElements.remove(item);
    }
}

