/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TreeSelection
implements IStructuredSelection {
    private TreePath[] fPaths;

    public TreeSelection(TreePath[] paths) {
        this.fPaths = null;
        this.fPaths = paths;
    }

    public TreeSelection(TreePath treePath) {
        TreePath[] treePathArray;
        if (treePath != null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePath;
        } else {
            treePathArray = null;
        }
        this(treePathArray);
    }

    public Object getFirstElement() {
        if (this.fPaths != null && this.fPaths.length > 0) {
            return this.fPaths[0].getLastSegment();
        }
        return null;
    }

    public Iterator iterator() {
        return this.toList().iterator();
    }

    public int size() {
        if (this.fPaths != null) {
            return this.fPaths.length;
        }
        return 0;
    }

    public Object[] toArray() {
        int size = this.size();
        Object[] selection = new Object[size];
        int i = 0;
        while (i < size) {
            selection[i] = this.fPaths[i].getLastSegment();
            ++i;
        }
        return selection;
    }

    public List toList() {
        int size = this.size();
        ArrayList<Object> selection = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            selection.add(this.fPaths[i].getLastSegment());
            ++i;
        }
        return selection;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreeSelection) {
            TreeSelection selection = (TreeSelection)obj;
            int size = this.size();
            if (selection.size() == size) {
                if (size > 0) {
                    int i = 0;
                    while (i < this.fPaths.length) {
                        if (!this.fPaths[i].equals(selection.fPaths[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
        } else if (obj instanceof IStructuredSelection && this.isEmpty() && ((IStructuredSelection)obj).isEmpty()) {
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        if (this.fPaths != null) {
            int i = 0;
            while (i < this.fPaths.length) {
                code += this.fPaths[i].hashCode();
                ++i;
            }
        }
        return code;
    }

    public TreePath[] getPaths() {
        return (TreePath[])this.fPaths.clone();
    }
}

