/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.Iterator;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewPresentationContext;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MemoryRetrievalProxy
extends AbstractModelProxy
implements IMemoryBlockListener {
    private IMemoryBlockRetrieval fRetrieval;
    static /* synthetic */ Class class$0;

    public MemoryRetrievalProxy(IMemoryBlockRetrieval retrieval) {
        this.fRetrieval = retrieval;
    }

    public void memoryBlocksAdded(IMemoryBlock[] memory) {
        ModelDelta delta = new ModelDelta(this.fRetrieval, 0);
        int i = 0;
        while (i < memory.length) {
            IMemoryBlockRetrieval retrieval;
            IMemoryBlock iMemoryBlock = memory[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((retrieval = (IMemoryBlockRetrieval)iMemoryBlock.getAdapter((Class)clazz)) == null) {
                retrieval = memory[i].getDebugTarget();
            }
            if (retrieval != null && retrieval == this.fRetrieval) {
                if (this.toSelect(memory[i])) {
                    delta.addNode(memory[i], 0x200001);
                } else {
                    delta.addNode(memory[i], 1);
                }
            }
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void memoryBlocksRemoved(IMemoryBlock[] memory) {
        ModelDelta delta = new ModelDelta(this.fRetrieval, 0);
        int i = 0;
        while (i < memory.length) {
            IMemoryBlockRetrieval retrieval;
            IMemoryBlock iMemoryBlock = memory[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((retrieval = (IMemoryBlockRetrieval)iMemoryBlock.getAdapter((Class)clazz)) == null) {
                retrieval = memory[i].getDebugTarget();
            }
            if (retrieval != null && retrieval == this.fRetrieval) {
                if (this.isMemoryBlockSelected(this.getCurrentSelection(), memory[i])) {
                    this.addSelectDeltaNode(delta);
                }
                delta.addNode(memory[i], 2);
            }
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
    }

    public synchronized void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
    }

    private void addSelectDeltaNode(ModelDelta delta) {
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (memoryBlocks != null && memoryBlocks.length > 0) {
            delta.addNode(memoryBlocks[0], 0x200000);
        }
    }

    private IStructuredSelection getCurrentSelection() {
        ISelection selection = this.getPresentationContext().getPart().getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private boolean isMemoryBlockSelected(IStructuredSelection selection, IMemoryBlock memoryBlock) {
        if (selection != null) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object sel = iter.next();
                if (sel == memoryBlock) {
                    return true;
                }
                if (!(sel instanceof IMemoryRendering) || ((IMemoryRendering)sel).getMemoryBlock() != memoryBlock) continue;
                return true;
            }
        }
        return false;
    }

    public void installed() {
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (memoryBlocks.length > 0) {
            ModelDelta delta = new ModelDelta(this.fRetrieval, 0);
            this.addSelectDeltaNode(delta);
            this.fireModelChanged(delta);
        }
    }

    private boolean toSelect(IMemoryBlock memoryBlock) {
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (memoryBlocks.length == 1) {
            return true;
        }
        if (this.getPresentationContext() instanceof MemoryViewPresentationContext) {
            MemoryViewPresentationContext context = (MemoryViewPresentationContext)this.getPresentationContext();
            if (context.isMemoryBlockRegistered(memoryBlock)) {
                return true;
            }
            if (!context.isPinMBDisplay()) {
                return true;
            }
        }
        return false;
    }
}

