/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class ThreadEventHandler
extends DebugEventHandler {
    private Set fThreadQueue = new LinkedHashSet();
    private Map fLastTopFrame = new HashMap();

    public ThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    public synchronized void dispose() {
        this.fLastTopFrame.clear();
        this.fThreadQueue.clear();
        super.dispose();
    }

    protected void handleSuspend(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (event.isEvaluation()) {
            ModelDelta delta = this.buildRootDelta();
            ModelDelta node = this.addPathToThread(delta, thread);
            try {
                IStackFrame frame = thread.getTopStackFrame();
                if (frame != null) {
                    node.addNode(frame, 2048);
                    this.fireDelta(delta);
                }
            }
            catch (DebugException debugException) {}
        } else {
            this.queueSuspendedThread(event);
            int extras = 0;
            if (event.getDetail() == 16 | event.getDetail() == 32) {
                extras = 0x100000;
            }
            this.fireDeltaUpdatingTopFrame(thread, extras);
        }
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected void handleResume(DebugEvent event) {
        IThread thread = this.removeSuspendedThread(event);
        this.fireDeltaAndClearTopFrame(thread, 3072);
        thread = this.getNextSuspendedThread();
        if (thread != null) {
            this.fireDeltaUpdatingTopFrame(thread, 0);
        }
    }

    protected void handleCreate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 2049);
    }

    protected void handleTerminate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 2);
    }

    protected void handleChange(DebugEvent event) {
        this.fireDeltaUpdatingTopFrame((IThread)event.getSource(), 2048);
    }

    protected void handleLateSuspend(DebugEvent suspend, DebugEvent resume) {
        IThread thread = this.queueSuspendedThread(suspend);
        this.fireDeltaUpdatingTopFrame(thread, 0x100400);
    }

    protected void handleSuspendTimeout(DebugEvent event) {
        IThread thread = this.removeSuspendedThread(event);
        this.fireDeltaAndClearTopFrame(thread, 1024);
    }

    private ModelDelta buildRootDelta() {
        return new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
    }

    protected ModelDelta addPathToThread(ModelDelta delta, IThread thread) {
        delta = delta.addNode(thread.getLaunch(), 0);
        return delta.addNode(thread.getDebugTarget(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaAndClearTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        node.addNode(thread, flags);
        ThreadEventHandler threadEventHandler = this;
        synchronized (threadEventHandler) {
            this.fLastTopFrame.remove(thread);
        }
        this.fireDelta(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaUpdatingTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        IStackFrame prev = null;
        ThreadEventHandler threadEventHandler = this;
        synchronized (threadEventHandler) {
            prev = (IStackFrame)this.fLastTopFrame.get(thread);
        }
        IStackFrame frame = null;
        try {
            frame = thread.getTopStackFrame();
        }
        catch (DebugException debugException) {}
        node = this.isEqual(frame, prev) ? node.addNode(thread, flags) : node.addNode(thread, flags | 0x400);
        if (frame != null) {
            node.addNode(frame, 0x200800);
        }
        ThreadEventHandler threadEventHandler2 = this;
        synchronized (threadEventHandler2) {
            if (!this.isDisposed()) {
                this.fLastTopFrame.put(thread, frame);
            }
        }
        this.fireDelta(delta);
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof IThread;
    }

    protected synchronized IThread queueSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (!this.isDisposed()) {
            this.fThreadQueue.add(thread);
        }
        return thread;
    }

    protected synchronized IThread removeSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fThreadQueue.remove(thread);
        return thread;
    }

    protected synchronized IThread getNextSuspendedThread() {
        if (!this.fThreadQueue.isEmpty()) {
            return (IThread)this.fThreadQueue.iterator().next();
        }
        return null;
    }
}

