/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.MonitorMemoryBlockDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class AddMemoryBlockAction
extends Action
implements ISelectionListener,
IDebugEventSetListener {
    protected ISelection fCurrentSelection = null;
    protected IMemoryBlock fLastMemoryBlock;
    private boolean fAddDefaultRenderings = true;
    protected IMemoryRenderingSite fSite;
    static /* synthetic */ Class class$0;

    public AddMemoryBlockAction(IMemoryRenderingSite site) {
        this.initialize(site);
    }

    AddMemoryBlockAction(IMemoryRenderingSite site, boolean addDefaultRenderings) {
        this.initialize(site);
        this.fAddDefaultRenderings = addDefaultRenderings;
    }

    private void initialize(IMemoryRenderingSite site) {
        ISelection selection;
        this.fSite = site;
        this.setText(DebugUIMessages.AddMemoryBlockAction_title);
        this.setToolTipText(DebugUIMessages.AddMemoryBlockAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        this.fSite.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fCurrentSelection = selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.updateAction(selection);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public AddMemoryBlockAction(String text, int style, IMemoryRenderingSite site) {
        super(text, style);
        ISelection selection;
        this.fSite = site;
        this.setToolTipText(DebugUIMessages.AddMemoryBlockAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        this.fSite.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fCurrentSelection = selection = this.fSite.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        this.updateAction(selection);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void run() {
        boolean exit = false;
        String prefillExp = null;
        String prefillLength = null;
        while (!exit) {
            String input;
            IMemoryBlockRetrieval standardMemRetrieval;
            exit = true;
            ISelection selection = this.fSite.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (!(elem instanceof IDebugElement)) {
                return;
            }
            IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
            IDebugElement iDebugElement = (IDebugElement)elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((standardMemRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
                standardMemRetrieval = debugTarget;
            }
            if (standardMemRetrieval == null) {
                return;
            }
            Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MonitorMemoryBlockDialog dialog = new MonitorMemoryBlockDialog(shell, standardMemRetrieval, prefillExp, prefillLength);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 1) {
                return;
            }
            prefillExp = input = dialog.getExpression();
            prefillLength = dialog.getLength();
            ArrayList<String> expressions = new ArrayList<String>();
            if (input.length() == 0) {
                expressions.add("");
            } else {
                StringTokenizer tokenizer = new StringTokenizer(input, ",");
                while (tokenizer.hasMoreTokens()) {
                    expressions.add(tokenizer.nextToken());
                }
            }
            String[] expressionsArray = expressions.toArray(new String[expressions.size()]);
            int i = 0;
            while (i < expressionsArray.length) {
                String expression = expressionsArray[i].trim();
                try {
                    if (standardMemRetrieval instanceof IMemoryBlockRetrievalExtension) {
                        IMemoryBlockRetrievalExtension memRetrieval = (IMemoryBlockRetrievalExtension)standardMemRetrieval;
                        IMemoryBlockExtension memBlock = memRetrieval.getExtendedMemoryBlock(expression, elem);
                        if (memBlock != null) {
                            this.fLastMemoryBlock = memBlock;
                            IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                            MemoryView view = this.getMemoryView();
                            if (view != null) {
                                view.registerMemoryBlocks(memArray);
                            }
                            MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                            if (this.fAddDefaultRenderings) {
                                this.addDefaultRenderings((IMemoryBlock)memBlock);
                            }
                        } else {
                            MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                            exit = false;
                        }
                    } else {
                        String hexPrefix;
                        if ((expression = expression.toUpperCase()).startsWith(hexPrefix = "0X")) {
                            expression = expression.substring(hexPrefix.length());
                        }
                        BigInteger address = new BigInteger(expression, 16);
                        long longAddress = address.longValue();
                        String strLength = dialog.getLength();
                        long length = Long.parseLong(strLength);
                        if (length <= 0L) {
                            String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                            MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                            exit = false;
                        } else {
                            IMemoryBlock memBlock = standardMemRetrieval.getMemoryBlock(longAddress, length);
                            if (memBlock instanceof IMemoryBlockExtension) {
                                Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "IMemoryBlockRetrieval returns IMemoryBlockExtension.  This may result in unexpected behavior.", null);
                                DebugUIPlugin.log((IStatus)status);
                            }
                            if (memBlock != null) {
                                this.fLastMemoryBlock = memBlock;
                                IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                                MemoryView view = this.getMemoryView();
                                if (view != null) {
                                    view.registerMemoryBlocks(memArray);
                                }
                                MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                                if (this.fAddDefaultRenderings) {
                                    this.addDefaultRenderings(memBlock);
                                }
                            } else {
                                MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                                exit = false;
                            }
                        }
                    }
                }
                catch (DebugException e1) {
                    MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_failed, (Exception)((Object)e1));
                    exit = false;
                }
                catch (NumberFormatException numberFormatException) {
                    String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                    MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                    exit = false;
                }
                ++i;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateAction(selection);
        this.fCurrentSelection = selection;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    private void handleDebugEvent(DebugEvent event) {
        Object src = event.getSource();
        IDebugTarget srcDT = null;
        IDebugTarget selectionDT = null;
        if (event.getKind() == 8) {
            Object elem;
            if (src instanceof ITerminate && src instanceof IDebugElement) {
                srcDT = ((IDebugElement)src).getDebugTarget();
            }
            if (this.fCurrentSelection instanceof IStructuredSelection && (elem = ((IStructuredSelection)this.fCurrentSelection).getFirstElement()) instanceof IDebugElement) {
                selectionDT = ((IDebugElement)elem).getDebugTarget();
            }
            if (srcDT == selectionDT) {
                this.setEnabled(false);
            }
        }
    }

    public IMemoryBlock getLastMemoryBlock() {
        return this.fLastMemoryBlock;
    }

    protected void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fSite.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock) {
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] renderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        try {
            if (primaryType != null) {
                this.createRenderingInContainer(memoryBlock, primaryType, IDebugUIConstants.ID_RENDERING_VIEW_PANE_1);
            } else if (renderingTypes.length > 0) {
                primaryType = renderingTypes[0];
                this.createRenderingInContainer(memoryBlock, renderingTypes[0], IDebugUIConstants.ID_RENDERING_VIEW_PANE_1);
            }
        }
        catch (CoreException e1) {
            DebugUIPlugin.log(e1);
        }
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                boolean create = true;
                if (primaryType != null && primaryType.getId().equals(renderingTypes[i].getId())) {
                    create = false;
                }
                if (create) {
                    this.createRenderingInContainer(memoryBlock, renderingTypes[i], IDebugUIConstants.ID_RENDERING_VIEW_PANE_2);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void createRenderingInContainer(IMemoryBlock memoryBlock, IMemoryRenderingType primaryType, String paneId) throws CoreException {
        IMemoryRendering rendering = primaryType.createRendering();
        IMemoryRenderingContainer container = this.fSite.getContainer(paneId);
        rendering.init(container, memoryBlock);
        container.addMemoryRendering(rendering);
    }

    protected MemoryView getMemoryView() {
        if (this.fSite instanceof MemoryView) {
            return (MemoryView)this.fSite;
        }
        return null;
    }

    protected void updateAction(ISelection debugContext) {
        this.setEnabled(MemoryViewUtil.isValidSelection(debugContext));
    }
}

