/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewIdRegistry;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewSynchronizationService;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.SwitchMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ToggleMemoryMonitorsAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class MemoryView
extends ViewPart
implements IMemoryRenderingSite {
    protected MemoryViewSelectionProvider fSelectionProvider;
    private MemoryViewPartListener fPartListener;
    private SashForm fSashForm;
    private Hashtable fViewPanes = new Hashtable();
    private Hashtable fViewPaneControls = new Hashtable();
    private ArrayList fVisibleViewPanes = new ArrayList();
    private boolean fVisible;
    private ArrayList fWeights = new ArrayList();
    private static final String VISIBILITY_PREF = "org.eclipse.debug.ui.MemoryView.viewPanesVisibility";
    private static final String ID_MEMORY_VIEW_CONTEXT = "org.eclipse.debug.ui.memoryview";
    private static final String ID_ADD_MEMORY_BLOCK_COMMAND = "org.eclipse.debug.ui.commands.addMemoryMonitor";
    private static final String ID_TOGGLE_MEMORY_MONITORS_PANE_COMMAND = "org.eclipse.debug.ui.commands.toggleMemoryMonitorsPane";
    private static final String ID_NEXT_MEMORY_BLOCK_COMMAND = "org.eclipse.debug.ui.commands.nextMemoryBlock";
    private String[] defaultVisiblePaneIds = new String[]{MemoryBlocksTreeViewPane.PANE_ID, IDebugUIConstants.ID_RENDERING_VIEW_PANE_1};
    private MemoryBlocksTreeViewPane fMemBlkViewer;
    private MemoryViewSynchronizationService fSyncService;
    private boolean fPinMBDisplay = true;
    private static int fViewCnt = 0;
    private IContextActivation fContext;
    private Set fRegisteredMemoryBlocks = new HashSet();
    private AbstractHandler fAddHandler;
    private AbstractHandler fToggleMonitorsHandler;
    private AbstractHandler fNextMemoryBlockHandler;
    private IMemoryBlockListener fMemoryBlockListener = new IMemoryBlockListener(){

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            MemoryView.this.unRegisterMemoryBlocks(memory);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ++fViewCnt;
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            MemoryViewIdRegistry.registerView(secondaryId);
        }
        if (fViewCnt == 1 && DebugUIPlugin.getActiveWorkbenchWindow() != null && DebugUIPlugin.getActiveWorkbenchWindow().getActivePage() != null) {
            IViewReference[] references = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int i = 0;
            while (i < references.length) {
                if (references[i].getSecondaryId() != null) {
                    MemoryViewIdRegistry.registerView(references[i].getSecondaryId());
                }
                ++i;
            }
        }
        this.fSyncService = new MemoryViewSynchronizationService();
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryView_context");
        this.fSashForm = new SashForm(parent, 256);
        this.fSelectionProvider = new MemoryViewSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.createMemoryBlocksTreeViewPane((Composite)this.fSashForm);
        this.createRenderingViewPane(IDebugUIConstants.ID_RENDERING_VIEW_PANE_1);
        this.createRenderingViewPane(IDebugUIConstants.ID_RENDERING_VIEW_PANE_2);
        this.setVisible(true);
        Integer[] weights = this.fWeights.toArray(new Integer[this.fWeights.size()]);
        int[] intWeights = new int[weights.length];
        int i = 0;
        while (i < weights.length) {
            intWeights[i] = weights[i];
            ++i;
        }
        this.fSashForm.setWeights(intWeights);
        this.loadViewPanesVisibility();
        this.fPartListener = new MemoryViewPartListener(this);
        this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener(this.fMemoryBlockListener);
        this.restoreView();
    }

    public void activated() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandSupport = (ICommandService)workbench.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextSupport = (IContextService)workbench.getAdapter((Class)clazz2);
        if (commandSupport != null && contextSupport != null) {
            this.fContext = contextSupport.activateContext(ID_MEMORY_VIEW_CONTEXT);
            Command addCommand = commandSupport.getCommand(ID_ADD_MEMORY_BLOCK_COMMAND);
            if (this.fAddHandler == null) {
                this.fAddHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        IAdaptable context = DebugUITools.getDebugContext();
                        if (context != null && MemoryViewUtil.isValidSelection((ISelection)new StructuredSelection((Object)context))) {
                            RetargetAddMemoryBlockAction action = new RetargetAddMemoryBlockAction(MemoryView.this);
                            action.run();
                            action.dispose();
                        }
                        return null;
                    }
                };
            }
            addCommand.setHandler((IHandler)this.fAddHandler);
            Command toggleCommand = commandSupport.getCommand(ID_TOGGLE_MEMORY_MONITORS_PANE_COMMAND);
            if (this.fToggleMonitorsHandler == null) {
                this.fToggleMonitorsHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        ToggleMemoryMonitorsAction action = new ToggleMemoryMonitorsAction();
                        action.init((IViewPart)MemoryView.this);
                        action.run();
                        action.dispose();
                        return null;
                    }
                };
            }
            toggleCommand.setHandler((IHandler)this.fToggleMonitorsHandler);
            Command nextMemoryBlockCommand = commandSupport.getCommand(ID_NEXT_MEMORY_BLOCK_COMMAND);
            if (nextMemoryBlockCommand != null) {
                this.fNextMemoryBlockHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        SwitchMemoryBlockAction action = new SwitchMemoryBlockAction();
                        action.init((IViewPart)MemoryView.this);
                        action.run();
                        action.dispose();
                        return null;
                    }
                };
                nextMemoryBlockCommand.setHandler((IHandler)this.fNextMemoryBlockHandler);
            }
        }
    }

    public void deactivated() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandSupport = (ICommandService)workbench.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextSupport = (IContextService)workbench.getAdapter((Class)clazz2);
        if (commandSupport != null && contextSupport != null) {
            Command command = commandSupport.getCommand(ID_ADD_MEMORY_BLOCK_COMMAND);
            command.setHandler(null);
            Command toggleCommand = commandSupport.getCommand(ID_TOGGLE_MEMORY_MONITORS_PANE_COMMAND);
            toggleCommand.setHandler(null);
            if (this.fContext != null) {
                contextSupport.deactivateContext(this.fContext);
            }
        }
    }

    private void createMemoryBlocksTreeViewPane(Composite parent) {
        this.fMemBlkViewer = new MemoryBlocksTreeViewPane((IViewPart)this);
        this.fViewPanes.put(MemoryBlocksTreeViewPane.PANE_ID, this.fMemBlkViewer);
        ViewForm viewerViewForm = new ViewForm(parent, 0x800000);
        this.fViewPaneControls.put(MemoryBlocksTreeViewPane.PANE_ID, viewerViewForm);
        this.fWeights.add(new Integer(15));
        this.fMemBlkViewer.addSelectionListener(this.fSelectionProvider);
        Control viewerControl = this.fMemBlkViewer.createViewPane((Composite)viewerViewForm, MemoryBlocksTreeViewPane.PANE_ID, DebugUIMessages.MemoryView_Memory_monitors);
        viewerViewForm.setContent(viewerControl);
        ISelection selection = this.fMemBlkViewer.getSelectionProvider().getSelection();
        if (selection != null) {
            this.fSelectionProvider.setSelection(selection);
        }
        ToolBarManager viewerToolBarMgr = new ToolBarManager(0x800000);
        IAction[] actions = this.fMemBlkViewer.getActions();
        int i = 0;
        while (i < actions.length) {
            viewerToolBarMgr.add(actions[i]);
            ++i;
        }
        ToolBar viewerToolbar = viewerToolBarMgr.createControl((Composite)viewerViewForm);
        viewerViewForm.setTopRight((Control)viewerToolbar);
        Label viewerLabel = new Label((Composite)viewerViewForm, 64);
        viewerLabel.setText(DebugUIMessages.MemoryView_Memory_monitors);
        viewerViewForm.setTopLeft((Control)viewerLabel);
    }

    public void createRenderingViewPane(String paneId) {
        RenderingViewPane renderingPane = new RenderingViewPane((IViewPart)this);
        this.fViewPanes.put(paneId, renderingPane);
        ViewForm renderingViewForm = new ViewForm((Composite)this.fSashForm, 0x800000);
        this.fViewPaneControls.put(paneId, renderingViewForm);
        this.fWeights.add(new Integer(40));
        Control renderingControl = renderingPane.createViewPane((Composite)renderingViewForm, paneId, DebugUIMessages.MemoryView_Memory_renderings);
        renderingViewForm.setContent(renderingControl);
        renderingPane.addSelectionListener(this.fSelectionProvider);
        ToolBarManager renderingViewMgr = new ToolBarManager(0x800000);
        IAction[] renderingActions = renderingPane.getActions();
        int i = 0;
        while (i < renderingActions.length) {
            renderingViewMgr.add(renderingActions[i]);
            ++i;
        }
        ToolBar renderingToolbar = renderingViewMgr.createControl((Composite)renderingViewForm);
        renderingViewForm.setTopRight((Control)renderingToolbar);
        Label renderingLabel = new Label((Composite)renderingViewForm, 0);
        renderingLabel.setText(renderingPane.getLabel());
        renderingViewForm.setTopLeft((Control)renderingLabel);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener(this.fMemoryBlockListener);
        Enumeration enumeration = this.fViewPanes.elements();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof IMemoryViewPane)) continue;
            ((IMemoryViewPane)element).dispose();
        }
        this.fViewPaneControls.clear();
        IViewSite viewSite = this.getViewSite();
        String secondaryId = viewSite.getSecondaryId();
        if (secondaryId != null) {
            MemoryViewIdRegistry.deregisterView(secondaryId);
        }
        this.fSyncService.shutdown();
        this.fRegisteredMemoryBlocks.clear();
        if (this.fAddHandler != null) {
            this.fAddHandler.dispose();
        }
        if (this.fToggleMonitorsHandler != null) {
            this.fToggleMonitorsHandler.dispose();
        }
        if (this.fNextMemoryBlockHandler != null) {
            this.fNextMemoryBlockHandler.dispose();
        }
        super.dispose();
    }

    private void setVisible(boolean visible) {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            if (this.fVisible) {
                viewPanes[i].setVisible(visible && viewPanes[i].isVisible());
            } else if (this.isViewPaneVisible(viewPanes[i].getId())) {
                viewPanes[i].setVisible(visible);
            }
            ++i;
        }
        this.fVisible = visible;
    }

    public IMemoryViewPane getViewPane(String paneId) {
        return (IMemoryViewPane)this.fViewPanes.get(paneId);
    }

    public IMemoryViewPane[] getViewPanes() {
        IMemoryViewPane[] viewPanes = new IMemoryViewPane[this.fViewPanes.size()];
        Enumeration enumeration = this.fViewPanes.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            viewPanes[i] = (IMemoryViewPane)enumeration.nextElement();
            ++i;
        }
        return viewPanes;
    }

    private void restoreView() {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            viewPanes[i].restoreViewPane();
            ++i;
        }
    }

    public void showViewPane(boolean show, String paneId) {
        Control viewPaneControl = (Control)this.fViewPaneControls.get(paneId);
        if (viewPaneControl != null) {
            Control[] children = this.fSashForm.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == viewPaneControl) {
                    children[i].setVisible(show);
                    IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
                    if (viewPane != null) {
                        viewPane.setVisible(show);
                    }
                }
                ++i;
            }
            this.fSashForm.layout();
        }
        this.storeViewPaneVisibility();
    }

    public boolean isViewPaneVisible(String paneId) {
        return this.fVisibleViewPanes.contains(paneId);
    }

    private void storeViewPaneVisibility() {
        this.fVisibleViewPanes.clear();
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        StringBuffer visibleViewPanes = new StringBuffer();
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            String paneId = (String)enumeration.nextElement();
            Control control = (Control)this.fViewPaneControls.get(paneId);
            if (!control.isVisible()) continue;
            visibleViewPanes.append(paneId);
            visibleViewPanes.append(",");
            this.fVisibleViewPanes.add(paneId);
        }
        prefs.setValue(this.getVisibilityPrefId(), visibleViewPanes.toString());
    }

    private void loadViewPanesVisibility() {
        String paneId;
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        String visiblePanes = prefs.getString(this.getVisibilityPrefId());
        if (visiblePanes != null && visiblePanes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(visiblePanes, ",");
            while (tokenizer.hasMoreTokens()) {
                paneId = tokenizer.nextToken();
                this.fVisibleViewPanes.add(paneId);
            }
        } else {
            int i = 0;
            while (i < this.defaultVisiblePaneIds.length) {
                this.fVisibleViewPanes.add(this.defaultVisiblePaneIds[i]);
                ++i;
            }
        }
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            paneId = (String)enumeration.nextElement();
            boolean visible = false;
            if (this.fVisibleViewPanes.contains(paneId)) {
                visible = true;
            }
            Control control = (Control)this.fViewPaneControls.get(paneId);
            control.setVisible(visible);
            IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
            viewPane.setVisible(visible);
        }
        this.fSashForm.layout();
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return this.fSyncService;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        Enumeration enumeration = this.fViewPanes.elements();
        ArrayList containers = new ArrayList();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof IMemoryRenderingContainer)) continue;
            containers.add(obj);
        }
        return containers.toArray(new IMemoryRenderingContainer[containers.size()]);
    }

    public IMemoryRenderingContainer getContainer(String id) {
        Object viewPane = this.fViewPanes.get(id);
        if (viewPane instanceof IMemoryRenderingContainer) {
            return (IMemoryRenderingContainer)viewPane;
        }
        return null;
    }

    public boolean isPinMBDisplay() {
        return this.fPinMBDisplay;
    }

    public void setPinMBDisplay(boolean pinMBDisplay) {
        this.fPinMBDisplay = pinMBDisplay;
    }

    private String getVisibilityPrefId() {
        IViewSite vs = this.getViewSite();
        String viewId = vs.getSecondaryId();
        if (viewId != null) {
            return "org.eclipse.debug.ui.MemoryView.viewPanesVisibility." + viewId;
        }
        return VISIBILITY_PREF;
    }

    public void registerMemoryBlocks(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            this.fRegisteredMemoryBlocks.add(memoryBlocks[i]);
            ++i;
        }
    }

    public void unRegisterMemoryBlocks(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            this.fRegisteredMemoryBlocks.remove(memoryBlocks[i]);
            ++i;
        }
    }

    public boolean isMemoryBlockRegistered(IMemoryBlock memoryBlock) {
        return this.fRegisteredMemoryBlocks.contains(memoryBlock);
    }

    class MemoryViewSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        ArrayList fListeners = new ArrayList();
        IStructuredSelection fSelections = new StructuredSelection();

        MemoryViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return this.fSelections;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListeners.contains(listener)) {
                this.fListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                boolean fireChanged = false;
                if (this.fSelections.getFirstElement() != ((IStructuredSelection)selection).getFirstElement()) {
                    fireChanged = true;
                }
                this.fSelections = (IStructuredSelection)selection;
                if (fireChanged) {
                    this.fireChanged();
                }
            }
        }

        public void fireChanged() {
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < this.fListeners.size()) {
                ((ISelectionChangedListener)this.fListeners.get(i)).selectionChanged(evt);
                ++i;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection viewPaneSelection = event.getSelection();
            if (viewPaneSelection instanceof IStructuredSelection) {
                Object selected = ((IStructuredSelection)viewPaneSelection).getFirstElement();
                if (selected != null) {
                    StructuredSelection strucSelection = new StructuredSelection(new Object[]{selected});
                    this.setSelection((ISelection)strucSelection);
                } else {
                    this.setSelection(viewPaneSelection);
                }
            }
        }
    }

    class MemoryViewPartListener
    implements IPartListener2 {
        IMemoryRenderingSite fView = null;

        public MemoryViewPartListener(IMemoryRenderingSite view) {
            this.fView = view;
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (ref.getPart(false) == this.fView) {
                MemoryView.this.activated();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
            if (ref.getPart(false) == this.fView) {
                MemoryView.this.deactivated();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(false);
            }
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(true);
                MemoryView.this.restoreView();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    }
}

