/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewerContentManager;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DefaultTableUpdatePolicy;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentInput;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingPresentationContext;

class AsyncTableRenderingUpdatePolicy
extends DefaultTableUpdatePolicy {
    static /* synthetic */ Class class$0;

    AsyncTableRenderingUpdatePolicy() {
    }

    public void modelChanged(IModelDelta node) {
        AsynchronousTableViewerContentManager contentManager = this.getTableViewer().getContentManager();
        IContentChangeComputer computer = null;
        if (contentManager instanceof IContentChangeComputer) {
            computer = (IContentChangeComputer)((Object)contentManager);
        }
        if (this.shouldClearCache(node)) {
            this.clearCache(computer);
        }
        if (!this.shouldHandleChange(node)) {
            return;
        }
        if (node.getElement() instanceof IMemoryBlock && (node.getFlags() & 0x400) != 0) {
            if (computer != null && this.getTableViewer() != null && !this.getTableViewer().getRendering().isDisplayingError()) {
                computer.cache(this.getTableViewer().getContentManager().getElements());
            }
            if (node.getElement() instanceof IMemoryBlock && this.handleMemoryBlockChanged((IMemoryBlock)node.getElement(), node)) {
                this.notifyRendering(node);
            }
        }
        super.modelChanged(node);
    }

    protected void clearCache(IContentChangeComputer computer) {
        if (computer != null) {
            computer.clearCache();
        }
    }

    private void notifyRendering(IModelDelta node) {
        if (this.getTableViewer() != null) {
            IModelChangedListener listener;
            AbstractAsyncTableRendering abstractAsyncTableRendering = this.getTableViewer().getRendering();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IModelChangedListener)abstractAsyncTableRendering.getAdapter(clazz)) != null) {
                listener.modelChanged(node);
            }
        }
    }

    protected boolean handleMemoryBlockChanged(IMemoryBlock mb, IModelDelta delta) {
        try {
            if (this.getViewer().getPresentationContext() instanceof TableRenderingPresentationContext) {
                TableRenderingContentInput input = ((TableRenderingPresentationContext)this.getViewer().getPresentationContext()).getInput();
                BigInteger address = this.getMemoryBlockBaseAddress(mb);
                if (!address.equals(input.getContentBaseAddress())) {
                    input.setLoadAddress(address);
                    input.updateContentBaseAddress();
                    this.getTableViewer().setTopIndex(address);
                    this.getTableViewer().setSelection(address);
                }
                return true;
            }
        }
        catch (DebugException e) {
            if (this.getTableViewer() != null) {
                this.getTableViewer().handlePresentationFailure(null, e.getStatus());
            }
            return false;
        }
        return true;
    }

    private BigInteger getMemoryBlockBaseAddress(IMemoryBlock mb) throws DebugException {
        if (mb instanceof IMemoryBlockExtension) {
            return ((IMemoryBlockExtension)mb).getBigBaseAddress();
        }
        return BigInteger.valueOf(mb.getStartAddress());
    }

    private AsyncTableRenderingViewer getTableViewer() {
        if (this.getViewer() instanceof AsyncTableRenderingViewer) {
            return (AsyncTableRenderingViewer)this.getViewer();
        }
        return null;
    }

    protected boolean shouldHandleChange(IModelDelta delta) {
        AbstractAsyncTableRendering rendering;
        TableRenderingPresentationContext context;
        return !(this.getViewer().getPresentationContext() instanceof TableRenderingPresentationContext) || !((context = (TableRenderingPresentationContext)this.getViewer().getPresentationContext()).getRendering() instanceof AbstractAsyncTableRendering) || (rendering = (AbstractAsyncTableRendering)context.getRendering()).isVisible();
    }

    protected boolean shouldClearCache(IModelDelta delta) {
        return true;
    }
}

