/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewerContentManager;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.views.memory.renderings.IPresentationErrorListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentManager;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class AsyncVirtualContentTableViewer
extends AsynchronousTableViewer {
    private Object fPendingTopIndexKey;
    private ArrayList fTopIndexQueue = new ArrayList();
    private boolean fPendingResizeColumns;
    private ListenerList fVirtualContentListeners = new ListenerList();
    private SelectionListener fScrollSelectionListener;
    private ListenerList fPresentationErrorListeners = new ListenerList();
    private Object fTopIndexKey;
    private IVirtualContentManager fVirtualContentManager;
    public static boolean DEBUG_DYNAMIC_LOADING;

    public AsyncVirtualContentTableViewer(Composite parent, int style) {
        super(parent, style);
        this.initScrollBarListener();
    }

    private void initScrollBarListener() {
        ScrollBar scroll = this.getTable().getVerticalBar();
        this.fScrollSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AsyncVirtualContentTableViewer.this.handleScrollBarSelection();
            }
        };
        scroll.addSelectionListener(this.fScrollSelectionListener);
    }

    public void setLabels(Widget widget, String[] labels, ImageDescriptor[] imageDescriptors) {
        super.setLabels(widget, labels, imageDescriptors);
        this.fPendingResizeColumns = this.attemptResizeColumnsToPreferredSize();
    }

    public void setTopIndex(Object key) {
        this.fPendingTopIndexKey = key;
        this.attemptSetTopIndex();
    }

    protected Object getPendingSetTopIndexKey() {
        return this.fPendingTopIndexKey;
    }

    protected void handlePresentationFailure(IAsynchronousRequestMonitor monitor, IStatus status) {
        this.notifyPresentationError(monitor, status);
    }

    public void disposeColumns() {
        TableColumn[] oldColumns = this.getTable().getColumns();
        int i = 0;
        while (i < oldColumns.length) {
            oldColumns[i].dispose();
            ++i;
        }
    }

    public void disposeCellEditors() {
        CellEditor[] oldCellEditors = this.getCellEditors();
        if (oldCellEditors != null) {
            int i = 0;
            while (i < oldCellEditors.length) {
                oldCellEditors[i].dispose();
                ++i;
            }
        }
    }

    public void resizeColumnsToPreferredSize() {
        this.fPendingResizeColumns = true;
        this.fPendingResizeColumns = this.attemptResizeColumnsToPreferredSize();
    }

    private boolean attemptResizeColumnsToPreferredSize() {
        if (this.fPendingResizeColumns && !this.hasPendingUpdates()) {
            Table table = this.getTable();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length - 1) {
                columns[i].pack();
                ++i;
            }
            return false;
        }
        return this.fPendingResizeColumns;
    }

    protected IVirtualContentManager getVirtualContentManager() {
        if (this.fVirtualContentManager == null && this.getContentManager() instanceof IVirtualContentManager) {
            this.fVirtualContentManager = (IVirtualContentManager)((Object)this.getContentManager());
        }
        return this.fVirtualContentManager;
    }

    protected synchronized void attemptSetTopIndex() {
        Object remaining;
        if (this.fPendingTopIndexKey != null && (remaining = this.doAttemptSetTopIndex(this.fPendingTopIndexKey)) == null) {
            this.fPendingTopIndexKey = remaining;
        }
    }

    private synchronized Object doAttemptSetTopIndex(final Object topIndexKey) {
        int i = this.getVirtualContentManager().indexOf(topIndexKey);
        if (i >= 0) {
            UIJob job = new UIJob("set top index"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (AsyncVirtualContentTableViewer.this.getTable().isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    AsyncVirtualContentTableViewer.this.removeKeyFromQueue(topIndexKey);
                    int idx = AsyncVirtualContentTableViewer.this.getVirtualContentManager().indexOf(topIndexKey);
                    if (idx > 0) {
                        if (DEBUG_DYNAMIC_LOADING) {
                            System.out.println("actual set top index: " + ((BigInteger)topIndexKey).toString(16));
                        }
                        AsyncVirtualContentTableViewer.this.setTopIndexKey(topIndexKey);
                        AsyncVirtualContentTableViewer.this.getTable().setTopIndex(idx);
                    } else {
                        if (DEBUG_DYNAMIC_LOADING) {
                            System.out.println("cannot find key, put it back to the queue: " + topIndexKey);
                        }
                        AsyncVirtualContentTableViewer.this.fPendingTopIndexKey = topIndexKey;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.addKeyToQueue(topIndexKey);
            job.setSystem(true);
            job.schedule();
            return null;
        }
        return topIndexKey;
    }

    protected void setChildren(final Widget widget, final List children) {
        this.preservingSelection(new Runnable(){

            public void run() {
                if (DEBUG_DYNAMIC_LOADING) {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " Set children");
                }
                AsyncVirtualContentTableViewer.super.setChildren(widget, children);
            }
        });
        if (widget == this.getTable()) {
            this.attemptSetTopIndex();
        }
    }

    public void addVirtualContentListener(IVirtualContentListener listener) {
        this.fVirtualContentListeners.add((Object)listener);
    }

    public void removeVirtualContentListener(IVirtualContentListener listener) {
        this.fVirtualContentListeners.remove((Object)listener);
    }

    protected void notifyListenersAtBufferStart() {
        int topIdx = this.getTable().getTopIndex();
        Object[] listeners = this.fVirtualContentListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IVirtualContentListener listener = (IVirtualContentListener)listeners[i];
            if (topIdx <= listener.getThreshold()) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.handledAtBufferStart();
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
            ++i;
        }
    }

    protected void notifyListenersAtBufferEnd() {
        Object[] listeners = this.fVirtualContentListeners.getListeners();
        int topIdx = this.getTable().getTopIndex();
        int bottomIdx = topIdx + this.getContentManager().getVisibleItemCount(topIdx);
        int elementsCnt = this.getContentManager().getElements().length;
        int numLinesLeft = elementsCnt - bottomIdx;
        int i = 0;
        while (i < listeners.length) {
            final IVirtualContentListener listener = (IVirtualContentListener)listeners[i];
            if (numLinesLeft <= listener.getThreshold()) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.handleAtBufferEnd();
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
            ++i;
        }
    }

    protected void handleScrollBarSelection() {
        if (!this.fTopIndexQueue.isEmpty()) {
            return;
        }
        this.topIndexChanged();
    }

    public void topIndexChanged() {
        MemorySegment a = (MemorySegment)((Object)this.getTable().getItem(this.getTable().getTopIndex()).getData());
        this.setTopIndexKey(this.getVirtualContentManager().getKey(this.getTable().getTopIndex()));
        if (DEBUG_DYNAMIC_LOADING) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " handle scroll bar moved:  top index: " + a.getAddress().toString(16));
        }
        this.notifyListenersAtBufferStart();
        this.notifyListenersAtBufferEnd();
    }

    protected void setTopIndexKey(Object key) {
        this.fTopIndexKey = key;
    }

    protected Object getTopIndexKey() {
        return this.fTopIndexKey;
    }

    /*
     * Exception decompiling
     */
    protected synchronized void preservingSelection(Runnable updateCode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 43->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addPresentationErrorListener(IPresentationErrorListener errorListener) {
        this.fPresentationErrorListeners.add((Object)errorListener);
    }

    public void removePresentationErrorListener(IPresentationErrorListener errorListener) {
        this.fPresentationErrorListeners.remove((Object)errorListener);
    }

    private void notifyPresentationError(final IAsynchronousRequestMonitor monitor, final IStatus status) {
        Object[] listeners = this.fPresentationErrorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IPresentationErrorListener) {
                final IPresentationErrorListener listener = (IPresentationErrorListener)listeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.handlePresentationFailure(monitor, status);
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
            ++i;
        }
    }

    protected AsynchronousTableViewerContentManager createContentManager() {
        return super.createContentManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyToQueue(Object topIndexKey) {
        ArrayList arrayList = this.fTopIndexQueue;
        synchronized (arrayList) {
            if (DEBUG_DYNAMIC_LOADING) {
                System.out.println(" >>> add to queue: " + ((BigInteger)topIndexKey).toString(16));
            }
            this.fTopIndexQueue.add(topIndexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeyFromQueue(Object topIndexKey) {
        ArrayList arrayList = this.fTopIndexQueue;
        synchronized (arrayList) {
            if (DEBUG_DYNAMIC_LOADING) {
                System.out.println(" >>> remove frome queue: " + ((BigInteger)topIndexKey).toString(16));
            }
            this.fTopIndexQueue.remove(topIndexKey);
        }
    }
}

