/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public abstract class DebugPopup
extends PopupDialog {
    private Point fAnchor;
    private IHandlerActivation fActivation;
    private IHandlerService fHandlerService;
    private String fCommandId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DebugPopup(Shell parent, Point anchor, String commandId) {
        super(parent, 16, true, true, false, true, null, null);
        this.fAnchor = anchor;
        this.fCommandId = commandId;
    }

    protected String getInfoText() {
        if (this.getCommandId() != null && this.getActionText() != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBindingService bindingService = (IBindingService)workbench.getAdapter((Class)clazz);
            TriggerSequence[] bindings = bindingService.getActiveBindingsFor(this.getCommandId());
            String infoText = null;
            if (bindings.length > 0) {
                infoText = MessageFormat.format(DebugUIViewsMessages.InspectPopupDialog_1, bindings[0].format(), this.getActionText());
            }
            return infoText;
        }
        return null;
    }

    protected String getActionText() {
        return null;
    }

    protected String getCommandId() {
        return this.fCommandId;
    }

    protected void persist() {
    }

    protected abstract Control createDialogArea(Composite var1);

    protected Point getInitialLocation(Point initialSize) {
        Point point = this.fAnchor;
        Rectangle monitor = this.getShell().getMonitor().getClientArea();
        if (monitor.width < point.x + initialSize.x) {
            point.x = Math.max(0, point.x - initialSize.x);
        }
        if (monitor.height < point.y + initialSize.y) {
            point.y = Math.max(0, point.y - initialSize.y);
        }
        return point;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        return settings;
    }

    public int open() {
        String infoText;
        IWorkbench workbench = PlatformUI.getWorkbench();
        String commandId = this.getCommandId();
        if (commandId != null) {
            AbstractHandler fCloseHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    DebugPopup.this.persist();
                    DebugPopup.this.close();
                    return null;
                }
            };
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fHandlerService = (IHandlerService)workbench.getAdapter((Class)clazz);
            this.fActivation = this.fHandlerService.activateHandler(commandId, (IHandler)fCloseHandler);
        }
        if ((infoText = this.getInfoText()) != null) {
            this.setInfoText(infoText);
        }
        return super.open();
    }

    public boolean close() {
        if (this.fActivation != null) {
            this.fHandlerService.deactivateHandler(this.fActivation);
        }
        return super.close();
    }
}

