/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.Collection;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class CountExpression
extends Expression {
    private static final int ANY_NUMBER = 5;
    private static final int EXACT = 4;
    private static final int ONE_OR_MORE = 3;
    private static final int NONE_OR_ONE = 2;
    private static final int NONE = 1;
    private static final int UNKNOWN = 0;
    private int fMode;
    private int fSize;

    public CountExpression(IConfigurationElement configElement) {
        String size = configElement.getAttribute("value");
        this.initializeSize(size);
    }

    public CountExpression(String size) {
        this.initializeSize(size);
    }

    private void initializeSize(String size) {
        if (size == null) {
            size = "*";
        }
        if (size.equals("*")) {
            this.fMode = 5;
        } else if (size.equals("?")) {
            this.fMode = 2;
        } else if (size.equals("!")) {
            this.fMode = 1;
        } else if (size.equals("+")) {
            this.fMode = 3;
        } else {
            try {
                this.fSize = Integer.parseInt(size);
                this.fMode = 4;
            }
            catch (NumberFormatException numberFormatException) {
                this.fMode = 0;
            }
        }
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object var = context.getDefaultVariable();
        Expressions.checkCollection(var, this);
        Collection collection = (Collection)var;
        int size = collection.size();
        switch (this.fMode) {
            case 0: {
                return EvaluationResult.FALSE;
            }
            case 1: {
                return EvaluationResult.valueOf(size == 0);
            }
            case 2: {
                return EvaluationResult.valueOf(size == 0 || size == 1);
            }
            case 3: {
                return EvaluationResult.valueOf(size >= 1);
            }
            case 4: {
                return EvaluationResult.valueOf(this.fSize == size);
            }
            case 5: {
                return EvaluationResult.TRUE;
            }
        }
        return EvaluationResult.FALSE;
    }

    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }
}

