/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class InstanceofExpression
extends Expression {
    private String fTypeName;

    public InstanceofExpression(IConfigurationElement element) throws CoreException {
        this.fTypeName = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fTypeName);
    }

    public InstanceofExpression(String typeName) {
        Assert.isNotNull(typeName);
        this.fTypeName = typeName;
    }

    public EvaluationResult evaluate(IEvaluationContext context) {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(Expressions.isInstanceOf(element, this.fTypeName));
    }

    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    public String toString() {
        return "<instanceof value=\"" + this.fTypeName + "\"/>";
    }
}

