/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTConverter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.NodeSearcher;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.jdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.jdt.internal.core.util.Util;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private boolean statementsRecovery;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ICompilationUnit compilationUnitSource = null;
    private IClassFile classFileSource = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.classFileSource = null;
        this.compilationUnitSource = null;
        this.resolveBindings = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        this.compilerOptions = JavaCore.getOptions();
    }

    public void setCompilerOptions(Map options) {
        if (options == null) {
            this.compilerOptions = JavaCore.getOptions();
        }
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean bindings) {
        this.resolveBindings = bindings;
    }

    public void setFocalPosition(int position) {
        this.partial = true;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.compilationUnitSource = null;
        this.classFileSource = null;
    }

    public void setSource(ICompilationUnit source) {
        this.compilationUnitSource = source;
        this.rawSource = null;
        this.classFileSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            this.compilerOptions = this.project.getOptions(true);
        }
    }

    public void setSource(IClassFile source) {
        this.classFileSource = source;
        this.rawSource = null;
        this.compilationUnitSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            this.compilerOptions = this.project.getOptions(true);
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setStatementsRecovery(boolean enabled) {
        this.statementsRecovery = enabled;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaProject project) {
        this.project = project;
        if (project != null) {
            this.compilerOptions = project.getOptions(true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASTNode createAST(IProgressMonitor monitor) {
        ASTNode result = null;
        try {
            if (this.rawSource == null && this.compilationUnitSource == null && this.classFileSource == null) {
                throw new IllegalStateException("source not specified");
            }
            result = this.internalCreateAST(monitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.initializeDefaults();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.initializeDefaults();
            return result;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createASTs(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                CompilationUnitResolver.resolve(compilationUnits, bindingKeys, requestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, this.statementsRecovery, monitor);
            } else {
                CompilationUnitResolver.parse(compilationUnits, requestor, this.apiLevel, this.compilerOptions, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.initializeDefaults();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.initializeDefaults();
            return;
        }
    }

    public IBinding[] createBindings(IJavaElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            IBinding[] iBindingArray = CompilationUnitResolver.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, this.statementsRecovery, monitor);
            Object var3_4 = null;
            this.initializeDefaults();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.initializeDefaults();
            throw throwable;
        }
    }

    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        boolean needToResolveBindings = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    NodeSearcher searcher = null;
                    org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = null;
                    ISourceReference element = null;
                    if (this.compilationUnitSource != null) {
                        sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)this.compilationUnitSource);
                        sourceUnit = new BasicCompilationUnit(sourceUnit.getContents(), sourceUnit.getPackageName(), new String(sourceUnit.getFileName()), this.project);
                        element = this.compilationUnitSource;
                    } else if (this.classFileSource != null) {
                        try {
                            String sourceString = this.classFileSource.getSource();
                            if (sourceString == null) {
                                throw new IllegalStateException();
                            }
                            PackageFragment packageFragment = (PackageFragment)this.classFileSource.getParent();
                            BinaryType type = (BinaryType)this.classFileSource.getType();
                            IBinaryType binaryType = (IBinaryType)type.getElementInfo();
                            char[] fileName = binaryType.getFileName();
                            int firstDollar = CharOperation.indexOf('$', fileName);
                            if (firstDollar != -1) {
                                char[] suffix = SuffixConstants.SUFFIX_class;
                                int suffixLength = suffix.length;
                                char[] newFileName = new char[firstDollar + suffixLength];
                                System.arraycopy(fileName, 0, newFileName, 0, firstDollar);
                                System.arraycopy(suffix, 0, newFileName, firstDollar, suffixLength);
                                fileName = newFileName;
                            }
                            sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), new String(fileName), this.project);
                            element = this.classFileSource;
                        }
                        catch (JavaModelException javaModelException) {
                            throw new IllegalStateException();
                        }
                    } else if (this.rawSource != null) {
                        needToResolveBindings = this.resolveBindings && this.unitName != null && this.project != null && this.compilerOptions != null;
                        sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    } else {
                        throw new IllegalStateException();
                    }
                    if (this.partial) {
                        searcher = new NodeSearcher(this.focalPointPosition);
                    }
                    if (needToResolveBindings) {
                        try {
                            compilationUnitDeclaration = CompilationUnitResolver.resolve(sourceUnit, this.project, searcher, this.compilerOptions, this.workingCopyOwner, this.statementsRecovery, monitor);
                        }
                        catch (JavaModelException javaModelException) {
                            compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, this.statementsRecovery);
                            needToResolveBindings = false;
                        }
                    } else {
                        compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, this.statementsRecovery);
                        needToResolveBindings = false;
                    }
                    CompilationUnit result = CompilationUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), this.apiLevel, this.compilerOptions, needToResolveBindings, this.compilationUnitSource == null ? this.workingCopyOwner : this.compilationUnitSource.getOwner(), needToResolveBindings ? new DefaultBindingResolver.BindingTables() : null, monitor);
                    result.setJavaElement((IJavaElement)((Object)element));
                    CompilationUnit compilationUnit = result;
                    Object var16_17 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                    }
                    return compilationUnit;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                    }
                    throw throwable;
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter converter = new ASTConverter(this.compilerOptions, false, null);
        converter.compilationUnitSource = this.rawSource;
        converter.compilationUnitSourceLength = this.rawSource.length;
        converter.scanner.setSource(this.rawSource);
        AST ast = AST.newAST(this.apiLevel);
        ast.setDefaultNodeFlag(2);
        ast.setBindingResolver(new BindingResolver());
        converter.setAST(ast);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        CompilationUnit compilationUnit = ast.newCompilationUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, true);
                RecoveryScannerData data = constructorDeclaration.compilationResult.recoveryScannerData;
                if (data != null) {
                    Scanner scanner = converter.scanner;
                    converter.docParser.scanner = converter.scanner = new RecoveryScanner(scanner, data.removeUnused());
                    converter.scanner.setSource(scanner.source);
                }
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (constructorDeclaration != null) {
                    Block block = ast.newBlock();
                    Statement[] statements = constructorDeclaration.statements;
                    if (statements != null) {
                        int statementsLength = statements.length;
                        int i = 0;
                        while (i < statementsLength) {
                            if (statements[i] instanceof LocalDeclaration) {
                                converter.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                            } else {
                                block.statements().add(converter.convert(statements[i]));
                            }
                            ++i;
                        }
                    }
                    this.rootNodeToCompilationUnit(ast, compilationUnit, block, recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return block;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 1: {
                org.eclipse.jdt.internal.compiler.ast.Expression expression = codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = converter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return expression2;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 4: {
                org.eclipse.jdt.internal.compiler.ast.ASTNode[] nodes = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (nodes != null) {
                    TypeDeclaration typeDeclaration = converter.convert(nodes);
                    this.rootNodeToCompilationUnit(typeDeclaration.getAST(), compilationUnit, typeDeclaration, codeSnippetParsingUtil.recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return typeDeclaration;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode astNode, IProblem[] problems) {
        ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator(problems);
        astNode.accept(syntaxErrorPropagator);
        ASTRecoveryPropagator recoveryPropagator = new ASTRecoveryPropagator(problems);
        astNode.accept(recoveryPropagator);
    }

    private void rootNodeToCompilationUnit(AST ast, CompilationUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = block.statements().size();
                    while (i < max) {
                        this.propagateErrors((ASTNode)block.statements().get(i), problems);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = typeDeclaration.bodyDeclarations().size();
                    while (i < max) {
                        this.propagateErrors((ASTNode)typeDeclaration.bodyDeclarations().get(i), problems);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, problems);
                    compilationUnit.setProblems(problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }
}

