/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.Compiler;

public class CompilerOptions {
    public static final String OPTION_LocalVariableAttribute = "org.eclipse.jdt.core.compiler.debug.localVariable";
    public static final String OPTION_LineNumberAttribute = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    public static final String OPTION_SourceFileAttribute = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    public static final String OPTION_PreserveUnusedLocal = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    public static final String OPTION_DocCommentSupport = "org.eclipse.jdt.core.compiler.doc.comment.support";
    public static final String OPTION_ReportMethodWithConstructorName = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    public static final String OPTION_ReportOverridingPackageDefaultMethod = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    public static final String OPTION_ReportDeprecation = "org.eclipse.jdt.core.compiler.problem.deprecation";
    public static final String OPTION_ReportDeprecationInDeprecatedCode = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    public static final String OPTION_ReportDeprecationWhenOverridingDeprecatedMethod = "org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod";
    public static final String OPTION_ReportHiddenCatchBlock = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    public static final String OPTION_ReportUnusedLocal = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String OPTION_ReportUnusedParameter = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    public static final String OPTION_ReportUnusedParameterWhenImplementingAbstract = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String OPTION_ReportUnusedParameterWhenOverridingConcrete = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String OPTION_ReportUnusedImport = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String OPTION_ReportSyntheticAccessEmulation = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    public static final String OPTION_ReportNoEffectAssignment = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    public static final String OPTION_ReportLocalVariableHiding = "org.eclipse.jdt.core.compiler.problem.localVariableHiding";
    public static final String OPTION_ReportSpecialParameterHidingField = "org.eclipse.jdt.core.compiler.problem.specialParameterHidingField";
    public static final String OPTION_ReportFieldHiding = "org.eclipse.jdt.core.compiler.problem.fieldHiding";
    public static final String OPTION_ReportTypeParameterHiding = "org.eclipse.jdt.core.compiler.problem.typeParameterHiding";
    public static final String OPTION_ReportPossibleAccidentalBooleanAssignment = "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment";
    public static final String OPTION_ReportNonExternalizedStringLiteral = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String OPTION_ReportIncompatibleNonInheritedInterfaceMethod = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String OPTION_ReportUnusedPrivateMember = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    public static final String OPTION_ReportNoImplicitStringConversion = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    public static final String OPTION_ReportAssertIdentifier = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    public static final String OPTION_ReportEnumIdentifier = "org.eclipse.jdt.core.compiler.problem.enumIdentifier";
    public static final String OPTION_ReportNonStaticAccessToStatic = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    public static final String OPTION_ReportIndirectStaticAccess = "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess";
    public static final String OPTION_ReportEmptyStatement = "org.eclipse.jdt.core.compiler.problem.emptyStatement";
    public static final String OPTION_ReportUnnecessaryTypeCheck = "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck";
    public static final String OPTION_ReportUnnecessaryElse = "org.eclipse.jdt.core.compiler.problem.unnecessaryElse";
    public static final String OPTION_ReportUndocumentedEmptyBlock = "org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock";
    public static final String OPTION_ReportInvalidJavadoc = "org.eclipse.jdt.core.compiler.problem.invalidJavadoc";
    public static final String OPTION_ReportInvalidJavadocTags = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTags";
    public static final String OPTION_ReportInvalidJavadocTagsDeprecatedRef = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef";
    public static final String OPTION_ReportInvalidJavadocTagsNotVisibleRef = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef";
    public static final String OPTION_ReportInvalidJavadocTagsVisibility = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTags = "org.eclipse.jdt.core.compiler.problem.missingJavadocTags";
    public static final String OPTION_ReportMissingJavadocTagsVisibility = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTagsOverriding = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding";
    public static final String OPTION_ReportMissingJavadocComments = "org.eclipse.jdt.core.compiler.problem.missingJavadocComments";
    public static final String OPTION_ReportMissingJavadocCommentsVisibility = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility";
    public static final String OPTION_ReportMissingJavadocCommentsOverriding = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding";
    public static final String OPTION_ReportFinallyBlockNotCompletingNormally = "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally";
    public static final String OPTION_ReportUnusedDeclaredThrownException = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException";
    public static final String OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding";
    public static final String OPTION_ReportUnqualifiedFieldAccess = "org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess";
    public static final String OPTION_ReportUncheckedTypeOperation = "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation";
    public static final String OPTION_ReportRawTypeReference = "org.eclipse.jdt.core.compiler.problem.rawTypeReference";
    public static final String OPTION_ReportFinalParameterBound = "org.eclipse.jdt.core.compiler.problem.finalParameterBound";
    public static final String OPTION_ReportMissingSerialVersion = "org.eclipse.jdt.core.compiler.problem.missingSerialVersion";
    public static final String OPTION_ReportVarargsArgumentNeedCast = "org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast";
    public static final String OPTION_Source = "org.eclipse.jdt.core.compiler.source";
    public static final String OPTION_TargetPlatform = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String OPTION_Compliance = "org.eclipse.jdt.core.compiler.compliance";
    public static final String OPTION_Encoding = "org.eclipse.jdt.core.encoding";
    public static final String OPTION_MaxProblemPerUnit = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    public static final String OPTION_TaskTags = "org.eclipse.jdt.core.compiler.taskTags";
    public static final String OPTION_TaskPriorities = "org.eclipse.jdt.core.compiler.taskPriorities";
    public static final String OPTION_TaskCaseSensitive = "org.eclipse.jdt.core.compiler.taskCaseSensitive";
    public static final String OPTION_InlineJsr = "org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode";
    public static final String OPTION_ReportNullReference = "org.eclipse.jdt.core.compiler.problem.nullReference";
    public static final String OPTION_ReportAutoboxing = "org.eclipse.jdt.core.compiler.problem.autoboxing";
    public static final String OPTION_ReportAnnotationSuperInterface = "org.eclipse.jdt.core.compiler.problem.annotationSuperInterface";
    public static final String OPTION_ReportMissingOverrideAnnotation = "org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation";
    public static final String OPTION_ReportMissingDeprecatedAnnotation = "org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation";
    public static final String OPTION_ReportIncompleteEnumSwitch = "org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch";
    public static final String OPTION_ReportForbiddenReference = "org.eclipse.jdt.core.compiler.problem.forbiddenReference";
    public static final String OPTION_ReportDiscouragedReference = "org.eclipse.jdt.core.compiler.problem.discouragedReference";
    public static final String OPTION_SuppressWarnings = "org.eclipse.jdt.core.compiler.problem.suppressWarnings";
    public static final String OPTION_ReportUnhandledWarningToken = "org.eclipse.jdt.core.compiler.problem.unhandledWarningToken";
    public static final String OPTION_ReportUnusedLabel = "org.eclipse.jdt.core.compiler.problem.unusedLabel";
    public static final String OPTION_FatalOptionalError = "org.eclipse.jdt.core.compiler.problem.fatalOptionalError";
    public static final String OPTION_ReportParameterAssignment = "org.eclipse.jdt.core.compiler.problem.parameterAssignment";
    public static final String OPTION_ReportInvalidAnnotation = "org.eclipse.jdt.core.compiler.problem.invalidAnnotation";
    public static final String OPTION_ReportMissingAnnotation = "org.eclipse.jdt.core.compiler.problem.missingAnnotation";
    public static final String OPTION_ReportMissingJavadoc = "org.eclipse.jdt.core.compiler.problem.missingJavadoc";
    public static final String OPTION_PrivateConstructorAccess = "org.eclipse.jdt.core.compiler.codegen.constructorAccessEmulation";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String VERSION_1_5 = "1.5";
    public static final String VERSION_1_6 = "1.6";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String DEFAULT = "default";
    public static final String PRIVATE = "private";
    public static final long MethodWithConstructorName = 1L;
    public static final long OverriddenPackageDefaultMethod = 2L;
    public static final long UsingDeprecatedAPI = 4L;
    public static final long MaskedCatchBlock = 8L;
    public static final long UnusedLocalVariable = 16L;
    public static final long UnusedArgument = 32L;
    public static final long NoImplicitStringConversion = 64L;
    public static final long AccessEmulation = 128L;
    public static final long NonExternalizedString = 256L;
    public static final long AssertUsedAsAnIdentifier = 512L;
    public static final long UnusedImport = 1024L;
    public static final long NonStaticAccessToStatic = 2048L;
    public static final long Task = 4096L;
    public static final long NoEffectAssignment = 8192L;
    public static final long IncompatibleNonInheritedInterfaceMethod = 16384L;
    public static final long UnusedPrivateMember = 32768L;
    public static final long LocalVariableHiding = 65536L;
    public static final long FieldHiding = 131072L;
    public static final long AccidentalBooleanAssign = 262144L;
    public static final long EmptyStatement = 524288L;
    public static final long MissingJavadocComments = 0x100000L;
    public static final long MissingJavadocTags = 0x200000L;
    public static final long UnqualifiedFieldAccess = 0x400000L;
    public static final long UnusedDeclaredThrownException = 0x800000L;
    public static final long FinallyBlockNotCompleting = 0x1000000L;
    public static final long InvalidJavadoc = 0x2000000L;
    public static final long UnnecessaryTypeCheck = 0x4000000L;
    public static final long UndocumentedEmptyBlock = 0x8000000L;
    public static final long IndirectStaticAccess = 0x10000000L;
    public static final long UnnecessaryElse = 0x20000000L;
    public static final long UncheckedTypeOperation = 0x40000000L;
    public static final long FinalParameterBound = 0x80000000L;
    public static final long MissingSerialVersion = 0x100000000L;
    public static final long EnumUsedAsAnIdentifier = 0x200000000L;
    public static final long ForbiddenReference = 0x400000000L;
    public static final long VarargsArgumentNeedCast = 0x800000000L;
    public static final long NullReference = 0x1000000000L;
    public static final long AutoBoxing = 0x2000000000L;
    public static final long AnnotationSuperInterface = 0x4000000000L;
    public static final long TypeParameterHiding = 0x8000000000L;
    public static final long MissingOverrideAnnotation = 0x10000000000L;
    public static final long IncompleteEnumSwitch = 0x20000000000L;
    public static final long MissingDeprecatedAnnotation = 0x40000000000L;
    public static final long DiscouragedReference = 0x80000000000L;
    public static final long UnhandledWarningToken = 0x100000000000L;
    public static final long RawTypeReference = 0x200000000000L;
    public static final long UnusedLabel = 0x400000000000L;
    public static final long ParameterAssignment = 0x800000000000L;
    public long errorThreshold = 0L;
    public long warningThreshold = 97649319538271L;
    public int produceDebugAttributes = 3;
    public long complianceLevel = 0x300000L;
    public long sourceLevel = 0x2F0000L;
    public long targetJDK = 0x2E0000L;
    public boolean isPrivateConstructorAccessChangingVisibility = false;
    public String defaultEncoding = null;
    public boolean verbose = Compiler.DEBUG;
    public boolean produceReferenceInfo = false;
    public boolean preserveAllLocalVariables = false;
    public boolean parseLiteralExpressionsAsConstants = true;
    public int maxProblemsPerUnit = 100;
    public char[][] taskTags = null;
    public char[][] taskPriorites = null;
    public boolean isTaskCaseSensitive = true;
    public boolean reportDeprecationInsideDeprecatedCode = false;
    public boolean reportDeprecationWhenOverridingDeprecatedMethod = false;
    public boolean reportUnusedParameterWhenImplementingAbstract = false;
    public boolean reportUnusedParameterWhenOverridingConcrete = false;
    public boolean reportUnusedDeclaredThrownExceptionWhenOverriding = false;
    public boolean reportSpecialParameterHidingField = false;
    public int reportInvalidJavadocTagsVisibility = 1;
    public boolean reportInvalidJavadocTags = false;
    public boolean reportInvalidJavadocTagsDeprecatedRef = false;
    public boolean reportInvalidJavadocTagsNotVisibleRef = false;
    public int reportMissingJavadocTagsVisibility = 1;
    public boolean reportMissingJavadocTagsOverriding = false;
    public int reportMissingJavadocCommentsVisibility = 1;
    public boolean reportMissingJavadocCommentsOverriding = false;
    public boolean inlineJsrBytecode = false;
    public boolean docCommentSupport = false;
    public boolean suppressWarnings = true;
    public boolean treatOptionalErrorAsFatal = true;
    public boolean performStatementsRecovery = true;
    public boolean storeAnnotations = false;

    public CompilerOptions() {
    }

    public CompilerOptions(Map settings) {
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public Map getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put(OPTION_LocalVariableAttribute, (this.produceDebugAttributes & 4) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_LineNumberAttribute, (this.produceDebugAttributes & 2) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_SourceFileAttribute, (this.produceDebugAttributes & 1) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_PreserveUnusedLocal, this.preserveAllLocalVariables ? PRESERVE : OPTIMIZE_OUT);
        optionsMap.put(OPTION_DocCommentSupport, this.docCommentSupport ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMethodWithConstructorName, this.getSeverityString(1L));
        optionsMap.put(OPTION_ReportOverridingPackageDefaultMethod, this.getSeverityString(2L));
        optionsMap.put(OPTION_ReportDeprecation, this.getSeverityString(4L));
        optionsMap.put(OPTION_ReportDeprecationInDeprecatedCode, this.reportDeprecationInsideDeprecatedCode ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod, this.reportDeprecationWhenOverridingDeprecatedMethod ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportHiddenCatchBlock, this.getSeverityString(8L));
        optionsMap.put(OPTION_ReportUnusedLocal, this.getSeverityString(16L));
        optionsMap.put(OPTION_ReportUnusedParameter, this.getSeverityString(32L));
        optionsMap.put(OPTION_ReportUnusedImport, this.getSeverityString(1024L));
        optionsMap.put(OPTION_ReportSyntheticAccessEmulation, this.getSeverityString(128L));
        optionsMap.put(OPTION_ReportNoEffectAssignment, this.getSeverityString(8192L));
        optionsMap.put(OPTION_ReportNonExternalizedStringLiteral, this.getSeverityString(256L));
        optionsMap.put(OPTION_ReportNoImplicitStringConversion, this.getSeverityString(64L));
        optionsMap.put(OPTION_ReportNonStaticAccessToStatic, this.getSeverityString(2048L));
        optionsMap.put(OPTION_ReportIndirectStaticAccess, this.getSeverityString(0x10000000L));
        optionsMap.put(OPTION_ReportIncompatibleNonInheritedInterfaceMethod, this.getSeverityString(16384L));
        optionsMap.put(OPTION_ReportUnusedPrivateMember, this.getSeverityString(32768L));
        optionsMap.put(OPTION_ReportLocalVariableHiding, this.getSeverityString(65536L));
        optionsMap.put(OPTION_ReportFieldHiding, this.getSeverityString(131072L));
        optionsMap.put(OPTION_ReportTypeParameterHiding, this.getSeverityString(0x8000000000L));
        optionsMap.put(OPTION_ReportPossibleAccidentalBooleanAssignment, this.getSeverityString(262144L));
        optionsMap.put(OPTION_ReportEmptyStatement, this.getSeverityString(524288L));
        optionsMap.put(OPTION_ReportAssertIdentifier, this.getSeverityString(512L));
        optionsMap.put(OPTION_ReportEnumIdentifier, this.getSeverityString(0x200000000L));
        optionsMap.put(OPTION_ReportUndocumentedEmptyBlock, this.getSeverityString(0x8000000L));
        optionsMap.put(OPTION_ReportUnnecessaryTypeCheck, this.getSeverityString(0x4000000L));
        optionsMap.put(OPTION_ReportUnnecessaryElse, this.getSeverityString(0x20000000L));
        optionsMap.put(OPTION_ReportAutoboxing, this.getSeverityString(0x2000000000L));
        optionsMap.put(OPTION_ReportAnnotationSuperInterface, this.getSeverityString(0x4000000000L));
        optionsMap.put(OPTION_ReportIncompleteEnumSwitch, this.getSeverityString(0x20000000000L));
        optionsMap.put(OPTION_ReportInvalidJavadoc, this.getSeverityString(0x2000000L));
        optionsMap.put(OPTION_ReportInvalidJavadocTagsVisibility, this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        optionsMap.put(OPTION_ReportInvalidJavadocTags, this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportInvalidJavadocTagsDeprecatedRef, this.reportInvalidJavadocTagsDeprecatedRef ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportInvalidJavadocTagsNotVisibleRef, this.reportInvalidJavadocTagsNotVisibleRef ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMissingJavadocTags, this.getSeverityString(0x200000L));
        optionsMap.put(OPTION_ReportMissingJavadocTagsVisibility, this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        optionsMap.put(OPTION_ReportMissingJavadocTagsOverriding, this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMissingJavadocComments, this.getSeverityString(0x100000L));
        optionsMap.put(OPTION_ReportMissingJavadocCommentsVisibility, this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        optionsMap.put(OPTION_ReportMissingJavadocCommentsOverriding, this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportFinallyBlockNotCompletingNormally, this.getSeverityString(0x1000000L));
        optionsMap.put(OPTION_ReportUnusedDeclaredThrownException, this.getSeverityString(0x800000L));
        optionsMap.put(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding, this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnqualifiedFieldAccess, this.getSeverityString(0x400000L));
        optionsMap.put(OPTION_ReportUncheckedTypeOperation, this.getSeverityString(0x40000000L));
        optionsMap.put(OPTION_ReportRawTypeReference, this.getSeverityString(0x200000000000L));
        optionsMap.put(OPTION_ReportFinalParameterBound, this.getSeverityString(0x80000000L));
        optionsMap.put(OPTION_ReportMissingSerialVersion, this.getSeverityString(0x100000000L));
        optionsMap.put(OPTION_ReportForbiddenReference, this.getSeverityString(0x400000000L));
        optionsMap.put(OPTION_ReportDiscouragedReference, this.getSeverityString(0x80000000000L));
        optionsMap.put(OPTION_ReportVarargsArgumentNeedCast, this.getSeverityString(0x800000000L));
        optionsMap.put(OPTION_ReportMissingOverrideAnnotation, this.getSeverityString(0x10000000000L));
        optionsMap.put(OPTION_ReportMissingDeprecatedAnnotation, this.getSeverityString(0x40000000000L));
        optionsMap.put(OPTION_ReportIncompleteEnumSwitch, this.getSeverityString(0x20000000000L));
        optionsMap.put(OPTION_ReportUnusedLabel, this.getSeverityString(0x400000000000L));
        optionsMap.put(OPTION_Compliance, CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        optionsMap.put(OPTION_Source, CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        optionsMap.put(OPTION_TargetPlatform, CompilerOptions.versionFromJdkLevel(this.targetJDK));
        optionsMap.put(OPTION_FatalOptionalError, this.treatOptionalErrorAsFatal ? ENABLED : DISABLED);
        if (this.defaultEncoding != null) {
            optionsMap.put(OPTION_Encoding, this.defaultEncoding);
        }
        optionsMap.put(OPTION_TaskTags, this.taskTags == null ? "" : new String(CharOperation.concatWith(this.taskTags, ',')));
        optionsMap.put(OPTION_TaskPriorities, this.taskPriorites == null ? "" : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        optionsMap.put(OPTION_TaskCaseSensitive, this.isTaskCaseSensitive ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnusedParameterWhenImplementingAbstract, this.reportUnusedParameterWhenImplementingAbstract ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnusedParameterWhenOverridingConcrete, this.reportUnusedParameterWhenOverridingConcrete ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportSpecialParameterHidingField, this.reportSpecialParameterHidingField ? ENABLED : DISABLED);
        optionsMap.put(OPTION_MaxProblemPerUnit, String.valueOf(this.maxProblemsPerUnit));
        optionsMap.put(OPTION_InlineJsr, this.inlineJsrBytecode ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportNullReference, this.getSeverityString(0x1000000000L));
        optionsMap.put(OPTION_SuppressWarnings, this.suppressWarnings ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnhandledWarningToken, this.getSeverityString(0x100000000000L));
        optionsMap.put(OPTION_ReportParameterAssignment, this.getSeverityString(0x800000000000L));
        return optionsMap;
    }

    public int getSeverity(long irritant) {
        if ((this.errorThreshold & irritant) != 0L) {
            return 33;
        }
        if ((this.warningThreshold & irritant) != 0L) {
            return 32;
        }
        return -1;
    }

    public String getSeverityString(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public String getVisibilityString(int level) {
        switch (level) {
            case 1: {
                return PUBLIC;
            }
            case 4: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return DEFAULT;
    }

    public void set(Map optionsMap) {
        long level;
        Object optionValue = optionsMap.get(OPTION_LocalVariableAttribute);
        if (optionValue != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 4;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFB;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_LineNumberAttribute)) != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 2;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFD;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_SourceFileAttribute)) != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 1;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFE;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_PreserveUnusedLocal)) != null) {
            if (PRESERVE.equals(optionValue)) {
                this.preserveAllLocalVariables = true;
            } else if (OPTIMIZE_OUT.equals(optionValue)) {
                this.preserveAllLocalVariables = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecationInDeprecatedCode)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_Compliance)) != null && (level = CompilerOptions.versionToJdkLevel(optionValue)) != 0L) {
            this.complianceLevel = level;
        }
        if ((optionValue = optionsMap.get(OPTION_Source)) != null && (level = CompilerOptions.versionToJdkLevel(optionValue)) != 0L) {
            this.sourceLevel = level;
        }
        if ((optionValue = optionsMap.get(OPTION_TargetPlatform)) != null) {
            level = CompilerOptions.versionToJdkLevel(optionValue);
            if (level != 0L) {
                this.targetJDK = level;
            }
            if (this.targetJDK >= 0x310000L) {
                this.inlineJsrBytecode = true;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_Encoding)) != null && optionValue instanceof String) {
            this.defaultEncoding = null;
            String stringValue = (String)optionValue;
            if (stringValue.length() > 0) {
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), stringValue);
                    this.defaultEncoding = stringValue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        if ((optionValue = optionsMap.get(OPTION_PrivateConstructorAccess)) != null && (level = CompilerOptions.versionToJdkLevel(optionValue)) >= 0x2F0000L) {
            this.isPrivateConstructorAccessChangingVisibility = true;
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameterWhenImplementingAbstract)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameterWhenOverridingConcrete)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportSpecialParameterHidingField)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportSpecialParameterHidingField = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportSpecialParameterHidingField = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_MaxProblemPerUnit)) != null && optionValue instanceof String) {
            String stringValue = (String)optionValue;
            try {
                int val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxProblemsPerUnit = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get(OPTION_TaskTags)) != null && optionValue instanceof String) {
            String stringValue = (String)optionValue;
            this.taskTags = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get(OPTION_TaskPriorities)) != null && optionValue instanceof String) {
            String stringValue = (String)optionValue;
            this.taskPriorites = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get(OPTION_TaskCaseSensitive)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.isTaskCaseSensitive = true;
            } else if (DISABLED.equals(optionValue)) {
                this.isTaskCaseSensitive = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_InlineJsr)) != null && this.targetJDK < 0x310000L) {
            if (ENABLED.equals(optionValue)) {
                this.inlineJsrBytecode = true;
            } else if (DISABLED.equals(optionValue)) {
                this.inlineJsrBytecode = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_SuppressWarnings)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.suppressWarnings = true;
            } else if (DISABLED.equals(optionValue)) {
                this.suppressWarnings = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_FatalOptionalError)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.treatOptionalErrorAsFatal = true;
            } else if (DISABLED.equals(optionValue)) {
                this.treatOptionalErrorAsFatal = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMethodWithConstructorName)) != null) {
            this.updateSeverity(1L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportOverridingPackageDefaultMethod)) != null) {
            this.updateSeverity(2L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecation)) != null) {
            this.updateSeverity(4L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportHiddenCatchBlock)) != null) {
            this.updateSeverity(8L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedLocal)) != null) {
            this.updateSeverity(16L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameter)) != null) {
            this.updateSeverity(32L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedImport)) != null) {
            this.updateSeverity(1024L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedPrivateMember)) != null) {
            this.updateSeverity(32768L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedDeclaredThrownException)) != null) {
            this.updateSeverity(0x800000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNoImplicitStringConversion)) != null) {
            this.updateSeverity(64L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportSyntheticAccessEmulation)) != null) {
            this.updateSeverity(128L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportLocalVariableHiding)) != null) {
            this.updateSeverity(65536L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportFieldHiding)) != null) {
            this.updateSeverity(131072L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportTypeParameterHiding)) != null) {
            this.updateSeverity(0x8000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportPossibleAccidentalBooleanAssignment)) != null) {
            this.updateSeverity(262144L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportEmptyStatement)) != null) {
            this.updateSeverity(524288L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNonExternalizedStringLiteral)) != null) {
            this.updateSeverity(256L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportAssertIdentifier)) != null) {
            this.updateSeverity(512L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportEnumIdentifier)) != null) {
            this.updateSeverity(0x200000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNonStaticAccessToStatic)) != null) {
            this.updateSeverity(2048L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIndirectStaticAccess)) != null) {
            this.updateSeverity(0x10000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIncompatibleNonInheritedInterfaceMethod)) != null) {
            this.updateSeverity(16384L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUndocumentedEmptyBlock)) != null) {
            this.updateSeverity(0x8000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnnecessaryTypeCheck)) != null) {
            this.updateSeverity(0x4000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnnecessaryElse)) != null) {
            this.updateSeverity(0x20000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportFinallyBlockNotCompletingNormally)) != null) {
            this.updateSeverity(0x1000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnqualifiedFieldAccess)) != null) {
            this.updateSeverity(0x400000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNoEffectAssignment)) != null) {
            this.updateSeverity(8192L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUncheckedTypeOperation)) != null) {
            this.updateSeverity(0x40000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportRawTypeReference)) != null) {
            this.updateSeverity(0x200000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportFinalParameterBound)) != null) {
            this.updateSeverity(0x80000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingSerialVersion)) != null) {
            this.updateSeverity(0x100000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportForbiddenReference)) != null) {
            this.updateSeverity(0x400000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDiscouragedReference)) != null) {
            this.updateSeverity(0x80000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportVarargsArgumentNeedCast)) != null) {
            this.updateSeverity(0x800000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNullReference)) != null) {
            this.updateSeverity(0x1000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportAutoboxing)) != null) {
            this.updateSeverity(0x2000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportAnnotationSuperInterface)) != null) {
            this.updateSeverity(0x4000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingOverrideAnnotation)) != null) {
            this.updateSeverity(0x10000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingDeprecatedAnnotation)) != null) {
            this.updateSeverity(0x40000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIncompleteEnumSwitch)) != null) {
            this.updateSeverity(0x20000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnhandledWarningToken)) != null) {
            this.updateSeverity(0x100000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedLabel)) != null) {
            this.updateSeverity(0x400000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportParameterAssignment)) != null) {
            this.updateSeverity(0x800000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_DocCommentSupport)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.docCommentSupport = true;
            } else if (DISABLED.equals(optionValue)) {
                this.docCommentSupport = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadoc)) != null) {
            this.updateSeverity(0x2000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 4;
            } else if (DEFAULT.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 0;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTags)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportInvalidJavadocTags = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportInvalidJavadocTags = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTagsDeprecatedRef)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportInvalidJavadocTagsDeprecatedRef = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportInvalidJavadocTagsDeprecatedRef = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTagsNotVisibleRef)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportInvalidJavadocTagsNotVisibleRef = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportInvalidJavadocTagsNotVisibleRef = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTags)) != null) {
            this.updateSeverity(0x200000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 4;
            } else if (DEFAULT.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 0;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTagsOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocComments)) != null) {
            this.updateSeverity(0x100000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocCommentsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 4;
            } else if (DEFAULT.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 0;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocCommentsOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = false;
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CompilerOptions:");
        buf.append("\n\t- local variables debug attributes: ").append((this.produceDebugAttributes & 4) != 0 ? "ON" : " OFF");
        buf.append("\n\t- line number debug attributes: ").append((this.produceDebugAttributes & 2) != 0 ? "ON" : " OFF");
        buf.append("\n\t- source debug attributes: ").append((this.produceDebugAttributes & 1) != 0 ? "ON" : " OFF");
        buf.append("\n\t- preserve all local variables: ").append(this.preserveAllLocalVariables ? "ON" : " OFF");
        buf.append("\n\t- method with constructor name: ").append(this.getSeverityString(1L));
        buf.append("\n\t- overridden package default method: ").append(this.getSeverityString(2L));
        buf.append("\n\t- deprecation: ").append(this.getSeverityString(4L));
        buf.append("\n\t- masked catch block: ").append(this.getSeverityString(8L));
        buf.append("\n\t- unused local variable: ").append(this.getSeverityString(16L));
        buf.append("\n\t- unused parameter: ").append(this.getSeverityString(32L));
        buf.append("\n\t- unused import: ").append(this.getSeverityString(1024L));
        buf.append("\n\t- synthetic access emulation: ").append(this.getSeverityString(128L));
        buf.append("\n\t- assignment with no effect: ").append(this.getSeverityString(8192L));
        buf.append("\n\t- non externalized string: ").append(this.getSeverityString(256L));
        buf.append("\n\t- static access receiver: ").append(this.getSeverityString(2048L));
        buf.append("\n\t- indirect static access: ").append(this.getSeverityString(0x10000000L));
        buf.append("\n\t- incompatible non inherited interface method: ").append(this.getSeverityString(16384L));
        buf.append("\n\t- unused private member: ").append(this.getSeverityString(32768L));
        buf.append("\n\t- local variable hiding another variable: ").append(this.getSeverityString(65536L));
        buf.append("\n\t- field hiding another variable: ").append(this.getSeverityString(131072L));
        buf.append("\n\t- type parameter hiding another type: ").append(this.getSeverityString(0x8000000000L));
        buf.append("\n\t- possible accidental boolean assignment: ").append(this.getSeverityString(262144L));
        buf.append("\n\t- superfluous semicolon: ").append(this.getSeverityString(524288L));
        buf.append("\n\t- uncommented empty block: ").append(this.getSeverityString(0x8000000L));
        buf.append("\n\t- unnecessary type check: ").append(this.getSeverityString(0x4000000L));
        buf.append("\n\t- javadoc comment support: ").append(this.docCommentSupport ? "ON" : " OFF");
        buf.append("\n\t\t+ invalid javadoc: ").append(this.getSeverityString(0x2000000L));
        buf.append("\n\t\t+ report invalid javadoc tags: ").append(this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        buf.append("\n\t\t\t* deprecated references: ").append(this.reportInvalidJavadocTagsDeprecatedRef ? ENABLED : DISABLED);
        buf.append("\n\t\t\t* not visible references: ").append(this.reportInvalidJavadocTagsNotVisibleRef ? ENABLED : DISABLED);
        buf.append("\n\t\t+ visibility level to report invalid javadoc tags: ").append(this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        buf.append("\n\t\t+ missing javadoc tags: ").append(this.getSeverityString(0x200000L));
        buf.append("\n\t\t+ visibility level to report missing javadoc tags: ").append(this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        buf.append("\n\t\t+ report missing javadoc tags in overriding methods: ").append(this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        buf.append("\n\t\t+ missing javadoc comments: ").append(this.getSeverityString(0x100000L));
        buf.append("\n\t\t+ visibility level to report missing javadoc comments: ").append(this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        buf.append("\n\t\t+ report missing javadoc comments in overriding methods: ").append(this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        buf.append("\n\t- finally block not completing normally: ").append(this.getSeverityString(0x1000000L));
        buf.append("\n\t- unused declared thrown exception: ").append(this.getSeverityString(0x800000L));
        buf.append("\n\t- unused declared thrown exception when overriding: ").append(this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        buf.append("\n\t- unnecessary else: ").append(this.getSeverityString(0x20000000L));
        buf.append("\n\t- JDK compliance level: " + CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        buf.append("\n\t- JDK source level: " + CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        buf.append("\n\t- JDK target level: " + CompilerOptions.versionFromJdkLevel(this.targetJDK));
        buf.append("\n\t- private constructor access: ").append(this.isPrivateConstructorAccessChangingVisibility ? "extra argument" : "make default access");
        buf.append("\n\t- verbose : ").append(this.verbose ? "ON" : "OFF");
        buf.append("\n\t- produce reference info : ").append(this.produceReferenceInfo ? "ON" : "OFF");
        buf.append("\n\t- parse literal expressions as constants : ").append(this.parseLiteralExpressionsAsConstants ? "ON" : "OFF");
        buf.append("\n\t- encoding : ").append(this.defaultEncoding == null ? "<default>" : this.defaultEncoding);
        buf.append("\n\t- task tags: ").append(this.taskTags == null ? "" : new String(CharOperation.concatWith(this.taskTags, ',')));
        buf.append("\n\t- task priorities : ").append(this.taskPriorites == null ? "" : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        buf.append("\n\t- report deprecation inside deprecated code : ").append(this.reportDeprecationInsideDeprecatedCode ? ENABLED : DISABLED);
        buf.append("\n\t- report deprecation when overriding deprecated method : ").append(this.reportDeprecationWhenOverridingDeprecatedMethod ? ENABLED : DISABLED);
        buf.append("\n\t- report unused parameter when implementing abstract method : ").append(this.reportUnusedParameterWhenImplementingAbstract ? ENABLED : DISABLED);
        buf.append("\n\t- report unused parameter when overriding concrete method : ").append(this.reportUnusedParameterWhenOverridingConcrete ? ENABLED : DISABLED);
        buf.append("\n\t- report constructor/setter parameter hiding existing field : ").append(this.reportSpecialParameterHidingField ? ENABLED : DISABLED);
        buf.append("\n\t- inline JSR bytecode : ").append(this.inlineJsrBytecode ? ENABLED : DISABLED);
        buf.append("\n\t- unsafe type operation: ").append(this.getSeverityString(0x40000000L));
        buf.append("\n\t- unsafe raw type: ").append(this.getSeverityString(0x200000000000L));
        buf.append("\n\t- final bound for type parameter: ").append(this.getSeverityString(0x80000000L));
        buf.append("\n\t- missing serialVersionUID: ").append(this.getSeverityString(0x100000000L));
        buf.append("\n\t- varargs argument need cast: ").append(this.getSeverityString(0x800000000L));
        buf.append("\n\t- forbidden reference to type with access restriction: ").append(this.getSeverityString(0x400000000L));
        buf.append("\n\t- discouraged reference to type with access restriction: ").append(this.getSeverityString(0x80000000000L));
        buf.append("\n\t- null reference: ").append(this.getSeverityString(0x1000000000L));
        buf.append("\n\t- autoboxing: ").append(this.getSeverityString(0x2000000000L));
        buf.append("\n\t- annotation super interface: ").append(this.getSeverityString(0x4000000000L));
        buf.append("\n\t- missing @Override annotation: ").append(this.getSeverityString(0x10000000000L));
        buf.append("\n\t- missing @Deprecated annotation: ").append(this.getSeverityString(0x40000000000L));
        buf.append("\n\t- incomplete enum switch: ").append(this.getSeverityString(0x20000000000L));
        buf.append("\n\t- suppress warnings: ").append(this.suppressWarnings ? ENABLED : DISABLED);
        buf.append("\n\t- unhandled warning token: ").append(this.getSeverityString(0x100000000000L));
        buf.append("\n\t- unused label: ").append(this.getSeverityString(0x400000000000L));
        buf.append("\n\t- treat optional error as fatal: ").append(this.treatOptionalErrorAsFatal ? ENABLED : DISABLED);
        buf.append("\n\t- parameter assignment: ").append(this.getSeverityString(0x800000000000L));
        return buf.toString();
    }

    void updateSeverity(long irritant, Object severityString) {
        if (ERROR.equals(severityString)) {
            this.errorThreshold |= irritant;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= irritant;
        } else if (IGNORE.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static long versionToJdkLevel(Object versionID) {
        if (VERSION_1_1.equals(versionID)) {
            return 2949123L;
        }
        if (VERSION_1_2.equals(versionID)) {
            return 0x2E0000L;
        }
        if (VERSION_1_3.equals(versionID)) {
            return 0x2F0000L;
        }
        if (VERSION_1_4.equals(versionID)) {
            return 0x300000L;
        }
        if (VERSION_1_5.equals(versionID)) {
            return 0x310000L;
        }
        if (VERSION_1_6.equals(versionID)) {
            return 0x320000L;
        }
        return 0L;
    }

    public static String versionFromJdkLevel(long jdkLevel) {
        if (jdkLevel == 2949123L) {
            return VERSION_1_1;
        }
        if (jdkLevel == 0x2E0000L) {
            return VERSION_1_2;
        }
        if (jdkLevel == 0x2F0000L) {
            return VERSION_1_3;
        }
        if (jdkLevel == 0x300000L) {
            return VERSION_1_4;
        }
        if (jdkLevel == 0x310000L) {
            return VERSION_1_5;
        }
        if (jdkLevel == 0x320000L) {
            return VERSION_1_6;
        }
        return "";
    }

    public static String[] warningOptionNames() {
        String[] result = new String[]{OPTION_ReportAnnotationSuperInterface, OPTION_ReportAssertIdentifier, OPTION_ReportAutoboxing, OPTION_ReportDeprecation, OPTION_ReportDiscouragedReference, OPTION_ReportEmptyStatement, OPTION_ReportEnumIdentifier, OPTION_ReportFieldHiding, OPTION_ReportFinalParameterBound, OPTION_ReportFinallyBlockNotCompletingNormally, OPTION_ReportForbiddenReference, OPTION_ReportHiddenCatchBlock, OPTION_ReportIncompatibleNonInheritedInterfaceMethod, OPTION_ReportIncompleteEnumSwitch, OPTION_ReportIndirectStaticAccess, OPTION_ReportInvalidJavadoc, OPTION_ReportLocalVariableHiding, OPTION_ReportMethodWithConstructorName, OPTION_ReportMissingDeprecatedAnnotation, OPTION_ReportMissingJavadocComments, OPTION_ReportMissingJavadocTags, OPTION_ReportMissingOverrideAnnotation, OPTION_ReportMissingSerialVersion, OPTION_ReportNoEffectAssignment, OPTION_ReportNoImplicitStringConversion, OPTION_ReportNonExternalizedStringLiteral, OPTION_ReportNonStaticAccessToStatic, OPTION_ReportNullReference, OPTION_ReportOverridingPackageDefaultMethod, OPTION_ReportParameterAssignment, OPTION_ReportPossibleAccidentalBooleanAssignment, OPTION_ReportSyntheticAccessEmulation, OPTION_ReportTypeParameterHiding, OPTION_ReportUncheckedTypeOperation, OPTION_ReportUndocumentedEmptyBlock, OPTION_ReportUnnecessaryElse, OPTION_ReportUnnecessaryTypeCheck, OPTION_ReportUnqualifiedFieldAccess, OPTION_ReportUnusedDeclaredThrownException, OPTION_ReportUnusedImport, OPTION_ReportUnusedLocal, OPTION_ReportUnusedParameter, OPTION_ReportUnusedPrivateMember, OPTION_ReportVarargsArgumentNeedCast, OPTION_ReportUnhandledWarningToken};
        return result;
    }

    public static String warningTokenFromIrritant(long irritant) {
        int irritantInt = (int)irritant;
        if ((long)irritantInt == irritant) {
            switch (irritantInt) {
                case 4: 
                case 0x2000004: {
                    return "deprecation";
                }
                case 0x1000000: {
                    return "finally";
                }
                case 8: 
                case 65536: 
                case 131072: {
                    return "hiding";
                }
                case 256: {
                    return "nls";
                }
                case 16: 
                case 32: 
                case 32768: 
                case 0x800000: {
                    return "unused";
                }
                case 2048: 
                case 0x10000000: {
                    return "static-access";
                }
                case 128: {
                    return "synthetic-access";
                }
                case 0x400000: {
                    return "unqualified-field-access";
                }
                case 0x40000000: {
                    return "unchecked";
                }
            }
        } else {
            irritantInt = (int)(irritant >>> 32);
            switch (irritantInt) {
                case 1: {
                    return "serial";
                }
                case 32: {
                    return "boxing";
                }
                case 128: {
                    return "hiding";
                }
                case 512: {
                    return "incomplete-switch";
                }
                case 1024: {
                    return "dep-ann";
                }
                case 8192: {
                    return "unchecked";
                }
                case 0: {
                    return "unused";
                }
                case 4: 
                case 2048: {
                    return "restriction";
                }
            }
        }
        return null;
    }

    public static long warningTokenToIrritant(String warningToken) {
        if (warningToken == null || warningToken.length() == 0) {
            return 0L;
        }
        switch (warningToken.charAt(0)) {
            case 'a': {
                if (!"all".equals(warningToken)) break;
                return -1L;
            }
            case 'b': {
                if (!"boxing".equals(warningToken)) break;
                return 0x2000000000L;
            }
            case 'd': {
                if ("deprecation".equals(warningToken)) {
                    return 4L;
                }
                if (!"dep-ann".equals(warningToken)) break;
                return 0x40000000000L;
            }
            case 'f': {
                if (!"finally".equals(warningToken)) break;
                return 0x1000000L;
            }
            case 'h': {
                if ("hiding".equals(warningToken)) {
                    return 0x8000030008L;
                }
            }
            case 'i': {
                if (!"incomplete-switch".equals(warningToken)) break;
                return 0x20000000000L;
            }
            case 'n': {
                if ("nls".equals(warningToken)) {
                    return 256L;
                }
                if (!"null".equals(warningToken)) break;
                return 0x1000000000L;
            }
            case 'r': {
                if (!"restriction".equals(warningToken)) break;
                return 0x80400000000L;
            }
            case 's': {
                if ("serial".equals(warningToken)) {
                    return 0x100000000L;
                }
                if ("static-access".equals(warningToken)) {
                    return 0x10000800L;
                }
                if (!"synthetic-access".equals(warningToken)) break;
                return 128L;
            }
            case 'u': {
                if ("unused".equals(warningToken)) {
                    return 70368752599088L;
                }
                if ("unchecked".equals(warningToken)) {
                    return 0x200040000000L;
                }
                if (!"unqualified-field-access".equals(warningToken)) break;
                return 0x400000L;
            }
        }
        return 0L;
    }
}

