/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;
    private HashMap methodDeclarationsWithInvalidParam = new HashMap();

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    protected void clear() {
        this.methodDeclarationsWithInvalidParam = new HashMap();
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        try {
            this.allSuperDeclaringTypeNames = new SuperTypeNamesCollector(this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, locator, this.pattern.declaringType, locator.progressMonitor).collect();
        }
        catch (JavaModelException javaModelException) {}
    }

    private boolean isTypeInSuperDeclaringTypeNames(char[][] typeName) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        int length = this.allSuperDeclaringTypeNames.length;
        int i = 0;
        while (i < length) {
            if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        return !method.isStatic() && !method.isPrivate() && !messageSend.isSuperAccess();
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int declarationsLevel = 0;
        if (this.pattern.findReferences && node instanceof ImportReference) {
            ImportReference importRef = (ImportReference)node;
            int length = importRef.tokens.length - 1;
            if (importRef.isStatic() && !importRef.onDemand && this.matchesName(this.pattern.selector, importRef.tokens[length])) {
                char[][] compoundName = new char[length][];
                System.arraycopy(importRef.tokens, 0, compoundName, 0, length);
                char[] declaringType = CharOperation.concat(this.pattern.declaringQualification, this.pattern.declaringSimpleName, '.');
                if (this.matchesName(declaringType, CharOperation.concatWith(compoundName, '.'))) {
                    declarationsLevel = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return nodeSet.addMatch(node, declarationsLevel);
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        boolean resolve = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (args != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            nodeSet.mustResolve = true;
                            resolve = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(node, null);
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        if (this.pattern.hasMethodArguments() && (node.typeParameters == null || node.typeParameters.length != this.pattern.methodArguments.length)) {
            return 0;
        }
        return nodeSet.addMatch(node, resolve ? 2 : 3);
    }

    public int match(MemberValuePair node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.name)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (node.bits & 0x8000) == 0)) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(Annotation node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        MemberValuePair[] pairs = node.memberValuePairs();
        if (pairs == null || pairs.length == 0) {
            return 0;
        }
        int length = pairs.length;
        MemberValuePair pair = null;
        int i = 0;
        while (i < length) {
            pair = node.memberValuePairs()[i];
            if (this.matchesName(this.pattern.selector, pair.name)) {
                ASTNode possibleNode = node instanceof SingleMemberAnnotation ? node : pair;
                return nodeSet.addMatch(possibleNode, this.pattern.mustResolve ? 2 : 3);
            }
            ++i;
        }
        return 0;
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        if (importRef.isStatic() && binding instanceof MethodBinding) {
            super.matchLevelAndReportImportRef(importRef, binding, locator);
        }
    }

    protected int matchMethod(MethodBinding method, boolean skipImpossibleArg) {
        int parameterCount;
        int newLevel;
        if (!this.matchesName(this.pattern.selector, method.selector)) {
            return 0;
        }
        int level = 3;
        if (this.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, method.returnType))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        int n = parameterCount = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.parameters == null) {
                return 1;
            }
            if (parameterCount != method.parameters.length) {
                return 0;
            }
            if (!method.isValidBinding() && ((ProblemMethodBinding)method).problemId() == 3) {
                return 1;
            }
            int i = 0;
            while (i < parameterCount) {
                TypeBinding argType = method.parameters[i];
                int newLevel2 = 0;
                newLevel2 = argType.isMemberType() ? (CharOperation.match(this.pattern.parameterSimpleNames[i], argType.sourceName(), this.isCaseSensitive) ? 3 : 0) : this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], argType);
                if (level > newLevel2) {
                    if (newLevel2 == 0) {
                        if (skipImpossibleArg) {
                            newLevel2 = level;
                        } else {
                            return 0;
                        }
                    }
                    level = newLevel2;
                }
                ++i;
            }
        }
        return level;
    }

    private boolean matchOverriddenMethod(ReferenceBinding type, MethodBinding method, MethodBinding matchMethod) {
        ReferenceBinding[] interfaces;
        if (type == null || this.pattern.selector == null) {
            return false;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT)) {
            ReferenceBinding superClass = type.superclass();
            if (superClass.isParameterizedType()) {
                MethodBinding[] methods = superClass.getMethods(this.pattern.selector);
                int length = methods.length;
                int i = 0;
                while (i < length) {
                    if (methods[i].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[i].original()) : methods[i].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.matchOverriddenMethod(superClass, method, matchMethod)) {
                return true;
            }
        }
        if ((interfaces = type.superInterfaces()) == null) {
            return false;
        }
        int iLength = interfaces.length;
        int i = 0;
        while (i < iLength) {
            if (interfaces[i].isParameterizedType()) {
                MethodBinding[] methods = interfaces[i].getMethods(this.pattern.selector);
                int length = methods.length;
                int j = 0;
                while (j < length) {
                    if (methods[j].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[j].original()) : methods[j].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++j;
                }
            }
            if (this.matchOverriddenMethod(interfaces[i], method, matchMethod)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = reference instanceof MessageSend ? ((MessageSend)reference).binding : (methodBinding = elementBinding instanceof MethodBinding ? (MethodBinding)elementBinding : null);
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (methodBinding == null) {
                return;
            }
            if (accuracy != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                this.reportDeclaration(methodBinding, locator, declPattern.knownMethods);
            }
        } else {
            this.match = locator.newMethodReferenceMatch(element, elementBinding, accuracy, -1, -1, false, false, reference);
            if (this.pattern.findReferences && reference instanceof MessageSend) {
                boolean isPrivate;
                IJavaElement focus = this.pattern.focus;
                if (focus != null && focus.getElementType() == 9 && methodBinding != null && (isPrivate = Flags.isPrivate(((IMethod)focus).getFlags())) && !CharOperation.equals(methodBinding.declaringClass.sourceName, focus.getParent().getElementName().toCharArray())) {
                    return;
                }
                this.matchReportReference((MessageSend)reference, locator, ((MessageSend)reference).binding);
            } else {
                if (reference instanceof SingleMemberAnnotation) {
                    reference = ((SingleMemberAnnotation)reference).memberValuePairs()[0];
                    this.match.setImplicit(true);
                }
                int offset = reference.sourceStart;
                int length = reference.sourceEnd - offset + 1;
                this.match.setOffset(offset);
                this.match.setLength(length);
                locator.report(this.match);
            }
        }
    }

    void matchReportReference(MessageSend messageSend, MatchLocator locator, MethodBinding methodBinding) throws CoreException {
        boolean report;
        boolean isParameterized = false;
        if (methodBinding instanceof ParameterizedGenericMethodBinding) {
            isParameterized = true;
            ParameterizedGenericMethodBinding parameterizedMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.match.setRaw(parameterizedMethodBinding.isRaw);
            TypeBinding[] typeArguments = parameterizedMethodBinding.typeArguments;
            this.updateMatch(typeArguments, locator, this.pattern.methodArguments, this.pattern.hasMethodParameters());
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasMethodArguments() || parameterizedBinding.isParameterizedWithOwnVariables())) {
                    this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (methodBinding instanceof ParameterizedMethodBinding) {
            isParameterized = true;
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!parameterizedBinding.isParameterizedWithOwnVariables()) {
                    this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasMethodArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!report) {
            return;
        }
        int offset = (int)(messageSend.nameSourcePosition >>> 32);
        this.match.setOffset(offset);
        this.match.setLength(messageSend.sourceEnd - offset + 1);
        if (isParameterized && this.pattern.hasMethodArguments()) {
            locator.reportAccurateParameterizedMethodReference(this.match, messageSend, messageSend.typeArguments);
        } else {
            locator.report(this.match);
        }
    }

    private boolean methodParametersEqualsPattern(MethodBinding method) {
        TypeBinding[] methodParameters = method.parameters;
        int length = methodParameters.length;
        if (length != this.pattern.parameterSimpleNames.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            char[] paramQualifiedName = MethodLocator.qualifiedPattern(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i]);
            if (!CharOperation.match(paramQualifiedName, methodParameters[i].readableName(), this.isCaseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, int length, MatchLocator locator) {
        if (elementBinding != null) {
            MethodBinding methodBinding = (MethodBinding)elementBinding;
            if (this.methodDeclarationsWithInvalidParam.containsKey(reference)) {
                Boolean report = (Boolean)this.methodDeclarationsWithInvalidParam.get(reference);
                if (report != null) {
                    if (report.booleanValue()) {
                        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                    }
                    return null;
                }
                if (this.matchOverriddenMethod(methodBinding.declaringClass, methodBinding, null)) {
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                if (this.isTypeInSuperDeclaringTypeNames(methodBinding.declaringClass.compoundName)) {
                    MethodBinding patternBinding = locator.getMethodBinding(this.pattern);
                    if (patternBinding != null && !this.matchOverriddenMethod(patternBinding.declaringClass, patternBinding, methodBinding)) {
                        this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                        return null;
                    }
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                return null;
            }
        }
        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
    }

    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator locator, SimpleSet knownMethods) throws CoreException {
        char[] typeName;
        int i;
        Object parameterTypes;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        char[] bindingSelector = methodBinding.selector;
        boolean isBinary = type.isBinary();
        IMethod method = null;
        TypeBinding[] parameters = methodBinding.original().parameters;
        int parameterLength = parameters.length;
        if (isBinary) {
            parameterTypes = new char[parameterLength][];
            i = 0;
            while (i < parameterLength) {
                typeName = parameters[i].qualifiedSourceName();
                int j = 0;
                int dim = parameters[i].dimensions();
                while (j < dim) {
                    typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                    ++j;
                }
                parameterTypes[i] = typeName;
                ++i;
            }
            method = locator.createBinaryMethodHandle(type, methodBinding.selector, (char[][])parameterTypes, locator);
        } else {
            parameterTypes = new String[parameterLength];
            i = 0;
            while (i < parameterLength) {
                typeName = parameters[i].shortReadableName();
                if (parameters[i].isMemberType()) {
                    typeName = CharOperation.subarray(typeName, CharOperation.indexOf('.', typeName) + 1, typeName.length);
                }
                parameterTypes[i] = (char[])Signature.createTypeSignature(typeName, false);
                ++i;
            }
            method = type.getMethod(new String(bindingSelector), (String[])parameterTypes);
        }
        if (method == null || knownMethods.includes(method)) {
            return;
        }
        knownMethods.add(method);
        IResource resource = type.getResource();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, method, methodBinding, info, 0);
        } else {
            ClassScope scope;
            if (declaringClass instanceof ParameterizedTypeBinding) {
                declaringClass = ((ParameterizedTypeBinding)declaringClass).type;
            }
            if ((scope = ((SourceTypeBinding)declaringClass).scope) != null) {
                TypeDeclaration typeDecl = scope.referenceContext;
                AbstractMethodDeclaration methodDecl = null;
                AbstractMethodDeclaration[] methodDecls = typeDecl.methods;
                int i2 = 0;
                int length = methodDecls.length;
                while (i2 < length) {
                    if (CharOperation.equals(bindingSelector, methodDecls[i2].selector)) {
                        methodDecl = methodDecls[i2];
                        break;
                    }
                    ++i2;
                }
                if (methodDecl != null) {
                    int offset = methodDecl.sourceStart;
                    MethodBinding binding = methodDecl.binding;
                    if (binding != null) {
                        method = (IMethod)((Object)((JavaElement)((Object)method)).resolved(binding));
                    }
                    this.match = new MethodDeclarationMatch(method, 0, offset, methodDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                    locator.report(this.match);
                }
            }
        }
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences) {
            if (possibleMatchingNode instanceof MessageSend) {
                return this.resolveLevel((MessageSend)possibleMatchingNode);
            }
            if (possibleMatchingNode instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)possibleMatchingNode;
                return this.resolveLevel(annotation.memberValuePairs()[0].binding);
            }
            if (possibleMatchingNode instanceof MemberValuePair) {
                MemberValuePair memberValuePair = (MemberValuePair)possibleMatchingNode;
                return this.resolveLevel(memberValuePair.binding);
            }
        }
        if (this.pattern.findDeclarations && possibleMatchingNode instanceof MethodDeclaration) {
            return this.resolveLevel(((MethodDeclaration)possibleMatchingNode).binding);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        boolean subType;
        char[] qualifiedPattern;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        boolean skipVerif = this.pattern.findDeclarations && this.mayBeGeneric;
        int methodLevel = this.matchMethod(method, skipVerif);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), skipVerif);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if ((qualifiedPattern = MethodLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification)) == null) {
            return methodLevel;
        }
        boolean bl = subType = !method.isStatic() && !method.isPrivate();
        if (subType && this.pattern.declaringQualification != null && method.declaringClass != null && method.declaringClass.fPackage != null) {
            subType = CharOperation.compareWith(this.pattern.declaringQualification, method.declaringClass.fPackage.shortReadableName()) == 0;
        }
        int declaringLevel = subType ? this.resolveLevelAsSubtype(qualifiedPattern, method.declaringClass) : this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int declaringLevel;
        char[] qualifiedPattern;
        MethodBinding method = messageSend.binding;
        if (method == null) {
            return 1;
        }
        if (messageSend.resolvedType == null) {
            int argLength;
            int n = argLength = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (this.pattern.parameterSimpleNames == null || argLength == this.pattern.parameterSimpleNames.length) {
                return 1;
            }
            return 0;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if ((qualifiedPattern = MethodLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification)) == null) {
            return methodLevel;
        }
        if (this.isVirtualInvoke(method, messageSend) && !(messageSend.actualReceiverType instanceof ArrayBinding)) {
            declaringLevel = this.resolveLevelAsSubtype(qualifiedPattern, method.declaringClass);
            if (declaringLevel == 0) {
                if (method.declaringClass == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][] compoundName = method.declaringClass.compoundName;
                    int i = 0;
                    int max = this.allSuperDeclaringTypeNames.length;
                    while (i < max) {
                        if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], compoundName)) {
                            return methodLevel;
                        }
                        ++i;
                    }
                }
            }
        } else {
            declaringLevel = this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        }
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevelAsSubtype(char[] qualifiedPattern, ReferenceBinding type) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(qualifiedPattern, type);
        if (level != 0) {
            return level;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (level = this.resolveLevelAsSubtype(qualifiedPattern, type.superclass())) != 0) {
            return level;
        }
        ReferenceBinding[] interfaces = type.superInterfaces();
        if (interfaces == null) {
            return 1;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelAsSubtype(qualifiedPattern, interfaces[i]);
            if (level != 0) {
                return level;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

