/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class RetrieverAction
extends Action {
    public void run() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return;
        }
        RetrieverQuery query = new RetrieverQuery(page);
        RetrieverPage.initializeQuery(query);
        if (this.modifyQuery(query)) {
            String searchPattern = query.getSearchText();
            NewSearchUI.runQueryInBackground(query);
            if (searchPattern == null || searchPattern.length() == 0) {
                SearchView view = (SearchView)InternalSearchUI.getInstance().getSearchViewManager().activateSearchView(true);
                view.showEmptySearchPage("org.eclipse.search.text.RetrieverPage");
            }
        }
    }

    protected abstract boolean modifyQuery(RetrieverQuery var1);

    protected abstract IWorkbenchPage getWorkbenchPage();

    protected final String extractSearchTextFromEditor(IEditorPart editor) {
        if (editor != null) {
            ISelection s;
            ITextSelection selection = null;
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider != null && (s = provider.getSelection()) instanceof ITextSelection) {
                selection = (ITextSelection)s;
            }
            if (selection != null) {
                ITextEditor txtEditor;
                if (selection.getLength() == 0 && (txtEditor = this.getTextEditor(editor)) != null) {
                    IDocument document = txtEditor.getDocumentProvider().getDocument((Object)txtEditor.getEditorInput());
                    selection = this.expandSelection(selection, document, null);
                }
                if (selection.getLength() > 0 && selection.getText() != null) {
                    return this.trimSearchString(selection.getText());
                }
            }
        }
        return null;
    }

    protected final String extractSearchTextFromSelection(ISelection sel) {
        String text;
        if (sel instanceof ITextSelection && (text = ((ITextSelection)sel).getText()) != null) {
            return this.trimSearchString(text);
        }
        return null;
    }

    private String trimSearchString(String text) {
        int idx = text.indexOf(10);
        int idx2 = text.indexOf(13);
        if (idx2 >= 0 && idx2 < idx) {
            idx = idx2;
        }
        if (idx >= 0) {
            text = text.substring(0, idx);
        }
        return text.trim();
    }

    private ITextEditor getTextEditor(IEditorPart editor) {
        FormEditor me;
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        if (editor instanceof FormEditor && (editor = (me = (FormEditor)editor).getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    private ITextSelection expandSelection(ITextSelection sel, IDocument document, String stopChars) {
        char ch;
        int a;
        int offset = sel.getOffset();
        int length = sel.getLength();
        if (length == 0) {
            char chr = '\u0000';
            char chl = '\u0000';
            try {
                chr = document.getChar(offset);
            }
            catch (BadLocationException badLocationException) {}
            try {
                chl = document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {}
            if (this.isPartOfIdentifier(chr)) {
                length = 1;
            } else if (this.isPartOfIdentifier(chl)) {
                --offset;
                length = 1;
            } else if (stopChars != null && stopChars.indexOf(chr) == -1) {
                length = 1;
            } else if (stopChars != null && stopChars.indexOf(chl) == -1) {
                --offset;
                length = 1;
            } else {
                return sel;
            }
        }
        int z = a = offset + length - 1;
        try {
            ch = document.getChar(z);
            while (this.isValidChar(stopChars, ch)) {
                ch = document.getChar(++z);
            }
        }
        catch (BadLocationException badLocationException) {}
        try {
            ch = document.getChar(a);
            while (this.isValidChar(stopChars, ch)) {
                ch = document.getChar(--a);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (a == z) {
            offset = a;
            length = 0;
        } else {
            offset = a + 1;
            length = z - a - 1;
        }
        return new TextSelection(document, offset, length);
    }

    private boolean isValidChar(String stopChars, char ch) {
        return stopChars == null ? this.isPartOfIdentifier(ch) : stopChars.indexOf(ch) == -1;
    }

    private boolean isPartOfIdentifier(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }
}

