/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.text.EditorOpener;
import org.eclipse.search.internal.ui.text.NewTextSearchActionGroup;
import org.eclipse.search.internal.ui.text.ResourceTransferDragAdapter;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.basic.views.SetLayoutAction;
import org.eclipse.search2.internal.ui.text2.FilterMatchEvent;
import org.eclipse.search2.internal.ui.text2.FlatFileSorter;
import org.eclipse.search2.internal.ui.text2.HierarchicalFileSorter;
import org.eclipse.search2.internal.ui.text2.IFileSorter;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverContentProvider;
import org.eclipse.search2.internal.ui.text2.RetrieverFilter;
import org.eclipse.search2.internal.ui.text2.RetrieverFilterTab;
import org.eclipse.search2.internal.ui.text2.RetrieverFindTab;
import org.eclipse.search2.internal.ui.text2.RetrieverLabelProvider;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.search2.internal.ui.text2.RetrieverReplaceTab;
import org.eclipse.search2.internal.ui.text2.RetrieverResult;
import org.eclipse.search2.internal.ui.text2.RetrieverTreeViewer;
import org.eclipse.search2.internal.ui.text2.RetrieverViewerSorter;
import org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class RetrieverPage
extends AbstractTextSearchViewPage
implements IQueryListener,
IRetrieverKeys {
    public static final String ID = "org.eclipse.search.text.RetrieverPage";
    private static final String QUERY_EXTENSION = ".query";
    private static final Collator COLLATOR = Collator.getInstance();
    static String sLastSearchPattern;
    static boolean sLastIsCaseSensitive;
    static boolean sLastIsRegularExpression;
    static boolean sLastIsWholeWord;
    static boolean sLastConsiderDerivedResources;
    static boolean sLastUseCaseSensitiveFilePatterns;
    static boolean sLastUseFlatLayout;
    static IScopeDescription sLastScope;
    static String sLastFilePatterns;
    private RetrieverFindTab fSearchControl = new RetrieverFindTab(this);
    private RetrieverFilterTab fFilterControl = new RetrieverFilterTab(this);
    private RetrieverReplaceTab fReplaceControl = new RetrieverReplaceTab(this);
    private IDialogSettings fDialogSettings;
    private boolean fSearchInProgress = false;
    private SashForm fSplitter;
    private ViewForm fResultForm;
    private ViewForm fInputForm;
    private TabFolder fTabFolder;
    private SetLayoutAction fFlatAction;
    private SetLayoutAction fHierarchicalAction;
    private Action fEnableFilter;
    private Action fUseCaseSensitiveFilePatterns;
    private Action fConsiderDerivedResources;
    private RetrieverContentProvider fContentProvider;
    private EditorOpener fEditorOpener = new EditorOpener();
    private Action fLoadAction;
    private Action fStoreAction;
    private Action fCreateWSAction;
    private ActionGroup fActionGroup;
    private RetrieverViewerSorter fSorter;
    private boolean fUseFlatLayout;
    private RetrieverLabelProvider fLabelProvider;
    private ISearchResultViewPart fViewPart;
    private RetrieverFilter fRecentFilter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RetrieverPage() {
        super(2);
    }

    public void createControl(Composite parent) {
        IDialogSettings ds = SearchPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = ds.getSection(this.getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = ds.addNewSection(this.getClass().getName());
        }
        this.restoreCurrentLayout();
        this.fSplitter = new SashForm(parent, 256);
        this.fSplitter.setLayoutData((Object)new GridData(768));
        this.fResultForm = new ViewForm((Composite)this.fSplitter, 0);
        super.createControl((Composite)this.fResultForm);
        this.fResultForm.setContent(super.getControl());
        this.fInputForm = new ViewForm((Composite)this.fSplitter, 0);
        this.fInputForm.setContent(this.createInputControl((Composite)this.fInputForm));
        this.fSplitter.setWeights(new int[]{60, 40});
        this.createListeners();
        this.restoreValues();
    }

    public Control getControl() {
        return this.fSplitter;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.createActions();
        IActionBars actionBars = pageSite.getActionBars();
        IMenuManager mm = actionBars.getMenuManager();
        mm.appendToGroup("group.new", (IAction)this.fLoadAction);
        mm.appendToGroup("group.new", (IAction)this.fStoreAction);
        mm.appendToGroup("group.show", (IAction)this.fEnableFilter);
        mm.appendToGroup("group.show", (IAction)this.fCreateWSAction);
        mm.appendToGroup("group.search", (IAction)this.fUseCaseSensitiveFilePatterns);
        mm.appendToGroup("group.search", (IAction)this.fConsiderDerivedResources);
        mm.appendToGroup("group.viewerSetup", (IAction)this.fFlatAction);
        mm.appendToGroup("group.viewerSetup", (IAction)this.fHierarchicalAction);
        actionBars.updateActionBars();
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        tbm.appendToGroup("group.show", (IAction)this.fEnableFilter);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fViewPart = part;
        this.fActionGroup = new NewTextSearchActionGroup(part);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        NewSearchUI.removeQueryListener(this);
        this.fSearchControl.dispose();
        this.fFilterControl = null;
        super.dispose();
    }

    public void setLayout(int layout) {
        boolean flat;
        boolean bl = flat = (layout & 1) != 0;
        if (this.fUseFlatLayout != flat) {
            this.onChangeLayout(flat);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (sel.getFirstElement() instanceof IFile) {
            this.fActionGroup.setContext(new ActionContext((ISelection)sel));
            this.fActionGroup.fillContextMenu(mgr);
        }
        if (!this.fSearchInProgress) {
            this.fReplaceControl.fillContextMenu(mgr);
        }
    }

    public void setFocus() {
        this.fSearchControl.setFocus();
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof RetrieverLine) {
            return ((RetrieverLine)element).getDisplayedMatchCount();
        }
        return 0;
    }

    public Match[] getDisplayedMatches(Object element) {
        if (element instanceof RetrieverLine) {
            return ((RetrieverLine)element).getDisplayedMatches();
        }
        return EMPTY_MATCH_ARRAY;
    }

    private Control createInputControl(Composite parent) {
        this.fTabFolder = new TabFolder(parent, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(768));
        this.fTabFolder.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite sc = this.createScrolledComposite((Composite)this.fTabFolder);
        this.fSearchControl.createControl((Composite)sc.getContent());
        this.setMinSize(sc);
        this.createTabItem(this.fTabFolder, (Control)sc, SearchMessages.RetrieverPage_FindTab_text);
        sc = this.createScrolledComposite((Composite)this.fTabFolder);
        this.fFilterControl.createControl((Composite)sc.getContent());
        this.setMinSize(sc);
        this.createTabItem(this.fTabFolder, (Control)sc, SearchMessages.RetrieverPage_FilterTab_text);
        sc = this.createScrolledComposite((Composite)this.fTabFolder);
        this.fReplaceControl.createControl((Composite)sc.getContent());
        this.setMinSize(sc);
        this.createTabItem(this.fTabFolder, (Control)sc, SearchMessages.RetrieverPage_ReplaceTab_text);
        return this.fTabFolder;
    }

    private void setMinSize(ScrolledComposite sc) {
        sc.setMinSize(sc.getContent().computeSize(-1, -1));
    }

    private void createTabItem(TabFolder folder, Control content, String text) {
        TabItem tabItem = new TabItem(folder, 0);
        tabItem.setText(text);
        tabItem.setControl(content);
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)new GridData(1808));
        sc.setLayout((Layout)new GridLayout(1, true));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(1, true));
        return sc;
    }

    private void createListeners() {
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.this.onTabChanged();
            }
        });
        this.fSearchControl.createListeners();
        this.fFilterControl.createListeners();
        this.fReplaceControl.createListeners((Viewer)this.getViewer());
        NewSearchUI.addQueryListener(this);
    }

    private void createActions() {
        this.fReplaceControl.createActions();
        this.fFlatAction = new SetLayoutAction(this, SearchMessages.AbstractTextSearchViewPage_flat_layout_label, SearchMessages.AbstractTextSearchViewPage_flat_layout_tooltip, 1);
        this.fHierarchicalAction = new SetLayoutAction(this, SearchMessages.AbstractTextSearchViewPage_hierarchical_layout_label, SearchMessages.AbstractTextSearchViewPage_hierarchical_layout_tooltip, 2);
        SearchPluginImages.setImageDescriptors((IAction)this.fFlatAction, "lcl16/", "org.eclipse.search.ui.flatLayout.gif");
        SearchPluginImages.setImageDescriptors((IAction)this.fHierarchicalAction, "lcl16/", "org.eclipse.search.ui.hierarchicalLayout.gif");
        this.fEnableFilter = new Action(SearchMessages.RetrieverPage_EnableFilter_text, 2){

            public void run() {
                RetrieverPage.this.onEnableToolbarFilter(RetrieverPage.this.fEnableFilter.isChecked());
            }
        };
        this.fEnableFilter.setToolTipText(SearchMessages.RetrieverPage_EnableFilter_tooltip);
        SearchPluginImages.setImageDescriptors((IAction)this.fEnableFilter, "lcl16/", "org.eclipse.search.ui.filter_ps.gif");
        this.fLoadAction = new Action(){

            public void run() {
                RetrieverPage.this.onLoad();
            }
        };
        this.fLoadAction.setText(SearchMessages.RetrieverPage_LoadQuery_text);
        this.fLoadAction.setToolTipText(SearchMessages.RetrieverPage_LoadQuery_tooltip);
        this.fStoreAction = new Action(){

            public void run() {
                RetrieverPage.this.onStore();
            }
        };
        this.fStoreAction.setText(SearchMessages.RetrieverPage_SaveQuery_text);
        this.fStoreAction.setToolTipText(SearchMessages.RetrieverPage_SaveQuery_tooltip);
        this.fCreateWSAction = new Action(){

            public void run() {
                RetrieverPage.this.onCreateWorkingSet();
            }
        };
        this.fCreateWSAction.setText(SearchMessages.RetrieverPage_CreateWorkingSet_text);
        this.fCreateWSAction.setToolTipText(SearchMessages.RetrieverPage_CreateWorkingSet_tooltip);
        this.fUseCaseSensitiveFilePatterns = new Action(){

            public void run() {
                RetrieverPage.this.onUseCaseSensitiveFilePatterns();
            }
        };
        this.fUseCaseSensitiveFilePatterns.setText(SearchMessages.RetrieverPage_CaseSensitiveFilePatterns_text);
        this.fConsiderDerivedResources = new Action(){

            public void run() {
                RetrieverPage.this.onConsiderDerivedResources();
            }
        };
        this.fConsiderDerivedResources.setText(SearchMessages.RetrieverPage_ConsiderDerived_text);
    }

    protected void onConsiderDerivedResources() {
        sLastConsiderDerivedResources = this.fConsiderDerivedResources.isChecked();
    }

    protected void onUseCaseSensitiveFilePatterns() {
        sLastUseCaseSensitiveFilePatterns = this.fUseCaseSensitiveFilePatterns.isChecked();
    }

    private void onChangeLayout(boolean flat) {
        this.fUseFlatLayout = flat;
        this.fLabelProvider.setAppendFileContainer(flat);
        this.fContentProvider.setLayout(flat);
        this.getViewer().refresh();
        this.storeValues();
    }

    protected void onCreateWorkingSet() {
        Object[] lines = null;
        String searchString = null;
        AbstractTextSearchResult input = this.getInput();
        if (input != null) {
            lines = input.getElements();
            RetrieverQuery q = (RetrieverQuery)input.getQuery();
            if (q != null) {
                searchString = q.getSearchText();
            }
        }
        if (lines == null || searchString == null || lines.length < 1) {
            this.showError(SearchMessages.RetrieverPage_error_noResourcesForWorkingSet);
            return;
        }
        InputDialog dlg = new InputDialog(this.getSite().getShell(), SearchMessages.RetrieverPage_CreateWorkingsetDialog_title, SearchMessages.RetrieverPage_CreateWorkingSetDialog_description, "contains-" + searchString, null);
        if (dlg.open() == 0) {
            String name = dlg.getValue();
            IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet ws = wsm.getWorkingSet(name);
            if (ws != null && !this.showQuestion(SearchMessages.RetrieverPage_question_overwriteWorkingSet)) {
                this.onCreateWorkingSet();
                return;
            }
            HashSet<IFile> fileset = new HashSet<IFile>();
            int i = 0;
            while (i < lines.length) {
                RetrieverLine line = (RetrieverLine)lines[i];
                fileset.add(line.getParent());
                ++i;
            }
            IFile[] files = fileset.toArray(new IFile[fileset.size()]);
            if (ws == null) {
                ws = wsm.createWorkingSet(name, (IAdaptable[])files);
                ws.setId("org.eclipse.ui.resourceWorkingSetPage");
                wsm.addWorkingSet(ws);
            } else {
                ws.setElements((IAdaptable[])files);
            }
            wsm.addRecentWorkingSet(ws);
        }
    }

    protected void onLoad() {
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 4096);
        dlg.setFilterPath(SearchPlugin.getDefault().getStateLocation().toOSString());
        dlg.setFilterExtensions(new String[]{"*.query"});
        String path = dlg.open();
        if (path != null) {
            Properties props = new Properties();
            try {
                FileInputStream in = new FileInputStream(path);
                props.load(in);
                this.fSearchControl.restoreValues(props);
                this.fFilterControl.setProperties(props);
                this.fReplaceControl.setProperties(props);
            }
            catch (IOException e) {
                this.handleError(SearchMessages.RetrieverPage_error_cannotLoadQuery, e, true);
            }
            this.storeValues();
            this.onFilterTabChanged();
        }
    }

    protected void onStore() {
        Properties props = new Properties();
        this.fSearchControl.storeValues(props);
        this.fFilterControl.getProperties(props);
        this.fReplaceControl.getProperties(props);
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 8192);
        dlg.setFilterPath(SearchPlugin.getDefault().getStateLocation().toOSString());
        dlg.setFilterExtensions(new String[]{"*.query"});
        String path = dlg.open();
        if (path != null) {
            if (!path.endsWith(QUERY_EXTENSION)) {
                path = String.valueOf(path) + QUERY_EXTENSION;
            }
            try {
                FileOutputStream out = new FileOutputStream(path);
                props.store(out, "Query for retriever");
            }
            catch (IOException e) {
                this.handleError(SearchMessages.RetrieverPage_error_cannotStoreQuery, e, true);
            }
        }
    }

    protected void onTabChanged() {
        int idx = this.fTabFolder.getSelectionIndex();
        switch (idx) {
            case 0: {
                this.fSearchControl.onSelected();
                break;
            }
            case 1: {
                this.fFilterControl.onSelected();
                break;
            }
            case 2: {
                this.fReplaceControl.onSelected();
            }
        }
    }

    public void onFilterTabChanged() {
        RetrieverResult r = (RetrieverResult)this.getInput();
        if (r != null) {
            r.filter(this.fFilterControl.getFilter());
        }
        this.postEnsureSelection();
    }

    public void onEnableToolbarFilter(boolean enable) {
        this.fEnableFilter.setChecked(enable);
        this.fFilterControl.onEnableToolbarFilter(enable);
        this.onFilterTabChanged();
        this.storeValues();
        if (enable) {
            this.fTabFolder.setSelection(1);
            this.fFilterControl.onSelected();
        }
    }

    void showError(String errorTxt) {
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)SearchMessages.RetrieverPage_ErrorDialog_title, (String)errorTxt);
    }

    boolean showQuestion(String qtext) {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)SearchMessages.RetrieverPage_QuestionDialog_title, (String)qtext);
    }

    void showInformation(String itext) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)SearchMessages.RetrieverPage_InformationDialog_title, (String)itext);
    }

    void storeValues() {
        int[] weights = this.fSplitter.getWeights();
        this.fDialogSettings.put("splitter.w1", weights[0]);
        this.fDialogSettings.put("splitter.w2", weights[1]);
        this.fDialogSettings.put("filter-action", this.fEnableFilter.isChecked());
        this.fDialogSettings.put("consider-derived", this.fConsiderDerivedResources.isChecked());
        this.fDialogSettings.put("case-sensitive-file-patterns", this.fUseCaseSensitiveFilePatterns.isChecked());
        this.fDialogSettings.put("flat-layout", this.fUseFlatLayout);
        sLastUseFlatLayout = this.fUseFlatLayout;
        sLastConsiderDerivedResources = this.fConsiderDerivedResources.isChecked();
        sLastUseCaseSensitiveFilePatterns = this.fUseCaseSensitiveFilePatterns.isChecked();
        this.fSearchControl.storeValues();
        this.fFilterControl.storeValues();
        this.fReplaceControl.storeValues();
    }

    private void restoreCurrentLayout() {
        this.fUseFlatLayout = this.fDialogSettings.get("flat-layout") == null ? true : this.fDialogSettings.getBoolean("flat-layout");
    }

    private void restoreValues() {
        int[] weights = new int[2];
        try {
            weights[0] = this.fDialogSettings.getInt("splitter.w1");
            weights[1] = this.fDialogSettings.getInt("splitter.w2");
            this.fSplitter.setWeights(weights);
        }
        catch (Exception exception) {}
        this.restoreAction(this.fEnableFilter, "filter-action", false);
        this.restoreAction(this.fUseCaseSensitiveFilePatterns, "case-sensitive-file-patterns", false);
        this.restoreAction(this.fConsiderDerivedResources, "consider-derived", false);
        this.fSearchControl.restoreValues();
        this.fFilterControl.restoreValues(this.fEnableFilter.isChecked());
        this.fReplaceControl.restoreValues();
        this.fFlatAction.setChecked(this.fUseFlatLayout);
        this.fHierarchicalAction.setChecked(!this.fUseFlatLayout);
    }

    void storeButton(Button button, String key) {
        if (button != null) {
            this.fDialogSettings.put(key, button.getSelection());
        }
    }

    void storeValue(boolean val, String key) {
        this.fDialogSettings.put(key, val);
    }

    public void storeValue(String[] val, String key) {
        this.fDialogSettings.put(key, val);
    }

    void storeComboContent(Combo combo, String key, int maxItems) {
        String ckey = String.valueOf(key) + ".combo";
        String[] stored = this.fDialogSettings.getArray(ckey);
        if (stored == null) {
            stored = new String[]{};
        }
        String text = combo.getText();
        ArrayList<String> newElems = new ArrayList<String>();
        if (text.length() > 0) {
            newElems.add(text);
        }
        int i = 0;
        while (i < stored.length && newElems.size() < maxItems) {
            String elem = stored[i];
            if (!text.equals(elem)) {
                newElems.add(elem);
            }
            ++i;
        }
        String[] save = newElems.toArray(new String[newElems.size()]);
        this.fDialogSettings.put(ckey, save);
        this.fDialogSettings.put(key, text);
        combo.removeAll();
        combo.setItems(save);
        combo.setText(text);
    }

    void storeScope(IScopeDescription scope, String key) {
        IDialogSettings ds = this.fDialogSettings.addNewSection(key);
        ds.put("scope-descriptor-class", scope.getClass().getName());
        scope.store(ds);
    }

    boolean restoreValue(String key, boolean defaultValue) {
        if (this.fDialogSettings.get(key) != null) {
            defaultValue = this.fDialogSettings.getBoolean(key);
        }
        return defaultValue;
    }

    public String[] restoreValue(String key, String[] defaultValue) {
        String[] result = this.fDialogSettings.getArray(key);
        return result == null ? defaultValue : result;
    }

    void restoreButton(Button button, String key, boolean defaultValue) {
        if (button != null) {
            if (this.fDialogSettings.get(key) != null) {
                defaultValue = this.fDialogSettings.getBoolean(key);
            }
            button.setSelection(defaultValue);
        }
    }

    void restoreAction(Action button, String key, boolean defaultValue) {
        if (this.fDialogSettings.get(key) != null) {
            defaultValue = this.fDialogSettings.getBoolean(key);
        }
        button.setChecked(defaultValue);
    }

    void restoreCombo(Combo combo, String key, String def) {
        String text;
        String ckey = String.valueOf(key) + ".combo";
        String[] stored = this.fDialogSettings.getArray(ckey);
        if (stored != null && stored.length > 0) {
            combo.setItems(stored);
        }
        if ((text = this.fDialogSettings.get(key)) == null) {
            text = def;
        }
        if (text != null && text.length() > 0) {
            combo.setText(text);
        }
    }

    public IScopeDescription restoreScope(String key) {
        return RetrieverPage.getScope(this.fDialogSettings, key);
    }

    IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getViewer().getSelection();
    }

    void handleError(String emsg, Exception e, boolean show) {
        if (show) {
            this.showError(emsg);
        } else {
            SearchPlugin.log((IStatus)new Status(4, "org.eclipse.search", 1, emsg, (Throwable)e));
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new RetrieverTreeViewer(parent, 770);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.fLabelProvider = new RetrieverLabelProvider(this, 1);
        this.fLabelProvider.setAppendFileContainer(this.fUseFlatLayout);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.fLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new RetrieverContentProvider((RetrieverTreeViewer)viewer, this.fUseFlatLayout);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fSorter = new RetrieverViewerSorter((ILabelProvider)this.fLabelProvider);
        viewer.setSorter((ViewerSorter)this.fSorter);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                RetrieverPage.this.fContentProvider.onExpansionStateChange(event.getElement(), false);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                RetrieverPage.this.fContentProvider.onExpansionStateChange(event.getElement(), true);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RetrieverPage.this.fContentProvider.onSelectionChanged(event);
            }
        });
        this.addDragAdapters((StructuredViewer)viewer);
    }

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    public ISearchResultViewPart getViewPart() {
        return this.fViewPart;
    }

    public synchronized void setInput(ISearchResult result, Object viewState) {
        ISearchQuery query;
        this.fSearchInProgress = false;
        if (result != null && (query = result.getQuery()) instanceof RetrieverQuery) {
            RetrieverQuery rq = (RetrieverQuery)query;
            this.restoreFromQuery(rq);
            this.fSearchInProgress = NewSearchUI.isQueryRunning(query);
        }
        super.setInput(result, viewState);
        this.updateEnablementOnTabs();
        this.setFocus();
    }

    private void restoreFromQuery(RetrieverQuery rq) {
        this.fConsiderDerivedResources.setChecked(rq.getConsiderDerivedResources());
        this.fUseCaseSensitiveFilePatterns.setChecked(rq.getUseCaseSensitiveFilePatterns());
        this.fSearchControl.restoreFromQuery(rq);
        this.initFilter((RetrieverResult)rq.getSearchResult());
        this.fReplaceControl.setPattern(rq.createSearchPattern());
        String searchText = rq.getSearchText();
        if (searchText == null || searchText.length() == 0) {
            this.fTabFolder.setSelection(0);
        }
        this.storeValues();
    }

    private void updateEnablementOnTabs() {
        this.fSearchControl.updateEnablement(this.fSearchInProgress);
        this.fReplaceControl.updateEnablement(this.fSearchInProgress);
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        adapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)adapter);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            IFile file = result.getFileMatchAdapter().getFile(match.getElement());
            IEditorPart editor = this.fEditorOpener.open(file, activate);
            if (offset != 0 && length != 0) {
                if (editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    textEditor.selectAndReveal(offset, length);
                } else if (editor != null) {
                    this.showWithMarker(editor, file, offset, length);
                }
            }
        }
        this.fReplaceControl.updatePreview(null);
    }

    /*
     * Exception decompiling
     */
    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 122->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
    }

    public synchronized void queryStarting(ISearchQuery query) {
        AbstractTextSearchResult result = this.getInput();
        if (result != null && result.getQuery() == query) {
            this.fSearchInProgress = true;
            this.asyncUpdateEnablement();
        }
    }

    public synchronized void queryFinished(ISearchQuery query) {
        AbstractTextSearchResult result = this.getInput();
        if (result != null && result.getQuery() == query) {
            this.fSearchInProgress = false;
            this.asyncUpdateEnablement();
        }
    }

    private void asyncUpdateEnablement() {
        this.asyncExec(new Runnable(){

            public void run() {
                if (RetrieverPage.this.fFilterControl != null) {
                    RetrieverPage.this.updateEnablementOnTabs();
                }
            }
        });
    }

    private void asyncExec(Runnable runnable) {
        Display display = this.getSite().getShell().getDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static IDialogSettings createSection(IDialogSettings ds, String name) {
        IDialogSettings result = ds.getSection(name);
        if (result == null) {
            result = ds.addNewSection(name);
        }
        return result;
    }

    public static void initializeQuery(RetrieverQuery query) {
        if (sLastSearchPattern == null) {
            RetrieverPage.initializeLastQuery();
        }
        query.setSearchString(sLastSearchPattern);
        query.setIsCaseSensitive(sLastIsCaseSensitive);
        query.setIsRegularExpression(sLastIsRegularExpression);
        query.setIsWholeWord(sLastIsWholeWord);
        query.setSearchScope(sLastScope, sLastConsiderDerivedResources);
        query.setFilePatterns(sLastFilePatterns, sLastUseCaseSensitiveFilePatterns);
        query.setSearchOrder(RetrieverPage.getSorterForLayout(sLastUseFlatLayout));
    }

    private static void initializeLastQuery() {
        IDialogSettings ds = SearchPlugin.getDefault().getDialogSettings();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.search2.internal.ui.text2.RetrieverPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ds = RetrieverPage.createSection(ds, clazz.getName());
        sLastSearchPattern = RetrieverPage.getValue(ds, "search-string", null);
        sLastIsCaseSensitive = RetrieverPage.getValue(ds, "case-sensitive", false);
        sLastIsRegularExpression = RetrieverPage.getValue(ds, "regular-expression", false);
        sLastIsWholeWord = RetrieverPage.getValue(ds, "whole-word", true);
        sLastConsiderDerivedResources = RetrieverPage.getValue(ds, "consider-derived", false);
        sLastFilePatterns = RetrieverPage.getValue(ds, "file-patterns", "*.c,*.cpp,*.h,*.java");
        sLastUseCaseSensitiveFilePatterns = RetrieverPage.getValue(ds, "case-sensitive-file-patterns", false);
        sLastUseFlatLayout = RetrieverPage.getValue(ds, "flat-layout", false);
        sLastScope = RetrieverPage.getScope(ds, "search-scope");
    }

    private static String getValue(IDialogSettings ds, String key, String def) {
        String result = ds.get(key);
        return result == null ? def : result;
    }

    private static boolean getValue(IDialogSettings ds, String key, boolean def) {
        String result = ds.get(key);
        return result == null ? def : ds.getBoolean(key);
    }

    private static IScopeDescription getScope(IDialogSettings ds, String key) {
        if ((ds = ds.getSection(key)) != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String scopeDescClass = RetrieverPage.getValue(ds, "scope-descriptor-class", clazz.getName());
            try {
                IScopeDescription result = (IScopeDescription)Class.forName(scopeDescClass).newInstance();
                result.restore(ds);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new WorkspaceScopeDescription();
    }

    public void initFilter(RetrieverResult result) {
        RetrieverFilter filter = result.getFilter();
        if (filter == null) {
            result.filter(this.fFilterControl.getFilter());
        } else {
            this.fRecentFilter = filter;
            this.handleNewFilterFromResult();
        }
    }

    private void handleNewFilterFromResult() {
        this.fEnableFilter.setChecked(this.fFilterControl.restoreFromResult(this.fRecentFilter));
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        RetrieverFilter filter;
        super.handleSearchResultChanged(e);
        if (e instanceof FilterMatchEvent && (filter = ((RetrieverResult)e.getSearchResult()).getFilter()) != this.fRecentFilter) {
            this.fRecentFilter = filter;
            this.asyncExec(new Runnable(){

                public void run() {
                    if (RetrieverPage.this.fFilterControl != null) {
                        RetrieverPage.this.handleNewFilterFromResult();
                    }
                }
            });
        }
    }

    public IFileSorter getPreferredSearchOrder() {
        return RetrieverPage.getSorterForLayout(this.fUseFlatLayout);
    }

    private static IFileSorter getSorterForLayout(boolean useFlatLayout) {
        if (useFlatLayout) {
            return new FlatFileSorter(COLLATOR);
        }
        return new HierarchicalFileSorter(COLLATOR);
    }

    public String getLabel() {
        RetrieverResult result = (RetrieverResult)this.getInput();
        if (result == null) {
            return SearchMessages.RetrieverResult_noInput_label;
        }
        int[] matchCount = result.getDetailedMatchCount();
        String description = result.getLabel();
        if (matchCount[0] == matchCount[1]) {
            return description;
        }
        Integer fullCount = new Integer(matchCount[0]);
        Integer filterCount = new Integer(matchCount[1]);
        String filter = matchCount[0] == 1 ? SearchMessages.RetrieverPage_filterSingular : SearchMessages.RetrieverPage_filterPlural;
        return MessageFormat.format(filter, description, filterCount, fullCount);
    }
}

