/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.SearchMatchInformationProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.IFileSorter;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverMatch;
import org.eclipse.search2.internal.ui.text2.RetrieverResult;
import org.eclipse.search2.internal.ui.text2.RetrieverSearchScope;
import org.eclipse.search2.internal.ui.text2.SearchMatchInformationProviderRegistry;
import org.eclipse.ui.IWorkbenchPage;

public class RetrieverQuery
implements ISearchQuery,
IRetrieverKeys {
    private String fSearchPattern = "";
    private boolean fIsCaseSensitive;
    private boolean fIsRegularExpression;
    private boolean fIsWholeWord;
    private boolean fConsiderDerivedResources;
    private boolean fUseCaseSensitiveFilePatterns;
    private IScopeDescription fScope;
    private String[] fFilePatterns;
    private RetrieverLine fCurrentLine;
    private int fCurrentLineOffset;
    private RetrieverResult fResult;
    private ArrayList fLinesOfCurrentFile;
    private IWorkbenchPage fWorkbenchPage;
    private SearchMatchInformationProvider fScanner;
    private IFileSorter fSearchOrder;

    public RetrieverQuery(IWorkbenchPage page) {
        this.fWorkbenchPage = page;
    }

    public void setSearchString(String searchFor) {
        this.fSearchPattern = searchFor == null ? "" : searchFor;
    }

    public void setIsCaseSensitive(boolean isCaseSensitive) {
        this.fIsCaseSensitive = isCaseSensitive;
    }

    public void setIsRegularExpression(boolean isRegularExpression) {
        this.fIsRegularExpression = isRegularExpression;
    }

    public void setIsWholeWord(boolean isWholeWord) {
        this.fIsWholeWord = isWholeWord;
    }

    public void setSearchScope(IScopeDescription scope) {
        this.fScope = scope;
    }

    public void setSearchScope(IScopeDescription scope, boolean considerDerived) {
        this.fScope = scope;
        this.fConsiderDerivedResources = considerDerived;
    }

    public void setFilePatterns(String filePatterns, boolean caseSensitive) {
        this.fFilePatterns = filePatterns.split(",");
        this.fUseCaseSensitiveFilePatterns = caseSensitive;
    }

    public void setFilePatterns(String[] fileNamePatterns) {
        this.fFilePatterns = (String[])fileNamePatterns.clone();
    }

    public String getLabel() {
        return SearchMessages.RetrieverQuery_label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new RetrieverResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.fSearchPattern.length() == 0) {
            return Status.OK_STATUS;
        }
        if (this.fResult != null) {
            this.fResult.removeAll();
            this.fResult.setComplete(false);
        }
        MultiStatus resStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.RetrieverQuery_statusMessage, null);
        IFile[] files = this.fScope.getFiles(this.fWorkbenchPage);
        if (files == null) {
            TextSearchScope scope = this.createSearchScope(this.fWorkbenchPage);
            files = scope.evaluateFilesInScope(resStatus);
        }
        if (this.fSearchOrder != null) {
            this.fSearchOrder.sortFiles(files);
        }
        IStatus status = this.performSearch(monitor, files);
        resStatus.addAll(status);
        return resStatus;
    }

    private IStatus performSearch(IProgressMonitor monitor, IFile[] scope) {
        TextSearchEngine engine = TextSearchEngine.create();
        TextSearchRequestor requestor = this.createRequestor();
        Pattern searchPattern = this.createSearchPattern();
        if (this.fResult != null) {
            this.fResult.setComplete(false);
        }
        return engine.search(scope, requestor, searchPattern, monitor);
    }

    Pattern createSearchPattern() {
        return PatternConstructor.createPattern(this.fSearchPattern, this.fIsRegularExpression, false, this.fIsCaseSensitive, this.fIsWholeWord);
    }

    private TextSearchScope createSearchScope(IWorkbenchPage page) {
        RetrieverSearchScope scope = new RetrieverSearchScope(this.fScope.getRoots(page), this.fFilePatterns, this.fUseCaseSensitiveFilePatterns);
        scope.setVisitDerived(this.fConsiderDerivedResources);
        return scope;
    }

    private TextSearchRequestor createRequestor() {
        return new TextSearchRequestor(){

            public boolean acceptFile(IFile file) throws CoreException {
                RetrieverQuery.this.onAcceptFile(file);
                return true;
            }

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                RetrieverQuery.this.onAcceptPatternMatch(matchAccess);
                return true;
            }

            public void beginReporting() {
                RetrieverQuery.this.onBeginReporting();
            }

            public void endReporting() {
                RetrieverQuery.this.onEndReporting();
            }
        };
    }

    protected void onBeginReporting() {
        this.fLinesOfCurrentFile = new ArrayList();
        this.getSearchResult();
        this.fScanner = null;
        this.fCurrentLine = null;
    }

    protected void onAcceptFile(IFile file) {
        this.flushMatches();
        if (this.fScanner != null) {
            this.fScanner.reset();
        }
        this.fScanner = null;
        this.fCurrentLine = null;
    }

    protected void onAcceptPatternMatch(TextSearchMatchAccess matchAccess) {
        Object match;
        if (this.fScanner == null) {
            this.fScanner = this.selectScanner(matchAccess);
        }
        int offset = matchAccess.getMatchOffset();
        int length = matchAccess.getMatchLength();
        int kind = this.fScanner.getLocationKind(matchAccess);
        int shiftedkind = 1;
        if (kind >= 0 && kind < 32) {
            shiftedkind = 1 << kind;
        }
        this.setupCurrentLine(matchAccess);
        int column = offset - this.fCurrentLineOffset;
        int endcolumn = column + length;
        String original = null;
        if (this.fCurrentLine.getLength() >= endcolumn) {
            original = this.fCurrentLine.substring(column, endcolumn);
        } else {
            match = new StringBuffer(length);
            int end = offset + length;
            int i = offset;
            while (i < end) {
                ((StringBuffer)match).append(matchAccess.getFileContentChar(i));
                ++i;
            }
            original = ((StringBuffer)match).toString();
        }
        match = new RetrieverMatch(this.fCurrentLine, original, offset, length, column, shiftedkind);
        this.fCurrentLine.addMatch((RetrieverMatch)match);
    }

    protected void onEndReporting() {
        this.fResult.setComplete(true);
        this.flushMatches();
        if (this.fScanner != null) {
            this.fScanner.reset();
        }
        this.fScanner = null;
        this.fCurrentLine = null;
        this.fLinesOfCurrentFile = null;
    }

    private void setupCurrentLine(TextSearchMatchAccess match) {
        SearchMatchInformationProvider.LineInformation info = this.fScanner.getLineInformation(match);
        int lineNumber = info.getLineNumber();
        if (this.fCurrentLine == null || this.fCurrentLine.getLineNumber() != lineNumber) {
            this.fCurrentLineOffset = info.getLineOffset();
            int lineLength = Math.min(info.getLineLength(), 8192);
            int lineEndOffset = this.fCurrentLineOffset + lineLength;
            int matchEndOffset = match.getMatchOffset() + match.getMatchLength();
            StringBuffer lineData = new StringBuffer(lineLength);
            int i = this.fCurrentLineOffset;
            while (i < lineEndOffset) {
                lineData.append(match.getFileContentChar(i));
                ++i;
            }
            if (lineEndOffset > matchEndOffset && lineLength > 0) {
                char last = lineData.charAt(lineLength - 1);
                if (last == '\n') {
                    if (lineEndOffset > matchEndOffset + 1 && lineLength > 1 && lineData.charAt(lineLength - 2) == '\r') {
                        lineData.setLength(lineLength - 2);
                    } else {
                        lineData.setLength(lineLength - 1);
                    }
                } else if (last == '\r') {
                    lineData.setLength(lineLength - 1);
                }
            }
            this.fCurrentLine = new RetrieverLine(match.getFile(), lineNumber);
            this.fCurrentLine.setData(lineData.toString());
            this.fLinesOfCurrentFile.add(this.fCurrentLine);
        }
    }

    private void flushMatches() {
        if (!this.fLinesOfCurrentFile.isEmpty()) {
            this.fResult.setLinesForFile(this.fCurrentLine.getParent(), this.fLinesOfCurrentFile);
            this.fLinesOfCurrentFile.clear();
            this.fCurrentLine = null;
        }
    }

    private SearchMatchInformationProvider selectScanner(TextSearchMatchAccess matchAccess) {
        SearchMatchInformationProviderRegistry registry = SearchPlugin.getDefault().getSearchMatchInformationProviderRegistry();
        SearchMatchInformationProvider scanner = registry.findScanner(matchAccess.getFile());
        if (scanner == null) {
            scanner = registry.getLineNumberScanner();
        }
        return scanner;
    }

    public IScopeDescription getScopeDescription() {
        return this.fScope;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean isRegularExpression() {
        return this.fIsRegularExpression;
    }

    public boolean isWholeWord() {
        return this.fIsWholeWord;
    }

    public String getSearchText() {
        return this.fSearchPattern;
    }

    public boolean getUseCaseSensitiveFilePatterns() {
        return this.fUseCaseSensitiveFilePatterns;
    }

    public String getFilePatterns() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.fFilePatterns.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.fFilePatterns[i]);
            ++i;
        }
        return buffer.toString();
    }

    public boolean getConsiderDerivedResources() {
        return this.fConsiderDerivedResources;
    }

    public void searchAgain(Collection outdated, IProgressMonitor monitor) {
        this.performSearch(monitor, outdated.toArray(new IFile[outdated.size()]));
    }

    public void setSearchOrder(IFileSorter searchOrder) {
        this.fSearchOrder = searchOrder;
    }
}

