/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.ui.IWorkbenchPage;

public class SelectedResourcesScopeDescription
implements IScopeDescription {
    private static final String KEY_RESOURCES = "resources";
    private IResource[] fSelectedResources;

    public SelectedResourcesScopeDescription() {
    }

    public SelectedResourcesScopeDescription(IResource[] res, boolean copy) {
        this.fSelectedResources = copy ? (IResource[])res.clone() : res;
    }

    public IResource[] getRoots(IWorkbenchPage page) {
        return this.fSelectedResources == null ? ResourcesPlugin.getWorkspace().getRoot().getProjects() : this.fSelectedResources;
    }

    public void store(IDialogSettings section) {
        String[] paths = this.getPaths();
        section.put(KEY_RESOURCES, paths);
    }

    private String[] getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        IResource[] roots = this.getRoots(null);
        int i = 0;
        while (i < roots.length) {
            IResource res = roots[i];
            paths.add(res.getFullPath().toPortableString());
            ++i;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public void restore(IDialogSettings section) {
        String[] paths = section.getArray(KEY_RESOURCES);
        this.restoreFromPaths(paths);
    }

    private void restoreFromPaths(String[] paths) {
        if (paths != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < paths.length) {
                IPath path = Path.fromPortableString((String)paths[i]);
                IResource res = root.findMember(path);
                if (res != null) {
                    resources.add(res);
                }
                ++i;
            }
            this.fSelectedResources = resources.toArray(new IResource[resources.size()]);
        }
    }

    public void store(Properties props, String prefix) {
        String[] paths = this.getPaths();
        props.put(String.valueOf(prefix) + KEY_RESOURCES, paths);
    }

    public void restore(Properties props, String prefix) {
        Object paths = props.get(String.valueOf(prefix) + KEY_RESOURCES);
        if (paths instanceof String[]) {
            this.restoreFromPaths((String[])paths);
        }
    }

    public String getLabelForCombo() {
        return SearchMessages.SelectedResourcesScopeDescription_label;
    }

    public String getNameForDescription() {
        return SearchMessages.SelectedResourcesScopeDescription_name;
    }

    public IFile[] getFiles(IWorkbenchPage page) {
        return null;
    }

    public void setSelection(IResource[] resources) {
        this.fSelectedResources = resources;
    }
}

