/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.WindowWorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class WorkingSetScopeDescription
implements IScopeDescription {
    private static final String KEY_WORKING_SET_NAME = "workingset-name";
    private static final String KEY_LABEL = "workingset-label";
    private static final IResource[] EMPTY_ARRAY = new IResource[0];
    private String fWorkingSetName;
    private String fLabel;
    static /* synthetic */ Class class$0;

    public WorkingSetScopeDescription() {
    }

    public WorkingSetScopeDescription(IWorkingSet set) {
        this.fWorkingSetName = set.getName();
        this.fLabel = set.getLabel();
        if (set.isAggregateWorkingSet()) {
            this.computeLabel();
        }
    }

    private void computeLabel() {
        if (this.fWorkingSetName.startsWith("Aggregate:") && this.fWorkingSetName.charAt(this.fWorkingSetName.length() - 1) == ':') {
            this.fLabel = this.fWorkingSetName.substring(10, this.fWorkingSetName.length() - 1).replace(':', '+');
        }
    }

    public String getLabelForCombo() {
        return this.fLabel;
    }

    public String getNameForDescription() {
        return this.fLabel;
    }

    protected void setLabel(String label) {
        this.fLabel = label;
    }

    public IResource[] getRoots(IWorkbenchPage page) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet ws = workingSetManager.getWorkingSet(this.fWorkingSetName);
        return this.getRootsFromWorkingSet(ws);
    }

    protected IResource[] getRootsFromWorkingSet(IWorkingSet ws) {
        if (ws == null) {
            return EMPTY_ARRAY;
        }
        HashSet resources = new HashSet();
        this.getResources(ws.getElements(), resources);
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource r = (IResource)iter.next();
            IContainer parent = r.getParent();
            while (parent != null) {
                if (resources.contains(parent)) {
                    iter.remove();
                    parent = null;
                    continue;
                }
                parent = parent.getParent();
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public String getWorkingSetName() {
        return this.fWorkingSetName;
    }

    private void getResources(IAdaptable[] elements, Collection target) {
        int i = 0;
        while (i < elements.length) {
            IResource r;
            IAdaptable adaptable = elements[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                target.add(r);
            }
            ++i;
        }
    }

    public void restore(IDialogSettings section) {
        this.fWorkingSetName = section.get(KEY_WORKING_SET_NAME);
        this.fLabel = section.get(KEY_LABEL);
        if (this.fLabel == null) {
            this.fLabel = this.fWorkingSetName;
        }
    }

    public void store(IDialogSettings section) {
        section.put(KEY_WORKING_SET_NAME, this.fWorkingSetName);
        section.put(KEY_LABEL, this.fLabel);
    }

    public void store(Properties props, String prefix) {
        props.put(String.valueOf(prefix) + KEY_WORKING_SET_NAME, this.fWorkingSetName);
        props.put(String.valueOf(prefix) + KEY_LABEL, this.fLabel);
    }

    public void restore(Properties props, String prefix) {
        this.fWorkingSetName = (String)props.get(String.valueOf(prefix) + KEY_WORKING_SET_NAME);
        this.fLabel = (String)props.get(String.valueOf(prefix) + KEY_LABEL);
        if (this.fLabel == null) {
            this.fLabel = this.fWorkingSetName;
        }
    }

    public static IScopeDescription createWithDialog(IWorkbenchPage page, IScopeDescription scope) {
        WorkingSetScopeDescription wsetscope;
        String name;
        IWorkingSet ws;
        if (page == null) {
            return null;
        }
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(page.getWorkbenchWindow().getShell(), false);
        IScopeDescription result = null;
        if (scope instanceof WindowWorkingSetScopeDescription) {
            dialog.setSelection(new IWorkingSet[]{page.getAggregateWorkingSet()});
        } else if (scope instanceof WorkingSetScopeDescription && (ws = manager.getWorkingSet(name = (wsetscope = (WorkingSetScopeDescription)scope).getWorkingSetName())) != null) {
            dialog.setSelection(new IWorkingSet[]{ws});
        }
        if (dialog.open() == 0) {
            IWorkingSet[] wsarray = dialog.getSelection();
            if (wsarray != null && wsarray.length > 0) {
                IWorkingSet ws2 = wsarray[0];
                if (ws2 == page.getAggregateWorkingSet()) {
                    result = new WindowWorkingSetScopeDescription();
                } else {
                    result = new WorkingSetScopeDescription(ws2);
                    manager.addRecentWorkingSet(ws2);
                }
            } else {
                result = new WorkspaceScopeDescription();
            }
        }
        return result;
    }

    public IFile[] getFiles(IWorkbenchPage page) {
        return null;
    }
}

