/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWindowTrim;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditActionSetsAction;
import org.eclipse.ui.internal.IReorderListener;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.PerspectiveBarNewContributionItem;
import org.eclipse.ui.internal.ResetPerspectiveAction;
import org.eclipse.ui.internal.SavePerspectiveAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.layout.CacheWrapper;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.PresentationUtil;

public class PerspectiveSwitcher
implements IWindowTrim {
    private IWorkbenchWindow window;
    private CBanner topBar;
    private int style;
    private Composite parent;
    private Composite trimControl;
    private Label trimSeparator;
    private GridData trimLayoutData;
    private boolean trimVisible = false;
    private int trimOldLength = 0;
    private PerspectiveBarManager perspectiveBar;
    private CoolBar perspectiveCoolBar;
    private CacheWrapper perspectiveCoolBarWrapper;
    private CoolItem coolItem;
    private CacheWrapper toolbarWrapper;
    private Menu popupMenu;
    private Menu genericMenu;
    private static final int INITIAL = -1;
    private static final int TOP_RIGHT = 1;
    private static final int TOP_LEFT = 2;
    private static final int LEFT = 3;
    private static final int DEFAULT_RIGHT_X = 160;
    private int currentLocation = -1;
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private IPropertyChangeListener propertyChangeListener;
    private Listener popupListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 35) {
                PerspectiveSwitcher.this.showPerspectiveBarPopup(new Point(event.x, event.y));
            }
        }
    };
    private PerspectiveAdapter perspectiveAdapter = new PerspectiveAdapter(){

        public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.addPerspectiveShortcut(perspective, page);
        }

        public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.removePerspectiveShortcut(perspective, page);
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(perspective, page, true);
        }

        public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(perspective, page, false);
        }

        public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
            PerspectiveSwitcher.this.updatePerspectiveShortcut(oldPerspective, newPerspective, page);
        }
    };
    private Listener dragListener;
    private IDragOverListener dragTarget;
    private IDragOverListener externalDragTarget;
    private DisposeListener toolBarListener;
    private IReorderListener reorderListener;

    public PerspectiveSwitcher(IWorkbenchWindow window, CBanner topBar, int style) {
        this.window = window;
        this.topBar = topBar;
        this.style = style;
        this.setPropertyChangeListener();
        this.toolBarListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.dispose();
            }
        };
        window.addPerspectiveListener(this.perspectiveAdapter);
    }

    private static int convertLocation(String preference) {
        if ("topRight".equals(preference)) {
            return 1;
        }
        if ("topLeft".equals(preference)) {
            return 2;
        }
        if ("left".equals(preference)) {
            return 3;
        }
        return 1;
    }

    public void createControl(Composite parent) {
        Assert.isTrue((this.parent == null ? 1 : 0) != 0);
        this.parent = parent;
        this.setPerspectiveBarLocation(PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR"));
    }

    private void addPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage workbenchPage) {
        if (this.perspectiveBar == null) {
            return;
        }
        PerspectiveBarContributionItem item = new PerspectiveBarContributionItem(perspective, workbenchPage);
        this.perspectiveBar.addItem(item);
        this.setCoolItemSize(this.coolItem);
        if (this.perspectiveBar != null) {
            this.perspectiveBar.update(true);
        }
    }

    public IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return null;
        }
        IContributionItem[] items = this.perspectiveBar.getItems();
        int length = items.length;
        int i = 0;
        while (i < length) {
            IContributionItem item = items[i];
            if (item instanceof PerspectiveBarContributionItem && ((PerspectiveBarContributionItem)item).handles(perspective, page)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void removePerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return;
        }
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            if (item instanceof PerspectiveBarContributionItem) {
                this.perspectiveBar.removeItem((PerspectiveBarContributionItem)item);
            }
            item.dispose();
            this.perspectiveBar.update(false);
            this.setCoolItemSize(this.coolItem);
        }
    }

    public void setPerspectiveBarLocation(String preference) {
        if (this.parent == null) {
            return;
        }
        int newLocation = PerspectiveSwitcher.convertLocation(preference);
        if (newLocation == this.currentLocation) {
            return;
        }
        this.createControlForLocation(newLocation);
        this.currentLocation = newLocation;
        this.showPerspectiveBar();
        if (newLocation == 2 || newLocation == 1) {
            this.updatePerspectiveBar();
            this.updateBarParent();
        }
    }

    private void showPerspectiveBar() {
        switch (this.currentLocation) {
            case 2: {
                this.topBar.setRight(null);
                this.topBar.setBottom((Control)this.perspectiveCoolBarWrapper.getControl());
                break;
            }
            case 1: {
                this.topBar.setBottom(null);
                this.topBar.setRight((Control)this.perspectiveCoolBarWrapper.getControl());
                this.topBar.setRightWidth(160);
                break;
            }
            case 3: {
                this.topBar.setBottom(null);
                this.topBar.setRight(null);
                LayoutUtil.resize((Control)this.topBar);
                this.window.getTrimManager().addTrim(16384, this);
                break;
            }
            default: {
                return;
            }
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    public void update(boolean force) {
        if (this.perspectiveBar == null) {
            return;
        }
        this.perspectiveBar.update(force);
        if (this.currentLocation == 3) {
            boolean shouldExpand;
            ToolItem[] items = this.perspectiveBar.getControl().getItems();
            boolean bl = shouldExpand = items.length > 0;
            if (shouldExpand != this.trimVisible) {
                this.perspectiveBar.getControl().setVisible(true);
                this.trimVisible = shouldExpand;
            }
            if (items.length != this.trimOldLength) {
                LayoutUtil.resize((Control)this.trimControl);
                this.trimOldLength = items.length;
            }
        }
    }

    private void selectPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page, boolean selected) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            if (selected) {
                PerspectiveBarContributionItem contribItem = (PerspectiveBarContributionItem)item;
                this.perspectiveBar.select(contribItem);
            }
            ((PerspectiveBarContributionItem)item).setSelection(selected);
        }
    }

    private void updatePerspectiveShortcut(IPerspectiveDescriptor oldDesc, IPerspectiveDescriptor newDesc, IWorkbenchPage page) {
        IContributionItem item = this.findPerspectiveShortcut(oldDesc, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            ((PerspectiveBarContributionItem)item).update(newDesc);
        }
    }

    public PerspectiveBarManager getPerspectiveBar() {
        return this.perspectiveBar;
    }

    public void dispose() {
        this.window.removePerspectiveListener(this.perspectiveAdapter);
        if (this.propertyChangeListener != null) {
            this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.unhookDragSupport();
        this.toolBarListener = null;
    }

    private void disposeChildControls() {
        if (this.trimControl != null) {
            this.trimControl.dispose();
            this.trimControl = null;
        }
        if (this.trimSeparator != null) {
            this.trimSeparator.dispose();
            this.trimSeparator = null;
        }
        if (this.perspectiveCoolBar != null) {
            this.perspectiveCoolBar.dispose();
            this.perspectiveCoolBar = null;
        }
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.dispose();
            this.perspectiveBar = null;
        }
        this.perspectiveCoolBarWrapper = null;
    }

    private void createControlForLocation(int newLocation) {
        if (this.perspectiveBar != null && this.perspectiveBar.getControl() != null && !this.perspectiveBar.getControl().isDisposed()) {
            if (newLocation == 3 && this.currentLocation == 3) {
                return;
            }
            if (!(newLocation != 2 && newLocation != 1 || this.currentLocation != 2 && this.currentLocation != 1)) {
                return;
            }
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.getControl().removeDisposeListener(this.toolBarListener);
            this.unhookDragSupport();
        }
        this.window.getTrimManager().removeTrim(this);
        this.disposeChildControls();
        if (newLocation == 3) {
            this.createControlForLeft();
        } else {
            this.createControlForTop();
        }
        this.hookDragSupport();
        this.perspectiveBar.getControl().addDisposeListener(this.toolBarListener);
    }

    private void unhookDragSupport() {
        ToolBar bar = this.perspectiveBar.getControl();
        if (bar == null || bar.isDisposed() || this.dragListener == null) {
            return;
        }
        PresentationUtil.removeDragListener((Control)bar, this.dragListener);
        DragUtil.removeDragTarget((Control)this.perspectiveBar.getControl(), this.dragTarget);
        DragUtil.removeDragTarget(null, this.externalDragTarget);
        this.dragListener = null;
        this.dragTarget = null;
        this.externalDragTarget = null;
    }

    private void hookDragSupport() {
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
                ToolBar toolbar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                ToolItem item = toolbar.getItem(new Point(event.x, event.y));
                if (item != null) {
                    if (item.getData() instanceof PerspectiveBarNewContributionItem) {
                        return;
                    }
                    Rectangle bounds = item.getBounds();
                    Rectangle parentBounds = toolbar.getBounds();
                    bounds.x += parentBounds.x;
                    bounds.y += parentBounds.y;
                    this.startDragging(item.getData(), toolbar.getDisplay().map((Control)toolbar, null, bounds));
                }
            }

            private void startDragging(Object widget, Rectangle bounds) {
                DragUtil.performDrag(widget, bounds, new Point(bounds.x, bounds.y), true);
            }
        };
        this.dragTarget = new IDragOverListener(){
            protected PerspectiveDropTarget perspectiveDropTarget;

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                if (draggedObject instanceof PerspectiveBarContributionItem) {
                    if (this.perspectiveDropTarget == null) {
                        this.perspectiveDropTarget = new PerspectiveDropTarget(draggedObject, position);
                    } else {
                        this.perspectiveDropTarget.update(draggedObject, position);
                    }
                    if (!this.perspectiveDropTarget.sameShell()) {
                        return null;
                    }
                    return this.perspectiveDropTarget;
                }
                return null;
            }

            class PerspectiveDropTarget
            extends AbstractDropTarget {
                private PerspectiveBarContributionItem perspective;
                private Point location;

                public PerspectiveDropTarget(Object draggedObject, Point location) {
                    this.update(draggedObject, location);
                }

                private void update(Object draggedObject, Point location) {
                    this.location = location;
                    this.perspective = (PerspectiveBarContributionItem)((Object)draggedObject);
                }

                public void drop() {
                    ToolBar toolBar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                    ToolItem item = toolBar.getItem(toolBar.getDisplay().map(null, (Control)toolBar, this.location));
                    if (toolBar.getItem(0) == item) {
                        return;
                    }
                    ToolItem[] items = toolBar.getItems();
                    ToolItem droppedItem = null;
                    int dropIndex = -1;
                    int i = 0;
                    while (i < items.length) {
                        if (item == items[i]) {
                            dropIndex = i;
                        }
                        if (items[i].getData() == this.perspective) {
                            droppedItem = items[i];
                        }
                        ++i;
                    }
                    if (dropIndex != -1 && droppedItem != null && droppedItem != item) {
                        PerspectiveBarContributionItem barItem = (PerspectiveBarContributionItem)((Object)droppedItem.getData());
                        if (PerspectiveSwitcher.this.reorderListener != null) {
                            PerspectiveSwitcher.this.reorderListener.reorder(barItem.getPerspective(), Math.abs(dropIndex - (items.length - 1)));
                        }
                        PerspectiveSwitcher.this.perspectiveBar.relocate(barItem, dropIndex);
                    }
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(5);
                }

                boolean sameShell() {
                    return this.perspective.getToolItem().getParent().getShell().equals(PerspectiveSwitcher.this.perspectiveBar.getControl().getShell());
                }

                /*
                 * WARNING - void declaration
                 */
                public Rectangle getSnapRectangle() {
                    void var3_3;
                    ToolBar toolBar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                    ToolItem item = toolBar.getItem(toolBar.getDisplay().map(null, (Control)toolBar, this.location));
                    if (item == null || item == toolBar.getItem(0)) {
                        return null;
                    }
                    Rectangle bounds = item.getBounds();
                    return toolBar.getDisplay().map((Control)toolBar, null, (Rectangle)var3_3);
                }
            }
        };
        this.externalDragTarget = new IDragOverListener(){
            protected ExternalPerspectiveDropTarget externalPerspectiveDropTarget;

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                if (draggedObject instanceof PerspectiveBarContributionItem) {
                    if (this.externalPerspectiveDropTarget == null) {
                        this.externalPerspectiveDropTarget = new ExternalPerspectiveDropTarget(draggedObject, position);
                    } else {
                        this.externalPerspectiveDropTarget.update(draggedObject, position);
                    }
                    return this.externalPerspectiveDropTarget;
                }
                return null;
            }

            class ExternalPerspectiveDropTarget
            extends AbstractDropTarget {
                private PerspectiveBarContributionItem perspective;
                private Rectangle rect;
                private Point location;

                public ExternalPerspectiveDropTarget(Object draggedObject, Point location) {
                    this.update(draggedObject, location);
                }

                private void update(Object draggedObject, Point location) {
                    this.location = location;
                    this.perspective = (PerspectiveBarContributionItem)((Object)draggedObject);
                }

                public void drop() {
                    IWorkbenchWindow workbenchWindow = Workbench.getInstance().getActiveWorkbenchWindow();
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    try {
                        workbenchWindow.getWorkbench().openWorkbenchWindow(this.perspective.getId(), page.getInput());
                    }
                    catch (WorkbenchException e) {
                        MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)WorkbenchMessages.OpenNewWindowMenu_dialogTitle, (String)e.getMessage());
                        return;
                    }
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(6);
                }

                public Rectangle getSnapRectangle() {
                    if (this.rect == null) {
                        IWorkbenchWindow workbenchWindow = Workbench.getInstance().getActiveWorkbenchWindow();
                        this.rect = workbenchWindow.getShell().getBounds();
                    }
                    this.rect.x = this.location.x;
                    this.rect.y = this.location.y;
                    return this.rect;
                }
            }
        };
        PresentationUtil.addDragListener((Control)this.perspectiveBar.getControl(), this.dragListener);
        DragUtil.addDragTarget((Control)this.perspectiveBar.getControl(), this.dragTarget);
        DragUtil.addDragTarget(null, this.externalDragTarget);
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                    if (PerspectiveSwitcher.this.perspectiveBar == null) {
                        return;
                    }
                    PerspectiveSwitcher.this.updatePerspectiveBar();
                    PerspectiveSwitcher.this.updateBarParent();
                }
            }
        };
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void createControlForLeft() {
        this.trimControl = new Composite(this.parent, 0);
        this.trimControl.setLayout((Layout)new CellLayout(1).setMargins(0, 0).setSpacing(3, 3).setDefaultRow(Row.fixed()).setDefaultColumn(Row.growing()));
        this.perspectiveBar = this.createBarManager(512);
        this.perspectiveBar.createControl(this.trimControl);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
        this.trimLayoutData = new GridData(1808);
        this.trimVisible = false;
        this.perspectiveBar.getControl().setLayoutData((Object)this.trimLayoutData);
    }

    private void createControlForTop() {
        this.perspectiveBar = this.createBarManager(256);
        this.perspectiveCoolBarWrapper = new CacheWrapper((Composite)this.topBar);
        this.perspectiveCoolBar = new CoolBar(this.perspectiveCoolBarWrapper.getControl(), 0x800000);
        this.coolItem = new CoolItem(this.perspectiveCoolBar, 4);
        this.toolbarWrapper = new CacheWrapper((Composite)this.perspectiveCoolBar);
        this.perspectiveBar.createControl(this.toolbarWrapper.getControl());
        this.coolItem.setControl((Control)this.toolbarWrapper.getControl());
        this.perspectiveCoolBar.setLocked(true);
        this.perspectiveBar.setParent(this.perspectiveCoolBar);
        this.perspectiveBar.update(true);
        this.perspectiveCoolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
            }
        });
        this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4 && PerspectiveSwitcher.this.perspectiveBar != null) {
                    PerspectiveSwitcher.this.perspectiveBar.handleChevron(e);
                }
            }
        });
        this.coolItem.setMinimumSize(0, 0);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
    }

    private void setCoolItemSize(CoolItem coolItem) {
        int rows;
        if (this.currentLocation == 3) {
            return;
        }
        ToolBar toolbar = this.perspectiveBar.getControl();
        if (toolbar == null) {
            return;
        }
        int rowHeight = 0;
        ToolItem[] toolItems = toolbar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            rowHeight = Math.max(rowHeight, toolItems[i].getBounds().height);
            ++i;
        }
        Rectangle area = this.perspectiveCoolBar.getClientArea();
        int n = rows = rowHeight <= 0 ? 1 : (int)Math.max(1.0, Math.floor(area.height / rowHeight));
        if (rows == 1 || (toolbar.getStyle() & 0x40) == 0 || this.currentLocation == 2) {
            Point p = toolbar.computeSize(-1, -1);
            coolItem.setSize(coolItem.computeSize(p.x, p.y));
            return;
        }
        Point offset = coolItem.computeSize(0, 0);
        Point wrappedSize = toolbar.computeSize(area.width - offset.x, -1);
        int h = rows * rowHeight;
        int w = wrappedSize.y <= h ? wrappedSize.x : wrappedSize.x + 1;
        coolItem.setSize(coolItem.computeSize(w, h));
    }

    private void showPerspectiveBarPopup(Point pt) {
        if (this.perspectiveBar == null) {
            return;
        }
        ToolBar toolBar = this.perspectiveBar.getControl();
        ToolItem toolItem = toolBar.getItem(toolBar.toControl(pt));
        Object data = null;
        if (toolItem != null) {
            data = toolItem.getData();
        }
        if (toolItem == null || !(data instanceof PerspectiveBarContributionItem)) {
            if (this.genericMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                this.addDockOnSubMenu(menu);
                this.addShowTextItem(menu);
                this.genericMenu = menu;
            }
            this.genericMenu.getItem(1).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
            this.updateLocationItems(this.genericMenu.getItem(0).getMenu(), this.currentLocation);
            this.genericMenu.setLocation(pt.x, pt.y);
            this.genericMenu.setVisible(true);
            return;
        }
        if (data == null || !(data instanceof PerspectiveBarContributionItem)) {
            return;
        }
        boolean selectedIsActive = this.selectedPerspectiveIsActive(data);
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopup(toolBar, selectedIsActive);
        }
        if (!selectedIsActive && this.popupMenu.getItemCount() > 5) {
            this.popupMenu.getItem(0).dispose();
            this.popupMenu.getItem(0).dispose();
            this.popupMenu.getItem(0).dispose();
        } else if (selectedIsActive && this.popupMenu.getItemCount() <= 5) {
            this.popupMenu.dispose();
            this.popupMenu = this.createPopup(toolBar, selectedIsActive);
        }
        this.popupMenu.setData((Object)toolItem);
        if (selectedIsActive) {
            this.popupMenu.getItem(7).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
            this.updateLocationItems(this.popupMenu.getItem(6).getMenu(), this.currentLocation);
        } else {
            this.popupMenu.getItem(4).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
            this.updateLocationItems(this.popupMenu.getItem(3).getMenu(), this.currentLocation);
        }
        this.popupMenu.setLocation(pt.x, pt.y);
        this.popupMenu.setVisible(true);
    }

    private boolean selectedPerspectiveIsActive(Object data) {
        if (data == null || data instanceof PerspectiveBarNewContributionItem) {
            return false;
        }
        IPerspectiveDescriptor perspectiveInFocus = ((PerspectiveBarContributionItem)((Object)data)).getPerspective();
        return perspectiveInFocus.equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective());
    }

    private Menu createPopup(ToolBar toolBar, boolean isActive) {
        Menu menu = new Menu((Control)toolBar);
        if (isActive) {
            this.addCustomizeItem(menu);
            this.addSaveAsItem(menu);
            this.addResetItem(menu);
        }
        this.addCloseItems(menu);
        new MenuItem(menu, 2);
        this.addDockOnSubMenu(menu);
        this.addShowTextItem(menu);
        return menu;
    }

    private void addCloseItems(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.close_page_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem perspectiveToolItem = (ToolItem)PerspectiveSwitcher.this.popupMenu.getData();
                if (perspectiveToolItem != null && !perspectiveToolItem.isDisposed()) {
                    PerspectiveBarContributionItem item = (PerspectiveBarContributionItem)((Object)perspectiveToolItem.getData());
                    item.getPage().closePerspective(item.getPerspective(), true, true);
                }
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_closeAll);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.close_all_pages_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem perspectiveToolItem = (ToolItem)PerspectiveSwitcher.this.popupMenu.getData();
                if (perspectiveToolItem != null && !perspectiveToolItem.isDisposed()) {
                    PerspectiveBarContributionItem item = (PerspectiveBarContributionItem)((Object)perspectiveToolItem.getData());
                    item.getPage().closeAllPerspectives(true, true);
                }
            }
        });
    }

    private PerspectiveBarManager createBarManager(int direction) {
        PerspectiveBarManager barManager = new PerspectiveBarManager(this.style | direction);
        barManager.add((IContributionItem)new PerspectiveBarNewContributionItem(this.window));
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenPerspectives();
            int i = 0;
            while (i < perspectives.length) {
                barManager.insert(1, (IContributionItem)new PerspectiveBarContributionItem(perspectives[i], page));
                ++i;
            }
        }
        return barManager;
    }

    private void updateLocationItems(Menu parent, int newLocation) {
        MenuItem topRight = parent.getItem(0);
        MenuItem topLeft = parent.getItem(1);
        MenuItem left = parent.getItem(2);
        if (newLocation == 3) {
            left.setSelection(true);
            topRight.setSelection(false);
            topLeft.setSelection(false);
        } else if (newLocation == 2) {
            topLeft.setSelection(true);
            left.setSelection(false);
            topRight.setSelection(false);
        } else {
            topRight.setSelection(true);
            left.setSelection(false);
            topLeft.setSelection(false);
        }
    }

    private void addDockOnSubMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText(WorkbenchMessages.PerspectiveSwitcher_dockOn);
        final Menu subMenu = new Menu(item);
        MenuItem menuItemTopRight = new MenuItem(subMenu, 16);
        menuItemTopRight.setText(WorkbenchMessages.PerspectiveSwitcher_topRight);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItemTopRight, "org.eclipse.ui.dock_on_perspective_action_context");
        final MenuItem menuItemTopLeft = new MenuItem(subMenu, 16);
        menuItemTopLeft.setText(WorkbenchMessages.PerspectiveSwitcher_topLeft);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItemTopLeft, "org.eclipse.ui.dock_on_perspective_action_context");
        final MenuItem menuItemLeft = new MenuItem(subMenu, 16);
        menuItemLeft.setText(WorkbenchMessages.PerspectiveSwitcher_left);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItemLeft, "org.eclipse.ui.dock_on_perspective_action_context");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                String pref = null;
                if (item.equals(menuItemLeft)) {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 3);
                    pref = "left";
                } else if (item.equals(menuItemTopLeft)) {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 2);
                    pref = "topLeft";
                } else {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 1);
                    pref = "topRight";
                }
                IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
                apiStore.setValue("DOCK_PERSPECTIVE_BAR", pref);
            }
        };
        menuItemTopRight.addSelectionListener((SelectionListener)listener);
        menuItemTopLeft.addSelectionListener((SelectionListener)listener);
        menuItemLeft.addSelectionListener((SelectionListener)listener);
        item.setMenu(subMenu);
    }

    private void addShowTextItem(Menu menu) {
        final MenuItem showtextMenuItem = new MenuItem(menu, 32);
        showtextMenuItem.setText(WorkbenchMessages.PerspectiveBar_showText);
        this.window.getWorkbench().getHelpSystem().setHelp(showtextMenuItem, "org.eclipse.ui.show_text_perspective_action_context");
        showtextMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                boolean preference = showtextMenuItem.getSelection();
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", preference);
            }
        });
    }

    private void addCustomizeItem(Menu menu) {
        MenuItem customizeMenuItem = new MenuItem(menu, 26);
        customizeMenuItem.setText(WorkbenchMessages.PerspectiveBar_customize);
        this.window.getWorkbench().getHelpSystem().setHelp(customizeMenuItem, "org.eclipse.ui.edit_action_sets_action_context");
        customizeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                EditActionSetsAction editAction = new EditActionSetsAction(PerspectiveSwitcher.this.window);
                editAction.setEnabled(true);
                editAction.run();
            }
        });
    }

    private void addSaveAsItem(Menu menu) {
        MenuItem saveasMenuItem = new MenuItem(menu, 26);
        saveasMenuItem.setText(WorkbenchMessages.PerspectiveBar_saveAs);
        this.window.getWorkbench().getHelpSystem().setHelp(saveasMenuItem, "org.eclipse.ui.save_perspective_action_context");
        saveasMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                SavePerspectiveAction saveAction = new SavePerspectiveAction(PerspectiveSwitcher.this.window);
                saveAction.setEnabled(true);
                saveAction.run();
            }
        });
    }

    private void addResetItem(Menu menu) {
        MenuItem resetMenuItem = new MenuItem(menu, 26);
        resetMenuItem.setText(WorkbenchMessages.PerspectiveBar_reset);
        this.window.getWorkbench().getHelpSystem().setHelp(resetMenuItem, "org.eclipse.ui.reset_perspective_action_context");
        resetMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                ResetPerspectiveAction resetAction = new ResetPerspectiveAction(PerspectiveSwitcher.this.window);
                resetAction.setEnabled(true);
                resetAction.run();
            }
        });
    }

    public void saveState(IMemento persBarMem) {
        IMemento childMem = persBarMem.createChild("itemSize");
        int x = this.currentLocation == 1 && this.topBar != null ? this.topBar.getRightWidth() : 160;
        childMem.putString("x", Integer.toString(x));
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento attributes = memento.getChild("perspectiveBar");
        IMemento size = null;
        if (attributes != null) {
            size = attributes.getChild("itemSize");
        }
        if (size != null && this.currentLocation == 1 && this.topBar != null) {
            Integer x = size.getInteger("x");
            if (x != null) {
                this.topBar.setRightWidth(x.intValue());
            } else {
                this.topBar.setRightWidth(160);
            }
        }
    }

    void updatePerspectiveBar() {
        IContributionItem[] items = this.perspectiveBar.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update();
            ++i;
        }
        this.perspectiveBar.arrangeToolbar();
        this.setCoolItemSize(this.coolItem);
        this.perspectiveBar.getControl().redraw();
    }

    public void updateBarParent() {
        if (this.perspectiveBar == null || this.perspectiveBar.getControl() == null) {
            return;
        }
        if (this.currentLocation == 1 && this.topBar != null) {
            int maxRowHeight = 0;
            ToolItem[] toolItems = this.perspectiveBar.getControl().getItems();
            int i = 0;
            while (i < toolItems.length) {
                maxRowHeight = Math.max(maxRowHeight, toolItems[i].getBounds().height);
                ++i;
            }
            this.topBar.setRightMinimumSize(new Point(-1, maxRowHeight));
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    public void addReorderListener(IReorderListener listener) {
        this.reorderListener = listener;
    }

    public void dock(int dropSide) {
    }

    public Control getControl() {
        return this.trimControl;
    }

    public String getId() {
        return "org.eclipse.ui.internal.PerspectiveSwitcher";
    }

    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_PerspectiveSwitcher_TrimName;
    }

    public int getValidSides() {
        return 0;
    }

    public boolean isCloseable() {
        return false;
    }

    public void handleClose() {
    }

    public int getWidthHint() {
        return -1;
    }

    public int getHeightHint() {
        return -1;
    }

    public boolean isResizeable() {
        return false;
    }
}

