/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.commands.PersistentState;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.util.PrefUtil;

public final class CommandService
implements ICommandService {
    private static final String PREFERENCE_KEY_PREFIX = "org.eclipse.ui.commands/state";
    private final CommandManager commandManager;
    private final CommandPersistence commandPersistence;

    static final String createPreferenceKey(Command command, String stateId) {
        return "org.eclipse.ui.commands/state/" + command.getId() + '/' + stateId;
    }

    public CommandService(CommandManager commandManager) {
        if (commandManager == null) {
            throw new NullPointerException("Cannot create a command service with a null manager");
        }
        this.commandManager = commandManager;
        this.commandPersistence = new CommandPersistence(this);
    }

    public final void addExecutionListener(IExecutionListener listener) {
        this.commandManager.addExecutionListener(listener);
    }

    public final void defineUncategorizedCategory(String name, String description) {
        this.commandManager.defineUncategorizedCategory(name, description);
    }

    public final ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
        return this.commandManager.deserialize(serializedParameterizedCommand);
    }

    public final void dispose() {
        this.commandPersistence.dispose();
        Command[] commands = this.commandManager.getAllCommands();
        int i = 0;
        while (i < commands.length) {
            Command command = commands[i];
            String[] stateIds = command.getStateIds();
            int j = 0;
            while (j < stateIds.length) {
                PersistentState persistentState;
                String stateId = stateIds[j];
                State state = command.getState(stateId);
                if (state instanceof PersistentState && (persistentState = (PersistentState)state).shouldPersist()) {
                    persistentState.save(PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, stateId));
                }
                ++j;
            }
            ++i;
        }
    }

    public final Category getCategory(String categoryId) {
        return this.commandManager.getCategory(categoryId);
    }

    public final Command getCommand(String commandId) {
        return this.commandManager.getCommand(commandId);
    }

    public final Category[] getDefinedCategories() {
        return this.commandManager.getDefinedCategories();
    }

    public final Collection getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    public final Collection getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    public final Command[] getDefinedCommands() {
        return this.commandManager.getDefinedCommands();
    }

    public Collection getDefinedParameterTypeIds() {
        return this.commandManager.getDefinedParameterTypeIds();
    }

    public ParameterType[] getDefinedParameterTypes() {
        return this.commandManager.getDefinedParameterTypes();
    }

    public ParameterType getParameterType(String parameterTypeId) {
        return this.commandManager.getParameterType(parameterTypeId);
    }

    public final void readRegistry() {
        this.commandPersistence.read();
    }

    public final void removeExecutionListener(IExecutionListener listener) {
        this.commandManager.removeExecutionListener(listener);
    }
}

