/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.dialogs.PatternItemFilter;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;

public class PreferencePatternFilter
extends PatternItemFilter {
    private Map keywordCache = new HashMap();

    public PreferencePatternFilter(boolean isMatchItem) {
        super(isMatchItem);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)viewer).getContentProvider();
        IPreferenceNode node = (IPreferenceNode)element;
        Object[] children = contentProvider.getChildren((Object)node);
        String text = node.getLabelText();
        if (this.wordMatches(text)) {
            return true;
        }
        if (this.matchItem && this.filter(viewer, element, children).length > 0) {
            return true;
        }
        return this.keywordMatches(node);
    }

    private boolean keywordMatches(Object element) {
        if (element instanceof WorkbenchPreferenceExtensionNode) {
            WorkbenchPreferenceExtensionNode workbenchNode = (WorkbenchPreferenceExtensionNode)element;
            Collection keywordCollection = (Collection)this.keywordCache.get(element);
            if (keywordCollection == null) {
                keywordCollection = workbenchNode.getKeywordLabels();
                this.keywordCache.put(element, keywordCollection);
            }
            if (keywordCollection.isEmpty()) {
                return false;
            }
            Iterator keywords = keywordCollection.iterator();
            while (keywords.hasNext()) {
                if (!this.wordMatches((String)keywords.next())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isElementSelectable(Object element) {
        return element instanceof WorkbenchPreferenceExtensionNode;
    }

    protected boolean isElementMatch(Viewer viewer, Object element) {
        IPreferenceNode node = (IPreferenceNode)element;
        String text = node.getLabelText();
        if (this.wordMatches(text)) {
            return true;
        }
        return this.keywordMatches(node);
    }
}

