/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public final class LegacyActionSetExpression
extends WorkbenchWindowExpression {
    private final String actionSetId;

    public LegacyActionSetExpression(String actionSetId, IWorkbenchWindow window) {
        super(window);
        if (actionSetId == null) {
            throw new NullPointerException("The action set identifier cannot be null");
        }
        this.actionSetId = actionSetId;
    }

    public final void collectExpressionInfo(ExpressionInfo info) {
        super.collectExpressionInfo(info);
        info.addVariableNameAccess("activeActionSets");
    }

    public final EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        EvaluationResult result = super.evaluate(context);
        if (result == EvaluationResult.FALSE) {
            return result;
        }
        Object variable = context.getVariable("activeActionSets");
        if (variable instanceof IActionSetDescriptor[]) {
            IActionSetDescriptor[] descriptors = (IActionSetDescriptor[])variable;
            int i = 0;
            while (i < descriptors.length) {
                IActionSetDescriptor descriptor = descriptors[i];
                String currentId = descriptor.getId();
                if (this.actionSetId.equals(currentId)) {
                    return EvaluationResult.TRUE;
                }
                ++i;
            }
        }
        return EvaluationResult.FALSE;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ActionSetExpression(");
        buffer.append(this.actionSetId);
        buffer.append(',');
        buffer.append(this.getWindow());
        buffer.append(')');
        return buffer.toString();
    }
}

