/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.commands.common.HandleObjectManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.menus.IMenuManagerListener;
import org.eclipse.ui.internal.menus.MenuManagerEvent;
import org.eclipse.ui.internal.menus.SActionSet;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SMenuLayout;
import org.eclipse.ui.internal.menus.SWidget;

public final class SMenuManager
extends HandleObjectManager
implements IPropertyChangeListener {
    private final Map actionSetsById = new HashMap();
    private final Set definedActionSets = new HashSet();
    private final Set definedGroups = new HashSet();
    private final Set definedMenus = new HashSet();
    private final Set definedWidgets = new HashSet();
    private final Map groupsById = new HashMap();
    private SMenuLayout layout = null;
    private final Map menusById = new HashMap();
    private final Map widgetsById = new HashMap();

    public final void addListener(IMenuManagerListener listener) {
        this.addListenerObject(listener);
    }

    private final void fireMenuManagerChanged(MenuManagerEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IMenuManagerListener listener = (IMenuManagerListener)listeners[i];
            listener.menuManagerChanged(event);
            ++i;
        }
    }

    public final SActionSet getActionSet(String actionSetId) {
        this.checkId(actionSetId);
        SActionSet actionSet = (SActionSet)((Object)this.actionSetsById.get(actionSetId));
        if (actionSet == null) {
            actionSet = new SActionSet(actionSetId);
            this.actionSetsById.put(actionSetId, actionSet);
            actionSet.addListener(this);
        }
        return actionSet;
    }

    public final SActionSet[] getDefinedActionSets() {
        return this.definedActionSets.toArray(new SActionSet[this.definedActionSets.size()]);
    }

    public final SGroup[] getDefinedGroups() {
        return this.definedGroups.toArray(new SGroup[this.definedGroups.size()]);
    }

    public final SItem[] getDefinedItems() {
        return this.definedHandleObjects.toArray(new SItem[this.definedHandleObjects.size()]);
    }

    public final SMenu[] getDefinedMenus() {
        return this.definedMenus.toArray(new SMenu[this.definedMenus.size()]);
    }

    public final SWidget[] getDefinedWidgets() {
        return this.definedWidgets.toArray(new SWidget[this.definedWidgets.size()]);
    }

    public final SGroup getGroup(String groupId) {
        this.checkId(groupId);
        SGroup group = (SGroup)((Object)this.groupsById.get(groupId));
        if (group == null) {
            group = new SGroup(groupId);
            this.groupsById.put(groupId, group);
            group.addListener(this);
        }
        return group;
    }

    public final SItem getItem(String itemId) {
        this.checkId(itemId);
        SItem item = (SItem)((Object)this.handleObjectsById.get(itemId));
        if (item == null) {
            item = new SItem(itemId);
            this.handleObjectsById.put(itemId, item);
            item.addListener(this);
        }
        return item;
    }

    public final SMenuLayout getLayout() {
        if (this.layout == null) {
            ArrayList menuElements = new ArrayList(this.definedMenus.size() + this.definedGroups.size() + this.definedHandleObjects.size() + this.definedWidgets.size());
            menuElements.addAll(this.definedMenus);
            menuElements.addAll(this.definedGroups);
            menuElements.addAll(this.definedHandleObjects);
            menuElements.addAll(this.definedWidgets);
            this.layout = SMenuLayout.computeLayout(menuElements);
        }
        return this.layout;
    }

    public final SMenu getMenu(String menuId) {
        this.checkId(menuId);
        SMenu menu = (SMenu)((Object)this.menusById.get(menuId));
        if (menu == null) {
            menu = new SMenu(menuId);
            this.menusById.put(menuId, menu);
            menu.addListener(this);
        }
        return menu;
    }

    public final SWidget getWidget(String widgetId) {
        this.checkId(widgetId);
        SWidget widget = (SWidget)((Object)this.widgetsById.get(widgetId));
        if (widget == null) {
            widget = new SWidget(widgetId);
            this.widgetsById.put(widgetId, widget);
            widget.addListener(this);
        }
        return widget;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("DEFINED".equals(event.getProperty())) {
            HandleObject handle = (HandleObject)event.getSource();
            String id = handle.getId();
            boolean added = (Boolean)event.getNewValue();
            if (added) {
                if (handle instanceof SActionSet) {
                    this.definedActionSets.add(handle);
                    if (this.isListenerAttached()) {
                        this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, null, false, null, false, id, added));
                    }
                } else if (handle instanceof SGroup) {
                    this.definedGroups.add(handle);
                    if (this.isListenerAttached()) {
                        this.fireMenuManagerChanged(new MenuManagerEvent(this, id, added, null, false, null, false, null, false, null, false));
                    }
                } else if (handle instanceof SItem) {
                    this.definedHandleObjects.add(handle);
                    if (this.isListenerAttached()) {
                        this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, id, added, null, false, null, false, null, false));
                    }
                } else if (handle instanceof SMenu) {
                    this.definedMenus.add(handle);
                    if (this.isListenerAttached()) {
                        this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, id, added, null, false, null, false));
                    }
                } else if (handle instanceof SWidget) {
                    this.definedWidgets.add(handle);
                    if (this.isListenerAttached()) {
                        this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, null, false, id, added, null, false));
                    }
                }
            } else if (handle instanceof SActionSet) {
                this.definedActionSets.remove(handle);
                if (this.isListenerAttached()) {
                    this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, null, false, null, false, id, added));
                }
            } else if (handle instanceof SGroup) {
                this.definedGroups.remove(handle);
                if (this.isListenerAttached()) {
                    this.fireMenuManagerChanged(new MenuManagerEvent(this, id, added, null, false, null, false, null, false, null, false));
                }
            } else if (handle instanceof SItem) {
                this.definedHandleObjects.remove(handle);
                if (this.isListenerAttached()) {
                    this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, id, added, null, false, null, false, null, false));
                }
            } else if (handle instanceof SMenu) {
                this.definedMenus.remove(handle);
                if (this.isListenerAttached()) {
                    this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, id, added, null, false, null, false));
                }
            } else if (handle instanceof SWidget) {
                this.definedWidgets.remove(handle);
                if (this.isListenerAttached()) {
                    this.fireMenuManagerChanged(new MenuManagerEvent(this, null, false, null, false, null, false, id, added, null, false));
                }
            }
        }
    }

    public final void removeListener(IMenuManagerListener listener) {
        this.removeListenerObject(listener);
    }
}

