/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Plugin;
import org.eclipse.team.internal.ccvs.ssh2.ExportDialog;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.ccvs.ssh2.PassphrasePrompt;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class CVSSSH2PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SSH2_PREFERENCE_PAGE_CONTEXT = "org.eclipse.team.cvs.ui.ssh2_preference_page_context";
    private Label ssh2HomeLabel;
    private Label proxyTypeLabel;
    private Label proxyHostLabel;
    private Label proxyPortLabel;
    private Label proxyUserLabel;
    private Label proxyPassLabel;
    private Label privateKeyLabel;
    private Combo proxyTypeCombo;
    private Text ssh2HomeText;
    private Text proxyHostText;
    private Text proxyPortText;
    private Text proxyUserText;
    private Text proxyPassText;
    private Text privateKeyText;
    private Button enableProxy;
    private Button enableAuth;
    private Button privateKeyAdd;
    private boolean useProxy;
    private boolean useAuth;
    private Button ssh2HomeBrowse;
    private Button keyGenerateDSA;
    private Button keyGenerateRSA;
    private Button keyLoad;
    private Button keyExport;
    private Button saveKeyPair;
    private Label keyCommentLabel;
    private Text keyCommentText;
    private Label keyFingerPrintLabel;
    private Text keyFingerPrintText;
    private Label keyPassphrase1Label;
    private Text keyPassphrase1Text;
    private Label keyPassphrase2Label;
    private Text keyPassphrase2Text;
    private Label publicKeylabel;
    private Text publicKeyText;
    private KeyPair kpair = null;
    private String kpairComment;
    public static final String AUTH_SCHEME = "";
    public static final URL FAKE_URL;
    private TableViewer viewer;
    private Button removeHostKeyButton;

    static {
        URL temp = null;
        try {
            temp = new URL("http://org.eclipse.team.cvs.ssh2");
        }
        catch (MalformedURLException malformedURLException) {}
        FAKE_URL = temp;
    }

    public CVSSSH2PreferencePage() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(CVSSSH2Messages.CVSSSH2PreferencePage_18);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)container);
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(CVSSSH2Messages.CVSSSH2PreferencePage_19);
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(CVSSSH2Messages.CVSSSH2PreferencePage_20);
        tabItem.setControl(this.createProxyPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(CVSSSH2Messages.CVSSSH2PreferencePage_21);
        tabItem.setControl(this.createKeyManagementPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(CVSSSH2Messages.CVSSSH2PreferencePage_133);
        tabItem.setControl(this.createHostKeyManagementPage((Composite)tabFolder));
        this.initControls();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), SSH2_PREFERENCE_PAGE_CONTEXT);
        return container;
    }

    private Control createGeneralPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.createSpacer(group, 3);
        this.ssh2HomeLabel = new Label(group, 0);
        this.ssh2HomeLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_23);
        this.ssh2HomeText = new Text(group, 2052);
        this.ssh2HomeText.setFont(group.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.ssh2HomeText.setLayoutData((Object)gd);
        this.ssh2HomeBrowse = new Button(group, 0);
        this.ssh2HomeBrowse.setText(CVSSSH2Messages.CVSSSH2PreferencePage_24);
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.ssh2HomeBrowse.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.privateKeyLabel = new Label(group, 0);
        this.privateKeyLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_25);
        this.privateKeyText = new Text(group, 2052);
        this.privateKeyText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.privateKeyText.setLayoutData((Object)gd);
        this.privateKeyAdd = new Button(group, 0);
        this.privateKeyAdd.setText(CVSSSH2Messages.CVSSSH2PreferencePage_26);
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.privateKeyAdd.setLayoutData((Object)gd);
        this.ssh2HomeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                if (!new File(home).exists()) {
                    int foo;
                    while ((foo = home.lastIndexOf(File.separator, home.length())) != -1 && !new File(home = home.substring(0, foo)).exists()) {
                    }
                }
                DirectoryDialog dd = new DirectoryDialog(CVSSSH2PreferencePage.this.getShell());
                dd.setFilterPath(home);
                dd.setMessage(CVSSSH2Messages.CVSSSH2PreferencePage_27);
                String dir = dd.open();
                if (dir == null) {
                    return;
                }
                CVSSSH2PreferencePage.this.ssh2HomeText.setText(dir);
            }
        });
        this.privateKeyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 4098);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String[] files = fd.getFileNames();
                String keys = CVSSSH2PreferencePage.this.privateKeyText.getText();
                String dir = fd.getFilterPath();
                dir = dir.equals(home) ? CVSSSH2PreferencePage.AUTH_SCHEME : String.valueOf(dir) + File.separator;
                int i = 0;
                while (i < files.length) {
                    String foo = files[i];
                    if (keys.length() != 0) {
                        keys = String.valueOf(keys) + ",";
                    }
                    keys = String.valueOf(keys) + dir + foo;
                    ++i;
                }
                CVSSSH2PreferencePage.this.privateKeyText.setText(keys);
            }
        });
        return group;
    }

    private Control createProxyPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.enableProxy = new Button(group, 32);
        this.enableProxy.setText(CVSSSH2Messages.CVSSSH2PreferencePage_30);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableProxy.setLayoutData((Object)gd);
        this.proxyTypeLabel = new Label(group, 0);
        this.proxyTypeLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_31);
        this.proxyTypeCombo = new Combo(group, 8);
        this.proxyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyTypeCombo.setLayoutData((Object)gd);
        this.proxyTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.proxyPortText == null) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                String foo = combo.getText();
                if (foo.equals("HTTP")) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText("80");
                } else if (foo.equals("SOCKS5")) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText("1080");
                }
            }
        });
        this.proxyTypeCombo.add("HTTP");
        this.proxyTypeCombo.add("SOCKS5");
        this.proxyTypeCombo.select(0);
        this.proxyHostLabel = new Label(group, 0);
        this.proxyHostLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_32);
        this.proxyHostText = new Text(group, 2052);
        this.proxyHostText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyHostText.setLayoutData((Object)gd);
        this.proxyPortLabel = new Label(group, 0);
        this.proxyPortLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_33);
        this.proxyPortText = new Text(group, 2052);
        this.proxyPortText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPortText.setLayoutData((Object)gd);
        this.proxyPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.isValidPort(CVSSSH2PreferencePage.this.proxyPortText.getText())) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.createSpacer(group, 3);
        this.enableAuth = new Button(group, 32);
        this.enableAuth.setText(CVSSSH2Messages.CVSSSH2PreferencePage_34);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableAuth.setLayoutData((Object)gd);
        this.proxyUserLabel = new Label(group, 0);
        this.proxyUserLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_35);
        this.proxyUserText = new Text(group, 2052);
        this.proxyUserText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyUserText.setLayoutData((Object)gd);
        this.proxyPassLabel = new Label(group, 0);
        this.proxyPassLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_36);
        this.proxyPassText = new Text(group, 2052);
        this.proxyPassText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPassText.setLayoutData((Object)gd);
        this.enableProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return group;
    }

    private Control createKeyManagementPage(Composite parent) {
        int columnSpan = 3;
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        this.keyGenerateDSA = new Button(group, 0);
        this.keyGenerateDSA.setText(CVSSSH2Messages.CVSSSH2PreferencePage_131);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateDSA.setLayoutData((Object)gd);
        this.keyGenerateRSA = new Button(group, 0);
        this.keyGenerateRSA.setText(CVSSSH2Messages.CVSSSH2PreferencePage_132);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateRSA.setLayoutData((Object)gd);
        this.keyLoad = new Button(group, 0);
        this.keyLoad.setText(CVSSSH2Messages.CVSSSH2PreferencePage_128);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyLoad.setLayoutData((Object)gd);
        this.publicKeylabel = new Label(group, 0);
        this.publicKeylabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_39);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text(group, 2626);
        this.publicKeyText.setText(AUTH_SCHEME);
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label(group, 0);
        this.keyFingerPrintLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_41);
        this.keyFingerPrintText = new Text(group, 2052);
        this.keyFingerPrintText.setFont(group.getFont());
        this.keyFingerPrintText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label(group, 0);
        this.keyCommentLabel.setText(CVSSSH2Messages.CVSSSH2PreferencePage_42);
        this.keyCommentText = new Text(group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.keyCommentText.getText());
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                }
                catch (IOException iOException) {}
            }
        });
        this.keyPassphrase1Label = new Label(group, 0);
        this.keyPassphrase1Label.setText(CVSSSH2Messages.CVSSSH2PreferencePage_43);
        this.keyPassphrase1Text = new Text(group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label(group, 0);
        this.keyPassphrase2Label.setText(CVSSSH2Messages.CVSSSH2PreferencePage_44);
        this.keyPassphrase2Text = new Text(group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.keyPassphrase1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (CVSSSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() == 0) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        this.keyPassphrase2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (CVSSSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        CVSSSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        this.keyPassphrase2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        CVSSSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                }
            }

            public void focusLost(FocusEvent e) {
                String pass2;
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (pass1.equals(pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        Composite buttons = new Composite(group, 0);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        buttons.setLayoutData((Object)gd);
        this.keyExport = new Button(buttons, 0);
        this.keyExport.setText(CVSSSH2Messages.CVSSSH2PreferencePage_105);
        gd = new GridData(1808);
        this.keyExport.setLayoutData((Object)gd);
        this.saveKeyPair = new Button(buttons, 0);
        this.saveKeyPair.setText(CVSSSH2Messages.CVSSSH2PreferencePage_45);
        gd = new GridData(1808);
        this.saveKeyPair.setLayoutData((Object)gd);
        SelectionAdapter keygenadapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSch jsch = JSchSession.getJSch();
                boolean ok = true;
                String _type = CVSSSH2PreferencePage.AUTH_SCHEME;
                try {
                    int type = 0;
                    if (e.widget == CVSSSH2PreferencePage.this.keyGenerateDSA) {
                        type = 1;
                        _type = "DSA";
                    } else if (e.widget == CVSSSH2PreferencePage.this.keyGenerateRSA) {
                        type = 2;
                        _type = "RSA";
                    } else {
                        return;
                    }
                    KeyPair[] _kpair = new KeyPair[1];
                    JSch _jsch = jsch;
                    int __type = type;
                    JSchException[] _e = new JSchException[1];
                    BusyIndicator.showWhile((Display)CVSSSH2PreferencePage.this.getShell().getDisplay(), (Runnable)new Runnable(this, _kpair, _jsch, __type, _e){
                        final /* synthetic */ 11 this$1;
                        private final /* synthetic */ KeyPair[] val$_kpair;
                        private final /* synthetic */ JSch val$_jsch;
                        private final /* synthetic */ int val$__type;
                        private final /* synthetic */ JSchException[] val$_e;
                        {
                            this.this$1 = var1_1;
                            this.val$_kpair = keyPairArray;
                            this.val$_jsch = jSch;
                            this.val$__type = n;
                            this.val$_e = jSchExceptionArray;
                        }

                        public void run() {
                            try {
                                this.val$_kpair[0] = KeyPair.genKeyPair((JSch)this.val$_jsch, (int)this.val$__type);
                            }
                            catch (JSchException e) {
                                this.val$_e[0] = e;
                            }
                        }
                    });
                    if (_e[0] != null) {
                        throw _e[0];
                    }
                    CVSSSH2PreferencePage.this.kpair = _kpair[0];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.keyPassphrase1Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.keyPassphrase2Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_error, (String)CVSSSH2Messages.CVSSSH2PreferencePage_47);
                }
            }
        };
        this.keyGenerateDSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyGenerateRSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 4096);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String pkey = fd.getFileName();
                String pkeyab = new File(fd.getFilterPath(), pkey).getAbsolutePath();
                try {
                    JSch jsch = JSchSession.getJSch();
                    KeyPair _kpair = KeyPair.load((JSch)jsch, (String)pkeyab);
                    PassphrasePrompt prompt = null;
                    while (_kpair.isEncrypted()) {
                        if (prompt == null) {
                            prompt = new PassphrasePrompt(NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_126, (Object[])new String[]{pkey}));
                        }
                        Display.getDefault().syncExec(prompt);
                        String passphrase = prompt.getPassphrase();
                        if (passphrase == null || _kpair.decrypt(passphrase)) break;
                        MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_error, (String)NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_129, (Object[])new String[]{pkey}));
                    }
                    if (_kpair.isEncrypted()) {
                        return;
                    }
                    CVSSSH2PreferencePage.this.kpair = _kpair;
                    String _type = CVSSSH2PreferencePage.this.kpair.getKeyType() == 1 ? "DSA" : "RSA";
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.keyPassphrase1Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.keyPassphrase2Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_error, (String)CVSSSH2Messages.CVSSSH2PreferencePage_130);
                }
            }
        });
        this.keyExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                CVSSSH2PreferencePage.this.setErrorMessage(null);
                String[] target = new String[1];
                String title = CVSSSH2Messages.CVSSSH2PreferencePage_106;
                String message = CVSSSH2Messages.CVSSSH2PreferencePage_107;
                Display.getDefault().syncExec(new Runnable(this, title, message, target){
                    final /* synthetic */ 14 this$1;
                    private final /* synthetic */ String val$title;
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ String[] val$target;
                    {
                        this.this$1 = var1_1;
                        this.val$title = string;
                        this.val$message = string2;
                        this.val$target = stringArray;
                    }

                    public void run() {
                        Display display = Display.getCurrent();
                        Shell shell = new Shell(display);
                        ExportDialog dialog = new ExportDialog(shell, this.val$title, this.val$message);
                        dialog.open();
                        shell.dispose();
                        this.val$target[0] = dialog.getTarget();
                    }
                });
                if (target[0] == null) {
                    return;
                }
                String user = CVSSSH2PreferencePage.AUTH_SCHEME;
                String host = CVSSSH2PreferencePage.AUTH_SCHEME;
                int port = 22;
                if (target[0].indexOf(64) > 0) {
                    user = target[0].substring(0, target[0].indexOf(64));
                    host = target[0].substring(target[0].indexOf(64) + 1);
                }
                if (host.indexOf(58) > 0) {
                    try {
                        port = Integer.parseInt(host.substring(host.indexOf(58) + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        port = -1;
                    }
                    host = host.substring(0, host.indexOf(58));
                }
                if (user.length() == 0 || host.length() == 0 || port == -1) {
                    CVSSSH2PreferencePage.this.setErrorMessage(NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_108, (Object[])new String[]{target[0]}));
                    return;
                }
                String options = CVSSSH2PreferencePage.AUTH_SCHEME;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    if (options.length() != 0) {
                        try {
                            bos.write((String.valueOf(options) + " ").getBytes());
                        }
                        catch (IOException iOException) {}
                    }
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)bos, CVSSSH2PreferencePage.this.kpairComment);
                    bos.close();
                    CVSSSH2PreferencePage.this.export_via_sftp(user, host, port, ".ssh/authorized_keys", bos.toByteArray());
                }
                catch (IOException iOException) {
                }
                catch (JSchException jSchException) {
                    CVSSSH2PreferencePage.this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_111);
                }
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (pass.length() == 0 && !MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_confirmation, (String)CVSSSH2Messages.CVSSSH2PreferencePage_49)) {
                    return;
                }
                CVSSSH2PreferencePage.this.kpair.setPassphrase(pass);
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                File _home = new File(home);
                if (!_home.exists()) {
                    if (!MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_confirmation, (String)NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_50, (Object[])new String[]{home}))) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        CVSSSH2PreferencePage.this.setErrorMessage(String.valueOf(CVSSSH2Messages.CVSSSH2PreferencePage_100) + home);
                        return;
                    }
                }
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 8192);
                fd.setFilterPath(home);
                String file = CVSSSH2PreferencePage.this.kpair.getKeyType() == 2 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists() && !MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_confirmation, (String)NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_53, (Object[])new String[]{file}))) {
                    return;
                }
                boolean ok = true;
                try {
                    CVSSSH2PreferencePage.this.kpair.writePrivateKey(file);
                    CVSSSH2PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", CVSSSH2PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (ok) {
                    MessageDialog.openInformation((Shell)CVSSSH2PreferencePage.this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_information, (String)(String.valueOf(CVSSSH2Messages.CVSSSH2PreferencePage_55) + "\n" + CVSSSH2Messages.CVSSSH2PreferencePage_57 + file + "\n" + CVSSSH2Messages.CVSSSH2PreferencePage_59 + file + ".pub"));
                }
            }
        });
        return group;
    }

    private Control createHostKeyManagementPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText(CVSSSH2Messages.CVSSSH2PreferencePage_139);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(group, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CVSSSH2PreferencePage.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText(CVSSSH2Messages.CVSSSH2PreferencePage_134);
        columns[1].setText(CVSSSH2Messages.CVSSSH2PreferencePage_135);
        columns[2].setText(CVSSSH2Messages.CVSSSH2PreferencePage_136);
        this.viewer.setColumnProperties(new String[]{CVSSSH2Messages.CVSSSH2PreferencePage_134, CVSSSH2Messages.CVSSSH2PreferencePage_135, CVSSSH2Messages.CVSSSH2PreferencePage_136});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                return (Object[])inputElement;
            }
        });
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(group, 0);
        buttons.setLayoutData((Object)new GridData(2));
        buttons.setLayout((Layout)new GridLayout());
        this.removeHostKeyButton = new Button(buttons, 8);
        this.removeHostKeyButton.setText(CVSSSH2Messages.CVSSSH2PreferencePage_138);
        int buttonWidth = SWTUtils.calculateControlSize((PixelConverter)SWTUtils.createDialogPixelConverter((Control)parent), (Control[])new Button[]{this.removeHostKeyButton});
        this.removeHostKeyButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)0x1000008, (int)0x1000000, (boolean)false, (boolean)false));
        this.removeHostKeyButton.setEnabled(false);
        this.removeHostKeyButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CVSSSH2PreferencePage.this.removeHostKey();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        JSchSession.loadKnownHosts();
        HostKeyRepository hkr = JSchSession.getJSch().getHostKeyRepository();
        this.viewer.setInput((Object)hkr.getHostKey());
        this.handleSelection();
        return group;
    }

    private void handleSelection() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.removeHostKeyButton.setEnabled(!empty);
    }

    private void removeHostKey() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        HostKeyRepository hkr = JSchSession.getJSch().getHostKeyRepository();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            HostKey hostkey = (HostKey)iterator.next();
            hkr.remove(hostkey.getHost(), hostkey.getType());
            this.viewer.remove((Object)hostkey);
        }
    }

    private void export_via_sftp(String user, String host, int port, String target, byte[] pkey) throws JSchException {
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            Session session = JSchSession.getSession(null, user, AUTH_SCHEME, host, port, (IProgressMonitor)pm).getSession();
            if (session.getServerVersion().indexOf("OpenSSH") == -1) {
                this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_110);
                return;
            }
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp c = (ChannelSftp)channel;
            c.pwd();
            SftpATTRS attr = null;
            try {
                attr = c.stat(".ssh");
            }
            catch (SftpException sftpException) {}
            if (attr == null) {
                try {
                    c.mkdir(".ssh");
                }
                catch (SftpException ee) {
                    this.setErrorMessage(ee.message);
                    return;
                }
            }
            try {
                c.cd(".ssh");
            }
            catch (SftpException ee) {
                this.setErrorMessage(ee.message);
                return;
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(pkey);
                c.put((InputStream)bis, "authorized_keys", null, 2);
                bis.close();
                this.checkPermission(c, "authorized_keys");
                this.checkPermission(c, ".");
                c.cd("..");
                this.checkPermission(c, ".");
            }
            catch (SftpException sftpException) {}
            MessageDialog.openInformation((Shell)this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_information, (String)(String.valueOf(CVSSSH2Messages.CVSSSH2PreferencePage_109) + user + "@" + host + (port == 22 ? AUTH_SCHEME : ":" + port) + ":~/.ssh/authorized_keys"));
            c.disconnect();
        }
        catch (IOException eee) {
            this.setErrorMessage(eee.toString());
        }
    }

    private void checkPermission(ChannelSftp c, String path) throws SftpException {
        SftpATTRS attr = c.stat(path);
        int permissions = attr.getPermissions();
        if ((permissions & 0x12) != 0) {
            c.chmod(permissions &= 0xFFFFFFED, path);
        }
    }

    private void updateControls() {
        boolean enable = this.enableProxy.getSelection();
        this.proxyTypeLabel.setEnabled(enable);
        this.proxyTypeCombo.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.proxyPortText.setEnabled(enable);
        this.proxyHostLabel.setEnabled(enable);
        this.proxyHostText.setEnabled(enable);
        this.enableAuth.setEnabled(enable);
        this.proxyUserLabel.setEnabled(enable &= this.enableAuth.getSelection());
        this.proxyUserText.setEnabled(enable);
        this.proxyPassLabel.setEnabled(enable);
        this.proxyPassText.setEnabled(enable);
        enable = this.kpair != null;
        this.publicKeylabel.setEnabled(enable);
        this.publicKeyText.setEnabled(enable);
        this.keyFingerPrintLabel.setEnabled(enable);
        this.keyFingerPrintText.setEnabled(enable);
        this.keyCommentLabel.setEnabled(enable);
        this.keyCommentText.setEnabled(enable);
        this.keyPassphrase1Label.setEnabled(enable);
        this.keyPassphrase1Text.setEnabled(enable);
        this.keyPassphrase2Label.setEnabled(enable);
        this.keyPassphrase2Text.setEnabled(enable);
        this.keyExport.setEnabled(enable);
        this.saveKeyPair.setEnabled(enable);
    }

    public void init(IWorkbench workbench) {
    }

    public void initialize() {
        this.initControls();
    }

    private void initControls() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.ssh2HomeText.setText(store.getString("CVSSSH2PreferencePage.SSH2HOME"));
        this.privateKeyText.setText(store.getString("CVSSSH2PreferencePage.PRIVATEKEY"));
        this.useProxy = store.getString("CVSSSH2PreferencePage.PROXY").equals("true");
        this.enableProxy.setSelection(this.useProxy);
        this.proxyHostText.setText(store.getString("CVSSSH2PreferencePage.PROXY_HOST"));
        this.proxyTypeCombo.select(store.getString("CVSSSH2PreferencePage.PROXY_TYPE").equals("HTTP") ? 0 : 1);
        this.proxyPortText.setText(store.getString("CVSSSH2PreferencePage.PROXY_PORT"));
        this.useAuth = store.getString("CVSSSH2PreferencePage.PROXY_AUTH").equals("true");
        this.enableAuth.setSelection(this.useAuth);
        Map map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME);
        if (map != null) {
            String password;
            String username = (String)map.get("CVSSSH2PreferencePage.PROXY_USER");
            if (username != null) {
                this.proxyUserText.setText(username);
            }
            if ((password = (String)map.get("CVSSSH2PreferencePage.PROXY_PASS")) != null) {
                this.proxyPassText.setText(password);
            }
        }
        this.proxyPassText.setEchoChar('*');
        this.updateControls();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.setErrorMessage(null);
            String home = this.ssh2HomeText.getText();
            File _home = new File(home);
            if (!_home.exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSSSH2Messages.CVSSSH2PreferencePage_question, (String)NLS.bind((String)CVSSSH2Messages.CVSSSH2PreferencePage_99, (Object[])new String[]{home})) && !_home.mkdirs()) {
                this.setErrorMessage(String.valueOf(CVSSSH2Messages.CVSSSH2PreferencePage_100) + home);
                return false;
            }
            if (this.enableProxy.getSelection() && !this.isValidPort(this.proxyPortText.getText())) {
                return false;
            }
            IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
            store.setValue("CVSSSH2PreferencePage.SSH2HOME", home);
            store.setValue("CVSSSH2PreferencePage.PRIVATEKEY", this.privateKeyText.getText());
            store.setValue("CVSSSH2PreferencePage.PROXY", this.enableProxy.getSelection());
            store.setValue("CVSSSH2PreferencePage.PROXY_TYPE", this.proxyTypeCombo.getText());
            store.setValue("CVSSSH2PreferencePage.PROXY_HOST", this.proxyHostText.getText());
            store.setValue("CVSSSH2PreferencePage.PROXY_PORT", this.proxyPortText.getText());
            store.setValue("CVSSSH2PreferencePage.PROXY_AUTH", this.enableAuth.getSelection());
            HashMap<String, String> map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME);
            if (map == null) {
                map = new HashMap<String, String>(10);
            }
            map.put("CVSSSH2PreferencePage.PROXY_USER", this.proxyUserText.getText());
            map.put("CVSSSH2PreferencePage.PROXY_PASS", this.proxyPassText.getText());
            try {
                Platform.addAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME, map);
            }
            catch (CoreException e) {
                Util.logError((String)"Cannot save ssh2 proxy authentication information to keyring file", (Throwable)e);
            }
        }
        CVSSSH2Plugin.getDefault().savePluginPreferences();
        return result;
    }

    private boolean isValidPort(String port) {
        int i = -1;
        try {
            i = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {}
        if (i < 0 || i > 65535) {
            this.setErrorMessage(CVSSSH2Messages.CVSSSH2PreferencePage_104);
            return false;
        }
        return true;
    }

    public void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        store.setToDefault("CVSSSH2PreferencePage.SSH2HOME");
        store.setToDefault("CVSSSH2PreferencePage.PRIVATEKEY");
        store.setToDefault("CVSSSH2PreferencePage.PROXY");
        store.setToDefault("CVSSSH2PreferencePage.PROXY_TYPE");
        store.setToDefault("CVSSSH2PreferencePage.PROXY_HOST");
        store.setToDefault("CVSSSH2PreferencePage.PROXY_PORT");
        store.setToDefault("CVSSSH2PreferencePage.PROXY_AUTH");
        this.initControls();
        this.updateControls();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            HostKey entry = (HostKey)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getHost();
                }
                case 1: {
                    return entry.getType();
                }
                case 2: {
                    return entry.getFingerPrint(JSchSession.getJSch());
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

