/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractSerialVersionOperation
implements ILinkedFixRewriteOperation {
    protected static final String LONG_SUFFIX = "L";
    public static final long SERIAL_VALUE = 1L;
    protected static final String DEFAULT_EXPRESSION = "1L";
    protected static final String NAME_FIELD = "serialVersionUID";
    private final ASTNode[] fNodes;
    private final ICompilationUnit fUnit;

    protected AbstractSerialVersionOperation(ICompilationUnit unit, ASTNode[] node) {
        this.fUnit = unit;
        this.fNodes = node;
    }

    protected abstract void addInitializer(VariableDeclarationFragment var1, ASTNode var2) throws CoreException;

    protected abstract void addLinkedPositions(ASTRewrite var1, VariableDeclarationFragment var2, List var3);

    protected ASTNode getDeclarationNode(ASTNode node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            if ((parent = parent.getParent()) instanceof ParameterizedType || parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                parent = creation.getAnonymousClassDeclaration();
            }
        }
        return parent;
    }

    public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
        this.rewriteAST(cuRewrite, textEditGroups, new ArrayList());
    }

    public ITrackedNodePosition rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups, List positionGroups) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        VariableDeclarationFragment fragment = null;
        int i = 0;
        while (i < this.fNodes.length) {
            String comment;
            ASTNode node = this.getDeclarationNode(this.fNodes[i]);
            AST ast = node.getAST();
            fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(NAME_FIELD));
            FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
            declaration.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
            declaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 26));
            this.addInitializer(fragment, node);
            if (fragment.getInitializer() != null) {
                TextEditGroup editGroup = new TextEditGroup(FixMessages.SerialVersion_group_description);
                textEditGroups.add(editGroup);
                if (node instanceof AbstractTypeDeclaration) {
                    rewrite.getListRewrite(node, ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty()).insertAt((ASTNode)declaration, 0, editGroup);
                } else if (node instanceof AnonymousClassDeclaration) {
                    rewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)declaration, 0, editGroup);
                } else if (node instanceof ParameterizedType) {
                    ClassInstanceCreation creation;
                    AnonymousClassDeclaration anonymous;
                    ParameterizedType type = (ParameterizedType)node;
                    ASTNode parent = type.getParent();
                    if (parent instanceof ClassInstanceCreation && (anonymous = (creation = (ClassInstanceCreation)parent).getAnonymousClassDeclaration()) != null) {
                        rewrite.getListRewrite((ASTNode)anonymous, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)declaration, 0, editGroup);
                    }
                } else {
                    Assert.isTrue(false);
                }
                this.addLinkedPositions(rewrite, fragment, positionGroups);
            }
            if ((comment = CodeGeneration.getFieldComment(this.fUnit, declaration.getType().toString(), NAME_FIELD, StubUtility.getLineDelimiterUsed((IJavaElement)this.fUnit))) != null && comment.length() > 0) {
                Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
                declaration.setJavadoc(doc);
            }
            ++i;
        }
        if (fragment == null) {
            return null;
        }
        return rewrite.track(fragment);
    }

    protected String getQualifiedName(ASTNode parent) {
        ITypeBinding binding = null;
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            binding = declaration.resolveBinding();
        } else if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            ClassInstanceCreation creation = (ClassInstanceCreation)declaration.getParent();
            binding = creation.resolveTypeBinding();
        } else if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            binding = type.resolveBinding();
        }
        if (binding != null) {
            return binding.getBinaryName();
        }
        return null;
    }
}

