/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class CodeStyleFix
extends AbstractFix {
    public static CodeStyleFix[] createNonStaticAccessFixes(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (!CodeStyleFix.isNonStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createNonStaticAccessResolveOperations(compilationUnit, problem);
        if (operations == null) {
            return null;
        }
        String label1 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStatic_description, operations[0].getAccessorName());
        CodeStyleFix fix1 = new CodeStyleFix(label1, compilationUnit, new IFixRewriteOperation[]{operations[0]});
        if (operations.length > 1) {
            String label2 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStaticUsingInstanceType_description, operations[1].getAccessorName());
            CodeStyleFix fix2 = new CodeStyleFix(label2, compilationUnit, new IFixRewriteOperation[]{operations[1]});
            return new CodeStyleFix[]{fix1, fix2};
        }
        return new CodeStyleFix[]{fix1};
    }

    public static CodeStyleFix createAddFieldQualifierFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (570425423 != problem.getProblemId()) {
            return null;
        }
        AddThisQualifierOperation operation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, problem);
        if (operation == null) {
            return null;
        }
        String groupName = operation.getDescription();
        return new CodeStyleFix(groupName, compilationUnit, new IFixRewriteOperation[]{operation});
    }

    public static CodeStyleFix createIndirectAccessToStaticFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (!CodeStyleFix.isIndirectStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createNonStaticAccessResolveOperations(compilationUnit, problem);
        if (operations == null) {
            return null;
        }
        String label = Messages.format(FixMessages.CodeStyleFix_ChangeStaticAccess_description, operations[0].getAccessorName());
        return new CodeStyleFix(label, compilationUnit, new IFixRewriteOperation[]{operations[0]});
    }

    public static CodeStyleFix createCleanUp(CompilationUnit compilationUnit, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean qualifyStaticFieldAccess, boolean changeIndirectStaticAccessToDirect) throws CoreException {
        if (!(addThisQualifier || changeNonStaticAccessToStatic || qualifyStaticFieldAccess || changeIndirectStaticAccessToDirect)) {
            return null;
        }
        ArrayList<ToStaticAccessOperation> operations = new ArrayList<ToStaticAccessOperation>();
        if (addThisQualifier || qualifyStaticFieldAccess) {
            CodeStyleVisitor codeStyleVisitor = new CodeStyleVisitor(compilationUnit, addThisQualifier, qualifyStaticFieldAccess, operations);
            compilationUnit.accept((ASTVisitor)codeStyleVisitor);
        }
        if (changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect) {
            IProblem[] problems = compilationUnit.getProblems();
            int i = 0;
            while (i < problems.length) {
                ToStaticAccessOperation[] nonStaticAccessInformation;
                boolean isIndirectStaticAccess;
                ProblemLocation problem = new ProblemLocation(problems[i]);
                boolean isNonStaticAccess = changeNonStaticAccessToStatic && CodeStyleFix.isNonStaticAccess(problem);
                boolean bl = isIndirectStaticAccess = changeIndirectStaticAccessToDirect && CodeStyleFix.isIndirectStaticAccess(problem);
                if ((isNonStaticAccess || isIndirectStaticAccess) && (nonStaticAccessInformation = CodeStyleFix.createNonStaticAccessResolveOperations(compilationUnit, problem)) != null) {
                    operations.add(nonStaticAccessInformation[0]);
                }
                ++i;
            }
        }
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new CodeStyleFix("", compilationUnit, operationsArray);
    }

    public static CodeStyleFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean changeIndirectStaticAccessToDirect) throws CoreException {
        IProblemLocation problem;
        int i;
        if (!(addThisQualifier || changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect)) {
            return null;
        }
        ArrayList<IFixRewriteOperation> operations = new ArrayList<IFixRewriteOperation>();
        if (addThisQualifier) {
            i = 0;
            while (i < problems.length) {
                AddThisQualifierOperation operation;
                problem = problems[i];
                if (problem.getProblemId() == 570425423 && (operation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, problem)) != null) {
                    operations.add(operation);
                }
                ++i;
            }
        }
        if (changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect) {
            i = 0;
            while (i < problems.length) {
                ToStaticAccessOperation[] nonStaticAccessInformation;
                boolean isIndirectStaticAccess;
                problem = problems[i];
                boolean isNonStaticAccess = changeNonStaticAccessToStatic && CodeStyleFix.isNonStaticAccess(problem);
                boolean bl = isIndirectStaticAccess = changeIndirectStaticAccessToDirect && CodeStyleFix.isIndirectStaticAccess(problem);
                if ((isNonStaticAccess || isIndirectStaticAccess) && (nonStaticAccessInformation = CodeStyleFix.createNonStaticAccessResolveOperations(compilationUnit, problem)) != null) {
                    operations.add(nonStaticAccessInformation[0]);
                }
                ++i;
            }
        }
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new CodeStyleFix("", compilationUnit, operationsArray);
    }

    private static boolean isIndirectStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425422 || problem.getProblemId() == 603979895;
    }

    private static boolean isNonStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425420 || problem.getProblemId() == 603979893;
    }

    private static ToStaticAccessOperation[] createNonStaticAccessResolveOperations(CompilationUnit astRoot, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return null;
        }
        Name qualifier = null;
        IBinding accessBinding = null;
        if (selectedNode instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)selectedNode;
            qualifier = name.getQualifier();
            accessBinding = name.resolveBinding();
        } else if (selectedNode instanceof SimpleName) {
            ASTNode parent = selectedNode.getParent();
            if (parent instanceof FieldAccess) {
                FieldAccess fieldAccess = (FieldAccess)parent;
                qualifier = fieldAccess.getExpression();
                accessBinding = fieldAccess.getName().resolveBinding();
            } else if (parent instanceof QualifiedName) {
                QualifiedName qualifiedName = (QualifiedName)parent;
                qualifier = qualifiedName.getQualifier();
                accessBinding = qualifiedName.getName().resolveBinding();
            }
        } else if (selectedNode instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)selectedNode;
            qualifier = methodInvocation.getExpression();
            accessBinding = methodInvocation.getName().resolveBinding();
        } else if (selectedNode instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)selectedNode;
            qualifier = fieldAccess.getExpression();
            accessBinding = fieldAccess.getName().resolveBinding();
        }
        if (accessBinding != null) {
            ToStaticAccessOperation declaring = null;
            ITypeBinding declaringTypeBinding = CodeStyleFix.getDeclaringTypeBinding(accessBinding);
            if (declaringTypeBinding != null) {
                declaringTypeBinding = declaringTypeBinding.getTypeDeclaration();
                declaring = new ToStaticAccessOperation(declaringTypeBinding, (Expression)qualifier);
            }
            ToStaticAccessOperation instance = null;
            ITypeBinding instanceTypeBinding = Bindings.normalizeTypeBinding(qualifier.resolveTypeBinding());
            if (instanceTypeBinding != null && (instanceTypeBinding = instanceTypeBinding.getTypeDeclaration()).getTypeDeclaration() != declaringTypeBinding) {
                instance = new ToStaticAccessOperation(instanceTypeBinding, (Expression)qualifier);
            }
            if (declaring != null && instance != null) {
                return new ToStaticAccessOperation[]{declaring, instance};
            }
            return new ToStaticAccessOperation[]{declaring};
        }
        return null;
    }

    private static ITypeBinding getDeclaringTypeBinding(IBinding accessBinding) {
        if (accessBinding instanceof IMethodBinding) {
            return ((IMethodBinding)accessBinding).getDeclaringClass();
        }
        if (accessBinding instanceof IVariableBinding) {
            return ((IVariableBinding)accessBinding).getDeclaringClass();
        }
        return null;
    }

    private static AddThisQualifierOperation getUnqualifiedFieldAccessResolveOperation(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        SimpleName name = CodeStyleFix.getName(compilationUnit, problem);
        if (name == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding.getKind() != 3) {
            return null;
        }
        ImportRewrite imports = StubUtility.createImportRewrite(compilationUnit, true);
        String replacement = CodeStyleFix.getQualifier((IVariableBinding)binding, imports, name);
        if (replacement == null) {
            return null;
        }
        return new AddThisQualifierOperation(replacement, name);
    }

    private static String getQualifier(IVariableBinding binding, ImportRewrite imports, SimpleName name) {
        String qualifier;
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (Modifier.isStatic((int)binding.getModifiers())) {
            qualifier = imports.addImport(declaringClass);
        } else {
            ITypeBinding parentType;
            ITypeBinding currType = parentType = Bindings.getBindingOfParentType((ASTNode)name);
            while (currType != null && !Bindings.isSuperType(declaringClass, currType)) {
                currType = currType.getDeclaringClass();
            }
            if (currType != parentType) {
                if (currType.isAnonymous()) {
                    return null;
                }
                String outer = imports.addImport(currType);
                qualifier = String.valueOf(outer) + ".this";
            } else {
                qualifier = "this";
            }
        }
        return qualifier;
    }

    private static SimpleName getName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        while (selectedNode instanceof QualifiedName) {
            selectedNode = ((QualifiedName)selectedNode).getQualifier();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return null;
        }
        return (SimpleName)selectedNode;
    }

    private CodeStyleFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class CodeStyleVisitor
    extends GenericVisitor {
        private final List fResult;
        private final ImportRewrite fImportRewrite;
        private final boolean fFindUnqualifiedAccesses;
        private final boolean fFindUnqualifiedStaticAccesses;
        static /* synthetic */ Class class$0;

        public CodeStyleVisitor(CompilationUnit compilationUnit, boolean findUnqualifiedAccesses, boolean findUnqualifiedStaticAccesses, List resultingCollection) throws CoreException {
            this.fFindUnqualifiedAccesses = findUnqualifiedAccesses;
            this.fFindUnqualifiedStaticAccesses = findUnqualifiedStaticAccesses;
            this.fImportRewrite = StubUtility.createImportRewrite(compilationUnit, true);
            this.fResult = resultingCollection;
        }

        public boolean visit(TypeDeclaration node) {
            if (!this.fFindUnqualifiedStaticAccesses && node.isInterface()) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(QualifiedName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                QualifiedName simpleName = node;
                while (simpleName instanceof QualifiedName) {
                    simpleName = simpleName.getQualifier();
                }
                if (simpleName instanceof SimpleName) {
                    this.handleSimpleName((SimpleName)simpleName);
                }
            }
            return false;
        }

        public boolean visit(SimpleName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                this.handleSimpleName(node);
            }
            return false;
        }

        private void handleSimpleName(SimpleName node) {
            ASTNode firstExpression = node.getParent();
            if (firstExpression instanceof FieldAccess) {
                while (firstExpression instanceof FieldAccess) {
                    firstExpression = ((FieldAccess)firstExpression).getExpression();
                }
                if (!(firstExpression instanceof SimpleName)) {
                    return;
                }
                node = (SimpleName)firstExpression;
            } else if (firstExpression instanceof SuperFieldAccess) {
                return;
            }
            StructuralPropertyDescriptor parentDescription = node.getLocationInParent();
            if (parentDescription == VariableDeclarationFragment.NAME_PROPERTY || parentDescription == SwitchCase.EXPRESSION_PROPERTY) {
                return;
            }
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return;
            }
            IVariableBinding varbinding = (IVariableBinding)binding;
            if (!varbinding.isField()) {
                return;
            }
            if (Modifier.isStatic((int)varbinding.getModifiers())) {
                if (this.fFindUnqualifiedStaticAccesses) {
                    Initializer initializer;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((initializer = (Initializer)ASTNodes.getParent((ASTNode)node, clazz)) != null && Modifier.isStatic((int)initializer.getModifiers()) && Modifier.isFinal((int)varbinding.getModifiers()) && parentDescription == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                        return;
                    }
                    if (varbinding.getDeclaringClass().isAnonymous()) {
                        return;
                    }
                    this.fResult.add(new AddStaticQualifierOperation(varbinding, node));
                }
            } else if (this.fFindUnqualifiedAccesses) {
                String qualifier = CodeStyleFix.getQualifier(varbinding, this.fImportRewrite, node);
                if (qualifier == null) {
                    return;
                }
                this.fResult.add(new AddThisQualifierOperation(qualifier, node));
            }
        }
    }

    private static final class AddThisQualifierOperation
    implements IFixRewriteOperation {
        private final String fQualifier;
        private final SimpleName fName;

        public AddThisQualifierOperation(String qualifier, SimpleName name) {
            this.fQualifier = qualifier;
            this.fName = name;
        }

        public String getDescription() {
            return Messages.format(FixMessages.CodeStyleFix_QualifyWithThis_description, new Object[]{this.fName.getIdentifier(), this.fQualifier});
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            String groupName = Messages.format(FixMessages.CodeStyleFix_QualifyWithThis_description, new Object[]{this.fName.getIdentifier(), this.fQualifier});
            TextEditGroup group = new TextEditGroup(groupName);
            textEditGroups.add(group);
            rewrite.replace((ASTNode)this.fName, rewrite.createStringPlaceholder(String.valueOf(this.fQualifier) + '.' + this.fName.getIdentifier(), 42), group);
        }
    }

    private static final class AddStaticQualifierOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final IVariableBinding fBinding;
        private final SimpleName fName;

        public AddStaticQualifierOperation(IVariableBinding binding, SimpleName name) {
            this.fBinding = binding;
            this.fName = name;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit compilationUnit = cuRewrite.getRoot();
            ITypeBinding declaringClass = this.fBinding.getDeclaringClass();
            Type qualifier = this.importType(declaringClass, (ASTNode)this.fName, cuRewrite.getImportRewrite(), compilationUnit);
            TextEditGroup group = new TextEditGroup(Messages.format(FixMessages.CodeStyleFix_QualifyWithThis_description, new Object[]{this.fName.getIdentifier(), ASTNodes.asString((ASTNode)qualifier)}));
            textEditGroups.add(group);
            rewrite.replace((ASTNode)this.fName, (ASTNode)compilationUnit.getAST().newQualifiedType(qualifier, (SimpleName)rewrite.createMoveTarget((ASTNode)this.fName)), group);
        }
    }

    private static final class ToStaticAccessOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ITypeBinding fDeclaringTypeBinding;
        private final Expression fQualifier;

        public ToStaticAccessOperation(ITypeBinding declaringTypeBinding, Expression qualifier) {
            this.fDeclaringTypeBinding = declaringTypeBinding;
            this.fQualifier = qualifier;
        }

        public String getAccessorName() {
            return this.fDeclaringTypeBinding.getName();
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            Type type = this.importType(this.fDeclaringTypeBinding, (ASTNode)this.fQualifier, cuRewrite.getImportRewrite(), cuRewrite.getRoot());
            TextEditGroup group = new TextEditGroup(Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStatic_description, this.fDeclaringTypeBinding.getName()));
            textEditGroups.add(group);
            cuRewrite.getASTRewrite().replace((ASTNode)this.fQualifier, (ASTNode)type, group);
        }
    }
}

