/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.ConvertForLoopOperation;
import org.eclipse.jdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.text.edits.TextEditGroup;

public class ControlStatementsFix
extends AbstractFix {
    private static final String FOR_LOOP_ELEMENT_IDENTIFIER = "element";

    public static IFix createConvertForLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertForLoopOperation loopConverter = new ConvertForLoopOperation(compilationUnit, loop, FOR_LOOP_ELEMENT_IDENTIFIER, false, false);
        if (!loopConverter.satisfiesPreconditions()) {
            return null;
        }
        return new ControlStatementsFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{loopConverter});
    }

    public static IFix createConvertIterableLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertIterableLoopOperation loopConverter = new ConvertIterableLoopOperation(compilationUnit, loop, FOR_LOOP_ELEMENT_IDENTIFIER);
        if (!loopConverter.isApplicable()) {
            return null;
        }
        return new ControlStatementsFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{loopConverter});
    }

    public static IFix[] createRemoveBlockFix(CompilationUnit compilationUnit, ASTNode node) {
        RemoveBlockOperation op;
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement == null) {
            return null;
        }
        if (statement instanceof IfStatement) {
            String label1 = FixMessages.ControlStatementsFix_removeIfBlock_proposalDescription;
            RemoveBlockOperation op1 = ControlStatementsFix.createRemoveBlockOperation(statement, IfStatement.THEN_STATEMENT_PROPERTY);
            String label2 = FixMessages.ControlStatementsFix_removeElseBlock_proposalDescription;
            RemoveBlockOperation op2 = ControlStatementsFix.createRemoveBlockOperation(statement, IfStatement.ELSE_STATEMENT_PROPERTY);
            if (op1 != null && op2 != null) {
                return new IFix[]{new ControlStatementsFix(label1, compilationUnit, new IFixRewriteOperation[]{op1}), new ControlStatementsFix(label2, compilationUnit, new IFixRewriteOperation[]{op2}), new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfElseBlock_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op1, op2})};
            }
            if (op1 != null) {
                return new IFix[]{new ControlStatementsFix(label1, compilationUnit, new IFixRewriteOperation[]{op1})};
            }
            if (op2 != null) {
                return new IFix[]{new ControlStatementsFix(label2, compilationUnit, new IFixRewriteOperation[]{op2})};
            }
        } else if (statement instanceof WhileStatement) {
            RemoveBlockOperation op2 = ControlStatementsFix.createRemoveBlockOperation(statement, WhileStatement.BODY_PROPERTY);
            if (op2 != null) {
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op2})};
            }
        } else if (statement instanceof ForStatement) {
            RemoveBlockOperation op3 = ControlStatementsFix.createRemoveBlockOperation(statement, ForStatement.BODY_PROPERTY);
            if (op3 != null) {
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op3})};
            }
        } else if (statement instanceof EnhancedForStatement) {
            RemoveBlockOperation op4 = ControlStatementsFix.createRemoveBlockOperation(statement, EnhancedForStatement.BODY_PROPERTY);
            if (op4 != null) {
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op4})};
            }
        } else if (statement instanceof DoStatement && (op = ControlStatementsFix.createRemoveBlockOperation(statement, DoStatement.BODY_PROPERTY)) != null) {
            return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
        }
        return null;
    }

    private static RemoveBlockOperation createRemoveBlockOperation(Statement statement, ChildPropertyDescriptor child) {
        Block block;
        ASTNode node = (ASTNode)statement.getStructuralProperty((StructuralPropertyDescriptor)child);
        if (node instanceof Block && (block = (Block)node).statements().size() == 1) {
            return new RemoveBlockOperation(block, statement, child);
        }
        return null;
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean convertSingleStatementToBlock, boolean removeUnnecessaryBlock, boolean convertForLoopToEnhanced) throws CoreException {
        if (!(convertSingleStatementToBlock || convertForLoopToEnhanced || removeUnnecessaryBlock)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        ControlStatementFinder finder = new ControlStatementFinder(compilationUnit, convertSingleStatementToBlock, removeUnnecessaryBlock, convertForLoopToEnhanced, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] ops = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new ControlStatementsFix("", compilationUnit, ops);
    }

    protected ControlStatementsFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List fResult;
        private final Hashtable fUsedNames;
        private final CompilationUnit fCompilationUnit;
        private final boolean fFindControlStatementsWithoutBlock;
        private final boolean fFindForLoopsToConvert;
        private final boolean fRemoveUnnecessaryBlocks;

        public ControlStatementFinder(CompilationUnit compilationUnit, boolean findControlStatementsWithoutBlock, boolean removeUnnecessaryBlocks, boolean findForLoopsToConvert, List resultingCollection) throws CoreException {
            this.fFindControlStatementsWithoutBlock = findControlStatementsWithoutBlock;
            this.fRemoveUnnecessaryBlocks = removeUnnecessaryBlocks;
            this.fFindForLoopsToConvert = findForLoopsToConvert;
            this.fResult = resultingCollection;
            this.fUsedNames = new Hashtable();
            this.fCompilationUnit = compilationUnit;
        }

        public boolean visit(DoStatement node) {
            RemoveBlockOperation op;
            if (this.fFindControlStatementsWithoutBlock) {
                Statement doBody = node.getBody();
                if (!(doBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(DoStatement.BODY_PROPERTY, (ASTNode)doBody, (Statement)node));
                }
            } else if (this.fRemoveUnnecessaryBlocks && (op = ControlStatementsFix.createRemoveBlockOperation((Statement)node, DoStatement.BODY_PROPERTY)) != null) {
                this.fResult.add(op);
            }
            return super.visit(node);
        }

        public boolean visit(ForStatement node) {
            RemoveBlockOperation op;
            if (this.fFindForLoopsToConvert) {
                List usedVaribles = this.getUsedVariableNames((ASTNode)node);
                usedVaribles.addAll(this.fUsedNames.values());
                String[] used = usedVaribles.toArray(new String[usedVaribles.size()]);
                String identifierName = ControlStatementsFix.FOR_LOOP_ELEMENT_IDENTIFIER;
                int count = 0;
                int i = 0;
                while (i < used.length) {
                    if (used[i].equals(identifierName)) {
                        identifierName = ControlStatementsFix.FOR_LOOP_ELEMENT_IDENTIFIER + count;
                        ++count;
                        i = 0;
                    }
                    ++i;
                }
                ConvertForLoopOperation forConverter = new ConvertForLoopOperation(this.fCompilationUnit, node, identifierName, this.fFindControlStatementsWithoutBlock, this.fRemoveUnnecessaryBlocks);
                if (forConverter.satisfiesPreconditions()) {
                    this.fResult.add(forConverter);
                    this.fUsedNames.put(node, identifierName);
                } else {
                    RemoveBlockOperation op2;
                    ConvertIterableLoopOperation iterableConverter = new ConvertIterableLoopOperation(this.fCompilationUnit, node, identifierName);
                    if (iterableConverter.isApplicable()) {
                        this.fResult.add(iterableConverter);
                        this.fUsedNames.put(node, identifierName);
                    } else if (this.fFindControlStatementsWithoutBlock) {
                        Statement forBody = node.getBody();
                        if (!(forBody instanceof Block)) {
                            this.fResult.add(new AddBlockOperation(ForStatement.BODY_PROPERTY, (ASTNode)forBody, (Statement)node));
                        }
                    } else if (this.fRemoveUnnecessaryBlocks && (op2 = ControlStatementsFix.createRemoveBlockOperation((Statement)node, ForStatement.BODY_PROPERTY)) != null) {
                        this.fResult.add(op2);
                    }
                }
            } else if (this.fFindControlStatementsWithoutBlock) {
                Statement forBody = node.getBody();
                if (!(forBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(ForStatement.BODY_PROPERTY, (ASTNode)forBody, (Statement)node));
                }
            } else if (this.fRemoveUnnecessaryBlocks && (op = ControlStatementsFix.createRemoveBlockOperation((Statement)node, ForStatement.BODY_PROPERTY)) != null) {
                this.fResult.add(op);
            }
            return super.visit(node);
        }

        public boolean visit(EnhancedForStatement node) {
            RemoveBlockOperation op;
            if (this.fFindControlStatementsWithoutBlock) {
                Statement forBody = node.getBody();
                if (!(forBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(EnhancedForStatement.BODY_PROPERTY, (ASTNode)forBody, (Statement)node));
                }
            } else if (this.fRemoveUnnecessaryBlocks && (op = ControlStatementsFix.createRemoveBlockOperation((Statement)node, EnhancedForStatement.BODY_PROPERTY)) != null) {
                this.fResult.add(op);
            }
            return super.visit(node);
        }

        public void endVisit(ForStatement node) {
            if (this.fFindForLoopsToConvert) {
                this.fUsedNames.remove(node);
            }
            super.endVisit(node);
        }

        private List getUsedVariableNames(ASTNode node) {
            CompilationUnit root = (CompilationUnit)node.getRoot();
            IBinding[] varsBefore = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 2);
            IBinding[] varsAfter = new ScopeAnalyzer(root).getDeclarationsAfter(node.getStartPosition() + node.getLength(), 2);
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < varsBefore.length) {
                names.add(varsBefore[i].getName());
                ++i;
            }
            i = 0;
            while (i < varsAfter.length) {
                names.add(varsAfter[i].getName());
                ++i;
            }
            return names;
        }

        public boolean visit(IfStatement statement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement elseStatement;
                Statement then = statement.getThenStatement();
                if (!(then instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.THEN_STATEMENT_PROPERTY, (ASTNode)then, (Statement)statement));
                }
                if ((elseStatement = statement.getElseStatement()) != null && !(elseStatement instanceof Block) && !(elseStatement instanceof IfStatement)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.ELSE_STATEMENT_PROPERTY, (ASTNode)elseStatement, (Statement)statement));
                }
            } else if (this.fRemoveUnnecessaryBlocks) {
                RemoveBlockOperation op = ControlStatementsFix.createRemoveBlockOperation((Statement)statement, IfStatement.THEN_STATEMENT_PROPERTY);
                if (op != null) {
                    this.fResult.add(op);
                }
                if (!(statement.getElseStatement() instanceof IfStatement) && (op = ControlStatementsFix.createRemoveBlockOperation((Statement)statement, IfStatement.ELSE_STATEMENT_PROPERTY)) != null) {
                    this.fResult.add(op);
                }
            }
            return super.visit(statement);
        }

        public boolean visit(WhileStatement node) {
            RemoveBlockOperation op;
            if (this.fFindControlStatementsWithoutBlock) {
                Statement whileBody = node.getBody();
                if (!(whileBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(WhileStatement.BODY_PROPERTY, (ASTNode)whileBody, (Statement)node));
                }
            } else if (this.fRemoveUnnecessaryBlocks && (op = ControlStatementsFix.createRemoveBlockOperation((Statement)node, WhileStatement.BODY_PROPERTY)) != null) {
                this.fResult.add(op);
            }
            return super.visit(node);
        }
    }

    private static final class AddBlockOperation
    implements IFixRewriteOperation {
        private final ChildPropertyDescriptor fBodyProperty;
        private final ASTNode fBody;
        private final Statement fStatement;

        public AddBlockOperation(ChildPropertyDescriptor bodyProperty, ASTNode body, Statement statement) {
            this.fBodyProperty = bodyProperty;
            this.fBody = body;
            this.fStatement = statement;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            String label = this.fBodyProperty == IfStatement.THEN_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeIfToBlock_desription : (this.fBodyProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeElseToBlock_description : FixMessages.CodeStyleFix_ChangeControlToBlock_description);
            TextEditGroup group = new TextEditGroup(label);
            textEditGroups.add(group);
            ASTNode childPlaceholder = rewrite.createMoveTarget(this.fBody);
            Block replacingBody = cuRewrite.getRoot().getAST().newBlock();
            replacingBody.statements().add(childPlaceholder);
            rewrite.set((ASTNode)this.fStatement, (StructuralPropertyDescriptor)this.fBodyProperty, (Object)replacingBody, group);
        }
    }

    private static class RemoveBlockOperation
    implements IFixRewriteOperation {
        private final Block fBlock;
        private final Statement fStatement;
        private final ChildPropertyDescriptor fChild;

        public RemoveBlockOperation(Block block, Statement statement, ChildPropertyDescriptor child) {
            this.fBlock = block;
            this.fStatement = statement;
            this.fChild = child;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Statement moveTarget = (Statement)rewrite.createMoveTarget((ASTNode)this.fBlock.statements().get(0));
            rewrite.set((ASTNode)this.fStatement, (StructuralPropertyDescriptor)this.fChild, (Object)moveTarget, null);
        }
    }
}

