/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class UnusedCodeFix
extends AbstractFix {
    private final int fCleanUpFlags;
    static /* synthetic */ Class class$0;

    public static UnusedCodeFix createRemoveUnusedImportFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ImportDeclaration node;
        int id = problem.getProblemId();
        if ((id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) && (node = UnusedCodeFix.getImportDeclaration(problem, compilationUnit)) != null) {
            String label = FixMessages.UnusedCodeFix_RemoveImport_description;
            RemoveImportOperation operation = new RemoveImportOperation(node);
            return new UnusedCodeFix(label, compilationUnit, new IFixRewriteOperation[]{operation}, 1);
        }
        return null;
    }

    public static UnusedCodeFix createUnusedMemberFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        IBinding binding;
        SimpleName name;
        int id = problem.getProblemId();
        if ((id == 603979894 || id == 603979910 || id == 570425421 || id == 553648135 || id == 536870973 || id == 536870974) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null) {
            if (UnusedCodeFix.isFormalParameterInEnhancedForStatement(name)) {
                return null;
            }
            String label = UnusedCodeFix.getDisplayString(name, binding);
            RemoveUnusedMemberOperation operation = new RemoveUnusedMemberOperation(new SimpleName[]{name});
            return new UnusedCodeFix(label, compilationUnit, new IFixRewriteOperation[]{operation}, UnusedCodeFix.getCleanUpFlag(binding));
        }
        return null;
    }

    public static IFix createRemoveUnusedCastFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode;
        if (problem.getProblemId() != 553648309) {
            return null;
        }
        ASTNode curr = selectedNode = problem.getCoveringNode(compilationUnit);
        while (curr instanceof ParenthesizedExpression) {
            curr = ((ParenthesizedExpression)curr).getExpression();
        }
        if (!(curr instanceof CastExpression)) {
            return null;
        }
        return new UnusedCodeFix(FixMessages.UnusedCodeFix_RemoveCast_description, compilationUnit, new IFixRewriteOperation[]{new RemoveCastOperation((CastExpression)curr, selectedNode)});
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, locations, removeUnusedPrivateMethods, removeUnusedPrivateConstructors, removeUnusedPrivateFields, removeUnusedPrivateTypes, removeUnusedLocalVariables, removeUnusedImports, removeUnusedCast);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast) {
        ArrayList<IFixRewriteOperation> result = new ArrayList<IFixRewriteOperation>();
        Hashtable variableDeclarations = new Hashtable();
        int i = 0;
        while (i < problems.length) {
            IBinding binding;
            SimpleName name;
            ImportDeclaration node;
            IProblemLocation problem = problems[i];
            int id = problem.getProblemId();
            if (removeUnusedImports && id == 268435844 && (node = UnusedCodeFix.getImportDeclaration(problem, compilationUnit)) != null) {
                result.add(new RemoveImportOperation(node));
            }
            if ((removeUnusedPrivateMethods && id == 603979894 || removeUnusedPrivateConstructors && id == 603979910 || removeUnusedPrivateTypes && id == 553648135) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null) {
                result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}));
            }
            if ((removeUnusedLocalVariables && id == 536870973 || removeUnusedPrivateFields && id == 570425421) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null && !UnusedCodeFix.isFormalParameterInEnhancedForStatement(name) && UnusedCodeFix.isSideEffectFree(name, compilationUnit)) {
                VariableDeclarationFragment parent;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((parent = (VariableDeclarationFragment)ASTNodes.getParent((ASTNode)name, clazz)) != null) {
                    ASTNode varDecl = parent.getParent();
                    if (!variableDeclarations.containsKey(varDecl)) {
                        variableDeclarations.put(varDecl, new ArrayList());
                    }
                    ((List)variableDeclarations.get(varDecl)).add(name);
                } else {
                    result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}));
                }
            }
            if (removeUnusedCast && id == 553648309) {
                ASTNode selectedNode;
                ASTNode curr = selectedNode = problem.getCoveringNode(compilationUnit);
                while (curr instanceof ParenthesizedExpression) {
                    curr = ((ParenthesizedExpression)curr).getExpression();
                }
                if (curr instanceof CastExpression) {
                    result.add(new RemoveCastOperation((CastExpression)curr, selectedNode));
                }
            }
            ++i;
        }
        Iterator iter = variableDeclarations.keySet().iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            List names = (List)variableDeclarations.get(node);
            result.add(new RemoveUnusedMemberOperation(names.toArray(new SimpleName[names.size()])));
        }
        if (result.size() == 0) {
            return null;
        }
        return new UnusedCodeFix("", compilationUnit, result.toArray(new IFixRewriteOperation[result.size()]));
    }

    private static boolean isFormalParameterInEnhancedForStatement(SimpleName name) {
        return name.getParent() instanceof SingleVariableDeclaration && name.getParent().getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY;
    }

    private static boolean isSideEffectFree(SimpleName simpleName, CompilationUnit completeRoot) {
        SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, simpleName.getStartPosition(), simpleName.getLength());
        SimpleName[] references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
        int i = 0;
        while (i < references.length) {
            if (UnusedCodeFix.hasSideEffect(references[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean hasSideEffect(SimpleName reference) {
        ASTNode parent = reference.getParent();
        while (parent instanceof QualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof FieldAccess) {
            parent = parent.getParent();
        }
        Expression node = null;
        int nameParentType = parent.getNodeType();
        if (nameParentType == 7) {
            Assignment assignment = (Assignment)parent;
            node = assignment.getRightHandSide();
        } else if (nameParentType == 44) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)parent;
            node = decl.getInitializer();
            if (node == null) {
                return false;
            }
        } else if (nameParentType == 59) {
            node = parent;
        } else {
            return false;
        }
        ArrayList sideEffects = new ArrayList();
        node.accept((ASTVisitor)new SideEffectFinder(sideEffects));
        return sideEffects.size() > 0;
    }

    private static SimpleName getUnusedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        SimpleName name = null;
        if (selectedNode instanceof MethodDeclaration) {
            name = ((MethodDeclaration)selectedNode).getName();
        } else if (selectedNode instanceof SimpleName) {
            name = (SimpleName)selectedNode;
        }
        if (name != null) {
            return name;
        }
        return null;
    }

    private static String getDisplayString(SimpleName simpleName, IBinding binding) {
        String name = simpleName.getIdentifier();
        switch (binding.getKind()) {
            case 2: {
                return Messages.format(FixMessages.UnusedCodeFix_RemoveType_description, name);
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveConstructor_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveMethod_description, name);
            }
            case 3: {
                if (((IVariableBinding)binding).isField()) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_description, name);
            }
        }
        return "";
    }

    private static int getCleanUpFlag(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return 16;
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return 2;
                }
                return 4;
            }
            case 3: {
                return 40;
            }
        }
        return 0;
    }

    private static ImportDeclaration getImportDeclaration(IProblemLocation problem, CompilationUnit compilationUnit) {
        ASTNode node;
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode != null && (node = ASTNodes.getParent(selectedNode, 26)) instanceof ImportDeclaration) {
            return (ImportDeclaration)node;
        }
        return null;
    }

    private UnusedCodeFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        this(name, compilationUnit, fixRewriteOperations, 0);
    }

    private UnusedCodeFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations, int cleanUpFlag) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fCleanUpFlags = cleanUpFlag;
    }

    public UnusedCodeCleanUp getCleanUp() {
        return new UnusedCodeCleanUp(this.fCleanUpFlags);
    }

    private static class SideEffectFinder
    extends ASTVisitor {
        private ArrayList fSideEffectNodes;

        public SideEffectFinder(ArrayList res) {
            this.fSideEffectNodes = res;
        }

        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(PostfixExpression node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(PrefixExpression node) {
            PrefixExpression.Operator operator = node.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add(node);
            }
            return false;
        }

        public boolean visit(MethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }
    }

    private static class RemoveImportOperation
    implements IFixRewriteOperation {
        private final ImportDeclaration fImportDeclaration;

        public RemoveImportOperation(ImportDeclaration importDeclaration) {
            this.fImportDeclaration = importDeclaration;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ImportDeclaration node = this.fImportDeclaration;
            TextEditGroup group = new TextEditGroup(String.valueOf(FixMessages.UnusedCodeFix_RemoveImport_description) + " " + node.getName());
            cuRewrite.getASTRewrite().remove((ASTNode)node, group);
            textEditGroups.add(group);
        }
    }

    private static class RemoveUnusedMemberOperation
    implements IFixRewriteOperation {
        private final SimpleName[] fUnusedNames;

        public RemoveUnusedMemberOperation(SimpleName[] unusedNames) {
            this.fUnusedNames = unusedNames;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            int i = 0;
            while (i < this.fUnusedNames.length) {
                this.removeUnusedName(cuRewrite.getASTRewrite(), this.fUnusedNames[i], cuRewrite.getRoot(), textEditGroups);
                ++i;
            }
        }

        private void removeUnusedName(ASTRewrite rewrite, SimpleName simpleName, CompilationUnit completeRoot, List groups) {
            IBinding binding = simpleName.resolveBinding();
            CompilationUnit root = (CompilationUnit)simpleName.getRoot();
            String displayString = UnusedCodeFix.getDisplayString(simpleName, binding);
            TextEditGroup group = new TextEditGroup(displayString);
            groups.add(group);
            if (binding.getKind() == 4) {
                IMethodBinding decl = ((IMethodBinding)binding).getMethodDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                rewrite.remove(declaration, group);
            } else if (binding.getKind() == 2) {
                ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                rewrite.remove(declaration, group);
            } else {
                SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, simpleName.getStartPosition(), simpleName.getLength());
                SimpleName[] references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
                int i = 0;
                while (i < references.length) {
                    this.removeVariableReferences(rewrite, references[i], group);
                    ++i;
                }
                IVariableBinding bindingDecl = ((IVariableBinding)nameNode.resolveBinding()).getVariableDeclaration();
                ASTNode declaringNode = completeRoot.findDeclaringNode((IBinding)bindingDecl);
                if (declaringNode instanceof SingleVariableDeclaration) {
                    this.removeParamTag(rewrite, (SingleVariableDeclaration)declaringNode, group);
                }
            }
        }

        private void removeParamTag(ASTRewrite rewrite, SingleVariableDeclaration varDecl, TextEditGroup group) {
            TagElement tagElement;
            Javadoc javadoc;
            if (varDecl.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)varDecl.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, varDecl.getName().getIdentifier())) != null) {
                rewrite.remove((ASTNode)tagElement, group);
            }
        }

        private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference, TextEditGroup group) {
            int nameParentType;
            ASTNode parent = reference.getParent();
            while (parent instanceof QualifiedName) {
                parent = parent.getParent();
            }
            if (parent instanceof FieldAccess) {
                parent = parent.getParent();
            }
            if ((nameParentType = parent.getNodeType()) == 7) {
                Assignment assignment = (Assignment)parent;
                Expression rightHand = assignment.getRightHandSide();
                ASTNode assignParent = assignment.getParent();
                if (assignParent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                    this.removeVariableWithInitializer(rewrite, (ASTNode)rightHand, assignParent, group);
                } else {
                    rewrite.replace((ASTNode)assignment, rewrite.createCopyTarget((ASTNode)rightHand), group);
                }
            } else if (nameParentType == 44) {
                rewrite.remove(parent, group);
            } else if (nameParentType == 59) {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                ASTNode varDecl = frag.getParent();
                List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
                if (fragments.size() == this.fUnusedNames.length) {
                    rewrite.remove(varDecl, group);
                } else {
                    rewrite.remove((ASTNode)frag, group);
                }
            }
        }

        private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode, TextEditGroup group) {
            ArrayList sideEffectNodes = new ArrayList();
            initializerNode.accept((ASTVisitor)new SideEffectFinder(sideEffectNodes));
            int nSideEffects = sideEffectNodes.size();
            if (nSideEffects == 0) {
                if (ASTNodes.isControlStatementBody(statementNode.getLocationInParent())) {
                    rewrite.replace(statementNode, (ASTNode)rewrite.getAST().newBlock(), group);
                } else {
                    rewrite.remove(statementNode, group);
                }
            }
        }
    }

    private static class RemoveCastOperation
    implements IFixRewriteOperation {
        private final CastExpression fCast;
        private final ASTNode fSelectedNode;

        public RemoveCastOperation(CastExpression cast, ASTNode selectedNode) {
            this.fCast = cast;
            this.fSelectedNode = selectedNode;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CastExpression cast = this.fCast;
            Expression expression = cast.getExpression();
            ASTNode placeholder = rewrite.createCopyTarget((ASTNode)expression);
            if (ASTNodes.needsParentheses(expression)) {
                rewrite.replace((ASTNode)this.fCast, placeholder, null);
            } else {
                rewrite.replace(this.fSelectedNode, placeholder, null);
            }
        }
    }
}

