/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.jface.text.IRegion;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull(this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(BodyDeclaration node) {
        Assert.isTrue(!(node instanceof AbstractTypeDeclaration));
        node.accept((ASTVisitor)this);
        return this.getFlowInfo((ASTNode)node);
    }

    protected boolean traverseNode(ASTNode node) {
        return node.getStartPosition() + node.getLength() > this.fSelection.getInclusiveEnd();
    }

    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return node.getStartPosition() >= this.fSelection.getInclusiveEnd();
    }

    public boolean visit(DoStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    public boolean visit(EnhancedForStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    public boolean visit(ForStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    public boolean visit(WhileStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    private void createLoopReentranceVisitor(ASTNode node) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
        }
    }

    public void endVisit(ConditionalExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Expression thenPart = node.getThenExpression();
        Expression elsePart = node.getElseExpression();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    public void endVisit(DoStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    public void endVisit(IfStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Statement thenPart = node.getThenStatement();
        Statement elsePart = node.getElseStatement();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    public void endVisit(EnhancedForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    public void endVisit(SwitchStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowAnalyzer.SwitchData data = this.createSwitchData(node);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo((ASTNode)node, info);
                info.merge(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return;
            }
            ++i;
        }
        super.endVisit(node, data);
    }

    public void endVisit(WhileStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    private void endVisitConditional(GenericSequentialFlowInfo info, ASTNode condition, ASTNode[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        int i = 0;
        while (i < branches.length) {
            ASTNode branch = branches[i];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++i;
        }
    }

    private void handleLoopReentrance(ASTNode node) {
        if (!this.fSelection.coveredBy(node) || this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != node) {
            return;
        }
        this.fLoopReentranceVisitor.process(node);
        GenericSequentialFlowInfo info = this.createSequential();
        info.merge(this.getFlowInfo(node), this.fFlowContext);
        info.merge(this.fLoopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
        this.setFlowInfo(node, info);
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private ASTNode fLoopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, ASTNode loopNode) {
            super(context);
            this.fSelection = selection;
            this.fLoopNode = loopNode;
        }

        protected boolean traverseNode(ASTNode node) {
            return true;
        }

        protected boolean createReturnFlowInfo(ReturnStatement node) {
            return node.getStartPosition() + node.getLength() <= this.fSelection.getExclusiveEnd();
        }

        protected ASTNode getLoopNode() {
            return this.fLoopNode;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void process(ASTNode node) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                node.accept((ASTVisitor)this);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fFlowContext.setLoopReentranceMode(false);
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fFlowContext.setLoopReentranceMode(false);
                return;
            }
        }

        public void endVisit(DoStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo((ASTNode)node, info);
            info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
            info.removeLabel(null);
        }

        public void endVisit(EnhancedForStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            FlowInfo paramInfo = this.getFlowInfo((ASTNode)node.getParameter());
            FlowInfo expressionInfo = this.getFlowInfo((ASTNode)node.getExpression());
            FlowInfo actionInfo = this.getFlowInfo((ASTNode)node.getBody());
            EnhancedForFlowInfo forInfo = this.createEnhancedFor();
            this.setFlowInfo((ASTNode)node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeExpression(expressionInfo, this.fFlowContext);
                forInfo.mergeParameter(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }

        public void endVisit(ForStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            GenericSequentialFlowInfo initInfo = this.createSequential(node.initializers());
            FlowInfo conditionInfo = this.getFlowInfo((ASTNode)node.getExpression());
            GenericSequentialFlowInfo incrementInfo = this.createSequential(node.updaters());
            FlowInfo actionInfo = this.getFlowInfo((ASTNode)node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo((ASTNode)node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }
    }
}

