/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.osgi.util.NLS;

public class RenameJavaProjectProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private IJavaProject fProject;
    private boolean fUpdateReferences;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameJavaProjectProcessor";

    public RenameJavaProjectProcessor(IJavaProject project) {
        this.fProject = project;
        if (this.fProject != null) {
            this.setNewElementName(this.fProject.getElementName());
        }
        this.fUpdateReferences = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fProject);
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameJavaProjectRefactoring_rename, new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public Object getNewElement() throws CoreException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fProject, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile projectFile = this.fProject.getProject().getFile(".project");
        if (projectFile != null && projectFile.exists()) {
            return new IFile[]{projectFile};
        }
        return new IFile[0];
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectRefactoring_already_exists);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            pm.beginTask("", 1);
            try {
                if (!this.isReadOnly()) break block3;
                String message = Messages.format(RefactoringCoreMessages.RenameJavaProjectRefactoring_read_only, this.fProject.getElementName());
                refactoringStatus = RefactoringStatus.createErrorStatus((String)message);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() {
        return Resources.isReadOnly(this.fProject.getResource());
    }

    private boolean projectNameAlreadyExists(String newName) {
        return this.fProject.getJavaModel().getJavaProject(newName).exists();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameJavaProjectChange(this.fProject, this.getNewElementName(), this.getComment(), this.fUpdateReferences));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (arguments instanceof GenericRefactoringArguments) {
            IResource resource;
            GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (resource == null || !resource.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)"org.eclipse.jdt.ui.rename.java.project"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PATH));
            }
            this.fProject = (IJavaProject)JavaCore.create((IResource)resource);
            String name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_NAME));
            }
            this.setNewElementName(name);
            references = generic.getAttribute(ATTRIBUTE_REFERENCES);
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_REFERENCES));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }
}

