/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;

public final class PullUpRefactoringProcessor
extends HierarchyProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_DELETE = "delete";
    private static final String ATTRIBUTE_PULL = "pull";
    private static final String ATTRIBUTE_STUBS = "stubs";
    private static final String ID_PULL_UP = "org.eclipse.jdt.ui.pull.up";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.pullUpProcessor";
    private Set fCachedSkippedSuperclasses;
    private ITypeHierarchy fCachedTargetClassHierarchy;
    private CodeGenerationSettings fCodeGenerationSettings;
    private boolean fCreateMethodStubs;
    private IMethod[] fMethodsToDeclareAbstract;
    private IMethod[] fMethodsToDelete;
    private IType fTargetType;

    private static void addToMapping(Map mapping, IMember key, IMember matchingMember) {
        Set<IMember> matchingSet;
        if (mapping.containsKey(key)) {
            matchingSet = (Set)mapping.get(key);
        } else {
            matchingSet = new HashSet();
            mapping.put(key, matchingSet);
        }
        Assert.isTrue(!matchingSet.contains(matchingMember));
        matchingSet.add(matchingMember);
    }

    private static CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private static IMember[] getMembersOfType(IMember[] members, int type) {
        List<IJavaElement> list = Arrays.asList(JavaElementUtil.getElementsOfType((IJavaElement[])members, type));
        return list.toArray(new IMember[list.size()]);
    }

    private static Block getMethodStubBody(MethodDeclaration method, AST ast) {
        Block body = ast.newBlock();
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, method.getReturnType2(), method.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        return body;
    }

    private static Set getNonAbstractSubclasses(ITypeHierarchy hierarchy, IType type) throws JavaModelException {
        IType[] subclasses = hierarchy.getSubclasses(type);
        HashSet<IType> result = new HashSet<IType>();
        int i = 0;
        while (i < subclasses.length) {
            IType subclass = subclasses[i];
            if (JdtFlags.isAbstract((IMember)subclass)) {
                result.addAll(PullUpRefactoringProcessor.getNonAbstractSubclasses(hierarchy, subclass));
            } else {
                result.add(subclass);
            }
            ++i;
        }
        return result;
    }

    private static IMethod[] getOriginals(IMethod[] methods) {
        IMethod[] result = new IMethod[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = (IMethod)WorkingCopyUtil.getOriginal((IMember)methods[i]);
            ++i;
        }
        return result;
    }

    private static void mergeSetsForCommonKeys(Map result, Map map) {
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (!map.containsKey(key)) continue;
            Set resultSet = (Set)result.get(key);
            Set mapSet = (Set)map.get(key);
            resultSet.addAll(mapSet);
        }
    }

    private static void putAllThatDoNotExistInResultYet(Map result, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (result.containsKey(key)) continue;
            Set mapSet = (Set)map.get(key);
            HashSet resultSet = new HashSet(mapSet);
            result.put(key, resultSet);
        }
    }

    public PullUpRefactoringProcessor(IMember[] members, CodeGenerationSettings settings) {
        super(members);
        if (members != null) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            try {
                if (type != null && RefactoringAvailabilityTester.getPullUpMembers(type).length != 0) {
                    this.fMembersToMove = new IMember[0];
                    this.fDeclaringType = RefactoringAvailabilityTester.getTopLevelType(members);
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        this.fCodeGenerationSettings = settings;
        this.fMethodsToDelete = new IMethod[0];
        this.fMethodsToDeclareAbstract = new IMethod[0];
        this.fCreateMethodStubs = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllRequiredPullableMembers(List queue, IMember member, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull(queue);
        Assert.isNotNull(member);
        Assert.isNotNull(monitor);
        SubProgressMonitor sub = null;
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, 3);
            IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            boolean isStatic = false;
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredMethods.length) {
                    IMethod requiredMethod = requiredMethods[index];
                    if ((!isStatic || JdtFlags.isStatic((IMember)requiredMethod)) && this.isRequiredPullableMember(queue, (IMember)requiredMethod) && !this.isVirtualAccessibleFromTargetClass(requiredMethod, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1))) {
                        queue.add(requiredMethod);
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                sub.done();
                throw throwable;
            }
            {
                Object var9_16 = null;
            }
            sub.done();
            IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredFields.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredFields.length) {
                    IField requiredField = requiredFields[index];
                    if ((!isStatic || JdtFlags.isStatic((IMember)requiredField)) && this.isRequiredPullableMember(queue, (IMember)requiredField)) {
                        queue.add(requiredField);
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                sub.done();
                throw throwable;
            }
            {
                Object var10_14 = null;
            }
            sub.done();
            IType[] requiredTypes = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredTypes.length) {
                    IType requiredType = requiredTypes[index];
                    if ((!isStatic || JdtFlags.isStatic((IMember)requiredType)) && this.isRequiredPullableMember(queue, (IMember)requiredType)) {
                        queue.add(requiredType);
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                sub.done();
                throw throwable;
            }
            {
                Object var11_20 = null;
                sub.done();
            }
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_24 = null;
        }
        monitor.done();
    }

    private void addMethodStubForAbstractMethod(IMethod sourceMethod, CompilationUnit declaringCuNode, AbstractTypeDeclaration typeToCreateStubIn, ICompilationUnit newCu, CompilationUnitRewrite rewriter, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        MethodDeclaration methodToCreateStubFor = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = rewriter.getRoot().getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(PullUpRefactoringProcessor.getMethodStubBody(methodToCreateStubFor, ast));
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodToCreateStubFor.getExtraDimensions());
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, JdtFlags.clearFlag(1280, methodToCreateStubFor.getModifiers()), adjustments, (IProgressMonitor)new SubProgressMonitor(monitor, 1), false, status)));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)methodToCreateStubFor.getName()));
        TypeVariableMaplet[] mapping = TypeVariableUtil.composeMappings(TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), this.getTargetClass()), TypeVariableUtil.superTypeToInheritedType(this.getTargetClass(), (IType)typeToCreateStubIn.resolveBinding().getJavaElement()));
        this.copyReturnType(rewriter.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        this.copyParameters(rewriter.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(methodToCreateStubFor, newMethod);
        newMethod.setJavadoc(this.createJavadocForStub(typeToCreateStubIn.getName().getIdentifier(), methodToCreateStubFor, newMethod, newCu, rewriter.getASTRewrite()));
        ImportRewriteUtil.addImports(rewriter, (ASTNode)newMethod, new HashMap(), new HashMap(), false);
        rewriter.getASTRewrite().getListRewrite((ASTNode)typeToCreateStubIn, typeToCreateStubIn.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, typeToCreateStubIn.bodyDeclarations()), rewriter.createGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_method_stub));
    }

    private void addMethodStubsToNonAbstractSubclassesOfTargetClass(List concreteSubclasses, CompilationUnit declaringCuNode, CompilationUnitRewrite unitRewriter, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        IType declaringType = this.getDeclaringType();
        IMethod[] methods = this.getAbstractMethods();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, concreteSubclasses.size());
        Iterator iter = concreteSubclasses.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            if (clazz.equals(declaringType)) continue;
            AbstractTypeDeclaration classToCreateStubIn = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(clazz, unitRewriter.getRoot());
            ICompilationUnit cuToCreateStubIn = clazz.getCompilationUnit();
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
            sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, methods.length);
            int j = 0;
            while (j < methods.length) {
                IMethod method = methods[j];
                if (JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), clazz) == null) {
                    this.addMethodStubForAbstractMethod(method, declaringCuNode, classToCreateStubIn, cuToCreateStubIn, unitRewriter, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1), status);
                }
                ++j;
            }
            sub.done();
        }
        monitor.done();
    }

    protected boolean canBeAccessedFrom(IMember member, IType target, ITypeHierarchy hierarchy) throws JavaModelException {
        if (super.canBeAccessedFrom(member, target, hierarchy)) {
            IMethod method;
            IMethod stub;
            if (target.equals(member.getDeclaringType())) {
                return true;
            }
            if (target.equals(member)) {
                return true;
            }
            if (member instanceof IMethod && (stub = target.getMethod((method = (IMethod)member).getElementName(), method.getParameterTypes())).exists()) {
                return true;
            }
            if (member.getDeclaringType() == null) {
                if (!(member instanceof IType)) {
                    return false;
                }
                if (JdtFlags.isPublic(member)) {
                    return true;
                }
                if (!JdtFlags.isPackageVisible(member)) {
                    return false;
                }
                if (JavaModelUtil.isSamePackage(((IType)member).getPackageFragment(), target.getPackageFragment())) {
                    return true;
                }
                IType type = member.getDeclaringType();
                if (type != null) {
                    return hierarchy.contains(type);
                }
                return false;
            }
            IType declaringType = member.getDeclaringType();
            if (!this.canBeAccessedFrom((IMember)declaringType, target, hierarchy)) {
                return false;
            }
            return !declaringType.equals(this.getDeclaringType());
        }
        return false;
    }

    private RefactoringStatus checkAccessedFields(IProgressMonitor pm, ITypeHierarchy hierarchy) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToMove, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        int i = 0;
        while (i < accessedFields.length) {
            IField field = accessedFields[i];
            if (field.exists()) {
                String message;
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(field) || deletedList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass, hierarchy) || Flags.isEnum((int)field.getFlags());
                if (!isAccessible) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_not_accessible, new String[]{PullUpRefactoringProcessor.createFieldLabel(field), PullUpRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                } else if (this.getSkippedSuperclasses((IProgressMonitor)new SubProgressMonitor(pm, 1)).contains(field.getDeclaringType())) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_cannot_be_accessed, new String[]{PullUpRefactoringProcessor.createFieldLabel(field), PullUpRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IProgressMonitor pm, ITypeHierarchy hierarchy) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMethod> declaredAbstractList = Arrays.asList(this.fMethodsToDeclareAbstract);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToMove, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        int i = 0;
        while (i < accessedMethods.length) {
            IMethod method = accessedMethods[i];
            if (method.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(method) || deletedList.contains(method) || declaredAbstractList.contains(method) || this.canBeAccessedFrom((IMember)method, targetClass, hierarchy);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_not_accessible, new String[]{PullUpRefactoringProcessor.createMethodLabel(method), PullUpRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                } else if (this.getSkippedSuperclasses((IProgressMonitor)new SubProgressMonitor(pm, 1)).contains(method.getDeclaringType())) {
                    Object[] keys = new String[]{PullUpRefactoringProcessor.createMethodLabel(method), PullUpRefactoringProcessor.createTypeLabel(targetClass)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_cannot_be_accessed, keys);
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IProgressMonitor pm, ITypeHierarchy hierarchy) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypesReferencedInMovedMembers(pm);
        IType targetClass = this.getTargetClass();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedTypes.length) {
            IType iType = accessedTypes[i];
            if (iType.exists() && !this.canBeAccessedFrom((IMember)iType, targetClass, hierarchy) && !pulledUpList.contains(iType)) {
                String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_type_not_accessible, new String[]{PullUpRefactoringProcessor.createTypeLabel(iType), PullUpRefactoringProcessor.createTypeLabel(targetClass)});
                result.addError(message, JavaStatusContext.create((IMember)iType));
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccesses(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 3);
        ITypeHierarchy hierarchy = this.getTargetClass().newSupertypeHierarchy(null);
        result.merge(this.checkAccessedTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), hierarchy));
        result.merge(this.checkAccessedFields((IProgressMonitor)new SubProgressMonitor(pm, 1), hierarchy));
        result.merge(this.checkAccessedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1), hierarchy));
        pm.done();
        return result;
    }

    private void checkAccessModifiers(RefactoringStatus result, Set notDeletedMembersInSubtypes) throws JavaModelException {
        List<IMethod> toDeclareAbstract = Arrays.asList(this.fMethodsToDeclareAbstract);
        Iterator iter = notDeletedMembersInSubtypes.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (member.getElementType() != 9 || toDeclareAbstract.contains(member)) continue;
            IMethod method = (IMethod)member;
            if (method.getDeclaringType().getPackageFragment().equals(this.fTargetType.getPackageFragment())) {
                if (!JdtFlags.isPrivate((IMember)method)) continue;
                result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_default_visibility, new String[]{PullUpRefactoringProcessor.createMethodLabel(method), PullUpRefactoringProcessor.createTypeLabel(method.getDeclaringType())}), JavaStatusContext.create((IMember)method));
                continue;
            }
            if (JdtFlags.isPublic((IMember)method) || JdtFlags.isProtected((IMember)method)) continue;
            result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_protected_visibility, new String[]{PullUpRefactoringProcessor.createMethodLabel(method), PullUpRefactoringProcessor.createTypeLabel(method.getDeclaringType())}), JavaStatusContext.create((IMember)method));
        }
    }

    protected RefactoringStatus checkDeclaringType(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus status = super.checkDeclaringType(monitor);
        if (JavaModelUtil.getFullyQualifiedName(this.getDeclaringType()).equals("java.lang.Object")) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PullUpRefactoring_no_java_lang_Object));
        }
        status.merge(this.checkSuperclassesOfDeclaringClass(monitor));
        return status;
    }

    private void checkFieldTypes(IProgressMonitor pm, RefactoringStatus result) throws JavaModelException {
        Map mapping = this.getMatchingMembersMappingFromTypeAndAllSubtypes(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass(), true);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (this.fMembersToMove[i].getElementType() == 8) {
                IField field = (IField)this.fMembersToMove[i];
                String type = Signature.toString((String)field.getTypeSignature());
                Assert.isTrue(mapping.containsKey(field));
                Iterator iter = ((Set)mapping.get(field)).iterator();
                while (iter.hasNext()) {
                    IField matchingField = (IField)iter.next();
                    if (field.equals(matchingField) || type.equals(Signature.toString((String)matchingField.getTypeSignature()))) continue;
                    Object[] keys = new String[]{PullUpRefactoringProcessor.createFieldLabel(matchingField), PullUpRefactoringProcessor.createTypeLabel(matchingField.getDeclaringType())};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_field_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create(matchingField.getCompilationUnit(), matchingField.getSourceRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 7);
                this.clearCaches();
                result = new RefactoringStatus();
                result.merge(this.checkGenericDeclaringType(new SubProgressMonitor(pm, 1)));
                result.merge(this.checkFinalFields((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkAccesses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkMembersInTypeAndAllSubtypes((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                result.merge(this.checkIfSkippingOverElements((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!JdtFlags.isAbstract((IMember)this.getTargetClass()) && this.getAbstractMethods().length > 0) {
                    result.merge(PullUpRefactoringProcessor.checkCallsToClassConstructors(this.getTargetClass(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                if (!result.hasFatalError()) break block6;
                refactoringStatus = result;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext()));
        RefactoringStatus refactoringStatus = result;
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkFinalFields(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
        int index = 0;
        while (index < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[index];
            if (member.getElementType() == 8 && !JdtFlags.isStatic(member) && JdtFlags.isFinal(member)) {
                RefactoringStatusContext context = JavaStatusContext.create(member);
                result.addWarning(RefactoringCoreMessages.PullUpRefactoring_final_fields, context);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++index;
        }
        monitor.done();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkGenericDeclaringType(SubProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            IMember[] pullables = this.getMembersToMove();
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, pullables.length);
            IType declaring = this.getDeclaringType();
            ITypeParameter[] parameters = declaring.getTypeParameters();
            if (parameters.length > 0) {
                TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(declaring);
                IMember member = null;
                int length = 0;
                int index = 0;
                while (index < pullables.length) {
                    member = pullables[index];
                    String[] unmapped = TypeVariableUtil.getUnmappedVariables(mapping, declaring, member);
                    length = unmapped.length;
                    switch (length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable_not_available, new String[]{unmapped[0], declaring.getSuperclassName()}), JavaStatusContext.create(member));
                            break;
                        }
                        case 2: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable2_not_available, new String[]{unmapped[0], unmapped[1], declaring.getSuperclassName()}), JavaStatusContext.create(member));
                            break;
                        }
                        case 3: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable3_not_available, new String[]{unmapped[0], unmapped[1], unmapped[2], declaring.getSuperclassName()}), JavaStatusContext.create(member));
                            break;
                        }
                        default: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variables_not_available, new String[]{declaring.getSuperclassName()}), JavaStatusContext.create(member));
                        }
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++index;
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        monitor.done();
        return status;
    }

    private RefactoringStatus checkIfDeclaredIn(IMember element, IType type) throws JavaModelException {
        if (element instanceof IMethod) {
            return this.checkIfMethodDeclaredIn((IMethod)element, type);
        }
        if (element instanceof IField) {
            return this.checkIfFieldDeclaredIn((IField)element, type);
        }
        if (element instanceof IType) {
            return this.checkIfTypeDeclaredIn((IType)element, type);
        }
        Assert.isTrue(false);
        return null;
    }

    private RefactoringStatus checkIfFieldDeclaredIn(IField iField, IType type) {
        IField fieldInType = type.getField(iField.getElementName());
        if (!fieldInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{PullUpRefactoringProcessor.createFieldLabel(fieldInType), PullUpRefactoringProcessor.createTypeLabel(type)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Field_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)fieldInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfMethodDeclaredIn(IMethod iMethod, IType type) throws JavaModelException {
        IMethod methodInType = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type);
        if (methodInType == null || !methodInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{PullUpRefactoringProcessor.createMethodLabel(methodInType), PullUpRefactoringProcessor.createTypeLabel(type)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Method_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)methodInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfSkippingOverElements(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
        try {
            Set skippedSuperclassSet = this.getSkippedSuperclasses((IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] skippedSuperclasses = skippedSuperclassSet.toArray(new IType[skippedSuperclassSet.size()]);
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < this.fMembersToMove.length) {
                IMember element = this.fMembersToMove[i];
                int j = 0;
                while (j < skippedSuperclasses.length) {
                    result.merge(this.checkIfDeclaredIn(element, skippedSuperclasses[j]));
                    ++j;
                }
                ++i;
            }
            refactoringStatus = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkIfTypeDeclaredIn(IType iType, IType type) {
        IType typeInType = type.getType(iType.getElementName());
        if (!typeInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{PullUpRefactoringProcessor.createTypeLabel(typeInType), PullUpRefactoringProcessor.createTypeLabel(type)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)typeInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block5: {
            block4: {
                RefactoringStatus refactoringStatus;
                try {
                    pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
                    result = new RefactoringStatus();
                    this.fMembersToMove = WorkingCopyUtil.getOriginals(this.fMembersToMove);
                    result.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (!result.hasFatalError()) break block4;
                    refactoringStatus = result;
                    Object var3_6 = null;
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return refactoringStatus;
            }
            result.merge(this.checkIfMembersExist());
            if (!result.hasFatalError()) break block5;
            RefactoringStatus refactoringStatus = result;
            Object var3_7 = null;
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = result;
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private void checkMembersInDestinationType(RefactoringStatus result, Set notDeletedMembersInTargetType) throws JavaModelException {
        IMember[] membersToBeCreatedInTargetClass = this.getMembersToBeCreatedInTargetClass();
        ArrayList<IMember> newMembersInDestinationType = new ArrayList<IMember>(membersToBeCreatedInTargetClass.length);
        newMembersInDestinationType.addAll(Arrays.asList(membersToBeCreatedInTargetClass));
        newMembersInDestinationType.addAll(notDeletedMembersInTargetType);
        newMembersInDestinationType.removeAll(Arrays.asList(this.fMethodsToDelete));
        IMember[] members = newMembersInDestinationType.toArray(new IMember[newMembersInDestinationType.size()]);
        result.merge(MemberCheckUtil.checkMembersInDestinationType(members, this.getTargetClass()));
    }

    private RefactoringStatus checkMembersInTypeAndAllSubtypes(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 3);
        Set notDeletedMembers = this.getNotDeletedMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        HashSet<IMember> notDeletedMembersInTargetType = new HashSet<IMember>();
        HashSet<IMember> notDeletedMembersInSubtypes = new HashSet<IMember>();
        Iterator iter = notDeletedMembers.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (this.getTargetClass().equals(member.getDeclaringType())) {
                notDeletedMembersInTargetType.add(member);
                continue;
            }
            notDeletedMembersInSubtypes.add(member);
        }
        this.checkMembersInDestinationType(result, notDeletedMembersInTargetType);
        this.checkAccessModifiers(result, notDeletedMembersInSubtypes);
        this.checkMethodReturnTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result, notDeletedMembersInSubtypes);
        this.checkFieldTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        pm.done();
        return result;
    }

    private void checkMethodReturnTypes(IProgressMonitor pm, RefactoringStatus result, Set notDeletedMembersInSubtypes) throws JavaModelException {
        Map mapping = this.getMatchingMembersMappingFromTypeAndAllSubtypes(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass(), true);
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            if (members[i].getElementType() == 9) {
                IMethod method = (IMethod)members[i];
                String returnType = Signature.toString((String)Signature.getReturnType((String)method.getSignature()).toString());
                Assert.isTrue(mapping.containsKey(method));
                Iterator iter = ((Set)mapping.get(method)).iterator();
                while (iter.hasNext()) {
                    IMethod matchingMethod = (IMethod)iter.next();
                    if (method.equals(matchingMethod) || !notDeletedMembersInSubtypes.contains(matchingMethod) || returnType.equals(Signature.toString((String)Signature.getReturnType((String)matchingMethod.getSignature()).toString()))) continue;
                    Object[] keys = new String[]{PullUpRefactoringProcessor.createMethodLabel(matchingMethod), PullUpRefactoringProcessor.createTypeLabel(matchingMethod.getDeclaringType())};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_method_return_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create(matchingMethod.getCompilationUnit(), matchingMethod.getNameRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    private RefactoringStatus checkSuperclassesOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.getPossibleTargetClasses(result, pm).length == 0 && !result.hasFatalError()) {
            String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_not_this_type, new String[]{PullUpRefactoringProcessor.createTypeLabel(this.getDeclaringType())});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return result;
    }

    protected void clearCaches() {
        super.clearCaches();
        this.fCachedMembersReferences.clear();
        this.fCachedTargetClassHierarchy = null;
    }

    private void copyBodyOfPulledUpMethod(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping, IProgressMonitor pm) throws JavaModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getCompilationUnit().getBuffer().getContents());
            ASTRewrite rewrite = ASTRewrite.create((AST)body.getAST());
            ITrackedNodePosition position = rewrite.track((ASTNode)body);
            body.accept((ASTVisitor)new PullUpAstNodeMapper(sourceRewrite, targetRewrite, rewrite, this.getSuperclassOfDeclaringClass(pm), mapping));
            rewrite.rewriteAST((IDocument)document, method.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getJavaProject(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
            newMethod.setBody((Block)targetRewrite.getASTRewrite().createStringPlaceholder(content, 8));
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    private void createAbstractMethod(IMethod sourceMethod, CompilationUnitRewrite sourceRewriter, CompilationUnit declaringCuNode, AbstractTypeDeclaration targetClass, TypeVariableMaplet[] mapping, CompilationUnitRewrite targetRewrite, Map adjustments, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        if (JavaModelUtil.is50OrHigher(sourceMethod.getJavaProject()) && (this.fCodeGenerationSettings.overrideAnnotation || "error".equals(sourceMethod.getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", true)))) {
            MarkerAnnotation annotation = sourceRewriter.getAST().newMarkerAnnotation();
            annotation.setTypeName((Name)sourceRewriter.getAST().newSimpleName("Override"));
            sourceRewriter.getASTRewrite().getListRewrite((ASTNode)oldMethod, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, sourceRewriter.createGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_override_annotation));
        }
        MethodDeclaration newMethod = targetRewrite.getAST().newMethodDeclaration();
        newMethod.setBody(null);
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        newMethod.setJavadoc(null);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, 0x400 | JdtFlags.clearFlag(272, sourceMethod.getFlags()), adjustments, pm, false, status);
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(targetRewrite.getAST(), modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)oldMethod.getName()));
        this.copyReturnType(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        ImportRewriteUtil.addImports(targetRewrite, (ASTNode)newMethod, new HashMap(), new HashMap(), false);
        targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetClass, targetClass.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, targetClass.bodyDeclarations()), targetRewrite.createGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_abstract_method));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.PullUpRefactoring_Pull_Up, (Change[])this.fChangeManager.getAllChanges()){

                public final RefactoringDescriptor getRefactoringDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("input", PullUpRefactoringProcessor.this.fTargetType.getHandleIdentifier());
                    if (PullUpRefactoringProcessor.this.fDeclaringType != null) {
                        arguments.put("element1", PullUpRefactoringProcessor.this.fDeclaringType.getHandleIdentifier());
                    }
                    arguments.put(PullUpRefactoringProcessor.ATTRIBUTE_PULL, new Integer(PullUpRefactoringProcessor.this.fMembersToMove.length).toString());
                    int offset = 0;
                    while (offset < PullUpRefactoringProcessor.this.fMembersToMove.length) {
                        arguments.put("element" + (offset + 2), PullUpRefactoringProcessor.this.fMembersToMove[offset].getHandleIdentifier());
                        ++offset;
                    }
                    arguments.put(PullUpRefactoringProcessor.ATTRIBUTE_DELETE, new Integer(PullUpRefactoringProcessor.this.fMethodsToDelete.length).toString());
                    offset = 0;
                    while (offset < PullUpRefactoringProcessor.this.fMethodsToDelete.length) {
                        arguments.put("element" + (offset + PullUpRefactoringProcessor.this.fMembersToMove.length + 2), PullUpRefactoringProcessor.this.fMethodsToDelete[offset].getHandleIdentifier());
                        ++offset;
                    }
                    arguments.put(PullUpRefactoringProcessor.ATTRIBUTE_ABSTRACT, new Integer(PullUpRefactoringProcessor.this.fMethodsToDeclareAbstract.length).toString());
                    offset = 0;
                    while (offset < PullUpRefactoringProcessor.this.fMethodsToDeclareAbstract.length) {
                        arguments.put("element" + (offset + PullUpRefactoringProcessor.this.fMembersToMove.length + PullUpRefactoringProcessor.this.fMethodsToDelete.length + 2), PullUpRefactoringProcessor.this.fMethodsToDeclareAbstract[offset].getHandleIdentifier());
                        ++offset;
                    }
                    arguments.put(PullUpRefactoringProcessor.ATTRIBUTE_STUBS, Boolean.valueOf(PullUpRefactoringProcessor.this.fCreateMethodStubs).toString());
                    String project = null;
                    IType declaring = PullUpRefactoringProcessor.this.getDeclaringType();
                    IJavaProject javaProject = declaring.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    return new RefactoringDescriptor(PullUpRefactoringProcessor.ID_PULL_UP, project, PullUpRefactoringProcessor.this.fMembersToMove.length == 1 ? NLS.bind((String)RefactoringCoreMessages.PullUpRefactoring_descriptor_description_full, (Object[])new String[]{JavaElementLabels.getElementLabel((IJavaElement)PullUpRefactoringProcessor.this.fMembersToMove[0], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)PullUpRefactoringProcessor.this.fTargetType, JavaElementLabels.ALL_FULLY_QUALIFIED)}) : NLS.bind((String)RefactoringCoreMessages.PullUpRefactoring_descriptor_description, (Object[])new String[]{JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)PullUpRefactoringProcessor.this.fTargetType, JavaElementLabels.ALL_FULLY_QUALIFIED)}), PullUpRefactoringProcessor.this.getComment(), arguments, 65542);
                }
            };
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearCaches();
            throw throwable;
        }
        pm.done();
        this.clearCaches();
        return dynamicValidationStateChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        TextChangeManager textChangeManager;
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 6);
            ICompilationUnit source = this.getDeclaringType().getCompilationUnit();
            IType targetClass = this.getTargetClass();
            ICompilationUnit target = targetClass.getCompilationUnit();
            CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(source);
            CompilationUnitRewrite targetRewriter = new CompilationUnitRewrite(target);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            rewrites.put(source, sourceRewriter);
            rewrites.put(target, targetRewriter);
            Map deleteMap = this.createMembersToDeleteMap((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Map effectedMap = this.createNonAbstractSubclassesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ICompilationUnit[] units = this.getInvolvedCompilationUnits((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ICompilationUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            HashMap<IMethod, MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment> adjustments = new HashMap<IMethod, MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment>();
            MemberVisibilityAdjustor adjustor = null;
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, units.length * 11);
                int index = 0;
                while (index < units.length) {
                    unit = units[index];
                    if (!(source.equals(unit) || target.equals(unit) || deleteMap.containsKey(unit) || effectedMap.containsKey(unit))) {
                        sub.worked(10);
                    } else {
                        rewrite = PullUpRefactoringProcessor.getCompilationUnitRewrite(rewrites, unit);
                        if (deleteMap.containsKey(unit) && !targetClass.isInterface()) {
                            PullUpRefactoringProcessor.deleteDeclarationNodes(sourceRewriter, sourceRewriter.getCu().equals(targetRewriter.getCu()), rewrite, (List)deleteMap.get(unit));
                        }
                        CompilationUnit root = sourceRewriter.getRoot();
                        if (unit.equals(target)) {
                            ASTRewrite rewriter = rewrite.getASTRewrite();
                            if (!JdtFlags.isAbstract((IMember)targetClass) && !targetClass.isInterface() && this.getAbstractMethods().length > 0) {
                                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(targetClass, rewrite.getRoot());
                                ModifierRewrite.create(rewriter, (ASTNode)declaration).setModifiers(declaration.getModifiers() | 0x400, rewrite.createGroupDescription(RefactoringCoreMessages.PullUpRefactoring_make_target_abstract));
                            }
                            TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), targetClass);
                            SubProgressMonitor subsub = new SubProgressMonitor((IProgressMonitor)sub, 1);
                            AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(targetClass, rewrite.getRoot());
                            this.fMembersToMove = JavaElementUtil.sortByOffset(this.fMembersToMove);
                            subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
                            IMember member = null;
                            int offset = this.fMembersToMove.length - 1;
                            while (true) {
                                if (offset < 0) {
                                    subsub.done();
                                    offset = 0;
                                    break;
                                }
                                member = this.fMembersToMove[offset];
                                adjustor = new MemberVisibilityAdjustor((IJavaElement)targetClass, member);
                                adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                adjustor.setFailureSeverity(2);
                                adjustor.setRewrites(rewrites);
                                adjustor.setStatus(status);
                                adjustor.setAdjustments(adjustments);
                                adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1));
                                adjustments.remove(member);
                                if (member instanceof IField) {
                                    VariableDeclarationFragment oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, root);
                                    if (oldField != null) {
                                        FieldDeclaration newField = PullUpRefactoringProcessor.createNewFieldDeclarationNode(rewriter, root, (IField)member, oldField, mapping, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status, this.getModifiersWithUpdatedVisibility(member, member.getFlags(), adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), true, status));
                                        rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newField, ASTNodes.getInsertionIndex((BodyDeclaration)newField, declaration.bodyDeclarations()), rewrite.createGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member));
                                        ImportRewriteUtil.addImports(rewrite, oldField.getParent(), new HashMap(), new HashMap(), false);
                                    }
                                } else if (member instanceof IMethod) {
                                    MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
                                    if (oldMethod != null) {
                                        MethodDeclaration newMethod = this.createNewMethodDeclarationNode(sourceRewriter, rewrite, (IMethod)member, oldMethod, root, mapping, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status);
                                        rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, declaration.bodyDeclarations()), rewrite.createGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member));
                                        ImportRewriteUtil.addImports(rewrite, (ASTNode)oldMethod, new HashMap(), new HashMap(), false);
                                    }
                                } else if (member instanceof IType) {
                                    AbstractTypeDeclaration oldType = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
                                    if (oldType != null) {
                                        BodyDeclaration newType = this.createNewTypeDeclarationNode((IType)member, oldType, root, mapping, rewriter);
                                        rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newType, ASTNodes.getInsertionIndex(newType, declaration.bodyDeclarations()), rewrite.createGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member));
                                        ImportRewriteUtil.addImports(rewrite, (ASTNode)oldType, new HashMap(), new HashMap(), false);
                                    }
                                } else {
                                    Assert.isTrue(false);
                                }
                                subsub.worked(1);
                                --offset;
                            }
                            while (offset < this.fMethodsToDeclareAbstract.length) {
                                this.createAbstractMethod(this.fMethodsToDeclareAbstract[offset], sourceRewriter, root, declaration, mapping, rewrite, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1), status);
                                ++offset;
                            }
                        } else {
                            sub.worked(2);
                        }
                        if (unit.equals(sourceRewriter.getCu())) {
                            SubProgressMonitor subsub = new SubProgressMonitor((IProgressMonitor)sub, 1);
                            subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMethodsToDeclareAbstract.length * 2);
                            IMethod method = null;
                            int offset = 0;
                            while (offset < this.fMethodsToDeclareAbstract.length) {
                                method = this.fMethodsToDeclareAbstract[offset];
                                adjustor = new MemberVisibilityAdjustor((IJavaElement)targetClass, (IMember)method);
                                adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                adjustor.setRewrites(rewrites);
                                adjustor.setFailureSeverity(2);
                                adjustor.setStatus(status);
                                adjustor.setAdjustments(adjustments);
                                if (this.needsVisibilityAdjustment((IMember)method, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status)) {
                                    adjustments.put(method, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)method, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)method), RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected}), (RefactoringStatusContext)JavaStatusContext.create((IMember)method))));
                                }
                                ++offset;
                            }
                        } else {
                            sub.worked(2);
                        }
                        if (effectedMap.containsKey(unit)) {
                            this.addMethodStubsToNonAbstractSubclassesOfTargetClass((List)effectedMap.get(unit), root, rewrite, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 2), status);
                        }
                        if (sub.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                sub.done();
                throw throwable;
            }
            {
                Object var27_31 = null;
            }
            sub.done();
            if (adjustor != null && !adjustments.isEmpty()) {
                adjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            TextChangeManager manager = new TextChangeManager();
            Iterator iterator = rewrites.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    textChangeManager = manager;
                    Object var29_33 = null;
                    break;
                }
                unit = (ICompilationUnit)iterator.next();
                rewrite = (CompilationUnitRewrite)rewrites.get(unit);
                if (rewrite == null) continue;
                manager.manage(unit, (TextChange)rewrite.createChange());
            }
        }
        catch (Throwable throwable) {
            Object var29_34 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChangeManager;
    }

    private Javadoc createJavadocForStub(String enclosingTypeName, MethodDeclaration oldMethod, MethodDeclaration newMethodNode, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        IMethodBinding binding;
        if (this.fCodeGenerationSettings.createComments && (binding = oldMethod.resolveBinding()) != null) {
            ITypeBinding[] params = binding.getParameterTypes();
            String fullTypeName = JavaModelUtil.getFullyQualifiedName(this.getTargetClass());
            String[] fullParamNames = new String[params.length];
            int i = 0;
            while (i < fullParamNames.length) {
                fullParamNames[i] = Bindings.getFullyQualifiedName(params[i]);
                ++i;
            }
            String comment = CodeGeneration.getMethodComment(cu, enclosingTypeName, newMethodNode, false, binding.getName(), fullTypeName, fullParamNames, StubUtility.getLineDelimiterUsed((IJavaElement)cu));
            return (Javadoc)rewrite.createStringPlaceholder(comment, 29);
        }
        return null;
    }

    private Map createMembersToDeleteMap(IProgressMonitor pm) throws JavaModelException {
        IMember[] membersToDelete = this.getMembersToDelete(pm);
        HashMap result = new HashMap();
        int i = 0;
        while (i < membersToDelete.length) {
            IMember member = membersToDelete[i];
            ICompilationUnit cu = member.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(member);
            ++i;
        }
        return result;
    }

    private MethodDeclaration createNewMethodDeclarationNode(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod sourceMethod, MethodDeclaration oldMethod, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, Map adjustments, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        if (!this.getTargetClass().isInterface()) {
            this.copyBodyOfPulledUpMethod(sourceRewrite, targetRewrite, sourceMethod, oldMethod, newMethod, mapping, pm);
        }
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        PullUpRefactoringProcessor.copyJavadocNode(rewrite, (IMember)sourceMethod, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, sourceMethod.getFlags(), adjustments, pm, true, status);
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        PullUpRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)oldMethod.getName()));
        this.copyReturnType(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PullUpRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        return newMethod;
    }

    private BodyDeclaration createNewTypeDeclarationNode(IType type, AbstractTypeDeclaration oldType, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        ICompilationUnit declaringCu = this.getDeclaringType().getCompilationUnit();
        if (!JdtFlags.isPublic((IMember)type) && !JdtFlags.isProtected((IMember)type)) {
            if (mapping.length > 0) {
                return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite, true);
            }
            return PullUpRefactoringProcessor.createPlaceholderForProtectedTypeDeclaration((BodyDeclaration)oldType, declaringCuNode, declaringCu, rewrite, true);
        }
        if (mapping.length > 0) {
            return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite, true);
        }
        return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, rewrite, true);
    }

    private Map createNonAbstractSubclassesMapping(IProgressMonitor pm) throws JavaModelException {
        if (!this.fCreateMethodStubs || this.getAbstractMethods().length <= 0) {
            return new HashMap(0);
        }
        Set nonAbstractSubclasses = PullUpRefactoringProcessor.getNonAbstractSubclasses(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass());
        HashMap result = new HashMap();
        Iterator iter = nonAbstractSubclasses.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            ICompilationUnit cu = type.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(type);
        }
        return result;
    }

    private IMethod[] getAbstractMethods() throws JavaModelException {
        IMethod[] toDeclareAbstract = this.fMethodsToDeclareAbstract;
        IMethod[] abstractPulledUp = this.getAbstractMethodsToPullUp();
        ArrayList<IMethod> result = new ArrayList<IMethod>(toDeclareAbstract.length + abstractPulledUp.length);
        result.addAll(Arrays.asList(toDeclareAbstract));
        result.addAll(Arrays.asList(abstractPulledUp));
        return result.toArray(new IMethod[result.size()]);
    }

    private IMethod[] getAbstractMethodsToPullUp() throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMembersToMove.length);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            if (member instanceof IMethod && JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembersToPullUp(IProgressMonitor pm) throws JavaModelException {
        IMember current;
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPullableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    public boolean getCreateMethodStubs() {
        return this.fCreateMethodStubs;
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    private ICompilationUnit[] getInvolvedCompilationUnits(IProgressMonitor pm) throws JavaModelException {
        IType[] allSubtypes = this.getTypeHierarchyOfTargetClass(pm).getAllSubtypes(this.getTargetClass());
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(allSubtypes.length);
        int i = 0;
        while (i < allSubtypes.length) {
            result.add(allSubtypes[i].getCompilationUnit());
            ++i;
        }
        result.add(this.getTargetClass().getCompilationUnit());
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public IMember[] getMatchingElements(IProgressMonitor pm, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            HashSet result = new HashSet();
            IType targetClass = this.getTargetClass();
            Map matching = this.getMatchingMembersMappingFromTypeAndAllSubtypes(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass(), includeMethodsToDeclareAbstract);
            Iterator iter = matching.keySet().iterator();
            while (iter.hasNext()) {
                IMember key = (IMember)iter.next();
                Assert.isTrue(!key.getDeclaringType().equals(targetClass));
                result.addAll((Set)matching.get(key));
            }
            iMemberArray = result.toArray(new IMember[result.size()]);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    private Map getMatchingMembersMapping(IType analyzedType) throws JavaModelException {
        HashMap result = new HashMap();
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            IMethod found;
            IMember member = members[i];
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                found = MemberCheckUtil.findMethod(method, analyzedType.getMethods());
                if (found != null) {
                    PullUpRefactoringProcessor.addToMapping(result, (IMember)method, (IMember)found);
                }
            } else if (member instanceof IField) {
                IField field = (IField)member;
                found = analyzedType.getField(field.getElementName());
                if (found.exists()) {
                    PullUpRefactoringProcessor.addToMapping(result, (IMember)field, (IMember)found);
                }
            } else if (member instanceof IType) {
                IType type = (IType)member;
                found = analyzedType.getType(type.getElementName());
                if (found.exists()) {
                    PullUpRefactoringProcessor.addToMapping(result, (IMember)type, (IMember)found);
                }
            } else {
                Assert.isTrue(false);
            }
            ++i;
        }
        return result;
    }

    private Map getMatchingMembersMappingFromTypeAndAllSubtypes(ITypeHierarchy hierarchy, IType type, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        HashMap result = new HashMap();
        result.putAll(this.getMatchingMembersMapping(type));
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        int i = 0;
        while (i < subTypes.length) {
            Map map = this.getMatchingMembersMapping(subTypes[i]);
            PullUpRefactoringProcessor.mergeSetsForCommonKeys(result, map);
            PullUpRefactoringProcessor.putAllThatDoNotExistInResultYet(result, map);
            ++i;
        }
        if (includeMethodsToDeclareAbstract) {
            return result;
        }
        i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            if (result.containsKey(this.fMethodsToDeclareAbstract[i])) {
                result.remove(this.fMethodsToDeclareAbstract[i]);
            }
            ++i;
        }
        return result;
    }

    private IMember[] getMembersToBeCreatedInTargetClass() {
        ArrayList<Object> result = new ArrayList<Object>(this.fMembersToMove.length + this.fMethodsToDeclareAbstract.length);
        result.addAll(Arrays.asList(this.fMembersToMove));
        result.addAll(Arrays.asList(this.fMethodsToDeclareAbstract));
        return result.toArray(new IMember[result.size()]);
    }

    private IMember[] getMembersToDelete(IProgressMonitor pm) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            IMember[] typesToDelete = WorkingCopyUtil.getOriginals(PullUpRefactoringProcessor.getMembersOfType(this.fMembersToMove, 7));
            IMember[] matchingElements = this.getMatchingElements(pm, false);
            IMember[] matchingFields = WorkingCopyUtil.getOriginals(PullUpRefactoringProcessor.getMembersOfType(matchingElements, 8));
            iMemberArray = JavaElementUtil.merge(JavaElementUtil.merge(matchingFields, typesToDelete), (IMember[])this.fMethodsToDelete);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    private int getModifiersWithUpdatedVisibility(IMember member, int modifiers, Map adjustments, IProgressMonitor monitor, boolean considerReferences, RefactoringStatus status) throws JavaModelException {
        if (this.needsVisibilityAdjustment(member, considerReferences, monitor, status)) {
            MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment adjustment = new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(member, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(member), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)member), MemberVisibilityAdjustor.getLabel(Modifier.ModifierKeyword.PROTECTED_KEYWORD)})));
            adjustment.setNeedsRewriting(false);
            adjustments.put(member, adjustment);
            return JdtFlags.clearAccessModifiers(modifiers) | 4;
        }
        return modifiers;
    }

    private Set getNotDeletedMembers(IProgressMonitor pm) throws JavaModelException {
        HashSet<IMember> matchingSet = new HashSet<IMember>();
        pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
        matchingSet.addAll(Arrays.asList(this.getMatchingElements((IProgressMonitor)new SubProgressMonitor(pm, 1), true)));
        matchingSet.removeAll(Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1))));
        pm.done();
        return matchingSet;
    }

    public IType[] getPossibleTargetClasses(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        IType[] superClasses = this.getDeclaringType().newSupertypeHierarchy(pm).getAllSupertypes(this.getDeclaringType());
        ArrayList<IType> superClassList = new ArrayList<IType>(superClasses.length);
        int binary = 0;
        int i = 0;
        while (i < superClasses.length) {
            IType superclass = superClasses[i];
            if (superclass != null && superclass.exists() && !superclass.isReadOnly() && !superclass.isBinary() && !"java.lang.Object".equals(superclass.getFullyQualifiedName())) {
                superClassList.add(superclass);
            } else if (superclass != null && superclass.isBinary()) {
                ++binary;
            }
            ++i;
        }
        if (superClasses.length == 1 && superClasses[0].getFullyQualifiedName().equals("java.lang.Object")) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_not_java_lang_object);
        } else if (superClasses.length == binary) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_no_all_binary);
        }
        Collections.reverse(superClassList);
        return superClassList.toArray(new IType[superClassList.size()]);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PullUpRefactoring_Pull_Up;
    }

    public IMember[] getPullableMembersOfDeclaringType() {
        try {
            return RefactoringAvailabilityTester.getPullUpMembers(this.getDeclaringType());
        }
        catch (JavaModelException javaModelException) {
            return new IMember[0];
        }
    }

    private Set getSkippedSuperclasses(IProgressMonitor pm) throws JavaModelException {
        Set set;
        block4: {
            pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
            if (this.fCachedSkippedSuperclasses == null || !this.getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1)).getType().equals(this.getTargetClass())) break block4;
            Set set2 = this.fCachedSkippedSuperclasses;
            Object var4_4 = null;
            pm.done();
            return set2;
        }
        try {
            ITypeHierarchy hierarchy = this.getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.fCachedSkippedSuperclasses = new HashSet(2);
            IType current = hierarchy.getSuperclass(this.getDeclaringType());
            while (current != null && !current.equals(this.getTargetClass())) {
                this.fCachedSkippedSuperclasses.add(current);
                current = hierarchy.getSuperclass(current);
            }
            set = this.fCachedSkippedSuperclasses;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return set;
    }

    private IType getSuperclassOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        return declaringType.newSupertypeHierarchy(pm).getSuperclass(declaringType);
    }

    public IType getTargetClass() {
        return this.fTargetType;
    }

    public ITypeHierarchy getTypeHierarchyOfTargetClass(IProgressMonitor pm) throws JavaModelException {
        block3: {
            ITypeHierarchy iTypeHierarchy;
            try {
                if (this.fCachedTargetClassHierarchy == null || !this.fCachedTargetClassHierarchy.getType().equals(this.getTargetClass())) break block3;
                iTypeHierarchy = this.fCachedTargetClassHierarchy;
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return iTypeHierarchy;
        }
        ITypeHierarchy iTypeHierarchy = this.fCachedTargetClassHierarchy = this.getTargetClass().newTypeHierarchy(pm);
        Object var2_5 = null;
        pm.done();
        return iTypeHierarchy;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof GenericRefactoringArguments) {
            IJavaElement element;
            String attribute;
            String instance;
            IJavaElement element2;
            GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
            String handle = generic.getAttribute("input");
            if (handle != null) {
                element2 = JavaCore.create((String)handle);
                if (element2 == null || !element2.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PULL_UP));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
            }
            this.fTargetType = (IType)element2;
            handle = generic.getAttribute("element1");
            if (handle != null) {
                element2 = JavaCore.create((String)handle);
                if (element2 == null || !element2.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PULL_UP));
                }
                this.fDeclaringType = (IType)element2;
            }
            if ((instance = generic.getAttribute(ATTRIBUTE_STUBS)) == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_STUBS));
            }
            this.fCreateMethodStubs = Boolean.valueOf(instance);
            int pullCount = 0;
            int abstractCount = 0;
            int deleteCount = 0;
            String value = generic.getAttribute(ATTRIBUTE_ABSTRACT);
            if (value != null && !"".equals(value)) {
                try {
                    abstractCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_ABSTRACT));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_ABSTRACT));
            }
            value = generic.getAttribute(ATTRIBUTE_DELETE);
            if (value != null && !"".equals(value)) {
                try {
                    deleteCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_DELETE));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_DELETE));
            }
            value = generic.getAttribute(ATTRIBUTE_PULL);
            if (value != null && !"".equals(value)) {
                try {
                    pullCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PULL));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PULL));
            }
            RefactoringStatus status = new RefactoringStatus();
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < pullCount) {
                attribute = "element" + (index + 2);
                handle = generic.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaCore.create((String)handle);
                    if (element == null || !element.exists()) {
                        status.merge(RefactoringStatus.createWarningStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PULL_UP)));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)attribute));
                }
                ++index;
            }
            this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < deleteCount) {
                attribute = "element" + (pullCount + index + 2);
                handle = generic.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaCore.create((String)handle);
                    if (element == null || !element.exists()) {
                        status.merge(RefactoringStatus.createWarningStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PULL_UP)));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)attribute));
                }
                ++index;
            }
            this.fMethodsToDelete = elements.toArray(new IMethod[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < abstractCount) {
                attribute = "element" + (pullCount + abstractCount + index + 2);
                handle = generic.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaCore.create((String)handle);
                    if (element == null || !element.exists()) {
                        status.merge(RefactoringStatus.createWarningStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PULL_UP)));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)attribute));
                }
                ++index;
            }
            this.fMethodsToDeclareAbstract = elements.toArray(new IMethod[elements.size()]);
            IJavaProject project = null;
            if (this.fMembersToMove.length > 0) {
                project = this.fMembersToMove[0].getJavaProject();
            }
            this.fCodeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isPullUpAvailable(this.fMembersToMove);
    }

    private boolean isDeclaredInTargetClassOrItsSuperclass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy hierarchy;
        IType targetClass;
        String name;
        String[] paramTypes;
        boolean isConstructor;
        block3: {
            try {
                isConstructor = false;
                paramTypes = method.getParameterTypes();
                name = method.getElementName();
                targetClass = this.getTargetClass();
                hierarchy = this.getTypeHierarchyOfTargetClass(pm);
                IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, targetClass);
                if (first == null || !MethodChecks.isVirtual(first)) break block3;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return true;
        }
        IMethod found = JavaModelUtil.findMethodInHierarchy(hierarchy, targetClass, name, paramTypes, isConstructor);
        boolean bl = found != null && MethodChecks.isVirtual(found);
        Object var10_10 = null;
        pm.done();
        return bl;
    }

    private boolean isRequiredPullableMember(List queue, IMember member) throws JavaModelException {
        if (member.getDeclaringType() == null) {
            return false;
        }
        return member.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(member) && RefactoringAvailabilityTester.isPullUpAvailable(member);
    }

    private boolean isVirtualAccessibleFromTargetClass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        try {
            bl = MethodChecks.isVirtual(method) && this.isDeclaredInTargetClassOrItsSuperclass(method, pm);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return bl;
    }

    protected void rewriteTypeOccurrences(TextChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set replacements) throws CoreException {
    }

    public void setCreateMethodStubs(boolean create) {
        this.fCreateMethodStubs = create;
    }

    public void setMembersToMove(IMember[] elements) {
        Assert.isNotNull(elements);
        this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])elements);
        this.fMembersToMove = WorkingCopyUtil.getOriginals(this.fMembersToMove);
    }

    public void setMethodsToDeclareAbstract(IMethod[] methods) {
        Assert.isNotNull(methods);
        this.fMethodsToDeclareAbstract = PullUpRefactoringProcessor.getOriginals(methods);
    }

    public void setMethodsToDelete(IMethod[] methodsToDelete) {
        Assert.isNotNull(methodsToDelete);
        this.fMethodsToDelete = PullUpRefactoringProcessor.getOriginals(methodsToDelete);
    }

    public void setTargetClass(IType targetType) {
        Assert.isNotNull(targetType);
        if (!targetType.equals(this.fTargetType)) {
            this.fCachedTargetClassHierarchy = null;
        }
        this.fTargetType = targetType;
    }

    public static class PullUpAstNodeMapper
    extends HierarchyProcessor.TypeVariableMapper {
        protected boolean fAnonymousClassDeclaration = false;
        protected final CompilationUnitRewrite fSourceRewriter;
        protected final IType fSuperReferenceType;
        protected final CompilationUnitRewrite fTargetRewriter;
        protected boolean fTypeDeclarationStatement = false;

        public PullUpAstNodeMapper(CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite targetRewriter, ASTRewrite rewrite, IType type, TypeVariableMaplet[] mapping) {
            super(rewrite, mapping);
            Assert.isNotNull(rewrite);
            Assert.isNotNull(type);
            this.fSourceRewriter = sourceRewriter;
            this.fTargetRewriter = targetRewriter;
            this.fSuperReferenceType = type;
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = false;
            super.endVisit(node);
        }

        public final void endVisit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = false;
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = true;
            return super.visit(node);
        }

        public final boolean visit(SuperFieldAccess node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                AST ast = node.getAST();
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(node.getName().getIdentifier()));
                this.fRewrite.replace((ASTNode)node, (ASTNode)access, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(SuperMethodInvocation node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                IType type;
                ITypeBinding binding;
                IBinding name = node.getName().resolveBinding();
                if (name != null && name.getKind() == 4 && (binding = ((IMethodBinding)name).getDeclaringClass()) != null && !this.fSuperReferenceType.equals(type = (IType)binding.getJavaElement())) {
                    return true;
                }
                AST ast = node.getAST();
                ThisExpression expression = ast.newThisExpression();
                MethodInvocation invocation = ast.newMethodInvocation();
                SimpleName simple = ast.newSimpleName(node.getName().getIdentifier());
                invocation.setName(simple);
                invocation.setExpression((Expression)expression);
                List arguments = (List)node.getStructuralProperty((StructuralPropertyDescriptor)SuperMethodInvocation.ARGUMENTS_PROPERTY);
                if (arguments != null && arguments.size() > 0) {
                    ListRewrite rewriter = this.fRewrite.getListRewrite((ASTNode)invocation, MethodInvocation.ARGUMENTS_PROPERTY);
                    rewriter.insertLast(rewriter.createCopyTarget((ASTNode)arguments.get(0), (ASTNode)arguments.get(arguments.size() - 1)), null);
                }
                this.fRewrite.replace((ASTNode)node, (ASTNode)invocation, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = true;
            return super.visit(node);
        }
    }
}

