/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class RefactoringASTParser {
    private ASTParser fParser;
    public static final String SOURCE_PROPERTY = "org.eclipse.jdt.ui.refactoring.ast_source";

    public RefactoringASTParser(int level) {
        this.fParser = ASTParser.newParser((int)level);
    }

    public CompilationUnit parse(ICompilationUnit unit, boolean resolveBindings) {
        return this.parse(unit, resolveBindings, null);
    }

    public CompilationUnit parse(ICompilationUnit unit, boolean resolveBindings, IProgressMonitor pm) {
        return this.parse(unit, null, resolveBindings, pm);
    }

    public CompilationUnit parse(ICompilationUnit unit, WorkingCopyOwner owner, boolean resolveBindings, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setSource(unit);
        if (owner != null) {
            this.fParser.setWorkingCopyOwner(owner);
        }
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)unit));
        CompilationUnit result = (CompilationUnit)this.fParser.createAST(pm);
        result.setProperty(SOURCE_PROPERTY, (Object)unit);
        return result;
    }

    public CompilationUnit parse(String newCuSource, ICompilationUnit originalCu, boolean resolveBindings, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setSource(newCuSource.toCharArray());
        this.fParser.setUnitName(originalCu.getElementName());
        this.fParser.setProject(originalCu.getJavaProject());
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)originalCu));
        CompilationUnit newCUNode = (CompilationUnit)this.fParser.createAST(pm);
        return newCUNode;
    }

    public static ICompilationUnit getCompilationUnit(ASTNode node) {
        Object source = node.getRoot().getProperty(SOURCE_PROPERTY);
        if (source instanceof ICompilationUnit) {
            return (ICompilationUnit)source;
        }
        return null;
    }

    public static Map getCompilerOptions(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        Map options = project.getOptions(true);
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value)) continue;
            options.put(key, "ignore");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }
}

