/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.corext.util.History;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFactory;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.w3c.dom.Element;

public class TypeInfoHistory
extends History {
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_NAME = "name";
    private static final String NODE_PACKAGE = "package";
    private static final String NODE_ENCLOSING_NAMES = "enclosingTypes";
    private static final String NODE_PATH = "path";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final char[][] EMPTY_ENCLOSING_NAMES = new char[0][0];
    private static TypeInfoHistory fgInstance;
    private final TypeInfoFactory fTypeInfoFactory = new TypeInfoFactory();

    public static TypeInfoHistory getDefault() {
        if (fgInstance == null) {
            fgInstance = new TypeInfoHistory("TypeInfoHistory.xml");
        }
        return fgInstance;
    }

    public TypeInfoHistory(String fileName) {
        super(fileName, NODE_ROOT, NODE_TYPE_INFO);
        this.load();
    }

    public synchronized boolean contains(TypeInfo type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeInfo info) {
        super.accessed(info);
    }

    public synchronized TypeInfo remove(TypeInfo info) {
        return (TypeInfo)super.remove(info);
    }

    public synchronized TypeInfo[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeInfo[] result = new TypeInfo[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeInfo)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeInfo[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered(type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeInfo[result.size()]);
    }

    protected Object getKey(Object object) {
        return ((TypeInfo)object).getFullyQualifiedName();
    }

    protected Object createFromElement(Element type) {
        String name = type.getAttribute(NODE_NAME);
        String pack = type.getAttribute(NODE_PACKAGE);
        char[][] enclosingNames = this.getEnclosingNames(type);
        String path = type.getAttribute(NODE_PATH);
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeInfo info = this.fTypeInfoFactory.create(pack.toCharArray(), name.toCharArray(), enclosingNames, modifiers, path);
        return info;
    }

    protected void setAttributes(Object object, Element typeElement) {
        TypeInfo type = (TypeInfo)object;
        typeElement.setAttribute(NODE_NAME, type.getTypeName());
        typeElement.setAttribute(NODE_PACKAGE, type.getPackageName());
        typeElement.setAttribute(NODE_ENCLOSING_NAMES, type.getEnclosingName());
        typeElement.setAttribute(NODE_PATH, type.getPath());
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
    }

    private char[][] getEnclosingNames(Element type) {
        String enclosingNames = type.getAttribute(NODE_ENCLOSING_NAMES);
        if (enclosingNames.length() == 0) {
            return EMPTY_ENCLOSING_NAMES;
        }
        StringTokenizer tokenizer = new StringTokenizer(enclosingNames, ".");
        ArrayList<char[]> names = new ArrayList<char[]>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            names.add(name.toCharArray());
        }
        return (char[][])names.toArray((T[])new char[names.size()][]);
    }

    public static int getBoost(String fullyQualifiedTypeName, int min, int max) {
        float position = TypeInfoHistory.getDefault().getNormalizedPosition(fullyQualifiedTypeName);
        int dist = max - min;
        return Math.round(position * (float)dist) + min;
    }

    public static void remember(TypeInfo typeInfo) {
        TypeInfoHistory.getDefault().accessed(typeInfo);
    }
}

